package com.android.printerapis;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.View;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrinterApisActivity extends Activity implements View.OnClickListener,PrinterManager.PrinterManagerListener {
    private PrinterManager mPrinterManager;

    private LinearLayout mRoot;
    private Button mText;
    private Button mTextTest;
    private Button mBarcode;
    private Button mQRcode;
    private Button mBitmap;
    private Button mReceipt1;
    private Button mReceipt2;
    private Button mReceipt3;
    private Button mWrappaper;
    private Button mSpeed;
    private Button mFmversion;
    private Button mUpgrade;
    private Button mPaper;
    private Button mPrinterFont;
    private Button mLength;
    private Button mTemperature;



    private Context mContext;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_printer_apis);
        mContext = this.getApplicationContext();

        initLayout();
    }
    @Override
    protected void onPause() {
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
        updateLayout(false);

        mPrinterManager = new PrinterManager(this,this);
        mPrinterManager.onPrinterStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
        //mPrinterManager.onPrinterStop();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        mPrinterManager.onPrinterStop();

    }

    @Override
    public void onServiceConnected() {
        mPrinterManager.printerInit();
        updateLayout(true);
    }

    private void initLayout(){
        mRoot = (LinearLayout) this.findViewById(R.id.content_view);

        mText = (Button) mRoot.findViewById(R.id.id_printer_text);
        mTextTest = (Button)mRoot.findViewById(R.id.id_printer_margin);
        mBarcode = (Button) mRoot.findViewById(R.id.id_printer_barcode);
        mQRcode = (Button) mRoot.findViewById(R.id.id_printer_qrcode);
        mBitmap = (Button) mRoot.findViewById(R.id.id_printer_bitmap);
        mReceipt1 = (Button) mRoot.findViewById(R.id.id_printer_receipt1);
        mReceipt2 = (Button) mRoot.findViewById(R.id.id_printer_receipt2);
        //mReceipt3 = (Button) mRoot.findViewById(R.id.id_printer_receipt3);
        mWrappaper = (Button) mRoot.findViewById(R.id.id_printer_wrappaper);
        mSpeed = (Button) mRoot.findViewById(R.id.id_printer_speed);
        mPrinterFont = (Button) mRoot.findViewById(R.id.id_printer_font);
        mFmversion = (Button) mRoot.findViewById(R.id.id_printer_version);
        mUpgrade = (Button) mRoot.findViewById(R.id.id_printer_upgrade);
        mPaper = (Button) mRoot.findViewById(R.id.id_printer_paper);
        mLength = (Button) mRoot.findViewById(R.id.id_printer_length);
        mTemperature = (Button) mRoot.findViewById(R.id.id_printer_temperature);


    }
    private void updateLayout(boolean enable){
        updateViewStatus(mText, R.bool.config_printer_text_support,enable);
        updateViewStatus(mTextTest, R.bool.config_printer_margin_support,enable);
        updateViewStatus(mBarcode, R.bool.config_printer_barcode_support,enable);
        updateViewStatus(mQRcode, R.bool.config_printer_qrcode_support,enable);
        updateViewStatus(mBitmap, R.bool.config_printer_bitmap_support,enable);
        updateViewStatus(mWrappaper, R.bool.config_printer_wrappaper_support,enable);
        updateViewStatus(mSpeed, R.bool.config_printer_speed_support, enable);
        updateViewStatus(mFmversion, R.bool.config_printer_version_support, enable);
        updateViewStatus(mUpgrade, R.bool.config_printer_upgrade_support, enable);
        updateViewStatus(mPaper, R.bool.config_printer_paper_support, enable);
        updateViewStatus(mReceipt1, R.bool.config_printer_receipt_support, enable);
        updateViewStatus(mReceipt2, R.bool.config_printer_receipt1_support, enable);
        updateViewStatus(mPrinterFont, R.bool.config_printer_font_support, enable);
        updateViewStatus(mLength, R.bool.config_printer_length_support, enable);
        updateViewStatus(mTemperature, R.bool.config_printer_temperature_support, enable);
        //updateViewStatus(mReceipt3, R.bool.config_printer_receipt2_support, enable);

    }
    private void updateViewStatus(View view,int res,boolean enable){
        boolean visible = false;
        try{
            visible = mContext.getResources().getBoolean(res);
        }catch(Exception e){
            visible = false;
        }
        view.setVisibility(visible ? View.VISIBLE : View.GONE);
        view.setOnClickListener(this);
        view.setEnabled(enable);
    }
    @Override
    public void onClick(View v) {
        int id = v.getId();
        switch(id){
            case R.id.id_printer_text:
                onTextClicked();
                break;
            case R.id.id_printer_margin:
                onTextTestClicked();
                break;
            case R.id.id_printer_barcode:
                onBarcodeClicked();
                break;
            case R.id.id_printer_qrcode:
                onQRcodeClicked();
                break;
            case R.id.id_printer_bitmap:
                onBitmapClicked();
                break;
            case R.id.id_printer_receipt1:
                onReceipt1Printer();
                break;
            case R.id.id_printer_receipt2:
                //onReceipt2Printer();
                onTestDifferentFonts();
                break;
            /*case R.id.id_printer_receipt3:

            	break;*/
            case R.id.id_printer_wrappaper:
                onWrappaperClicked();
                break;
            case R.id.id_printer_speed:
                onSpeedClicked();
                break;
            case R.id.id_printer_font:
                onPrinterFontClicked();
                break;
            case R.id.id_printer_version:
                onVersionClicked();
                break;
            case R.id.id_printer_upgrade:
                onUpgradeClicked();
                break;
            case R.id.id_printer_paper:
                onPaperClicked();
                break;
            case R.id.id_printer_length:
                onLengthClicked();
                break;
            case R.id.id_printer_temperature:
                onTemperatureDetect();
                break;
        }
    }
    private void onTextTestClicked(){
        final Map<String,Integer> map1 = new HashMap<String,Integer>();
        map1.put(PrinterManager.KEY_LINESPACE,0);
        map1.put(PrinterManager.KEY_TEXTSIZE,20);
        map1.put(PrinterManager.KEY_TYPEFACE, 0);
        map1.put(PrinterManager.KEY_ALIGN, 1);
        map1.put(PrinterManager.KEY_MARGINLEFT, 15);
        map1.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final Map<String,Integer> map2 = new HashMap<String,Integer>();
        map2.put(PrinterManager.KEY_LINESPACE,0);
        map2.put(PrinterManager.KEY_TEXTSIZE,20);
        map1.put(PrinterManager.KEY_TYPEFACE, 0);
        map2.put(PrinterManager.KEY_ALIGN, 1);
        map2.put(PrinterManager.KEY_MARGINLEFT, 20);
        map2.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final Map<String,Integer> map3 = new HashMap<String,Integer>();
        map3.put(PrinterManager.KEY_LINESPACE,0);
        map3.put(PrinterManager.KEY_TEXTSIZE,20);
        map3.put(PrinterManager.KEY_TYPEFACE, 0);
        map3.put(PrinterManager.KEY_ALIGN, 1);
        map3.put(PrinterManager.KEY_MARGINLEFT, 5);
        map3.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final Map<String,Integer> map4 = new HashMap<String,Integer>();
        map4.put(PrinterManager.KEY_LINESPACE,0);
        map4.put(PrinterManager.KEY_TEXTSIZE,30);
        map4.put(PrinterManager.KEY_TYPEFACE, 0);
        map4.put(PrinterManager.KEY_ALIGN, 1);
        map4.put(PrinterManager.KEY_MARGINLEFT, 0);
        map4.put(PrinterManager.KEY_MARGINRIGHT, 0);


        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printText("Default left margin 10");
                    //mPrinterManager.printText("\n");

                    mPrinterManager.printTextWithAttributes("Set left margin 15", map1);
                    //mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("Set left margin 20", map2);
                    mPrinterManager.printTextWithAttributes("Set left margin 5", map3);
                    //mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("Русские буквы слева границы 5 KEY_TEXTSIZE 20", map3);
                    mPrinterManager.printTextWithAttributes("0123456789_123456789_0123456789_0123456789_0123456789", map3);
                    mPrinterManager.printTextWithAttributes("Русские буквы слева границы по нулям KEY_TEXTSIZE 30", map4);
                    mPrinterManager.printTextWithAttributes("0123456789_123456789_0123456789_0123456789_0123456789", map4);
                    mPrinterManager.printText("\n\n");
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onReceipt1Printer(){
        final Bitmap cielo_title = BitmapFactory.decodeResource(mContext.getResources(), R.raw.printer);
        final Map<String,Integer> map_cielo = new HashMap<String,Integer>();
        map_cielo.put(PrinterManager.KEY_ALIGN, 0);
        map_cielo.put(PrinterManager.KEY_MARGINLEFT, 5);
        map_cielo.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final Map<String,Integer> mapCielo = new HashMap<String,Integer>();
        mapCielo.put(PrinterManager.KEY_LINESPACE,10);
        mapCielo.put(PrinterManager.KEY_TEXTSIZE,48);
        mapCielo.put(PrinterManager.KEY_TYPEFACE, 1);
        mapCielo.put(PrinterManager.KEY_ALIGN, 0);
        mapCielo.put(PrinterManager.KEY_MARGINLEFT, 0);
        mapCielo.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> mapTitle = new HashMap<String,Integer>();
        mapTitle.put(PrinterManager.KEY_LINESPACE,10);
        mapTitle.put(PrinterManager.KEY_TEXTSIZE,24);
        mapTitle.put(PrinterManager.KEY_TYPEFACE, 0);
        mapTitle.put(PrinterManager.KEY_ALIGN, 0);
        mapTitle.put(PrinterManager.KEY_MARGINLEFT, 0);
        mapTitle.put(PrinterManager.KEY_MARGINRIGHT, 0);
        final String stringtext1 = "VIA - ESTABELECIMENTO / POS=69000004\nCNPJ:00.000.000/000-00\nMENSAGEM TBL F";
        final String stringtext2 = "Alameda Grajau, 219\nBarueri  -  SP\n00000000000003  DOC=305262  AUT=2000053";
        final Map<String,Integer> maptext1 = new HashMap<String,Integer>();
        maptext1.put(PrinterManager.KEY_LINESPACE,10);
        maptext1.put(PrinterManager.KEY_TEXTSIZE,20);
        maptext1.put(PrinterManager.KEY_TYPEFACE, 0);
        maptext1.put(PrinterManager.KEY_ALIGN, 1);
        maptext1.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext1.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext2 = new HashMap<String,Integer>();
        maptext2.put(PrinterManager.KEY_LINESPACE,10);
        maptext2.put(PrinterManager.KEY_TEXTSIZE,20);
        maptext2.put(PrinterManager.KEY_TYPEFACE, 0);
        maptext2.put(PrinterManager.KEY_ALIGN, 1);
        maptext2.put(PrinterManager.KEY_MARGINLEFT, 10);
        maptext2.put(PrinterManager.KEY_MARGINRIGHT, 10);

        final Map<String,Integer> maptext3 = new HashMap<String,Integer>();
        maptext3.put(PrinterManager.KEY_LINESPACE,10);
        maptext3.put(PrinterManager.KEY_TEXTSIZE,20);
        maptext3.put(PrinterManager.KEY_TYPEFACE, 0);
        maptext3.put(PrinterManager.KEY_ALIGN, 1);
        maptext3.put(PrinterManager.KEY_MARGINLEFT, 20);
        maptext3.put(PrinterManager.KEY_MARGINRIGHT, 20);

        final Map<String,Integer> maptext4 = new HashMap<String,Integer>();
        maptext4.put(PrinterManager.KEY_LINESPACE,10);
        maptext4.put(PrinterManager.KEY_TEXTSIZE,20);
        maptext4.put(PrinterManager.KEY_TYPEFACE, 0);
        maptext4.put(PrinterManager.KEY_ALIGN, 1);
        maptext4.put(PrinterManager.KEY_MARGINLEFT, 50);
        maptext4.put(PrinterManager.KEY_MARGINRIGHT, 50);

        final Map<String,Integer> mapbold = new HashMap<String,Integer>();
        mapbold.put(PrinterManager.KEY_LINESPACE,10);
        mapbold.put(PrinterManager.KEY_TEXTSIZE,20);
        mapbold.put(PrinterManager.KEY_TYPEFACE, 0);
        mapbold.put(PrinterManager.KEY_ALIGN, 1);
        mapbold.put(PrinterManager.KEY_MARGINLEFT, 0);
        mapbold.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> map1 = new HashMap<String,Integer>();
        map1.put(PrinterManager.KEY_LINESPACE,0);
        map1.put(PrinterManager.KEY_TEXTSIZE,20);
        map1.put(PrinterManager.KEY_TYPEFACE, 1);
        map1.put(PrinterManager.KEY_ALIGN, 2);
        map1.put(PrinterManager.KEY_MARGINLEFT, 0);
        map1.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> map2 = new HashMap<String,Integer>();
        map2.put(PrinterManager.KEY_LINESPACE,0);
        map2.put(PrinterManager.KEY_TEXTSIZE,20);
        map2.put(PrinterManager.KEY_ALIGN, 0);
        map2.put(PrinterManager.KEY_MARGINLEFT, 0);
        map2.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final String[] cols1Texts = {"13/03/17","20:00","ONL-D"};
        final String[] cols2Texts = {"VALOR:"," ","66,22"};

        final Map<String,Integer> attrCols1Map1 = new HashMap<String,Integer>();
        attrCols1Map1.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map1.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map1.put(PrinterManager.KEY_ALIGN, 1);
        attrCols1Map1.put(PrinterManager.KEY_WEIGHT, 1);
        attrCols1Map1.put(PrinterManager.KEY_TYPEFACE, 0);
        final Map<String,Integer> attrCols1Map2 = new HashMap<String,Integer>();
        attrCols1Map2.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map2.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map2.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map2.put(PrinterManager.KEY_WEIGHT, 1);
        attrCols1Map1.put(PrinterManager.KEY_TYPEFACE, 0);
        final Map<String,Integer> attrCols1Map3 = new HashMap<String,Integer>();
        attrCols1Map3.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map3.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map3.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map3.put(PrinterManager.KEY_WEIGHT, 1);
        attrCols1Map1.put(PrinterManager.KEY_TYPEFACE, 0);

        final List attrCols1 = new ArrayList();
        attrCols1.add(attrCols1Map1);
        attrCols1.add(attrCols1Map2);
        attrCols1.add(attrCols1Map3);

        final List attrCols2 = new ArrayList();
        attrCols2.add(attrCols1Map1);
        attrCols2.add(attrCols1Map2);
        attrCols2.add(attrCols1Map3);



        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printBitmap(cielo_title,map_cielo);
                    //mPrinterManager.printTextWithAttributes("CIELO", mapCielo);
                    mPrinterManager.printTextWithAttributes("Visa", mapTitle);
                    mPrinterManager.printTextWithAttributes("CREDITO  A  VISTA  -  I", mapTitle);
                    mPrinterManager.printTextWithAttributes("442780 - 0865", mapTitle);
                    mPrinterManager.printTextWithAttributes(stringtext1, maptext1);
                    mPrinterManager.printTextWithAttributes("POSTO  ABC", mapbold);
                    mPrinterManager.printTextWithAttributes(stringtext2, maptext1);
                    mPrinterManager.printColumnsTextWithAttributes(cols1Texts, attrCols1);
                    mPrinterManager.printTextWithAttributes("VENDA  A  CERDITO", maptext1);
                    mPrinterManager.printColumnsTextWithAttributes(cols2Texts, attrCols2);
                    mPrinterManager.printTextWithAttributes("MENSAGEM  TBL  DO", maptext1);

                    mPrinterManager.printTextWithAttributes("VENDA  A  CERDITO", maptext1);
                    mPrinterManager.printTextWithAttributes("VENDA  A  CERDITO", maptext2);
                    mPrinterManager.printTextWithAttributes("VENDA  A  CERDITO", maptext3);
                    mPrinterManager.printTextWithAttributes("VENDA  A  CERDITO", maptext4);
                    mPrinterManager.printText("\n\n\n");


                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });

    }
    private void onTestDifferentFonts(){
        final Map<String,Integer> maptext1 = new HashMap<String,Integer>();
        maptext1.put(PrinterManager.KEY_LINESPACE,10);
        maptext1.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext1.put(PrinterManager.KEY_TYPEFACE, 0);
        maptext1.put(PrinterManager.KEY_ALIGN, 1);
        maptext1.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext1.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext2 = new HashMap<String,Integer>();
        maptext2.put(PrinterManager.KEY_LINESPACE,10);
        maptext2.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext2.put(PrinterManager.KEY_TYPEFACE, 1);
        maptext2.put(PrinterManager.KEY_ALIGN, 1);
        maptext2.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext2.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext3 = new HashMap<String,Integer>();
        maptext3.put(PrinterManager.KEY_LINESPACE,10);
        maptext3.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext3.put(PrinterManager.KEY_TYPEFACE, 2);
        maptext3.put(PrinterManager.KEY_ALIGN, 1);
        maptext3.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext3.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext4 = new HashMap<String,Integer>();
        maptext4.put(PrinterManager.KEY_LINESPACE,10);
        maptext4.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext4.put(PrinterManager.KEY_TYPEFACE, 3);
        maptext4.put(PrinterManager.KEY_ALIGN, 1);
        maptext4.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext4.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext5 = new HashMap<String,Integer>();
        maptext5.put(PrinterManager.KEY_LINESPACE,10);
        maptext5.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext5.put(PrinterManager.KEY_TYPEFACE, 4);
        maptext5.put(PrinterManager.KEY_ALIGN, 1);
        maptext5.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext5.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext6 = new HashMap<String,Integer>();
        maptext6.put(PrinterManager.KEY_LINESPACE,10);
        maptext6.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext6.put(PrinterManager.KEY_TYPEFACE, 5);
        maptext6.put(PrinterManager.KEY_ALIGN, 1);
        maptext6.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext6.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext7 = new HashMap<String,Integer>();
        maptext7.put(PrinterManager.KEY_LINESPACE,10);
        maptext7.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext7.put(PrinterManager.KEY_TYPEFACE, 6);
        maptext7.put(PrinterManager.KEY_ALIGN, 1);
        maptext7.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext7.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext8 = new HashMap<String,Integer>();
        maptext8.put(PrinterManager.KEY_LINESPACE,10);
        maptext8.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext8.put(PrinterManager.KEY_TYPEFACE, 7);
        maptext8.put(PrinterManager.KEY_ALIGN, 1);
        maptext8.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext8.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext9 = new HashMap<String,Integer>();
        maptext9.put(PrinterManager.KEY_LINESPACE,10);
        maptext9.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext9.put(PrinterManager.KEY_TYPEFACE, 8);
        maptext9.put(PrinterManager.KEY_ALIGN, 1);
        maptext9.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext9.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext10 = new HashMap<String,Integer>();
        maptext10.put(PrinterManager.KEY_LINESPACE,10);
        maptext10.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext10.put(PrinterManager.KEY_TYPEFACE, 9);
        maptext10.put(PrinterManager.KEY_ALIGN, 1);
        maptext10.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext10.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext11 = new HashMap<String,Integer>();
        maptext11.put(PrinterManager.KEY_LINESPACE,10);
        maptext11.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext11.put(PrinterManager.KEY_TYPEFACE, 10);
        maptext11.put(PrinterManager.KEY_ALIGN, 1);
        maptext11.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext11.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext12 = new HashMap<String,Integer>();
        maptext12.put(PrinterManager.KEY_LINESPACE,10);
        maptext12.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext12.put(PrinterManager.KEY_TYPEFACE, 11);
        maptext12.put(PrinterManager.KEY_ALIGN, 1);
        maptext12.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext12.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext13 = new HashMap<String,Integer>();
        maptext13.put(PrinterManager.KEY_LINESPACE,10);
        maptext13.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext13.put(PrinterManager.KEY_TYPEFACE, 12);
        maptext13.put(PrinterManager.KEY_ALIGN, 1);
        maptext13.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext13.put(PrinterManager.KEY_MARGINRIGHT, 0);

        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {

                    mPrinterManager.printTextWithAttributes("This used for test normal fonts,font size is 26\n中文测试打印效果", maptext1);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test bold fonts,font size is 26\n中文测试打印效果", maptext2);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test serif fonts,font size is 26\n中文测试打印效果", maptext3);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test Arial fonts,font size is 26\n中文测试打印效果", maptext4);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test FangHei fonts,font size is 26\n中文测试打印效果", maptext5);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test FranklinGothic fonts,font size is 26\n中文测试打印效果", maptext6);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test Haettenschweiler fonts,font size is 26\n中文测试打印效果", maptext7);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test HuaSong fonts,font size is 26\n中文测试打印效果", maptext8);
                    mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("This used for test Sanmono fonts,font size is 26\n中文测试打印效果", maptext9);
                    mPrinterManager.printText("\n\n\n");


                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onReceipt2Printer(){
        final Bitmap cielo_title = BitmapFactory.decodeResource(mContext.getResources(), R.raw.printer);
        final Map<String,Integer> map_cielo = new HashMap<String,Integer>();
        map_cielo.put(PrinterManager.KEY_ALIGN, 0);
        map_cielo.put(PrinterManager.KEY_MARGINLEFT, 5);
        map_cielo.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final Map<String,Integer> mapCielo = new HashMap<String,Integer>();
        mapCielo.put(PrinterManager.KEY_LINESPACE,10);
        mapCielo.put(PrinterManager.KEY_TEXTSIZE,48);
        mapCielo.put(PrinterManager.KEY_TYPEFACE, 1);
        mapCielo.put(PrinterManager.KEY_ALIGN, 0);
        mapCielo.put(PrinterManager.KEY_MARGINLEFT, 0);
        mapCielo.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> mapTitle = new HashMap<String,Integer>();
        mapTitle.put(PrinterManager.KEY_LINESPACE,10);
        mapTitle.put(PrinterManager.KEY_TEXTSIZE,24);
        mapTitle.put(PrinterManager.KEY_TYPEFACE, 0);
        mapTitle.put(PrinterManager.KEY_ALIGN, 0);
        mapTitle.put(PrinterManager.KEY_MARGINLEFT, 0);
        mapTitle.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> mapbold = new HashMap<String,Integer>();
        mapbold.put(PrinterManager.KEY_LINESPACE,10);
        mapbold.put(PrinterManager.KEY_TEXTSIZE,28);
        mapbold.put(PrinterManager.KEY_TYPEFACE, 0);
        mapbold.put(PrinterManager.KEY_ALIGN, 1);
        mapbold.put(PrinterManager.KEY_MARGINLEFT, 0);
        mapbold.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final Map<String,Integer> maptext1 = new HashMap<String,Integer>();
        maptext1.put(PrinterManager.KEY_LINESPACE,10);
        maptext1.put(PrinterManager.KEY_TEXTSIZE,20);
        maptext1.put(PrinterManager.KEY_TYPEFACE, 0);
        maptext1.put(PrinterManager.KEY_ALIGN, 1);
        maptext1.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext1.put(PrinterManager.KEY_MARGINRIGHT, 0);

        final String[] cols1Texts = {"DOC=9421","18/01/17","10:49","ONL-D"};
        final String[] cols2Texts = {"VALOR:"," "," ","40,00"};

        final Map<String,Integer> attrCols1Map1 = new HashMap<String,Integer>();
        attrCols1Map1.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map1.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map1.put(PrinterManager.KEY_ALIGN, 1);
        attrCols1Map1.put(PrinterManager.KEY_WEIGHT, 1);
        final Map<String,Integer> attrCols1Map2 = new HashMap<String,Integer>();
        attrCols1Map2.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map2.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map2.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map2.put(PrinterManager.KEY_WEIGHT, 1);
        final Map<String,Integer> attrCols1Map3 = new HashMap<String,Integer>();
        attrCols1Map3.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map3.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map3.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map3.put(PrinterManager.KEY_WEIGHT, 1);
        final Map<String,Integer> attrCols1Map4 = new HashMap<String,Integer>();
        attrCols1Map4.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map4.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map4.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map4.put(PrinterManager.KEY_WEIGHT, 1);

        final List attrCols1 = new ArrayList();
        attrCols1.add(attrCols1Map1);
        attrCols1.add(attrCols1Map2);
        attrCols1.add(attrCols1Map3);
        attrCols1.add(attrCols1Map4);

        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printBitmap(cielo_title,map_cielo);
                    //mPrinterManager.printTextWithAttributes("CIELO", mapCielo);
                    mPrinterManager.printTextWithAttributes("VISA", mapTitle);
                    mPrinterManager.printTextWithAttributes("CREDITO  A  VISTA", mapTitle);
                    mPrinterManager.printTextWithAttributes("****************8520", mapTitle);
                    mPrinterManager.printTextWithAttributes("VIA  CLIENTE / POS=787310", mapTitle);
                    mPrinterManager.printTextWithAttributes("CNPJ:04.908.058/0001-99", maptext1);
                    mPrinterManager.printTextWithAttributes("RISA", mapbold);
                    mPrinterManager.printTextWithAttributes("ARAUCARIA PR", maptext1);
                    mPrinterManager.printColumnsTextWithAttributes(cols1Texts, attrCols1);
                    mPrinterManager.printTextWithAttributes("VENDA  A CREDITO", maptext1);
                    mPrinterManager.printColumnsTextWithAttributes(cols2Texts, attrCols1);
                    mPrinterManager.printText("\n\n\n");


                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }

    private void onTextClicked(){
        final Map<String,Integer> map1 = new HashMap<String,Integer>();
        map1.put(PrinterManager.KEY_LINESPACE,0);
        map1.put(PrinterManager.KEY_TEXTSIZE,20);
        map1.put(PrinterManager.KEY_TYPEFACE, 1);
        map1.put(PrinterManager.KEY_ALIGN, 2);
        map1.put(PrinterManager.KEY_MARGINLEFT, 5);
        map1.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final Map<String,Integer> map2 = new HashMap<String,Integer>();
        map2.put(PrinterManager.KEY_LINESPACE,0);
        map2.put(PrinterManager.KEY_TEXTSIZE,20);
        map2.put(PrinterManager.KEY_ALIGN, 0);
        map2.put(PrinterManager.KEY_MARGINLEFT, 5);
        map2.put(PrinterManager.KEY_MARGINRIGHT, 5);

        final String[] cols1Texts = {"Name","Lables","Counts","Money"};
        final String[] cols2Texts = {"Apple","Iphone","1","6088"};

        final Map<String,Integer> attrCols1Map1 = new HashMap<String,Integer>();
        attrCols1Map1.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map1.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map1.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map1.put(PrinterManager.KEY_WEIGHT, 1);
        final Map<String,Integer> attrCols1Map2 = new HashMap<String,Integer>();
        attrCols1Map2.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map2.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map2.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map2.put(PrinterManager.KEY_WEIGHT, 2);
        final Map<String,Integer> attrCols1Map3 = new HashMap<String,Integer>();
        attrCols1Map3.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map3.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map3.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map3.put(PrinterManager.KEY_WEIGHT, 1);
        final Map<String,Integer> attrCols1Map4 = new HashMap<String,Integer>();
        attrCols1Map4.put(PrinterManager.KEY_LINESPACE,0);
        attrCols1Map4.put(PrinterManager.KEY_TEXTSIZE,20);
        attrCols1Map4.put(PrinterManager.KEY_ALIGN, 0);
        attrCols1Map4.put(PrinterManager.KEY_WEIGHT, 1);

        final List attrCols1 = new ArrayList();
        attrCols1.add(attrCols1Map1);
        attrCols1.add(attrCols1Map2);
        attrCols1.add(attrCols1Map3);
        attrCols1.add(attrCols1Map4);

        final List attrCols2 = new ArrayList();
        attrCols2.add(attrCols1Map1);
        attrCols2.add(attrCols1Map2);
        attrCols2.add(attrCols1Map3);
        attrCols2.add(attrCols1Map4);

        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printText("FORMAT TESTS");
                    //mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("Textsize 22&Bold", map1);
                    //mPrinterManager.printText("\n");
                    mPrinterManager.printTextWithAttributes("Textsize 24&Normal", map2);
                    //mPrinterManager.printText("\n");

                    mPrinterManager.printColumnsTextWithAttributes(cols1Texts, attrCols1);
                    mPrinterManager.printColumnsTextWithAttributes(cols2Texts, attrCols2);
                    mPrinterManager.printColumnsTextWithAttributes(cols2Texts, attrCols2);
                    mPrinterManager.printText("\n\n");
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onBarcodeClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printBarCode("20170301",1, 300, 100, true);
                    mPrinterManager.printText("\n");
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onQRcodeClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printQRCode("www.baidu.com", 1, 200);
                    mPrinterManager.printText("\n");
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onBitmapClicked(){
        final Bitmap bitmap = BitmapFactory.decodeResource(mContext.getResources(), R.raw.printer);

        final Map<String,Integer> map = new HashMap<String,Integer>();
        map.put(PrinterManager.KEY_ALIGN, 0);
        map.put(PrinterManager.KEY_MARGINLEFT, 5);
        map.put(PrinterManager.KEY_MARGINRIGHT, 5);

        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printBitmap(bitmap,map);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onWrappaperClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.printWrapPaper(10);
                    //mPrinterManager.printText("\n");
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onSpeedClicked(){
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(mContext.getString(R.string.text_printer_speed_settings));
        final String[] speeds = {"Level1", "Level2", "Level3", "Level4", "Level5","Level6"};
        builder.setItems(speeds, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                final int speed = which + 1;
                ThreadPoolManager.getInstance().executeTask(new Runnable() {
                    @Override
                    public void run() {
                        // TODO Auto-generated method stub
                        try {
                            mPrinterManager.setPrinterSpeed(speed);
                        } catch (Exception e) {
                            // TODO Auto-generated catch block
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        builder.show();
    }
    private void onPrinterFontClicked(){
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle(mContext.getString(R.string.text_printer_font_settings));
        final String[] speeds = {"Normal", "Bold", "Serif", "Arial", "FangHei","FranklinGothic","Haettenschweiler","Huasong","SansMono"};
        builder.setItems(speeds, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                android.util.Log.i("tyj","which value = " + which);
                final int fontNum = which;
                onPrinterDifferentFont(fontNum);
            }
        });
        builder.show();
    }
    private void onPrinterDifferentFont(int fontNum){
        final String stringtext1 = "VIA - Establecimento / Pos=69000004\ncbpj:00.000.000/000-00\nMENTAGN TBL F";
        final String stringtext2 = "Alameda Grajau, 219\nBarueri  -  SP\n00000000000003  DOC=305262  AUT=2000053";
        final Map<String,Integer> maptext1 = new HashMap<String,Integer>();
        maptext1.put(PrinterManager.KEY_LINESPACE,10);
        maptext1.put(PrinterManager.KEY_TEXTSIZE,26);
        maptext1.put(PrinterManager.KEY_TYPEFACE, fontNum);
        maptext1.put(PrinterManager.KEY_ALIGN, 1);
        maptext1.put(PrinterManager.KEY_MARGINLEFT, 0);
        maptext1.put(PrinterManager.KEY_MARGINRIGHT, 0);
        String diffStr = "test";
        switch(fontNum){
            case 0:
                diffStr = "Normal fonts,size is 26";
                break;
            case 1:
                diffStr = "Bold fonts,size is 26";
                break;
            case 2:
                diffStr = "Serial fonts,size is 26";
                break;
            case 3:
                diffStr = "Arial fonts,size is 26";
                break;
            case 4:
                diffStr = "FangHei fonts,size is 26";
                break;
            case 5:
                diffStr = "FranklinGothic fonts,size is 26";
                break;
            case 6:
                diffStr = "Haettenschweiler fonts,size is 26";
                break;
            case 7:
                diffStr = "HuaSong fonts,size is 26";
                break;
            case 8:
                diffStr = "SansMono fonts,size is 26";
                break;
            default:
                break;

        }
        final String myDiffStr = diffStr;

        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {

                    mPrinterManager.printTextWithAttributes(stringtext1, maptext1);
                    mPrinterManager.printTextWithAttributes(myDiffStr, maptext1);
                    mPrinterManager.printTextWithAttributes("上海祥承通讯", maptext1);
                    mPrinterManager.printTextWithAttributes("测试中文字体格式", maptext1);
                    mPrinterManager.printText("\n\n\n");


                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onVersionClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    String bootloader = mPrinterManager.getBootloaderVersion();
                    String firmware = mPrinterManager.getFirmwareVersion();
                    final String content = "Bootloader:"+bootloader+" Firmware:"+firmware;
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(mContext,content,Toast.LENGTH_LONG).show();
                        }
                    });
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onTemperatureDetect(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    int temperature = mPrinterManager.printerTemperature(PrinterApisActivity.this);
                    String content = "temperature normal";
                    if(temperature == 1){
                        content = "temperature normal";
                        android.util.Log.i("tyj","temperature is normal ");
                    }else{
                        content = "temperature abnormal";
                        android.util.Log.i("tyj","temperature is abnormal ");
                    }
                    android.util.Log.i("tyj","temperature value = " + temperature);
                    final String tempContent = content;
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(mContext,tempContent,Toast.LENGTH_LONG).show();
                        }
                    });
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onUpgradeClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    mPrinterManager.upgradePrinter();
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onPaperClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {
                    final boolean hasPaper = mPrinterManager.printerPaper();
                    runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            String message = hasPaper ? "HAS PAPER" : "NO PAPER";
                            Toast.makeText(mContext, message, Toast.LENGTH_LONG).show();
                        }
                    });

                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
    private void onLengthClicked(){
        ThreadPoolManager.getInstance().executeTask(new Runnable() {
            @Override
            public void run() {
                // TODO Auto-generated method stub
                try {


                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        });
    }
}
