#include <linux/module.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <linux/delay.h>
#include <linux/types.h>
#include <linux/err.h>
#include <linux/uaccess.h>
#include "externcard.h"
#include <mach/mt_gpio.h>
#include <linux/cdev.h>
#include <linux/miscdevice.h>
#include <linux/platform_device.h>
#include <linux/leds.h>
#include <cust_leds.h>
#include <cust_leds_def.h>
#include <mach/upmu_common_sw.h>
#include <mach/upmu_hw.h>
#include "../leds/leds_sw.h"
#include "externcard.h"

#define MODULE_CATD_EN        89
#define ON                     1
#define OFF                    0

static unsigned int limit = 255;
static DEFINE_SEMAPHORE(power_mutex);

static void uart_switch0 (int on);
static void uart_switch1 (int on);

struct externcard_dev
{
	int data;
    struct cdev c_dev;
};


static unsigned int brightness_mapping(unsigned int level)
{
    unsigned int mapped_level;
    
    mapped_level = level;
       
	return mapped_level;
}

static int brightness_set_pmic(enum mt65xx_led_pmic pmic_type, enum led_brightness level)
{
#define PMIC_BACKLIGHT_LEVEL    80

	int tmp_level = level;
	//static bool backlight_init_flag = false;
	static bool first_time = true;
        static unsigned char duty_mapping[PMIC_BACKLIGHT_LEVEL] = {
                0,	1,	2,	3,	4,	5,	6,	7,	8,	9,	10,	11,	
                12,     13,     14,     15,     16,     17,     18,     19,     20,     21,     22,     23,     
                24,     25,     26,     27,     28,     29,     30,     31,     16,     17,     18,     19,     
                20,     21,     22,     23,     24,     25,     26,     27,     28,     29,     30,     31,     
                21,     22,     23,     24,     25,     26,     27,     28,     29,     30,     31,     24,     
                25,     26,     27,     28,     29,     30,     31,     25,     26,     27,     28,     29,     
                30,     31,     26,     27,     28,     29,     30,     31,

    };
        static unsigned char current_mapping[PMIC_BACKLIGHT_LEVEL] = {
                0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,
                0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      0,      
                0,      0,      0,      0,      0,      0,      0,      0,      1,      1,      1,      1,      
                1,      1,      1,      1,      1,      1,      1,      1,      1,      1,      1,      1,      
                2,      2,      2,      2,      2,      2,      2,      2,      2,      2,      2,      3,      
                3,      3,      3,      3,      3,      3,      3,      4,      4,      4,      4,      4,      
                4,      4,      5,      5,      5,      5,      5,      5,
    };

	printk("[LEDS]LK: PMIC Type: %d, Level: %d\n", pmic_type, level);

	if (pmic_type == MT65XX_LED_PMIC_LCD_ISINK)
	{
		//if(backlight_init_flag == false)
		{
            upmu_set_rg_drv_2m_ck_pdn(0x0); // Disable power down
            upmu_set_rg_drv_32k_ck_pdn(0x0); // Disable power down (backlight no need?)    

            // For backlight: Current: 24mA, PWM frequency: 20K, Duty: 20~100, Soft start: off, Phase shift: on
            // ISINK0
            upmu_set_rg_isink0_ck_pdn(0x0); // Disable power down    
            upmu_set_rg_isink0_ck_sel(0x1); // Freq = 1Mhz for Backlight
			upmu_set_isink_ch0_mode(ISINK_PWM_MODE);
            upmu_set_isink_ch0_step(0x5); // 24mA
            upmu_set_isink_sfstr0_en(0x0); // Disable soft start
			upmu_set_rg_isink0_double_en(0x1); // Enable double current
			upmu_set_isink_phase_dly_tc(0x0); // TC = 0.5us
			upmu_set_isink_phase0_dly_en(0x1); // Enable phase delay
            upmu_set_isink_chop0_en(0x1); // Enable CHOP clk
            // ISINK1
            upmu_set_rg_isink1_ck_pdn(0x0); // Disable power down   
            upmu_set_rg_isink1_ck_sel(0x1); // Freq = 1Mhz for Backlight
			upmu_set_isink_ch1_mode(ISINK_PWM_MODE);
            upmu_set_isink_ch1_step(0x5); // 24mA
            upmu_set_isink_sfstr1_en(0x0); // Disable soft start
                        upmu_set_rg_isink1_double_en(0x1); // Enable double current
			upmu_set_isink_phase1_dly_en(0x1); // Enable phase delay
            upmu_set_isink_chop1_en(0x1); // Enable CHOP clk         
            // ISINK2
            upmu_set_rg_isink2_ck_pdn(0x0); // Disable power down   
            upmu_set_rg_isink2_ck_sel(0x1); // Freq = 1Mhz for Backlight
			upmu_set_isink_ch2_mode(ISINK_PWM_MODE);
            upmu_set_isink_ch2_step(0x5); // 24mA
            upmu_set_isink_sfstr2_en(0x0); // Disable soft start
                        upmu_set_rg_isink2_double_en(0x1); // Enable double current
			upmu_set_isink_phase2_dly_en(0x1); // Enable phase delay
            upmu_set_isink_chop2_en(0x1); // Enable CHOP clk   
            // ISINK3
            upmu_set_rg_isink3_ck_pdn(0x0); // Disable power down   
            upmu_set_rg_isink3_ck_sel(0x1); // Freq = 1Mhz for Backlight
			upmu_set_isink_ch3_mode(ISINK_PWM_MODE);
            upmu_set_isink_ch3_step(0x5); // 24mA
            upmu_set_isink_sfstr3_en(0x0); // Disable soft start
                        upmu_set_rg_isink3_double_en(0x1); // Enable double current
			upmu_set_isink_phase3_dly_en(0x1); // Enable phase delay
            upmu_set_isink_chop3_en(0x1); // Enable CHOP clk                
                        //backlight_init_flag = true;
		}
		
		if (level) 
		{
			level = brightness_mapping(tmp_level);
			if(level == ERROR_BL_LEVEL)
				level = limit;
#if 0            
            if(((level << 5) / limit) < 1)
            {
                level = 0;
            }
            else
            {
                level = ((level << 5) / limit) - 1;
            }
#endif      

            if(level == limit)
            {
				level = PMIC_BACKLIGHT_LEVEL;
            }
            else
            {
				level = ((level * PMIC_BACKLIGHT_LEVEL) / 255) + 1;
            }
            printk("[LEDS]LK: Level Mapping = %d \n", level);
            printk("[LEDS]LK: ISINK DIM Duty = %d \n", duty_mapping[level-1]);
            printk("[LEDS]LK: ISINK Current = %d \n", current_mapping[level-1]);
            upmu_set_isink_dim0_duty(duty_mapping[level-1]);
            upmu_set_isink_dim1_duty(duty_mapping[level-1]);
            upmu_set_isink_dim2_duty(duty_mapping[level-1]);
            upmu_set_isink_dim3_duty(duty_mapping[level-1]);
            upmu_set_isink_ch0_step(current_mapping[level-1]);
            upmu_set_isink_ch1_step(current_mapping[level-1]);
            upmu_set_isink_ch2_step(current_mapping[level-1]);
            upmu_set_isink_ch3_step(current_mapping[level-1]);
            upmu_set_isink_dim0_fsel(0x2); // 20Khz
            upmu_set_isink_dim1_fsel(0x2); // 20Khz
            upmu_set_isink_dim2_fsel(0x2); // 20Khz
            upmu_set_isink_dim3_fsel(0x2); // 20Khz            
            upmu_set_isink_ch0_en(0x1); // Turn on ISINK Channel 0
            upmu_set_isink_ch1_en(0x1); // Turn on ISINK Channel 1
            upmu_set_isink_ch2_en(0x1); // Turn on ISINK Channel 2
            upmu_set_isink_ch3_en(0x1); // Turn on ISINK Channel 3
		}
		else 
		{
            upmu_set_isink_ch0_en(0x0); // Turn off ISINK Channel 0
            upmu_set_isink_ch1_en(0x0); // Turn off ISINK Channel 1
            upmu_set_isink_ch2_en(0x0); // Turn off ISINK Channel 2
            upmu_set_isink_ch3_en(0x0); // Turn off ISINK Channel 3
		}
        
		return 0;
	}
	else if(pmic_type == MT65XX_LED_PMIC_NLED_ISINK0)
	{
		if(first_time == true)
		{
            upmu_set_isink_ch0_en(0x0); // Turn off ISINK Channel 0
			first_time = false;
		}

            upmu_set_rg_isink0_ck_pdn(0x0); // Disable power down    
            upmu_set_rg_isink0_ck_sel(0x0); // Freq = 32KHz for Indicator            
            upmu_set_isink_dim0_duty(15); // 16 / 32, no use for register mode
			upmu_set_isink_ch0_mode(ISINK_REGISTER_MODE);
            upmu_set_isink_dim0_fsel(0x0); // 1KHz, no use for register mode
            upmu_set_isink_ch0_step(0x0); // 4mA
            upmu_set_isink_sfstr0_tc(0x0); // 0.5us
            upmu_set_isink_sfstr0_en(0x0); // Disable soft start
			upmu_set_rg_isink0_double_en(0x0); // Disable double current
			upmu_set_isink_phase0_dly_en(0x0); // Disable phase delay
            upmu_set_isink_chop0_en(0x0); // Disable CHOP clk
		
		if (level) 
		{
            upmu_set_rg_drv_2m_ck_pdn(0x0); // Disable power down (indicator no need?)     
            upmu_set_rg_drv_32k_ck_pdn(0x0); // Disable power down            
            upmu_set_isink_ch0_en(0x1); // Turn on ISINK Channel 0
			
		}
		else 
		{
            upmu_set_isink_ch0_en(0x0); // Turn off ISINK Channel 0
		}
		return 0;
	}
	else if(pmic_type == MT65XX_LED_PMIC_NLED_ISINK1)
	{
		if(first_time == true)
		{
            upmu_set_isink_ch1_en(0x0); // Turn off ISINK Channel 1
			first_time = false;
		}

            upmu_set_rg_isink1_ck_pdn(0x0); // Disable power down    
            upmu_set_rg_isink1_ck_sel(0x0); // Freq = 32KHz for Indicator            
            upmu_set_isink_dim1_duty(15); // 16 / 32, no use for register mode
			upmu_set_isink_ch1_mode(ISINK_REGISTER_MODE);
            upmu_set_isink_dim1_fsel(0x0); // 1KHz, no use for register mode
            upmu_set_isink_ch1_step(0x0); // 4mA
            upmu_set_isink_sfstr1_tc(0x0); // 0.5us
            upmu_set_isink_sfstr1_en(0x0); // Disable soft start
			upmu_set_rg_isink1_double_en(0x0); // Disable double current
			upmu_set_isink_phase1_dly_en(0x0); // Disable phase delay
            upmu_set_isink_chop1_en(0x0); // Disable CHOP clk

		
		if (level) 
		{
            upmu_set_rg_drv_2m_ck_pdn(0x0); // Disable power down (indicator no need?)     
            upmu_set_rg_drv_32k_ck_pdn(0x0); // Disable power down            
            upmu_set_isink_ch1_en(0x1); // Turn on ISINK Channel 1
			
		}
		else 
		{
            upmu_set_isink_ch1_en(0x0); // Turn off ISINK Channel 1
		}
		return 0;
	}
	else if(pmic_type == MT65XX_LED_PMIC_NLED_ISINK2)
	{
		if(first_time == true)
		{
            upmu_set_isink_ch2_en(0x0); // Turn off ISINK Channel 2
			first_time = false;
		}

            upmu_set_rg_isink2_ck_pdn(0x0); // Disable power down    
            upmu_set_rg_isink2_ck_sel(0x0); // Freq = 32KHz for Indicator            
            upmu_set_isink_dim2_duty(15); // 16 / 32, no use for register mode
			upmu_set_isink_ch2_mode(ISINK_REGISTER_MODE);
            upmu_set_isink_dim2_fsel(0x0); // 1KHz, no use for register mode
            upmu_set_isink_ch2_step(0x0); // 4mA
            upmu_set_isink_sfstr2_tc(0x0); // 0.5us
            upmu_set_isink_sfstr2_en(0x0); // Disable soft start
			upmu_set_rg_isink2_double_en(0x0); // Disable double current
			upmu_set_isink_phase2_dly_en(0x0); // Disable phase delay
            upmu_set_isink_chop2_en(0x0); // Disable CHOP clk

		
		if (level) 
		{
            upmu_set_rg_drv_2m_ck_pdn(0x0); // Disable power down (indicator no need?)     
            upmu_set_rg_drv_32k_ck_pdn(0x0); // Disable power down            
            upmu_set_isink_ch2_en(0x1); // Turn on ISINK Channel 2
			
		}
		else 
		{
            upmu_set_isink_ch2_en(0x0); // Turn off ISINK Channel 2
		}
		return 0;
	}
    else if(pmic_type == MT65XX_LED_PMIC_NLED_ISINK3)
	{
		if(first_time == true)
		{
            upmu_set_isink_ch3_en(0x0); // Turn off ISINK Channel 3
			first_time = false;
		}

            upmu_set_rg_isink3_ck_pdn(0x0); // Disable power down    
            upmu_set_rg_isink3_ck_sel(0x0); // Freq = 32KHz for Indicator            
            upmu_set_isink_dim3_duty(15); // 16 / 32, no use for register mode
			upmu_set_isink_ch3_mode(ISINK_REGISTER_MODE);
            upmu_set_isink_dim3_fsel(0x0); // 1KHz, no use for register mode
            upmu_set_isink_ch3_step(0x0); // 4mA
            upmu_set_isink_sfstr3_tc(0x0); // 0.5us
            upmu_set_isink_sfstr3_en(0x0); // Disable soft start
			upmu_set_rg_isink3_double_en(0x0); // Disable double current
			upmu_set_isink_phase3_dly_en(0x0); // Disable phase delay
            upmu_set_isink_chop3_en(0x0); // Disable CHOP clk
		
		if (level) 
		{
            upmu_set_rg_drv_2m_ck_pdn(0x0); // Disable power down (indicator no need?)     
            upmu_set_rg_drv_32k_ck_pdn(0x0); // Disable power down            
            upmu_set_isink_ch3_en(0x1); // Turn on ISINK Channel 3
			
		}
		else 
		{
            upmu_set_isink_ch3_en(0x0); // Turn off ISINK Channel 3
		}
		return 0;
	}
	return -1;
}


//this funciton will power on the Card enable pin
static void card_en(int on)
{
	mt_set_gpio_mode(MODULE_CATD_EN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_CATD_EN,GPIO_DIR_OUT);
	
	if(on){
		mt_set_gpio_out(MODULE_CATD_EN,GPIO_OUT_ONE);
	}else{
		mt_set_gpio_out(MODULE_CATD_EN,GPIO_OUT_ZERO);
	}
}

static void switch_iccard()
{
	printk("externcard driver: switch to iccard\n");
	uart_switch0(0);
	uart_switch1(0);
}

static void switch_code()
{
	printk("externcard driver: switch to code\n");
	uart_switch0(1);
	uart_switch1(0);
}

static void switch_ext()
{
	printk("externcard driver: switch to ext\n");
	uart_switch0(0);
	uart_switch1(1);
}

static void switch_psam()
{
	printk("externcard driver: switch to psam\n");
	uart_switch0(1);
	uart_switch1(1);
}


static void uart_switch0 (int on)
{
	if(on){
		 printk(KERN_ERR "ISINK1 output 1\n");
		 brightness_set_pmic(MT65XX_LED_PMIC_NLED_ISINK1, LED_OFF);
	}else{
		printk(KERN_ERR "ISINK1 output 0\n");
		brightness_set_pmic(MT65XX_LED_PMIC_NLED_ISINK1, LED_FULL);
	}
}

static void uart_switch1 (int on)
{
	if(on){
		 printk(KERN_ERR "ISINK2 output 1\n");
		 brightness_set_pmic(MT65XX_LED_PMIC_NLED_ISINK0, LED_OFF);
	}else{
		 printk(KERN_ERR "ISINK2 output 0\n");
		brightness_set_pmic(MT65XX_LED_PMIC_NLED_ISINK0, LED_FULL);
	}
}

static ssize_t externcard_show(struct device *dev, struct device_attribute *attr, char *buf)
{
	int data = -1;
	struct externcard_dev *extcard = (struct externcard_dev *)dev_get_drvdata(dev);
	data = extcard->data;
	return sprintf(buf, "%d\n", data);
}

static DEVICE_ATTR(externcard, S_IRUGO, externcard_show, NULL);

//when application execut open function ,this function will be executed
static int externcard_open (struct inode *inode, struct file *file)
{
    struct externcard_dev *extcard;
	
	extcard = container_of(inode->i_cdev, struct externcard_dev, c_dev);
	file->private_data = (void *)extcard;
	
	return 0;
}

//when application execut read function ,this function will be executed
static ssize_t externcard_read (struct file *file, char __user *buff, size_t count, loff_t *f_ops)
{
	struct externcard_dev *extcard;
	extcard = (struct externcard_dev *)file->private_data;
	
	if(count < sizeof(extcard->data))
		return 0;
	copy_to_user(buff, &(extcard->data), sizeof(extcard->data));
	
	return sizeof(extcard->data);
}

static ssize_t externcard_write (struct file *file, const char __user * buff, size_t count, loff_t *f_ops)
{
	return 0;
}

static int externcard_release (struct inode *inode, struct file * file)
{
	switch_psam();

	return 0;
}

static long externcard_unlocked_ioctl (struct file *file, unsigned int cmd, unsigned long arg)
{
	int ret = -1;
	struct externcard_dev *extcard;
	
	extcard = (struct externcard_dev *)file->private_data;
	if((_IOC_TYPE(cmd) != EXTERNCARD) && (_IOC_NR(cmd) > EXTERNCARD_MAX))
	{
		printk("the cmd %d unavailable!\n", cmd);
		return -EINVAL;
	}

	switch(cmd)
	{
		case EXTERNCARD_ICCARD:
			switch_iccard();
			ret = 0;
			break;

		case EXTERNCARD_CODE:
			switch_code();
			ret = 0;
			break;
		
		case EXTERNCARD_EXT:
			switch_ext();
			ret = 0;
			break;
		
		case EXTERNCARD_PSAM:
			switch_psam();
			ret = 0;
			break;
		default: 
			ret = -1;
			break;
	}
	return ret;
}

static struct file_operations externcard_fops = {
    .owner          = THIS_MODULE,
    .read           = externcard_read,
    .write          = externcard_write,
    .unlocked_ioctl = externcard_unlocked_ioctl,
	.open           = externcard_open,
    .release        = externcard_release,
};

static struct miscdevice externcard_miscdev =
{
	.minor = MISC_DYNAMIC_MINOR,
	.name = "externcard",
	.fops = &externcard_fops,
};

static int externcard_suspend(struct platform_device *kdev, pm_message_t state)
{
    return 0;
}

static int externcard_resume(struct platform_device *pdev)
{
	return 0;
}

static void externcard_shutdown(struct platform_device *pdev)
{
	return NULL;
}

static void externcard_remove(struct platform_device *pdev)
{
	misc_deregister(&externcard_miscdev);
}

static int externcard_probe(struct platform_device *pdev)
{
    int err;
	struct externcard_dev *extcard = NULL;

	extcard = kmalloc(sizeof(struct externcard_dev), GFP_KERNEL);
	memset(extcard, 0 , sizeof(struct externcard_dev));
	//default data is 3, so the default swithc data is 3
	extcard->data = 3;

	err = device_create_file(&(pdev->dev), &dev_attr_externcard);
	if(err)
	{
		printk("create externcard_dev failure !");
		return err;
	}
	
	dev_set_drvdata(&(pdev->dev), (void *)extcard);
	err = misc_register(&externcard_miscdev);
	if(err)
	{
		printk("misc externcard dev regitster failed !\n");
		return err;
	}
	return 0;
}

struct platform_device externcard_device =
{
    .name = "externcard",
    .id = -1,
};

struct platform_driver externcard_driver =
{
	.probe = externcard_probe,
	.remove = externcard_remove,
	.shutdown = externcard_shutdown,
	.suspend = externcard_suspend,
	.resume = externcard_resume,
	.driver =
		{
		.owner = THIS_MODULE,
		.name = "externcard",
		},
};

static int __init externcard_init(void)
{
    platform_device_register(&externcard_device);
    platform_driver_register(&externcard_driver);
}


static void __exit externcard_exit(void)
{
	platform_device_unregister(&externcard_device);
	platform_driver_unregister(&externcard_driver);
}


module_init(externcard_init);
module_exit(externcard_exit);
MODULE_DESCRIPTION("externcard driver");
MODULE_LICENSE("GPL");
MODULE_AUTHOR("chenqw");

