﻿#include <linux/module.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <linux/delay.h>
#include <linux/types.h>
#include <linux/err.h>
#include <linux/uaccess.h>
#include "magnetic.h"
#include <mach/mt_gpio.h>

//#define MODULE_GPIO_CARD_EN   17
#define MODULE_GPIO_CARD_EN   89
#define MODULE_MSR_STROBE     135
#define MODULE_MSR_DATA       136  

///Max received data buffer size of IC card reader
#define IC_READER_MAX_BUFFER_SIZE           (256)
///Max size of data on 1st strip
#define MSTRIP_READER_STRIP1_MAX_DATA_SIZE  (76)
///Max size of data on 2nd strip
#define MSTRIP_READER_STRIP2_MAX_DATA_SIZE  (37)
///Max size of data on 3rd strip
#define MSTRIP_READER_STRIP3_MAX_DATA_SIZE  (104)
#define MSTRIP_READER_PRECODE_DATA_SIZE     (16)

#define  DEF_MAGNETICSTRIPECARDLENINBIT_PRE   16   //前导
#define  DEF_MAGNETICSTRIPECARDLENINBYTE_PRE  (DEF_MAGNETICSTRIPECARDLENINBIT_PRE / 8) //2
#define  DEF_MAGNETICSTRIPECARDLENINBIT       704  //数据
#define  DEF_MAGNETICSTRIPECARDLENINBYTE      (DEF_MAGNETICSTRIPECARDLENINBIT / 8)     //=88
#define  DEF_MAGNETICSTRIPECARDLENINBIT_ALL   (DEF_MAGNETICSTRIPECARDLENINBIT_PRE + (3 * DEF_MAGNETICSTRIPECARDLENINBIT))
#define  DEF_MAGNETICSTRIPECARDLENINBYTE_ALL  (DEF_MAGNETICSTRIPECARDLENINBIT_ALL / 8)

static   uint8_t ucMagneticStripeCardGetStat;
#define  DEF_MAGNETICSTRIPECARD_PRESENT  0
#define  DEF_MAGNETICSTRIPECARD_READY    1

static   uint8_t   ucMagneticStripeCardByteCnt1,ucMagneticStripeCardByteCnt2,ucMagneticStripeCardByteCnt3 ;

static int data_count = 0;
static char msr_data[IC_READER_MAX_BUFFER_SIZE];
static int msr_major = -1;
static int msr_minor = -1;
static struct magnetic_dev* msr_dev = NULL;


/**
* 函 数 MagneticStripeCardInit() 功能描述：磁条卡读卡器初始化
* @param  
* @return  
* @author  
* @date 20151016
* @note
*/
static void MagneticStripeCardInit(void)
{		
	MagneticStripeCardDataIn();
	MagneticStripeCardSetClkHigh();
	mdelay(10);   		//10ms (Trdy) ,  complete power up reset
	MagneticStripeCardRst_Arm();     //进入等待读卡
	ucMagneticStripeCardGetStat = DEF_MAGNETICSTRIPECARD_PRESENT;
}

/**
 * 函 数 MagneticStripeCardRst_Arm() 功能描述：磁条卡读卡器复位
 * @param  
 * @return  
 * @author  
 * @date 20151016
 * @note
 */
static void MagneticStripeCardRst_Arm(void) 
{ 
	//ndelay(250);                     //250ns (TstbL)
	MagneticStripeCardSetClkHigh();
	ndelay(250);                     //170ns (Tsu1_rst)
	
	MagneticStripeCardSetDataLow();
	
	udelay(5);   					//4.5us (Tsu2_rst)
	MagneticStripeCardSetClkLow();

	ndelay(250);                    //250ns (TstbL)
	MagneticStripeCardSetClkHigh();

	ndelay(250); 					//250ns (TstbH)
	MagneticStripeCardSetClkLow();

	ndelay(250);
	MagneticStripeCardDataIn();
	
	//ndelay(250); 					//20ns (Tsu_mode)
	//MagneticStripeCardSetDataHigh();
	
	ndelay(250); 					//250ns (TstbL) ,  20ns (Th_mode)
	MagneticStripeCardSetClkHigh();

	udelay(130);                    //12.75us (TstbH2)
	MagneticStripeCardSetClkLow();

	//Arm
	ndelay(250); //250ns (TstbL)
	MagneticStripeCardSetClkHigh();

	ndelay(250); //250ns (TstbH)
	MagneticStripeCardSetClkLow();
	printk(KERN_ERR "MagneticStripeCardRst_Arm");

}

/**
 * 函 数 MagneticStripeCardSetDataHigh() 功能描述：磁条卡读卡器的数据线置高
 * @param  
 * @return  
 * @author  
 * @date 20151016
 * @note
 */
static void MagneticStripeCardSetDataHigh(void)
{
	mt_set_gpio_mode(MODULE_MSR_DATA,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_MSR_DATA,GPIO_DIR_OUT);
	mt_set_gpio_out(MODULE_MSR_DATA,GPIO_OUT_ONE);
}

/**
 * 函 数 MagneticStripeCardVccEn() 功能描述：磁条卡读卡器的数据线置高
 * @param  
 * @return  
 * @author  
 * @date 20151016
 * @note
 */
static void MagneticStripeCardVccEn(int en)
{
	mt_set_gpio_mode(MODULE_GPIO_CARD_EN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_GPIO_CARD_EN,GPIO_DIR_OUT);
	
	if(en){
		mt_set_gpio_out(MODULE_GPIO_CARD_EN,GPIO_OUT_ONE);
	}else{
		mt_set_gpio_out(MODULE_GPIO_CARD_EN,GPIO_OUT_ZERO);
	}
	
	
}



/**
* 函 数 MagneticStripeCardSetDataLow() 功能描述：磁条卡读卡器的数据线置低
* @param  
* @return  
* @author  
* @date 20151016
* @note
*/
static void   MagneticStripeCardSetDataLow(void)
{
	mt_set_gpio_mode(MODULE_MSR_DATA,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_MSR_DATA,GPIO_DIR_OUT);
	mt_set_gpio_out(MODULE_MSR_DATA,GPIO_OUT_ZERO);
}

/**
* 函 数 MagneticStripeCardSetClkHigh() 功能描述：磁条卡读卡器的时钟线置高
* @param  
* @return  
* @author  
* @date 20151016
* @note
*/
static void MagneticStripeCardSetClkHigh(void)
{
	mt_set_gpio_mode(MODULE_MSR_STROBE,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_MSR_STROBE,GPIO_DIR_OUT);
	mt_set_gpio_out(MODULE_MSR_STROBE,GPIO_OUT_ONE);
}
/**
* 函 数 MagneticStripeCardSetClkLow() 功能描述：磁条卡读卡器的时钟线置低
* @param  
* @return  
* @author  
* @date 20151016
* @note
*/
static void MagneticStripeCardSetClkLow(void)
{
	mt_set_gpio_mode(MODULE_MSR_STROBE,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_MSR_STROBE,GPIO_DIR_OUT);
	mt_set_gpio_out(MODULE_MSR_STROBE,GPIO_OUT_ZERO);
}

/**
 * 函 数 MagneticStripeCardDataIn() 功能描述：读取磁条卡读卡器的 数据 的高低电平
 * @param  
 * @return  磁条卡读卡器的 数据 的高低电平
 * @author  左俊
 * @date 20101117
 * @note
 */
static void MagneticStripeCardDataIn(void)
{
	mt_set_gpio_pull_enable(MODULE_MSR_DATA,GPIO_PULL_DISABLE);
	mt_set_gpio_mode(MODULE_MSR_DATA,GPIO_MODE_GPIO);
	mt_set_gpio_dir(MODULE_MSR_DATA,GPIO_DIR_IN);
	//return  mt_get_gpio_in(MODULE_MSR_DATA);
}
/**
 * 函 数 MagneticStripeCardDataRead() 功能描述：读取磁条卡读卡器的 数据 的高低电平
 * @param  
 * @return  磁条卡读卡器的 数据 的高低电平
 * @author  左俊
 * @date 20101117
 * @note
 */
static uint8_t MagneticStripeCardDataRead(void)
{
	MagneticStripeCardDataIn();
	return  mt_get_gpio_in(MODULE_MSR_DATA);
}

/**
 * 函 数 MagneticStripeCardAlterGetABit() 功能描述：从串缓冲区中取一位的数据
 * @param pucSrc 需要读取的数据缓冲区  uiOffset 数据的位置.
 * @return  返回 缓冲区中对应位 的数据 1/0
 * @author  左俊
 * @date 20101117
 * @note
 */
uint8_t MagneticStripeCardAlterGetABit(uint8_t* pucSrc , uint16_t  uiOffset)
{
	const uint8_t ucaBitMask[8] = {0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
	if((pucSrc[ uiOffset / 8] & ucaBitMask[uiOffset % 8] ) != 0)
		return  1;
	else
		return  0;
}

/**
 * 函 数 _ucChgHiLo() 功能描述：对一字节,高低位置换
 * @param ucP1 需要转换的数据
 * @return  返回 转换后的数据
 * @author  左俊
 * @date 20101117
 * @note
 */
uint8_t ucChgHiLo(uint8_t ucP1)
{
	uint8_t ucRet1;
	uint8_t ucCnt1;
	const uint8_t ucaBitMask[8] = {0x80,0x40,0x20,0x10,0x08,0x04,0x02,0x01};
	ucRet1 = 0;
	for(ucCnt1 = 0;ucCnt1 < 8;ucCnt1++)
	{
		if((ucP1 & ucaBitMask[ucCnt1] ) != 0)
			ucRet1 |= ucaBitMask[7-ucCnt1];
	}
	return  ucRet1;
}

/**
 * 函 数 MagneticStripeCard2Check() 功能描述：磁条卡读卡器 的定时器循环检测
 * @param 
 * @return  
 * @author  左俊
 * @date 20101117
 * @note  检测到数据时,通过发送函数送出数据
 */
int MagneticStripeCard2Check(void) 
{
	uint16_t uiMagCnt1, uiMagCnt2, uiMagCnt3;
	uint8_t* pucMagSrcData;
	uint8_t* pucT1;
	uint8_t prt = 0;
	uint8_t ret = -1;
	/*
	if(uiMagneticStripeCardWaitCnt == 0)
		return;
	*/	
//	uiMagneticStripeCardWaitCnt--;
/*
	if(uiMagneticStripeCardGap2 > 0) //
		uiMagneticStripeCardGap2--;
*/
	printk(KERN_ERR "MagneticStripeCard2Check");

	while(1)
	{
		ret = MagneticStripeCardGetChk();
		if(2 == ret)     //有刷卡操作
			continue;
		else if(1 == ret)//数据有效确认成功
		{
			pucMagSrcData = kmalloc(DEF_MAGNETICSTRIPECARDLENINBYTE_ALL+1, GFP_KERNEL);
			if(pucMagSrcData != NULL)
			{
				memset((void *)pucMagSrcData,0,DEF_MAGNETICSTRIPECARDLENINBYTE_ALL+1);
				printk(KERN_ERR "MagneticStripeCard2Check has data");
				MagneticStripeCardGetData(pucMagSrcData, DEF_MAGNETICSTRIPECARDLENINBIT_ALL);   //三个磁道的数据
				MagneticStripeCardRst_Arm();

				uiMagCnt2 = 88+ (2-1); //最后字节,前面 2 字节干吗的呢？
				while(uiMagCnt2 > 2)
				{
					if(pucMagSrcData[uiMagCnt2] != 0)
						break;
					uiMagCnt2--;
				}
				ucMagneticStripeCardByteCnt1 = uiMagCnt2 - 1;    //一磁道数据个数

				uiMagCnt2 = 88+88+ (2-1); //最后字节
				while(uiMagCnt2 > (2+88))
				{
					if(pucMagSrcData[uiMagCnt2] != 0)
						break;
					uiMagCnt2--;
				}
				ucMagneticStripeCardByteCnt2 = uiMagCnt2 - (1+88);  //二磁道数据个数

				uiMagCnt2 = 88+88+88+ (2-1); //最后字节
				while(uiMagCnt2 > (2+88+88))
				{
					if(pucMagSrcData[uiMagCnt2] != 0)
						break;
					uiMagCnt2--;
				}
				ucMagneticStripeCardByteCnt3 = uiMagCnt2 - (1+88+88);   //三磁道数据个数

				pucT1 = kmalloc(300, GFP_KERNEL);
				if(pucT1 != NULL)
				{
				#if 1
					uiMagCnt1 = MagneticStripeCardAlterData1((uint8_t*)(pucMagSrcData+2), ucMagneticStripeCardByteCnt1, (uint8_t*)(pucT1 + prt + 1));
					if(uiMagCnt1 <= 1)
					uiMagCnt1 = MagneticStripeCardAlterData23((uint8_t*)(pucMagSrcData+2),ucMagneticStripeCardByteCnt1, (uint8_t*)(pucT1 + prt + 1));
					if(0 == uiMagCnt1)
						pucT1[prt] = 0x00;          //当一磁道数据为空的时候，将有效数据设置为0
					else
						pucT1[prt] = uiMagCnt1 - 1;  //不为空时,去掉最后的校验位

					//重新设置有效数据buff指针
					if(uiMagCnt1 > 1)
						prt += (uiMagCnt1-1);         
					else
						prt += uiMagCnt1;
					//转换第二磁道数据
					uiMagCnt2 = MagneticStripeCardAlterData23((uint8_t*)(pucMagSrcData+(2+88)),ucMagneticStripeCardByteCnt2, (uint8_t*)(pucT1 + prt +2));
					
					if(0 == uiMagCnt2)
						pucT1[prt + 1] = 0x00;
					else
						pucT1[prt + 1] = uiMagCnt2 - 1;

					if(uiMagCnt2 > 1)
						prt += (uiMagCnt2 - 1);
					else
						prt += uiMagCnt2;
					uiMagCnt3 = MagneticStripeCardAlterData23((uint8_t*)(pucMagSrcData+(2+88+88)),ucMagneticStripeCardByteCnt3, (uint8_t*)(pucT1 + prt + 3));
					if(uiMagCnt3 <= 1)
					uiMagCnt3 = MagneticStripeCardAlterData1 ((uint8_t*)(pucMagSrcData+(2+88+88)),ucMagneticStripeCardByteCnt3, (uint8_t*)(pucT1+ prt + 3));
					if(0 == uiMagCnt3)
						pucT1[prt + 2] = 0x00;
					else
						pucT1[prt + 2] = uiMagCnt3 - 1;

					if(uiMagCnt3 > 1)
						prt += (uiMagCnt3 -1);
					else
						prt += uiMagCnt3;
					if((uiMagCnt1 != 0) || (uiMagCnt2 != 0) ||(uiMagCnt3 != 0))
					{
						memset(msr_data, 0, sizeof(msr_data));
						memcpy((void *)msr_data, (void *)pucT1, prt + 3);
						data_count = prt +3;
						kfree((void *)pucT1);
						kfree((void *)pucMagSrcData);
						return 0;
					}
					#else
					memcpy((void *)pucT1, (void *)"MAG{", 4);
					uiMagCnt1 = MagneticStripeCardAlterData1((uint8_t*)(pucMagSrcData+2), ucMagneticStripeCardByteCnt1, (uint8_t*)(pucT1+4));
					if(uiMagCnt1 <= 1)
						uiMagCnt1 = MagneticStripeCardAlterData23((uint8_t*)(pucMagSrcData+2),ucMagneticStripeCardByteCnt1, (uint8_t*)(pucT1+4));

					pucT1[uiMagCnt1+4] = '~';
					uiMagCnt2 = MagneticStripeCardAlterData23((uint8_t*)(pucMagSrcData+(2+88)),ucMagneticStripeCardByteCnt2, (uint8_t*)(pucT1+(uiMagCnt1+5)));
					pucT1[uiMagCnt1+uiMagCnt2+5] = '~';

					uiMagCnt3 = MagneticStripeCardAlterData23((uint8_t*)(pucMagSrcData+(2+88+88)),ucMagneticStripeCardByteCnt3, (uint8_t*)(pucT1+(uiMagCnt1+uiMagCnt2+6)));
					if(uiMagCnt3 <= 1)
					uiMagCnt3 = MagneticStripeCardAlterData1 ((uint8_t*)(pucMagSrcData+(2+88+88)),ucMagneticStripeCardByteCnt3, (uint8_t*)(pucT1+(uiMagCnt1+uiMagCnt2+6)));

					pucT1[uiMagCnt1+uiMagCnt2+uiMagCnt3+6] = '}';
					pucT1[uiMagCnt1+uiMagCnt2+uiMagCnt3+7] = 0x0d;
					pucT1[uiMagCnt1+uiMagCnt2+uiMagCnt3+8] = 0x0a;
					if((uiMagCnt1 != 0) || (uiMagCnt2 != 0) ||(uiMagCnt3 != 0))
					{
						memset(msr_data, 0, sizeof(msr_data));
						memcpy((void *)msr_data, (void *)pucT1, uiMagCnt1+uiMagCnt2+uiMagCnt3+9);
						kfree((void *)pucT1);
						kfree((void *)pucMagSrcData);
						return 0;
					}
					#endif
				}
			}
			kfree((void *)pucT1);
			kfree((void *)pucMagSrcData);
		}
		else if (0 == ret)   //无刷卡操作
		{
			break;
		}else if(-1== ret)
		{
			//timeout
		}
	}
	return -1;
}


/**
 * 函 数 MagneticStripeCardGetChk() 功能描述：检查磁条卡读卡器 有无刷卡
 * @param  
 * @return  刷卡了则返回1,其它0
 * @author  
 * @date 20151016
 * @note
 */
uint8_t	MagneticStripeCardGetChk(void)
{
	switch (ucMagneticStripeCardGetStat)
	{
		case DEF_MAGNETICSTRIPECARD_PRESENT:
			if (MagneticStripeCardDataRead()==0)
			{
				//MAGClrPresent();
				udelay(1); //20ns (Tsu_stbH)
				MagneticStripeCardSetClkHigh();

				udelay(1);   //1.1us (TstbH_CP)
				MagneticStripeCardSetClkLow();  
				
				ucMagneticStripeCardGetStat = DEF_MAGNETICSTRIPECARD_READY;
				return 2;
			}
			break;

		case DEF_MAGNETICSTRIPECARD_READY:
			if (MagneticStripeCardDataRead()==0)
			{
				ucMagneticStripeCardGetStat = DEF_MAGNETICSTRIPECARD_PRESENT;
				return  1;
			}
			/*
			else
			if (uiMagneticStripeCardGap2 == 0) //异常时,等待 3 秒
			{
				uiMagneticStripeCardGap2 = 0;
				MagneticStripeCardRst_Arm(); 
				ucMagneticStripeCardGetStat = DEF_MAGNETICSTRIPECARD_PRESENT;
			}
			*/
			break;
		}
		return  0;

}


/**
 * 函 数 MagneticStripeCardGetData() 功能描述：读取磁条卡读卡器 的数据到缓冲区
 * @param  pryubTkData-缓冲区 ,uwCntInBits-数据位数
 * @return  
 * @author  左俊
 * @date 20101117
 * @note
 */
void MagneticStripeCardGetData(uint8_t* pryubTkData, uint16_t uwCntInBits)
{
	uint8_t ubTkBitPos;
	ubTkBitPos = 0x80; //原来先收为低位 ,现在改为 先收在高位.
	*pryubTkData = 0;  //init
	ndelay(300);     //250ns (TstbL)

	// this delay is for the _MagneticStripeCardSetClkHigh(); statement in the while loop
	while (uwCntInBits--)
	{
		//250ns (TstbL)
		MagneticStripeCardSetClkHigh();

		ndelay(250); //250ns (TstbH)
		MagneticStripeCardSetClkLow();

		ndelay(250); //170ns (Tsd)

		if (MagneticStripeCardDataRead()==0) 
			*pryubTkData |= ubTkBitPos;                     
			ubTkBitPos >>= 1;

		if (ubTkBitPos == 0)
		{
			ubTkBitPos = 0x80;
			pryubTkData++;
			//if (uwCntInBits)
			{
				*pryubTkData = 0;  //init
			}
		}
	}
}


/**
 * 函 数 MagneticStripeCardAlterData1() 功能描述：一磁道数据解析, 从原始数据中,解析磁条数据到 ASC码.
 * @param pucSrc-原始数据缓冲区, ucSrcLen-原始数据的长度, pucTgt-目标数据缓冲区
 * @return  返回 结束的数据的长度.0-解析不成功
 * @author  左俊
 * @date 20101117
 * @note
 */
uint8_t MagneticStripeCardAlterData1(uint8_t* pucSrc, uint8_t ucSrcLen, uint8_t* pucTgt)
{
	uint8_t   ucRev;
	uint8_t   ucTgtCnt;
	uint16_t  uiCurPos,uiCurPosK;
	uint8_t   ucCurChar;
	uint8_t   ucLrc;
	uint8_t   ucAlterStat; //1-找到了起始符号；2－找到了结束符号; 3-接收了效验，4－异常了

	uint8_t   ucBitCnt;
	uint8_t   ucBit1Cnt;
	uint16_t  uiSrcLen1;

	pucTgt[0] = 0;

    // Liuwl 20130523 不再限定磁道最少数据
	//if(ucSrcLen <= 4) //zlq2012.11.05
	//	return  0;

	uiSrcLen1 = ucSrcLen;
	uiSrcLen1*= 8;
	for(ucRev = 0; ucRev<2; ucRev++)
	{
		uiCurPosK= 0;
		while(uiCurPosK < uiSrcLen1)
		{
			ucTgtCnt = 0;
			uiCurPos = uiCurPosK;
			for( ; uiCurPos<uiSrcLen1; uiCurPos++)
			{
				if(MagneticStripeCardAlterGetABit(pucSrc , uiCurPos) != 0)
					break;
			}
			
			uiCurPosK = uiCurPos+1;

			if( uiCurPos >= uiSrcLen1)
					break;
			
			ucLrc = 0;
			ucAlterStat = 0;
			for(;;)
			{
				for(ucCurChar = 0, ucBit1Cnt = 0, ucBitCnt=0;ucBitCnt<7;ucBitCnt++)
				{
					ucCurChar >>= 1;
					if(MagneticStripeCardAlterGetABit(pucSrc , uiCurPos) != 0)
					{
						ucCurChar = ucCurChar | 0x40;
						ucBit1Cnt++;
					}
					uiCurPos++;
				}
				if((ucCurChar == 0) && (ucTgtCnt != 0))
				{
					if(((ucLrc == 0) && (ucAlterStat == 3)) && (ucTgtCnt > 4))
					{
						pucTgt[ucTgtCnt] = 0;
						return  ucTgtCnt; //结束
					}
					else
						break; 
				}
				if((ucBit1Cnt & 0x01) == 0x00 )
					break;

				ucCurChar = (ucCurChar & 0x3f);
				//找起始符号
				if(ucAlterStat == 0)
				{
					if(ucCurChar != 0x05)
						break;
					ucAlterStat = 1;
				}
				//中途的数据
				else if(ucAlterStat == 1)
				{
					if(ucCurChar == 0x1F)
					{
						if(ucTgtCnt <= 1)
							break;
						ucAlterStat = 2;
					}
					else if(ucCurChar == 0x05)
					{
						ucLrc = 0;
						ucTgtCnt = 0;
					}
				}	
				else if(ucAlterStat == 2)  //效验
				{
					ucAlterStat = 3;
				}else if(ucAlterStat == 3) //异常
				{
					ucAlterStat = 4;
				}
				else
					break;
				ucLrc  ^= ucCurChar;
				pucTgt[ucTgtCnt++] = ucCurChar+0x20;
			}
		
			if((ucTgtCnt <= 1) && (ucCurChar == 0x3F))
				break;
		}

		if(ucRev == 0)
		{
			for(ucLrc = 0,ucTgtCnt = ucSrcLen - 1; ucLrc < ucTgtCnt ; ucLrc++, ucTgtCnt--)
			{
				ucCurChar        = ucChgHiLo(pucSrc[ucLrc]);
				pucSrc[ucLrc]    = ucChgHiLo(pucSrc[ucTgtCnt]);
				pucSrc[ucTgtCnt] = ucCurChar;
			}
			if(ucLrc == ucTgtCnt)
				pucSrc[ucLrc] = ucChgHiLo(pucSrc[ucTgtCnt]);
		}
	}
	return  0;//找不到合适的数据 
}

/**
 * 函 数 MagneticStripeCardAlterData23() 功能描述：二三磁道数据解析, 从原始数据中,解析磁条数据到 ASC码.
 * @param pucSrc-原始数据缓冲区, ucSrcLen-原始数据的长度, pucTgt-目标数据缓冲区
 * @return  返回 结束的数据的长度.0-解析不成功
 * @author  左俊
 * @date 20101117
 * @note
 */
uint8_t MagneticStripeCardAlterData23(uint8_t* pucSrc, uint8_t ucSrcLen, uint8_t* pucTgt)
{
	uint8_t   ucRev;
	uint8_t   ucTgtCnt;
	uint16_t  uiCurPos,uiCurPosK;
	uint8_t   ucCurChar;
	uint8_t   ucLrc;
	uint8_t   ucAlterStat; //1-找到了起始符号；2－找到了结束符号; 3-接收了效验，4－异常了

	uint8_t   ucBitCnt;
	uint8_t   ucBit1Cnt;
	uint16_t  uiSrcLen1;

	pucTgt[0] = 0;

    // Liuwl 20130523 不再限定磁道最少数据
	//if(ucSrcLen <= 4)//zlq2012.11.05
	//	return  0;

	uiSrcLen1 = ucSrcLen;
	uiSrcLen1*= 8;

	for(ucRev = 0;ucRev < 2;ucRev++)
	{
		uiCurPosK= 0;
		while(uiCurPosK < uiSrcLen1)
		{
			ucTgtCnt = 0;
			uiCurPos = uiCurPosK;
			for(  ; uiCurPos < uiSrcLen1; uiCurPos++)
			{
				if(MagneticStripeCardAlterGetABit(pucSrc , uiCurPos) != 0)
					break;
			}
			uiCurPosK = uiCurPos+1;

			if( uiCurPos >= uiSrcLen1)
				break;
			
			ucLrc = 0;
			ucAlterStat = 0;
			for(;;)
			{
				//取一个5位原始数据. 
				for(ucCurChar = 0, ucBit1Cnt = 0, ucBitCnt=0;ucBitCnt<5;ucBitCnt++)
				{
					ucCurChar >>= 1;
					if(MagneticStripeCardAlterGetABit(pucSrc , uiCurPos) != 0)
					{
						ucCurChar = ucCurChar | 0x10;
						ucBit1Cnt++;
					}
					uiCurPos++;
				}

				if((ucCurChar == 0) && (ucTgtCnt != 0))
				{
					if(((ucLrc == 0) && (ucAlterStat == 3)) && (ucTgtCnt > 4))
					{
						pucTgt[ucTgtCnt] = 0;
						return  ucTgtCnt; //结束
					}
					else
						break;		//return  1;
				}
				
				if((ucBit1Cnt & 0x01) == 0x00 )
					break;

				ucCurChar &= 0x0f;

				if(ucAlterStat == 0)  				//找起始符号
				{
					if(ucCurChar != 0x0b)
						break;
					ucAlterStat = 1;
				}else if(ucAlterStat == 1)				//中途的数据
				{
					if(ucCurChar == 0x0F)
					{
						if(ucTgtCnt <= 1)
							break;
						ucAlterStat = 2;
					}else if(ucCurChar == 0x0B)
					{
							ucLrc = 0;
							ucTgtCnt = 0;
					}
				}else if(ucAlterStat == 2)     //效验
				{
					ucAlterStat = 3;
				}else if(ucAlterStat == 3)       //异常
				{
					ucAlterStat = 4;
				}else
						break;

				ucLrc ^= ucCurChar;
				ucCurChar += 0x30;
				pucTgt[ucTgtCnt++] = ucCurChar;
			}
			
			if((ucTgtCnt <= 1) && (ucCurChar == 0x3F))
					break;
		}
		
		if(ucRev == 0)
		{//将原始数据 倒换后再来尝试.
			for(ucLrc = 0,ucTgtCnt = ucSrcLen - 1; ucLrc < ucTgtCnt ; ucLrc++, ucTgtCnt--)
			{
				ucCurChar        = ucChgHiLo(pucSrc[ucLrc]);
				pucSrc[ucLrc]    = ucChgHiLo(pucSrc[ucTgtCnt]);
				pucSrc[ucTgtCnt] = ucCurChar;
			}
			if(ucLrc == ucTgtCnt)
				pucSrc[ucLrc] = ucChgHiLo(pucSrc[ucTgtCnt]);
				
		}
	}
	
	return  0;//找不到合适的数据 
}

static int magnetic_open (struct inode *inode, struct file *file)
{
	//MagneticStripeCardVccEn(0);
	//mdelay(30);
	//MagneticStripeCardVccEn(1);
	return 0;
}


static ssize_t magnetic_read (struct file *file, char __user *buff, size_t count, loff_t *f_ops)
{
	int ret = -1;
	
	if(0 == MagneticStripeCard2Check())
	{
		ret = copy_to_user(buff, &msr_data, data_count);
		printk(KERN_ERR "msr copy_to_user");
		return data_count;
	}
	
	if(ret!=0)
		return -EAGAIN;
	
}


static ssize_t magnetic_write (struct file *file, const char __user * buff, size_t count, loff_t *f_ops)
{
	return 0;
}
static long magnetic_unlocked_ioctl (struct file *file, unsigned int cmd, unsigned long arg)
{
	int ret = -1;
	switch(cmd)
	{
		case MSR_READY_READ:
			MagneticStripeCardInit();
			ret = 0;
			break;
		case MSR_READ_TRACK:
			ret = -1;
			break;
		default: 
			ret = -1;
			break;
	}
	return ret;
}
static int magnetic_release (struct inode *inode, struct file * file)
{	
	MagneticStripeCardSetClkLow();
	MagneticStripeCardSetDataLow();
	//MagneticStripeCardVccEn(0);
	return 0;
}


static struct file_operations msr_fops = {
	.owner          = THIS_MODULE,
	.read           = magnetic_read,
	.write          = magnetic_write,
	.unlocked_ioctl = magnetic_unlocked_ioctl,
	.open           = magnetic_open,
	.release        = magnetic_release,
};


static int __init magnetic_init(void)
{
	dev_t devt;
	int result;
	
	printk(KERN_ALERT "magnetic_init");

	result = alloc_chrdev_region(&devt, 0, 1,MSR_DEVICE_NODE); //在 proc/devices会显示
	if(result < 0){
		printk(KERN_ERR "alloc magnetic device number error!\n");
		return result;
	}
	msr_major = MAJOR(devt);
	msr_minor = MINOR(devt);

	msr_dev = kmalloc(sizeof(struct magnetic_dev),GFP_KERNEL);
	if(!msr_dev){
		result = -ENOMEM;
		printk(KERN_ALERT "no memory to alloc magnetic_dev");
		goto malloc_fail;
	}

	memset(msr_dev, 0, sizeof(struct magnetic_dev));
	cdev_init(&(msr_dev->cdev),&msr_fops);
	msr_dev->cdev.ops = &msr_fops;
	msr_dev->cdev.owner = THIS_MODULE;

	result = cdev_add(&(msr_dev->cdev) , devt,1);
	if(result < 0){
		printk(KERN_ERR "magnetic_init : register magnetic devices fail");
		goto register_fail;
	}

	msr_dev->class = class_create(THIS_MODULE, MSR_DEVICE_CLASS_NAME);
	if(IS_ERR(msr_dev->class)){
		printk(KERN_ERR "magnetic_init: magnetic class creat fail");
		result = PTR_ERR(msr_dev->class);
		goto class_fail;
	}

	msr_dev->device = device_create(msr_dev->class, NULL, devt, NULL, MSR_DEVICE_CLASS_NAME);
	if(IS_ERR(msr_dev->device)){
		printk(KERN_ALERT "magnetic_init: magnetic device create fail");
		result = PTR_ERR(msr_dev->device);
		goto device_fali;
	}
	
	
	return 0;

device_fali:
	class_destroy(msr_dev->class);
class_fail:
	cdev_del(&(msr_dev->cdev));
register_fail:
	kfree(msr_dev);
malloc_fail:
	unregister_chrdev_region(devt, 1);
	return result;
	
}

static void __exit magnetic_exit(void)
{
	dev_t devt = MKDEV(msr_major,msr_minor);

	if(msr_dev->class){
		device_destroy(msr_dev->class, devt);
		class_destroy(msr_dev->class);
	}

	if(msr_dev){
		cdev_del(&(msr_dev->cdev));
		kfree(msr_dev);
	}
	
	unregister_chrdev_region(devt, 1);
	
}

module_init(magnetic_init);
module_exit(magnetic_exit);
MODULE_LICENSE("GPL");

