
#ifndef __MAGNETIC_H_
#define __MAGNETIC_H_


#include <linux/cdev.h>
#include <linux/semaphore.h>

#define MSR_MAGIC 'd'
#define MSR_READY_READ   _IO(MSR_MAGIC,0)
#define MSR_READ_TRACK   _IOW(MSR_MAGIC,1,int)

#define MSR_DEVICE_CLASS_NAME    "msr"
#define MSR_DEVICE_NODE          "msr"
#define MSR_DEVICE_FILE_NAME     "msr"

static void MagneticStripeCardInit(void);
static void MagneticStripeCardRst_Arm(void);
static void MagneticStripeCardSetDataHigh(void);
static void MagneticStripeCardSetDataLow(void);
static uint8_t MagneticStripeCardDataRead(void);
static void MagneticStripeCardDataIn(void);
static void MagneticStripeCardSetClkHigh(void);
static void MagneticStripeCardSetClkLow(void);
static int msr_check_thread_start(void);
static void msr_check_thread_stop(void);
static int msr_check_kthread(void* data);

uint8_t	MagneticStripeCardGetChk(void);
void MagneticStripeCardGetData(uint8_t* pryubTkData, uint16_t uwCntInBits);
uint8_t MagneticStripeCardAlterData1(uint8_t* pucSrc, uint8_t ucSrcLen, uint8_t* pucTgt);
uint8_t MagneticStripeCardAlterGetABit(uint8_t* pucSrc , uint16_t  uiOffset);
uint8_t MagneticStripeCardAlterData23(uint8_t* pucSrc, uint8_t ucSrcLen, uint8_t* pucTgt);


struct magnetic_dev {
	   struct cdev cdev;
	   struct class *class;
	   struct device *device;
};

#endif
