#include <linux/module.h>
#include <linux/init.h>
#include <linux/fs.h>
#include <linux/slab.h>
#include <linux/device.h>
#include <linux/delay.h>
#include <linux/types.h>
#include <linux/err.h>
#include <linux/uaccess.h>
#include <mach/mt_gpio.h>
#include <linux/cdev.h>
#include <linux/miscdevice.h>
#include <linux/platform_device.h>
#include "telpoio.h"

#define CARD_ENABLE_PIN        89
#define PRT_EN                 61
#define HOST_PWR_EN            128
#define ON                     1
#define OFF                    0

static int host_count = 0;
static int card_count = 0;
static DEFINE_SEMAPHORE(dev_power_mutex);

static struct power_dev
{
	int data;
    struct cdev c_dev;
};

static void printer_power(int on)
{
	mt_set_gpio_mode(PRT_EN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(PRT_EN,GPIO_DIR_OUT);
	mt_set_gpio_mode(HOST_PWR_EN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(HOST_PWR_EN,GPIO_DIR_OUT);
	
	if(on){
		mt_set_gpio_out(PRT_EN,GPIO_OUT_ONE);
		mt_set_gpio_out(HOST_PWR_EN,GPIO_OUT_ONE);
	}else{
		mt_set_gpio_out(PRT_EN,GPIO_OUT_ZERO);
		mdelay(200);
		if(host_count<=0)
			mt_set_gpio_out(HOST_PWR_EN,GPIO_OUT_ZERO);
	}
	
}

static void psam_power(int on)
{
	mt_set_gpio_mode(CARD_ENABLE_PIN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(CARD_ENABLE_PIN,GPIO_DIR_OUT);
	mt_set_gpio_mode(HOST_PWR_EN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(HOST_PWR_EN,GPIO_DIR_OUT);
	
	if(on){
		mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ONE);
		mt_set_gpio_out(HOST_PWR_EN,GPIO_OUT_ONE);
	}else{
		if(card_count<=0)
			mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ZERO);
		if(host_count<=0)
			mt_set_gpio_out(HOST_PWR_EN,GPIO_OUT_ZERO);
	}
}
static void iccard_power(int on)
{
	mt_set_gpio_mode(CARD_ENABLE_PIN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(CARD_ENABLE_PIN,GPIO_DIR_OUT);
	
	if(on){
		mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ONE);
	}else{
		if(card_count<=0)
		    mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ZERO);
	}
}
static void qrcode_power(int on)
{
	mt_set_gpio_mode(CARD_ENABLE_PIN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(CARD_ENABLE_PIN,GPIO_DIR_OUT);
	
	if(on){
		mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ONE);
	}else{
		if(card_count<=0)
		    mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ZERO);
	}
}

static void msr_power(int on)
{
	mt_set_gpio_mode(CARD_ENABLE_PIN,GPIO_MODE_GPIO);
	mt_set_gpio_dir(CARD_ENABLE_PIN,GPIO_DIR_OUT);
	
	if(on){
		mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ONE);
	}else{
		if(card_count<=0)
		    mt_set_gpio_out(CARD_ENABLE_PIN,GPIO_OUT_ZERO);
	}
}
//when application execut open function ,this function will be executed
static int devices_power_open (struct inode *inode, struct file *file)
{
	struct power_dev *power;
	
	power = container_of(inode->i_cdev, struct power_dev, c_dev);
	file->private_data = (void *)power;
	
	return 0;
}

//when application execut read function ,this function will be executed
static ssize_t devices_power_read (struct file *file, char __user *buff, size_t count, loff_t *f_ops)
{
	return 0;
}

static ssize_t devices_power_write (struct file *file, const char __user * buff, size_t count, loff_t *f_ops)
{
	return 0;
}

static int devices_power_release (struct inode *inode, struct file * file)
{	
	return 0;
}

static long devices_power_unlocked_ioctl (struct file *file, unsigned int cmd, unsigned long arg)
{
	int ret = -1;
	printk("telpoio:ioctl running....\n");
	switch(cmd)
	{
		case TELPO_IOCTL_USB_PRINTER_POWON:
			if (down_interruptible(&dev_power_mutex))
			return -ERESTARTSYS;
			printer_power(ON);
			host_count++;
			up(&dev_power_mutex);
			ret = 0;
			break;
		case TELPO_IOCTL_USB_PRINTER_POWOFF:
			if (down_interruptible(&dev_power_mutex))
				return -ERESTARTSYS;
			host_count--;
			printer_power(OFF);
			up(&dev_power_mutex);
			ret = 0;
			break;
                 case TELPO_IOCTL_PSAM_CARD_SELON:
                        if (down_interruptible(&dev_power_mutex))
	                        return -ERESTARTSYS;
                        psam_power(ON);
                        host_count++;
                        card_count++;
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
                 case TELPO_IOCTL_PSAM_CARD_SELOFF:
                        if (down_interruptible(&dev_power_mutex))
                                 return -ERESTARTSYS;
                        host_count--;
                        card_count--;
                        psam_power(OFF);
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
					
                 case TELPO_IOCTL_IC_CARD_SELON:
                        if (down_interruptible(&dev_power_mutex))
	                        return -ERESTARTSYS;
                        iccard_power(ON);
                        card_count++;
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
                 case TELPO_IOCTL_IC_CARD_SELOFF:
                        if (down_interruptible(&dev_power_mutex))
                                 return -ERESTARTSYS;
                        card_count--;
                        iccard_power(OFF);
                        up(&dev_power_mutex);
                        ret = 0;
                        break;

                 case TELPO_IOCTL_QR_CODE_SELON:
                        if (down_interruptible(&dev_power_mutex))
	                        return -ERESTARTSYS;
                        qrcode_power(ON);
                        card_count++;
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
                 case TELPO_IOCTL_QR_CODE_SELOFF:
                        if (down_interruptible(&dev_power_mutex))
                                 return -ERESTARTSYS;
                        card_count--;
                        qrcode_power(OFF);
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
                 case TELPO_IOCTL_MSR_CARD_SELON:
                        if (down_interruptible(&dev_power_mutex))
	                        return -ERESTARTSYS;
                        msr_power(ON);
                        card_count++;
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
                 case TELPO_IOCTL_MSR_CARD_SELOFF:
                        if (down_interruptible(&dev_power_mutex))
                                 return -ERESTARTSYS;
                        card_count--;
                        msr_power(OFF);
                        up(&dev_power_mutex);
                        ret = 0;
                        break;
		default: 
			ret = -1;
			break;
	}
	return ret;
}

static struct file_operations dev_power_fops = {
    .owner          = THIS_MODULE,
    .read           = devices_power_read,
    .write          = devices_power_write,
    .unlocked_ioctl = devices_power_unlocked_ioctl,
	.open           = devices_power_open,
    .release        = devices_power_release,
};

static struct miscdevice devices_power_miscdev =
{
	.minor = MISC_DYNAMIC_MINOR,
	.name = "telpoio",
	.fops = &dev_power_fops,
};

static int telpoio_suspend(struct platform_device *kdev, pm_message_t state)
{
    return 0;
}

static int telpoio_resume(struct platform_device *pdev)
{
	return 0;
}

static void telpoio_shutdown(struct platform_device *pdev)
{

}

static void telpoio_remove(struct platform_device *pdev)
{
	misc_deregister(&devices_power_miscdev);
}

static int telpoio_probe(struct platform_device *pdev)
{
    int err;
	struct power_dev *power = NULL;

	power = kmalloc(sizeof(struct power_dev), GFP_KERNEL);
	memset(power, 0 , sizeof(struct power_dev));
	power->data = 0;

	err = misc_register(&devices_power_miscdev);
	if(err)
	{
		printk("misc devices power dev regitster failed !\n");
		return err;
	}
	return 0;
}

struct platform_device telpoio_dev =
{
    .name = "telpoio",
    .id = -1,
};

struct platform_driver telpoio_driver =
{
	.probe = telpoio_probe,
	.remove = telpoio_remove,
	.shutdown = telpoio_shutdown,
	.suspend = telpoio_suspend,
	.resume = telpoio_resume,
	.driver =
		{
		.owner = THIS_MODULE,
		.name = "telpoio",
		},
};

static int __init telpoio_init(void)
{
    platform_device_register(&telpoio_dev);
    platform_driver_register(&telpoio_driver);
}


static void __exit telpoio_exit(void)
{
	platform_device_unregister(&telpoio_dev);
	platform_driver_unregister(&telpoio_driver);
}


module_init(telpoio_init);
module_exit(telpoio_exit);
MODULE_DESCRIPTION("telpoio driver");
MODULE_LICENSE("GPL");
MODULE_AUTHOR("chenqw");

