#ifndef ANDROID_AUDIO_MTK_HARDWARE_COMMAND_H
#define ANDROID_AUDIO_MTK_HARDWARE_COMMAND_H

enum AudioCommand
{
    AUDIOCOMMAND_NONE = 0,
    SETOUTPUTFIRINDEX = 1,
    GETOUTPUTFIRINDEX = 2,
    SETMEDDATA = 3,
    GETMEDDATA = 4,
    GETAUDIOCUSTOMDATASIZE = 5,
    SETAUDIOCUSTOMDATA = 6,
    GETAUDIOCUSTOMDATA = 7,
    START_FMTX_SINEWAVE = 8,
    STOP_FMTX_SINEWAVE  = 9,
    // use for MED output FIR
    GETNORMALOUTPUTFIRINDEX = 0x10,
    GETHEADSETOUTPUTFIRINDEX = 0x11,
    GETSPEAKEROUTPUTFIRINDEX = 0x12,
    SETNORMALOUTPUTFIRINDEX = 0x20,
    SETHEADSETOUTPUTFIRINDEX = 0x21,
    SETSPEAKEROUTPUTFIRINDEX = 0x22,
    GET_DUAL_MIC_PARAMETER   = 0x30,
    SET_DUAL_MIC_PARAMETER   = 0x31,
    GET_WB_SPEECH_PARAMETER   = 0x40,
    SET_WB_SPEECH_PARAMETER   = 0x41,
    SET_LOAD_VOLUME_SETTING    = 0x50,
    SET_DUMP_AUDIO_AEE_CHECK    = 0x5E,
    GET_DUMP_AUDIO_AEE_CHECK    = 0x5F,
    // used for Speech Logger
    SET_SPEECH_VM_ENABLE       = 0x60,
    SET_DUMP_SPEECH_DEBUG_INFO = 0x61,
    // used for Audio Logger
    SET_DUMP_AUDIO_DEBUG_INFO  = 0x62,
    SET_DUMP_AUDIO_STREAM_OUT  = 0x63,
    GET_DUMP_AUDIO_STREAM_OUT  = 0x64,
    SET_DUMP_AUDIO_MIXER_BUF   = 0x65,
    GET_DUMP_AUDIO_MIXER_BUF   = 0x66,
    SET_DUMP_AUDIO_TRACK_BUF   = 0x67,
    GET_DUMP_AUDIO_TRACK_BUF   = 0x68,
    SET_DUMP_A2DP_STREAM_OUT   = 0x69,
    GET_DUMP_A2DP_STREAM_OUT   = 0x6A,
    SET_DUMP_AUDIO_STREAM_IN   = 0x6B,
    GET_DUMP_AUDIO_STREAM_IN   = 0x6C,
    SET_DUMP_IDLE_VM_RECORD    = 0x6D,
    GET_DUMP_IDLE_VM_RECORD    = 0x6E,
    // for audio taste tool
    AUD_TASTE_TUNING = 0x70,
    HOOK_FM_DEVICE_CALLBACK    = 0x71,
    UNHOOK_FM_DEVICE_CALLBACK  = 0x72,
    HOOK_BESLOUDNESS_CONTROL_CALLBACK    = 0x73,
    UNHOOK_BESLOUDNESS_CONTROL_CALLBACK  = 0x74,
    //used for Gain Table in advanced meta
    GET_GAIN_TABLE_CTRPOINT_NUM     = 0x80,
    GET_GAIN_TABLE_CTRPOINT_BITS    = 0x81,
    GET_GAIN_TABLE_CTRPOINT_TABLE   = 0x82,
    // used for test case
    AUDIO_USER_TEST = 0x90,
    //AP side Speech logger
    SET_DUMP_AP_SPEECH_EPL   = 0xA0,
    GET_DUMP_AP_SPEECH_EPL   = 0xA1,
    SET_MagiASR_TEST_ENABLE   = 0xA2,
    GET_MagiASR_TEST_ENABLE   = 0xA3,
    SET_AECREC_TEST_ENABLE   = 0xA4,
    GET_AECREC_TEST_ENABLE   = 0xA5,
    //ANC Data
    GET_SPEECH_ANC_SUPPORT = 0xB0,
    SET_SPEECH_ANC_STATUS = 0xB1,
    GET_SPEECH_ANC_STATUS = 0xB2,
    SET_SPEECH_ANC_LOG_ENABLE = 0xB3,
    SET_SPEECH_ANC_LOG_DISABLE = 0xB4,
    GET_SPEECH_ANC_LOG_STATUS = 0xB5,
    START_SPEECH_ANC_CALIBRATION = 0xB6,
    GET_SPEECH_ANC_CALIBRATION_STATUS = 0xB7,

    // audio data
    GET_AUDIO_VER1_DATA = 0x100,
    SET_AUDIO_VER1_DATA = 0x101,
    // used for voice ui and unlock
    GET_VOICE_CUST_PARAM = 0x200,
    GET_VOICE_FIR_COEF = 0x201,
    GET_VOICE_GAIN = 0x202,

    // used for vibration spk calibration
    SET_CUREENT_SENSOR_ENABLE = 0x210,
    SET_CURRENT_SENSOR_RESET = 0x211
#ifdef MTK_ACF_AUTO_GEN_SUPPORT
                               ,
    AUDIO_ACF_FO = 0x212
#endif
};
#endif
