/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/*******************************************************************************
 *
 * Filename:
 * ---------
 *   AudioFtm.cpp
 *
 * Project:
 * --------
 *   Android Audio Driver
 *
 * Description:
 * ------------
 *   Factory mode Control
 *
 * Author:
 * -------
 *   Chipeng Chang (mtk02308)
 *
 *------------------------------------------------------------------------------
 * $Revision: #5 $
 * $Modtime:$
 * $Log:$
 *
 * 04 10 2012 weiguo.li
 * [ALPS00266592] [Need Patch] [Volunteer Patch] ICS_MP patchback to ALPS.ICS of Audio
 * .
 *
 * 01 11 2012 donglei.ji
 * [ALPS00106007] [Need Patch] [Volunteer Patch]DMNR acoustic loopback feature
 * .
 *
 *
 *******************************************************************************/

/*****************************************************************************
*                     C O M P I L E R   F L A G S
******************************************************************************
*/


/*****************************************************************************
*                E X T E R N A L   R E F E R E N C E S
******************************************************************************
*/

#include <string.h>
#include <stdint.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sched.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <utils/String8.h>

#include <CFG_AUDIO_File.h>

#include "AudioFtm.h"
#include "AudioIoctl.h"
#include "AudioDef.h"
#include "AudioType.h"
#include "audio_custom_exp.h"
//#include "AudioMTKStreamOut.h"
#include "AudioAnalogReg.h"

#include "AudioFMController.h"
#include "AudioMATVController.h"

#include "LoopbackManager.h"

#include "AudioVIBSPKControl.h"
#include "AudioCompFltCustParam.h"


#ifdef LOG_TAG
#undef LOG_TAG
#endif
#define LOG_TAG  "AudioFtm"
#ifndef ANDROID_DEFAULT_CODE
#include <cutils/xlog.h>
#ifdef ALOGE
#undef ALOGE
#endif
#ifdef ALOGW
#undef ALOGW
#endif ALOGI
#undef ALOGI
#ifdef ALOGD
#undef ALOGD
#endif
#ifdef ALOGV
#undef ALOGV
#endif
#define ALOGE XLOGE
#define ALOGW XLOGW
#define ALOGI XLOGI
#define ALOGD XLOGD
#define ALOGV XLOGV
#else
#include <utils/Log.h>
#endif

//#define MTK_DIGITAL_MIC_SUPPORT
/*****************************************************************************
*                          C O N S T A N T S
******************************************************************************
*/

static int OutputGainMap[] = {15, 12, 9, 6, 3, 0};

enum
{
    FTM_OUTPUTGAIN_1 = 0, // lowest gain
    FTM_OUTPUTGAIN_2,
    FTM_OUTPUTGAIN_3,
    FTM_OUTPUTGAIN_4,
    FTM_OUTPUTGAIN_5,
};


unsigned char stone1k_48kHz[192] =
{
    0x00, 0x00, 0xFF, 0xFF, 0xB5, 0x10, 0xB5, 0x10, 0x21, 0x21, 0x21, 0x21,
    0xFC, 0x30, 0xFC, 0x30, 0x00, 0x40, 0x00, 0x40, 0xEB, 0x4D, 0xEB, 0x4D,
    0x81, 0x5A, 0x82, 0x5A, 0x8C, 0x65, 0x8C, 0x65, 0xD9, 0x6E, 0xD9, 0x6E,
    0x40, 0x76, 0x41, 0x76, 0xA3, 0x7B, 0xA2, 0x7B, 0xE7, 0x7E, 0xE6, 0x7E,
    0xFF, 0x7F, 0xFF, 0x7F, 0xE6, 0x7E, 0xE7, 0x7E, 0xA2, 0x7B, 0xA2, 0x7B,
    0x41, 0x76, 0x41, 0x76, 0xD9, 0x6E, 0xD8, 0x6E, 0x8D, 0x65, 0x8C, 0x65,
    0x82, 0x5A, 0x81, 0x5A, 0xEB, 0x4D, 0xEB, 0x4D, 0xFF, 0x3F, 0xFF, 0x3F,
    0xFB, 0x30, 0xFB, 0x30, 0x20, 0x21, 0x21, 0x21, 0xB5, 0x10, 0xB5, 0x10,
    0x00, 0x00, 0xFF, 0xFF, 0x4B, 0xEF, 0x4B, 0xEF, 0xE0, 0xDE, 0xE0, 0xDE,
    0x05, 0xCF, 0x05, 0xCF, 0x00, 0xC0, 0x00, 0xC0, 0x14, 0xB2, 0x14, 0xB2,
    0x7D, 0xA5, 0x7F, 0xA5, 0x74, 0x9A, 0x75, 0x9A, 0x27, 0x91, 0x26, 0x91,
    0xC0, 0x89, 0xBF, 0x89, 0x5E, 0x84, 0x5D, 0x84, 0x19, 0x81, 0x19, 0x81,
    0x02, 0x80, 0x02, 0x80, 0x19, 0x81, 0x19, 0x81, 0x5E, 0x84, 0x5E, 0x84,
    0xBF, 0x89, 0xBF, 0x89, 0x27, 0x91, 0x28, 0x91, 0x75, 0x9A, 0x74, 0x9A,
    0x7E, 0xA5, 0x7E, 0xA5, 0x15, 0xB2, 0x15, 0xB2, 0x00, 0xC0, 0x00, 0xC0,
    0x04, 0xCF, 0x04, 0xCF, 0xDF, 0xDE, 0xDF, 0xDE, 0x4B, 0xEF, 0x4B, 0xEF
};

unsigned char stone1k_m4dB_48kHz[192] =
{
    0x00, 0x00, 0x00, 0x00, 0x8A, 0x0A, 0x8B, 0x0A, 0xE6, 0x14, 0xE7, 0x14,
    0xE7, 0x1E, 0xE7, 0x1E, 0x61, 0x28, 0x62, 0x28, 0x29, 0x31, 0x2B, 0x31,
    0x1A, 0x39, 0x1B, 0x39, 0x12, 0x40, 0x12, 0x40, 0xF1, 0x45, 0xF1, 0x45,
    0x9D, 0x4A, 0x9D, 0x4A, 0x02, 0x4E, 0x02, 0x4E, 0x11, 0x50, 0x12, 0x50,
    0xC3, 0x50, 0xC3, 0x50, 0x12, 0x50, 0x11, 0x50, 0x03, 0x4E, 0x02, 0x4E,
    0x9D, 0x4A, 0x9D, 0x4A, 0xF1, 0x45, 0xF1, 0x45, 0x13, 0x40, 0x12, 0x40,
    0x1B, 0x39, 0x1B, 0x39, 0x29, 0x31, 0x2A, 0x31, 0x62, 0x28, 0x62, 0x28,
    0xE8, 0x1E, 0xE7, 0x1E, 0xE7, 0x14, 0xE6, 0x14, 0x8B, 0x0A, 0x8B, 0x0A,
    0x00, 0x00, 0x00, 0x00, 0x76, 0xF5, 0x76, 0xF5, 0x19, 0xEB, 0x19, 0xEB,
    0x18, 0xE1, 0x19, 0xE1, 0x9E, 0xD7, 0x9E, 0xD7, 0xD6, 0xCE, 0xD6, 0xCE,
    0xE6, 0xC6, 0xE5, 0xC6, 0xEE, 0xBF, 0xEE, 0xBF, 0x0F, 0xBA, 0x0F, 0xBA,
    0x64, 0xB5, 0x64, 0xB5, 0xFE, 0xB1, 0xFE, 0xB1, 0xEE, 0xAF, 0xEF, 0xAF,
    0x3D, 0xAF, 0x3D, 0xAF, 0xEF, 0xAF, 0xEE, 0xAF, 0xFE, 0xB1, 0xFE, 0xB1,
    0x63, 0xB5, 0x63, 0xB5, 0x0F, 0xBA, 0x10, 0xBA, 0xED, 0xBF, 0xEE, 0xBF,
    0xE4, 0xC6, 0xE6, 0xC6, 0xD6, 0xCE, 0xD6, 0xCE, 0x9F, 0xD7, 0x9F, 0xD7,
    0x19, 0xE1, 0x18, 0xE1, 0x1A, 0xEB, 0x19, 0xEB, 0x75, 0xF5, 0x76, 0xF5
};

unsigned char stone1k_m8dB_48kHz[192] =
{
    0x01, 0x00, 0xFF, 0xFF, 0xA7, 0x06, 0xA6, 0x06, 0x31, 0x0D, 0x31, 0x0D,
    0x80, 0x13, 0x80, 0x13, 0x7A, 0x19, 0x7A, 0x19, 0x05, 0x1F, 0x05, 0x1F,
    0x08, 0x24, 0x08, 0x24, 0x6D, 0x28, 0x6D, 0x28, 0x21, 0x2C, 0x22, 0x2C,
    0x14, 0x2F, 0x14, 0x2F, 0x38, 0x31, 0x39, 0x31, 0x85, 0x32, 0x86, 0x32,
    0xF6, 0x32, 0xF5, 0x32, 0x85, 0x32, 0x85, 0x32, 0x37, 0x31, 0x39, 0x31,
    0x14, 0x2F, 0x14, 0x2F, 0x21, 0x2C, 0x21, 0x2C, 0x6D, 0x28, 0x6D, 0x28,
    0x07, 0x24, 0x08, 0x24, 0x05, 0x1F, 0x05, 0x1F, 0x7A, 0x19, 0x7B, 0x19,
    0x81, 0x13, 0x81, 0x13, 0x30, 0x0D, 0x31, 0x0D, 0xA6, 0x06, 0xA7, 0x06,
    0xFF, 0xFF, 0x00, 0x00, 0x5A, 0xF9, 0x59, 0xF9, 0xD0, 0xF2, 0xD0, 0xF2,
    0x80, 0xEC, 0x80, 0xEC, 0x86, 0xE6, 0x86, 0xE6, 0xFB, 0xE0, 0xFB, 0xE0,
    0xF7, 0xDB, 0xF8, 0xDB, 0x93, 0xD7, 0x93, 0xD7, 0xDF, 0xD3, 0xDF, 0xD3,
    0xEC, 0xD0, 0xEC, 0xD0, 0xC7, 0xCE, 0xC8, 0xCE, 0x7A, 0xCD, 0x7B, 0xCD,
    0x0B, 0xCD, 0x0B, 0xCD, 0x7B, 0xCD, 0x7A, 0xCD, 0xC8, 0xCE, 0xC8, 0xCE,
    0xED, 0xD0, 0xEC, 0xD0, 0xDF, 0xD3, 0xDE, 0xD3, 0x93, 0xD7, 0x92, 0xD7,
    0xF8, 0xDB, 0xF8, 0xDB, 0xFB, 0xE0, 0xFB, 0xE0, 0x86, 0xE6, 0x86, 0xE6,
    0x80, 0xEC, 0x81, 0xEC, 0xD0, 0xF2, 0xD0, 0xF2, 0x5A, 0xF9, 0x59, 0xF9
};

unsigned char stone2k_48kHz[96] =
{
    0x00, 0x00, 0x00, 0x00, 0x20, 0x21, 0x21, 0x21, 0x00, 0x40, 0xFF, 0x3F,
    0x82, 0x5A, 0x83, 0x5A, 0xD9, 0x6E, 0xD9, 0x6E, 0xA2, 0x7B, 0xA3, 0x7B,
    0xFE, 0x7F, 0xFE, 0x7F, 0xA2, 0x7B, 0xA2, 0x7B, 0xD9, 0x6E, 0xD9, 0x6E,
    0x82, 0x5A, 0x82, 0x5A, 0x00, 0x40, 0x00, 0x40, 0x21, 0x21, 0x20, 0x21,
    0x00, 0x00, 0x00, 0x00, 0xE0, 0xDE, 0xDF, 0xDE, 0x00, 0xC0, 0x01, 0xC0,
    0x7E, 0xA5, 0x7E, 0xA5, 0x27, 0x91, 0x27, 0x91, 0x5E, 0x84, 0x5E, 0x84,
    0x01, 0x80, 0x01, 0x80, 0x5E, 0x84, 0x5D, 0x84, 0x27, 0x91, 0x26, 0x91,
    0x7E, 0xA5, 0x7E, 0xA5, 0x00, 0xC0, 0x01, 0xC0, 0xE0, 0xDE, 0xDF, 0xDE
};

unsigned char stone2k_m4dB_48kHz[96] =
{
    0x00, 0x00, 0x00, 0x00, 0xE8, 0x14, 0xE8, 0x14, 0x62, 0x28, 0x61, 0x28,
    0x1C, 0x39, 0x1B, 0x39, 0xF0, 0x45, 0xF1, 0x45, 0x03, 0x4E, 0x01, 0x4E,
    0xC2, 0x50, 0xC3, 0x50, 0x02, 0x4E, 0x02, 0x4E, 0xF1, 0x45, 0xF1, 0x45,
    0x1B, 0x39, 0x1B, 0x39, 0x61, 0x28, 0x61, 0x28, 0xE6, 0x14, 0xE6, 0x14,
    0xFF, 0xFF, 0x00, 0x00, 0x1A, 0xEB, 0x1A, 0xEB, 0x9E, 0xD7, 0x9F, 0xD7,
    0xE5, 0xC6, 0xE5, 0xC6, 0x0F, 0xBA, 0x0F, 0xBA, 0xFE, 0xB1, 0xFE, 0xB1,
    0x3E, 0xAF, 0x3D, 0xAF, 0xFD, 0xB1, 0xFE, 0xB1, 0x10, 0xBA, 0x0F, 0xBA,
    0xE5, 0xC6, 0xE5, 0xC6, 0x9F, 0xD7, 0x9E, 0xD7, 0x19, 0xEB, 0x19, 0xEB
};

unsigned char stone3k_48kHz[64] =
{
    0x00, 0x00, 0x00, 0x00, 0xFB, 0x30, 0xFB, 0x30, 0x82, 0x5A, 0x82, 0x5A,
    0x41, 0x76, 0x41, 0x76, 0xFF, 0x7F, 0xFF, 0x7F, 0x40, 0x76, 0x41, 0x76,
    0x82, 0x5A, 0x82, 0x5A, 0xFB, 0x30, 0xFC, 0x30, 0x00, 0x00, 0x00, 0x00,
    0x05, 0xCF, 0x05, 0xCF, 0x7E, 0xA5, 0x7E, 0xA5, 0xBF, 0x89, 0xBF, 0x89,
    0x01, 0x80, 0x01, 0x80, 0xC0, 0x89, 0xC0, 0x89, 0x7D, 0xA5, 0x7E, 0xA5,
    0x05, 0xCF, 0x04, 0xCF
};

unsigned char stone3k_m4dB_48kHz[64] =
{
    0x00, 0x00, 0xFF, 0xFF, 0xE8, 0x1E, 0xE8, 0x1E, 0x1B, 0x39, 0x1B, 0x39,
    0x9D, 0x4A, 0x9D, 0x4A, 0xC3, 0x50, 0xC2, 0x50, 0x9D, 0x4A, 0x9D, 0x4A,
    0x1A, 0x39, 0x1B, 0x39, 0xE8, 0x1E, 0xE7, 0x1E, 0x00, 0x00, 0x01, 0x00,
    0x18, 0xE1, 0x18, 0xE1, 0xE6, 0xC6, 0xE5, 0xC6, 0x63, 0xB5, 0x63, 0xB5,
    0x3E, 0xAF, 0x3D, 0xAF, 0x63, 0xB5, 0x63, 0xB5, 0xE5, 0xC6, 0xE5, 0xC6,
    0x18, 0xE1, 0x19, 0xE1
};

unsigned char stone4k_48kHz[48] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x40, 0xD9, 0x6E, 0xD9, 0x6E,
    0xFF, 0x7F, 0xFF, 0x7F, 0xD9, 0x6E, 0xD9, 0x6E, 0xFF, 0x3F, 0xFF, 0x3F,
    0x01, 0x00, 0xFF, 0xFF, 0x01, 0xC0, 0x01, 0xC0, 0x27, 0x91, 0x27, 0x91,
    0x00, 0x80, 0x01, 0x80, 0x27, 0x91, 0x27, 0x91, 0x00, 0xC0, 0x00, 0xC0
};

unsigned char stone4k_m4dB_48kHz[48] =
{
    0x00, 0x00, 0x01, 0x00, 0x61, 0x28, 0x61, 0x28, 0xF0, 0x45, 0xF1, 0x45,
    0xC2, 0x50, 0xC2, 0x50, 0xF1, 0x45, 0xF1, 0x45, 0x62, 0x28, 0x62, 0x28,
    0x00, 0x00, 0xFF, 0xFF, 0x9F, 0xD7, 0x9F, 0xD7, 0x0F, 0xBA, 0x0F, 0xBA,
    0x3E, 0xAF, 0x3E, 0xAF, 0x0F, 0xBA, 0x10, 0xBA, 0x9F, 0xD7, 0x9F, 0xD7
};

unsigned char stone5k_48kHz[192] =
{
    0x00, 0x00, 0x00, 0x00, 0xEC, 0x4D, 0xEB, 0x4D, 0xA3, 0x7B, 0xA2, 0x7B,
    0x41, 0x76, 0x41, 0x76, 0xFF, 0x3F, 0xFF, 0x3F, 0x4C, 0xEF, 0x4B, 0xEF,
    0x7F, 0xA5, 0x7E, 0xA5, 0x19, 0x81, 0x19, 0x81, 0x27, 0x91, 0x27, 0x91,
    0x05, 0xCF, 0x05, 0xCF, 0x21, 0x21, 0x20, 0x21, 0x8C, 0x65, 0x8D, 0x65,
    0xFF, 0x7F, 0xFF, 0x7F, 0x8C, 0x65, 0x8C, 0x65, 0x21, 0x21, 0x21, 0x21,
    0x05, 0xCF, 0x04, 0xCF, 0x27, 0x91, 0x27, 0x91, 0x1A, 0x81, 0x19, 0x81,
    0x7E, 0xA5, 0x7E, 0xA5, 0x4B, 0xEF, 0x4B, 0xEF, 0xFF, 0x3F, 0xFF, 0x3F,
    0x41, 0x76, 0x41, 0x76, 0xA2, 0x7B, 0xA2, 0x7B, 0xEB, 0x4D, 0xEC, 0x4D,
    0x00, 0x00, 0x01, 0x00, 0x15, 0xB2, 0x14, 0xB2, 0x5E, 0x84, 0x5E, 0x84,
    0xBF, 0x89, 0xBF, 0x89, 0x01, 0xC0, 0x00, 0xC0, 0xB5, 0x10, 0xB6, 0x10,
    0x81, 0x5A, 0x82, 0x5A, 0xE6, 0x7E, 0xE7, 0x7E, 0xD9, 0x6E, 0xDA, 0x6E,
    0xFC, 0x30, 0xFA, 0x30, 0xDF, 0xDE, 0xE0, 0xDE, 0x75, 0x9A, 0x74, 0x9A,
    0x01, 0x80, 0x01, 0x80, 0x73, 0x9A, 0x75, 0x9A, 0xE0, 0xDE, 0xDF, 0xDE,
    0xFB, 0x30, 0xFC, 0x30, 0xD9, 0x6E, 0xD9, 0x6E, 0xE7, 0x7E, 0xE6, 0x7E,
    0x81, 0x5A, 0x82, 0x5A, 0xB5, 0x10, 0xB5, 0x10, 0x00, 0xC0, 0x01, 0xC0,
    0xC0, 0x89, 0xC0, 0x89, 0x5D, 0x84, 0x5E, 0x84, 0x15, 0xB2, 0x15, 0xB2
};

unsigned char stone5k_m4dB_48kHz[192] =
{
    0x00, 0x00, 0xFF, 0xFF, 0x2A, 0x31, 0x2A, 0x31, 0x02, 0x4E, 0x02, 0x4E,
    0x9E, 0x4A, 0x9D, 0x4A, 0x62, 0x28, 0x61, 0x28, 0x75, 0xF5, 0x76, 0xF5,
    0xE5, 0xC6, 0xE5, 0xC6, 0xEE, 0xAF, 0xEE, 0xAF, 0x10, 0xBA, 0x0F, 0xBA,
    0x18, 0xE1, 0x19, 0xE1, 0xE7, 0x14, 0xE7, 0x14, 0x13, 0x40, 0x12, 0x40,
    0xC3, 0x50, 0xC2, 0x50, 0x12, 0x40, 0x12, 0x40, 0xE7, 0x14, 0xE6, 0x14,
    0x18, 0xE1, 0x19, 0xE1, 0x10, 0xBA, 0x10, 0xBA, 0xEE, 0xAF, 0xEE, 0xAF,
    0xE5, 0xC6, 0xE5, 0xC6, 0x76, 0xF5, 0x75, 0xF5, 0x61, 0x28, 0x61, 0x28,
    0x9D, 0x4A, 0x9D, 0x4A, 0x02, 0x4E, 0x02, 0x4E, 0x2A, 0x31, 0x29, 0x31,
    0x00, 0x00, 0x00, 0x00, 0xD6, 0xCE, 0xD7, 0xCE, 0xFE, 0xB1, 0xFE, 0xB1,
    0x64, 0xB5, 0x63, 0xB5, 0xA0, 0xD7, 0x9F, 0xD7, 0x8A, 0x0A, 0x8A, 0x0A,
    0x1B, 0x39, 0x1B, 0x39, 0x11, 0x50, 0x12, 0x50, 0xF1, 0x45, 0xF0, 0x45,
    0xE8, 0x1E, 0xE8, 0x1E, 0x19, 0xEB, 0x19, 0xEB, 0xEE, 0xBF, 0xEE, 0xBF,
    0x3D, 0xAF, 0x3D, 0xAF, 0xED, 0xBF, 0xED, 0xBF, 0x19, 0xEB, 0x1A, 0xEB,
    0xE7, 0x1E, 0xE8, 0x1E, 0xF1, 0x45, 0xF0, 0x45, 0x12, 0x50, 0x12, 0x50,
    0x1B, 0x39, 0x1A, 0x39, 0x8B, 0x0A, 0x8A, 0x0A, 0x9E, 0xD7, 0x9F, 0xD7,
    0x63, 0xB5, 0x63, 0xB5, 0xFF, 0xB1, 0xFE, 0xB1, 0xD6, 0xCE, 0xD7, 0xCE
};

unsigned char stone6k_48kHz[32] =
{
    0x00, 0x00, 0x00, 0x00, 0x82, 0x5A, 0x82, 0x5A, 0xFF, 0x7F, 0xFF, 0x7F,
    0x82, 0x5A, 0x82, 0x5A, 0x00, 0x00, 0x00, 0x00, 0x7E, 0xA5, 0x7E, 0xA5,
    0x02, 0x80, 0x01, 0x80, 0x7F, 0xA5, 0x7F, 0xA5
};

unsigned char stone6k_m4dB_48kHz[32] =
{
    0xFF, 0xFF, 0x00, 0x00, 0x1B, 0x39, 0x1B, 0x39, 0xC3, 0x50, 0xC3, 0x50,
    0x1B, 0x39, 0x1C, 0x39, 0x00, 0x00, 0x00, 0x00, 0xE4, 0xC6, 0xE5, 0xC6,
    0x3D, 0xAF, 0x3E, 0xAF, 0xE4, 0xC6, 0xE4, 0xC6
};

unsigned char stone7k_48kHz[192] =
{
    0x00, 0x00, 0xFF, 0xFF, 0x8B, 0x65, 0x8B, 0x65, 0xA2, 0x7B, 0xA3, 0x7B,
    0xFB, 0x30, 0xFB, 0x30, 0x00, 0xC0, 0x00, 0xC0, 0x19, 0x81, 0x19, 0x81,
    0x7F, 0xA5, 0x7E, 0xA5, 0xB5, 0x10, 0xB5, 0x10, 0xD8, 0x6E, 0xD9, 0x6E,
    0x41, 0x76, 0x41, 0x76, 0x20, 0x21, 0x21, 0x21, 0x14, 0xB2, 0x15, 0xB2,
    0x01, 0x80, 0x01, 0x80, 0x15, 0xB2, 0x14, 0xB2, 0x21, 0x21, 0x21, 0x21,
    0x40, 0x76, 0x41, 0x76, 0xD9, 0x6E, 0xD9, 0x6E, 0xB5, 0x10, 0xB5, 0x10,
    0x7D, 0xA5, 0x7E, 0xA5, 0x19, 0x81, 0x1A, 0x81, 0x01, 0xC0, 0x00, 0xC0,
    0xFB, 0x30, 0xFC, 0x30, 0xA3, 0x7B, 0xA3, 0x7B, 0x8C, 0x65, 0x8B, 0x65,
    0x01, 0x00, 0xFF, 0xFF, 0x75, 0x9A, 0x73, 0x9A, 0x5D, 0x84, 0x5E, 0x84,
    0x05, 0xCF, 0x05, 0xCF, 0xFF, 0x3F, 0xFF, 0x3F, 0xE6, 0x7E, 0xE7, 0x7E,
    0x82, 0x5A, 0x81, 0x5A, 0x4C, 0xEF, 0x4B, 0xEF, 0x27, 0x91, 0x27, 0x91,
    0xBE, 0x89, 0xBF, 0x89, 0xE0, 0xDE, 0xDF, 0xDE, 0xEC, 0x4D, 0xEB, 0x4D,
    0xFF, 0x7F, 0xFF, 0x7F, 0xEB, 0x4D, 0xEC, 0x4D, 0xDF, 0xDE, 0xE0, 0xDE,
    0xC0, 0x89, 0xBF, 0x89, 0x27, 0x91, 0x28, 0x91, 0x4B, 0xEF, 0x4B, 0xEF,
    0x82, 0x5A, 0x82, 0x5A, 0xE7, 0x7E, 0xE7, 0x7E, 0xFF, 0x3F, 0x00, 0x40,
    0x05, 0xCF, 0x04, 0xCF, 0x5E, 0x84, 0x5D, 0x84, 0x75, 0x9A, 0x74, 0x9A
};

unsigned char stone7k_m4dB_48kHz[192] =
{
    0x00, 0x00, 0x00, 0x00, 0x13, 0x40, 0x12, 0x40, 0x02, 0x4E, 0x02, 0x4E,
    0xE9, 0x1E, 0xE8, 0x1E, 0x9E, 0xD7, 0x9F, 0xD7, 0xEE, 0xAF, 0xEF, 0xAF,
    0xE5, 0xC6, 0xE5, 0xC6, 0x8B, 0x0A, 0x8B, 0x0A, 0xF1, 0x45, 0xF1, 0x45,
    0x9C, 0x4A, 0x9D, 0x4A, 0xE7, 0x14, 0xE7, 0x14, 0xD6, 0xCE, 0xD7, 0xCE,
    0x3E, 0xAF, 0x3D, 0xAF, 0xD6, 0xCE, 0xD7, 0xCE, 0xE6, 0x14, 0xE7, 0x14,
    0x9D, 0x4A, 0x9D, 0x4A, 0xF1, 0x45, 0xF1, 0x45, 0x8A, 0x0A, 0x8A, 0x0A,
    0xE6, 0xC6, 0xE5, 0xC6, 0xEF, 0xAF, 0xEE, 0xAF, 0x9F, 0xD7, 0x9F, 0xD7,
    0xE7, 0x1E, 0xE9, 0x1E, 0x03, 0x4E, 0x02, 0x4E, 0x12, 0x40, 0x12, 0x40,
    0x00, 0x00, 0x00, 0x00, 0xEF, 0xBF, 0xEE, 0xBF, 0xFE, 0xB1, 0xFE, 0xB1,
    0x18, 0xE1, 0x19, 0xE1, 0x61, 0x28, 0x61, 0x28, 0x11, 0x50, 0x11, 0x50,
    0x1B, 0x39, 0x1B, 0x39, 0x76, 0xF5, 0x75, 0xF5, 0x10, 0xBA, 0x0F, 0xBA,
    0x63, 0xB5, 0x63, 0xB5, 0x19, 0xEB, 0x19, 0xEB, 0x2A, 0x31, 0x29, 0x31,
    0xC3, 0x50, 0xC3, 0x50, 0x2A, 0x31, 0x2B, 0x31, 0x19, 0xEB, 0x19, 0xEB,
    0x64, 0xB5, 0x63, 0xB5, 0x10, 0xBA, 0x0F, 0xBA, 0x75, 0xF5, 0x76, 0xF5,
    0x1B, 0x39, 0x1B, 0x39, 0x12, 0x50, 0x11, 0x50, 0x61, 0x28, 0x61, 0x28,
    0x18, 0xE1, 0x19, 0xE1, 0xFE, 0xB1, 0xFD, 0xB1, 0xEE, 0xBF, 0xED, 0xBF
};

unsigned char stone8k_48kHz[24] =
{
    0x00, 0x00, 0x01, 0x00, 0xDA, 0x6E, 0xD8, 0x6E, 0xD9, 0x6E, 0xDA, 0x6E,
    0x00, 0x00, 0x00, 0x00, 0x27, 0x91, 0x26, 0x91, 0x27, 0x91, 0x27, 0x91
};

unsigned char stone8k_m4dB_48kHz[24] =
{
    0x00, 0x00, 0x01, 0x00, 0xF1, 0x45, 0xF1, 0x45, 0xF1, 0x45, 0xF1, 0x45,
    0xFF, 0xFF, 0x01, 0x00, 0x10, 0xBA, 0x0F, 0xBA, 0x0F, 0xBA, 0x0F, 0xBA
};

unsigned char stone9k_48kHz[64] =
{
    0x00, 0x00, 0x00, 0x00, 0x40, 0x76, 0x41, 0x76, 0x82, 0x5A, 0x82, 0x5A,
    0x04, 0xCF, 0x04, 0xCF, 0x00, 0x80, 0x01, 0x80, 0x04, 0xCF, 0x04, 0xCF,
    0x82, 0x5A, 0x82, 0x5A, 0x40, 0x76, 0x41, 0x76, 0x00, 0x00, 0xFF, 0xFF,
    0xC0, 0x89, 0xBF, 0x89, 0x7D, 0xA5, 0x7E, 0xA5, 0xFB, 0x30, 0xFB, 0x30,
    0xFF, 0x7F, 0xFF, 0x7F, 0xFC, 0x30, 0xFB, 0x30, 0x7E, 0xA5, 0x7E, 0xA5,
    0xC0, 0x89, 0xBF, 0x89
};

unsigned char stone9k_m4dB_48kHz[64] =
{
    0x00, 0x00, 0x01, 0x00, 0x9D, 0x4A, 0x9D, 0x4A, 0x1B, 0x39, 0x1B, 0x39,
    0x18, 0xE1, 0x18, 0xE1, 0x3D, 0xAF, 0x3D, 0xAF, 0x19, 0xE1, 0x18, 0xE1,
    0x1B, 0x39, 0x1B, 0x39, 0x9C, 0x4A, 0x9D, 0x4A, 0x00, 0x00, 0x00, 0x00,
    0x63, 0xB5, 0x63, 0xB5, 0xE4, 0xC6, 0xE5, 0xC6, 0xE8, 0x1E, 0xE8, 0x1E,
    0xC3, 0x50, 0xC3, 0x50, 0xE8, 0x1E, 0xE8, 0x1E, 0xE5, 0xC6, 0xE5, 0xC6,
    0x63, 0xB5, 0x63, 0xB5
};

unsigned char stone10k_48kHz[96] =
{
    0x00, 0x00, 0x00, 0x00, 0xA2, 0x7B, 0xA3, 0x7B, 0x00, 0x40, 0xFF, 0x3F,
    0x7E, 0xA5, 0x7E, 0xA5, 0x27, 0x91, 0x26, 0x91, 0x21, 0x21, 0x21, 0x21,
    0xFF, 0x7F, 0xFF, 0x7F, 0x21, 0x21, 0x20, 0x21, 0x27, 0x91, 0x27, 0x91,
    0x7F, 0xA5, 0x7D, 0xA5, 0x00, 0x40, 0x00, 0x40, 0xA3, 0x7B, 0xA3, 0x7B,
    0x00, 0x00, 0x00, 0x00, 0x5E, 0x84, 0x5E, 0x84, 0x00, 0xC0, 0x01, 0xC0,
    0x82, 0x5A, 0x82, 0x5A, 0xD9, 0x6E, 0xD9, 0x6E, 0xDF, 0xDE, 0xE0, 0xDE,
    0x01, 0x80, 0x00, 0x80, 0xDF, 0xDE, 0xDF, 0xDE, 0xD9, 0x6E, 0xD9, 0x6E,
    0x82, 0x5A, 0x82, 0x5A, 0x01, 0xC0, 0x01, 0xC0, 0x5E, 0x84, 0x5D, 0x84
};

unsigned char stone10k_m4dB_48kHz[96] =
{
    0x00, 0x00, 0xFF, 0xFF, 0x02, 0x4E, 0x01, 0x4E, 0x61, 0x28, 0x61, 0x28,
    0xE5, 0xC6, 0xE5, 0xC6, 0x10, 0xBA, 0x0E, 0xBA, 0xE7, 0x14, 0xE7, 0x14,
    0xC2, 0x50, 0xC3, 0x50, 0xE7, 0x14, 0xE6, 0x14, 0x10, 0xBA, 0x0F, 0xBA,
    0xE5, 0xC6, 0xE4, 0xC6, 0x61, 0x28, 0x61, 0x28, 0x02, 0x4E, 0x02, 0x4E,
    0x00, 0x00, 0xFF, 0xFF, 0xFE, 0xB1, 0xFE, 0xB1, 0x9F, 0xD7, 0x9F, 0xD7,
    0x1C, 0x39, 0x1C, 0x39, 0xF1, 0x45, 0xF1, 0x45, 0x18, 0xEB, 0x19, 0xEB,
    0x3E, 0xAF, 0x3D, 0xAF, 0x19, 0xEB, 0x1A, 0xEB, 0xF0, 0x45, 0xF1, 0x45,
    0x1C, 0x39, 0x1A, 0x39, 0x9F, 0xD7, 0x9F, 0xD7, 0xFD, 0xB1, 0xFE, 0xB1
};

unsigned char stone11k_48kHz[192] =
{
    0x00, 0x00, 0xFF, 0xFF, 0xE7, 0x7E, 0xE6, 0x7E, 0x20, 0x21, 0x21, 0x21,
    0xBE, 0x89, 0xBF, 0x89, 0x01, 0xC0, 0x01, 0xC0, 0x8C, 0x65, 0x8C, 0x65,
    0x82, 0x5A, 0x81, 0x5A, 0x14, 0xB2, 0x14, 0xB2, 0x27, 0x91, 0x27, 0x91,
    0xFB, 0x30, 0xFB, 0x30, 0xA3, 0x7B, 0xA2, 0x7B, 0x4B, 0xEF, 0x4B, 0xEF,
    0x01, 0x80, 0x01, 0x80, 0x4A, 0xEF, 0x4C, 0xEF, 0xA3, 0x7B, 0xA2, 0x7B,
    0xFB, 0x30, 0xFB, 0x30, 0x26, 0x91, 0x27, 0x91, 0x14, 0xB2, 0x15, 0xB2,
    0x82, 0x5A, 0x82, 0x5A, 0x8B, 0x65, 0x8C, 0x65, 0x00, 0xC0, 0x01, 0xC0,
    0xBF, 0x89, 0xBF, 0x89, 0x21, 0x21, 0x20, 0x21, 0xE7, 0x7E, 0xE7, 0x7E,
    0x01, 0x00, 0xFF, 0xFF, 0x19, 0x81, 0x1A, 0x81, 0xDF, 0xDE, 0xDF, 0xDE,
    0x41, 0x76, 0x41, 0x76, 0x00, 0x40, 0x00, 0x40, 0x74, 0x9A, 0x74, 0x9A,
    0x7E, 0xA5, 0x7E, 0xA5, 0xEB, 0x4D, 0xEB, 0x4D, 0xD9, 0x6E, 0xD9, 0x6E,
    0x05, 0xCF, 0x05, 0xCF, 0x5E, 0x84, 0x5D, 0x84, 0xB5, 0x10, 0xB4, 0x10,
    0xFE, 0x7F, 0xFF, 0x7F, 0xB4, 0x10, 0xB6, 0x10, 0x5E, 0x84, 0x5D, 0x84,
    0x04, 0xCF, 0x04, 0xCF, 0xDA, 0x6E, 0xD9, 0x6E, 0xEB, 0x4D, 0xEB, 0x4D,
    0x7E, 0xA5, 0x7E, 0xA5, 0x74, 0x9A, 0x74, 0x9A, 0x00, 0x40, 0x00, 0x40,
    0x40, 0x76, 0x41, 0x76, 0xDF, 0xDE, 0xDF, 0xDE, 0x19, 0x81, 0x19, 0x81
};

unsigned char stone11k_m4dB_48kHz[192] =
{
    0x01, 0x00, 0x00, 0x00, 0x12, 0x50, 0x11, 0x50, 0xE7, 0x14, 0xE6, 0x14,
    0x63, 0xB5, 0x63, 0xB5, 0x9F, 0xD7, 0x9F, 0xD7, 0x12, 0x40, 0x12, 0x40,
    0x1B, 0x39, 0x1B, 0x39, 0xD6, 0xCE, 0xD6, 0xCE, 0x0F, 0xBA, 0x0F, 0xBA,
    0xE8, 0x1E, 0xE8, 0x1E, 0x02, 0x4E, 0x02, 0x4E, 0x75, 0xF5, 0x76, 0xF5,
    0x3D, 0xAF, 0x3D, 0xAF, 0x75, 0xF5, 0x75, 0xF5, 0x02, 0x4E, 0x03, 0x4E,
    0xE7, 0x1E, 0xE8, 0x1E, 0x0F, 0xBA, 0x0F, 0xBA, 0xD6, 0xCE, 0xD6, 0xCE,
    0x1B, 0x39, 0x1C, 0x39, 0x12, 0x40, 0x12, 0x40, 0x9F, 0xD7, 0x9F, 0xD7,
    0x63, 0xB5, 0x64, 0xB5, 0xE7, 0x14, 0xE6, 0x14, 0x12, 0x50, 0x12, 0x50,
    0x01, 0x00, 0x00, 0x00, 0xEE, 0xAF, 0xEE, 0xAF, 0x19, 0xEB, 0x19, 0xEB,
    0x9D, 0x4A, 0x9D, 0x4A, 0x61, 0x28, 0x61, 0x28, 0xED, 0xBF, 0xEE, 0xBF,
    0xE5, 0xC6, 0xE5, 0xC6, 0x2A, 0x31, 0x29, 0x31, 0xF0, 0x45, 0xF1, 0x45,
    0x18, 0xE1, 0x19, 0xE1, 0xFD, 0xB1, 0xFE, 0xB1, 0x8B, 0x0A, 0x8B, 0x0A,
    0xC2, 0x50, 0xC3, 0x50, 0x8A, 0x0A, 0x8A, 0x0A, 0xFE, 0xB1, 0xFF, 0xB1,
    0x18, 0xE1, 0x18, 0xE1, 0xF1, 0x45, 0xF1, 0x45, 0x2A, 0x31, 0x29, 0x31,
    0xE5, 0xC6, 0xE5, 0xC6, 0xED, 0xBF, 0xEE, 0xBF, 0x61, 0x28, 0x62, 0x28,
    0x9D, 0x4A, 0x9D, 0x4A, 0x18, 0xEB, 0x1A, 0xEB, 0xEE, 0xAF, 0xEE, 0xAF
};

unsigned char stone12k_48kHz[64] =
{
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0xFF, 0x7F, 0xFF, 0xFF, 0x00, 0x00,
    0x01, 0x80, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x7F, 0xFE, 0x7F,
    0x01, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0xFF, 0xFF, 0x00, 0x00,
    0xFF, 0x7F, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01, 0x80,
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x7F, 0xFF, 0x7F, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x80, 0x01, 0x80
};

unsigned char stone12k_m4dB_48kHz[64] =
{
    0x00, 0x00, 0x00, 0x00, 0xC3, 0x50, 0xC2, 0x50, 0xFF, 0xFF, 0x00, 0x00,
    0x3D, 0xAF, 0x3D, 0xAF, 0x00, 0x00, 0x00, 0x00, 0xC3, 0x50, 0xC2, 0x50,
    0x01, 0x00, 0x00, 0x00, 0x3E, 0xAF, 0x3D, 0xAF, 0x00, 0x00, 0x00, 0x00,
    0xC2, 0x50, 0xC3, 0x50, 0x00, 0x00, 0x00, 0x00, 0x3E, 0xAF, 0x3E, 0xAF,
    0x00, 0x00, 0x01, 0x00, 0xC3, 0x50, 0xC3, 0x50, 0x00, 0x00, 0x00, 0x00,
    0x3E, 0xAF, 0x3D, 0xAF
};

unsigned char stone13k_48kHz[192] =
{
    0x01, 0x00, 0x01, 0x00, 0xE6, 0x7E, 0xE7, 0x7E, 0xDF, 0xDE, 0xE0, 0xDE,
    0xBF, 0x89, 0xBF, 0x89, 0xFF, 0x3F, 0x00, 0x40, 0x8C, 0x65, 0x8C, 0x65,
    0x7E, 0xA5, 0x7E, 0xA5, 0x15, 0xB2, 0x14, 0xB2, 0xD8, 0x6E, 0xD9, 0x6E,
    0xFB, 0x30, 0xFC, 0x30, 0x5E, 0x84, 0x5E, 0x84, 0x4B, 0xEF, 0x4B, 0xEF,
    0xFF, 0x7F, 0xFF, 0x7F, 0x4B, 0xEF, 0x4B, 0xEF, 0x5E, 0x84, 0x5E, 0x84,
    0xFC, 0x30, 0xFB, 0x30, 0xD9, 0x6E, 0xD9, 0x6E, 0x15, 0xB2, 0x15, 0xB2,
    0x7E, 0xA5, 0x7F, 0xA5, 0x8C, 0x65, 0x8B, 0x65, 0x00, 0x40, 0xFF, 0x3F,
    0xC0, 0x89, 0xBF, 0x89, 0xDF, 0xDE, 0xDF, 0xDE, 0xE7, 0x7E, 0xE7, 0x7E,
    0x00, 0x00, 0x00, 0x00, 0x19, 0x81, 0x19, 0x81, 0x20, 0x21, 0x20, 0x21,
    0x41, 0x76, 0x41, 0x76, 0x00, 0xC0, 0x01, 0xC0, 0x75, 0x9A, 0x75, 0x9A,
    0x81, 0x5A, 0x81, 0x5A, 0xEB, 0x4D, 0xEB, 0x4D, 0x27, 0x91, 0x27, 0x91,
    0x04, 0xCF, 0x05, 0xCF, 0xA3, 0x7B, 0xA3, 0x7B, 0xB5, 0x10, 0xB5, 0x10,
    0x02, 0x80, 0x01, 0x80, 0xB5, 0x10, 0xB5, 0x10, 0xA3, 0x7B, 0xA2, 0x7B,
    0x05, 0xCF, 0x05, 0xCF, 0x27, 0x91, 0x26, 0x91, 0xEC, 0x4D, 0xEC, 0x4D,
    0x82, 0x5A, 0x82, 0x5A, 0x74, 0x9A, 0x74, 0x9A, 0x01, 0xC0, 0x00, 0xC0,
    0x40, 0x76, 0x41, 0x76, 0x21, 0x21, 0x21, 0x21, 0x19, 0x81, 0x19, 0x81
};

unsigned char stone13k_m4dB_48kHz[192] =
{
    0x01, 0x00, 0x00, 0x00, 0x11, 0x50, 0x12, 0x50, 0x19, 0xEB, 0x19, 0xEB,
    0x64, 0xB5, 0x63, 0xB5, 0x62, 0x28, 0x61, 0x28, 0x12, 0x40, 0x12, 0x40,
    0xE5, 0xC6, 0xE5, 0xC6, 0xD5, 0xCE, 0xD6, 0xCE, 0xF1, 0x45, 0xF1, 0x45,
    0xE8, 0x1E, 0xE8, 0x1E, 0xFE, 0xB1, 0xFE, 0xB1, 0x75, 0xF5, 0x76, 0xF5,
    0xC3, 0x50, 0xC3, 0x50, 0x75, 0xF5, 0x76, 0xF5, 0xFE, 0xB1, 0xFD, 0xB1,
    0xE8, 0x1E, 0xE8, 0x1E, 0xF1, 0x45, 0xF0, 0x45, 0xD6, 0xCE, 0xD6, 0xCE,
    0xE5, 0xC6, 0xE4, 0xC6, 0x12, 0x40, 0x13, 0x40, 0x61, 0x28, 0x62, 0x28,
    0x63, 0xB5, 0x63, 0xB5, 0x1A, 0xEB, 0x19, 0xEB, 0x11, 0x50, 0x11, 0x50,
    0x00, 0x00, 0x00, 0x00, 0xEF, 0xAF, 0xEE, 0xAF, 0xE7, 0x14, 0xE6, 0x14,
    0x9D, 0x4A, 0x9D, 0x4A, 0x9E, 0xD7, 0x9E, 0xD7, 0xEE, 0xBF, 0xEE, 0xBF,
    0x1B, 0x39, 0x1B, 0x39, 0x29, 0x31, 0x2A, 0x31, 0x0F, 0xBA, 0x0F, 0xBA,
    0x18, 0xE1, 0x18, 0xE1, 0x03, 0x4E, 0x02, 0x4E, 0x8A, 0x0A, 0x8B, 0x0A,
    0x3D, 0xAF, 0x3E, 0xAF, 0x8B, 0x0A, 0x8A, 0x0A, 0x02, 0x4E, 0x02, 0x4E,
    0x18, 0xE1, 0x17, 0xE1, 0x0F, 0xBA, 0x10, 0xBA, 0x2A, 0x31, 0x2A, 0x31,
    0x1C, 0x39, 0x1B, 0x39, 0xEE, 0xBF, 0xED, 0xBF, 0x9F, 0xD7, 0x9E, 0xD7,
    0x9C, 0x4A, 0x9D, 0x4A, 0xE7, 0x14, 0xE7, 0x14, 0xEE, 0xAF, 0xEF, 0xAF
};

unsigned char stone14k_48kHz[96] =
{
    0x01, 0x00, 0x00, 0x00, 0xA3, 0x7B, 0xA3, 0x7B, 0x01, 0xC0, 0x01, 0xC0,
    0x7E, 0xA5, 0x7E, 0xA5, 0xD9, 0x6E, 0xDA, 0x6E, 0x21, 0x21, 0x21, 0x21,
    0x00, 0x80, 0x01, 0x80, 0x21, 0x21, 0x21, 0x21, 0xD9, 0x6E, 0xDA, 0x6E,
    0x7F, 0xA5, 0x7E, 0xA5, 0x00, 0xC0, 0x01, 0xC0, 0xA3, 0x7B, 0xA3, 0x7B,
    0x00, 0x00, 0x00, 0x00, 0x5D, 0x84, 0x5E, 0x84, 0x00, 0x40, 0x00, 0x40,
    0x81, 0x5A, 0x82, 0x5A, 0x27, 0x91, 0x26, 0x91, 0xE0, 0xDE, 0xE0, 0xDE,
    0xFF, 0x7F, 0xFF, 0x7F, 0xE0, 0xDE, 0xDE, 0xDE, 0x27, 0x91, 0x26, 0x91,
    0x81, 0x5A, 0x82, 0x5A, 0x00, 0x40, 0x00, 0x40, 0x5D, 0x84, 0x5D, 0x84
};

unsigned char stone14k_m4dB_48kHz[96] =
{
    0x00, 0x00, 0x00, 0x00, 0x02, 0x4E, 0x02, 0x4E, 0x9E, 0xD7, 0x9E, 0xD7,
    0xE5, 0xC6, 0xE5, 0xC6, 0xF0, 0x45, 0xF0, 0x45, 0xE7, 0x14, 0xE7, 0x14,
    0x3D, 0xAF, 0x3E, 0xAF, 0xE7, 0x14, 0xE6, 0x14, 0xF1, 0x45, 0xF1, 0x45,
    0xE5, 0xC6, 0xE5, 0xC6, 0x9F, 0xD7, 0x9F, 0xD7, 0x03, 0x4E, 0x02, 0x4E,
    0x00, 0x00, 0x00, 0x00, 0xFD, 0xB1, 0xFD, 0xB1, 0x61, 0x28, 0x62, 0x28,
    0x1B, 0x39, 0x1B, 0x39, 0x0F, 0xBA, 0x0F, 0xBA, 0x19, 0xEB, 0x1A, 0xEB,
    0xC3, 0x50, 0xC3, 0x50, 0x19, 0xEB, 0x1A, 0xEB, 0x0F, 0xBA, 0x0F, 0xBA,
    0x1B, 0x39, 0x1B, 0x39, 0x62, 0x28, 0x61, 0x28, 0xFE, 0xB1, 0xFD, 0xB1
};

unsigned char stone15k_48kHz[64] =
{
    0x00, 0x00, 0x00, 0x00, 0x41, 0x76, 0x41, 0x76, 0x7E, 0xA5, 0x7E, 0xA5,
    0x05, 0xCF, 0x05, 0xCF, 0xFF, 0x7F, 0xFF, 0x7F, 0x05, 0xCF, 0x04, 0xCF,
    0x7E, 0xA5, 0x7E, 0xA5, 0x41, 0x76, 0x41, 0x76, 0x00, 0x00, 0x00, 0x00,
    0xBF, 0x89, 0xBF, 0x89, 0x82, 0x5A, 0x82, 0x5A, 0xFB, 0x30, 0xFB, 0x30,
    0x01, 0x80, 0x02, 0x80, 0xFB, 0x30, 0xFB, 0x30, 0x82, 0x5A, 0x81, 0x5A,
    0xBF, 0x89, 0xBF, 0x89
};

unsigned char stone15k_m4dB_48kHz[64] =
{
    0xFF, 0xFF, 0x00, 0x00, 0x9D, 0x4A, 0x9D, 0x4A, 0xE4, 0xC6, 0xE4, 0xC6,
    0x18, 0xE1, 0x19, 0xE1, 0xC3, 0x50, 0xC3, 0x50, 0x18, 0xE1, 0x18, 0xE1,
    0xE6, 0xC6, 0xE4, 0xC6, 0x9D, 0x4A, 0x9C, 0x4A, 0x00, 0x00, 0x00, 0x00,
    0x64, 0xB5, 0x63, 0xB5, 0x1B, 0x39, 0x1B, 0x39, 0xE7, 0x1E, 0xE8, 0x1E,
    0x3D, 0xAF, 0x3E, 0xAF, 0xE8, 0x1E, 0xE8, 0x1E, 0x1B, 0x39, 0x1B, 0x39,
    0x62, 0xB5, 0x63, 0xB5
};


/*****************************************************************************
*                          D A T A   T Y P E S
******************************************************************************
*/

#define FTM_Audio_FMTx   0
#define FTM_Audio_HDMI   1

/*****************************************************************************
*                        F U N C T I O N   D E F I N I T I O N
******************************************************************************
*/

namespace android
{

AudioFtm *AudioFtm::UniqueAudioFtmInstance = 0;

AudioFtm *AudioFtm::getInstance()
{
    if (UniqueAudioFtmInstance == 0)
    {
        ALOGD("+UniqueAudioFtmInstance\n");
        UniqueAudioFtmInstance = new AudioFtm();
        ALOGD("-UniqueAudioFtmInstance\n");
    }
    return UniqueAudioFtmInstance;
}

AudioFtm::AudioFtm()
{
    mSamplingRate = 0;
    mAudioSinWave_thread = false;
    mAudioBuffer = NULL;
    mSineWaveStatus = 0;

    // create volume instance
    mAudioVolumeInstance = AudioVolumeFactory::CreateAudioVolumeController();
    mAudioVolumeInstance->initCheck();
    // create digital control instnace
    mAudioDigitalInstance  = AudioDigitalControlFactory::CreateAudioDigitalControl();
    mAudioDigitalInstance->InitCheck();
    // create digital control instnace
    mAudioAnalogInstance  = AudioAnalogControlFactory::CreateAudioAnalogControl();
    mAudioAnalogInstance->InitCheck();

    //    mStreamInManager = AudioMTKStreamInManager::getInstance();    //ship marked
    mAudioResourceManager = AudioResourceManager::getInstance();

    mAudioResourceManager->SetFrequency(AudioResourceManagerInterface::DEVICE_OUT_DAC, 48000);
    mAudioResourceManager->SetFrequency(AudioResourceManagerInterface::DEVICE_IN_ADC, 48000);

    // set mux first
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_EARPIECER, AudioAnalogType::MUX_VOICE);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_SPEAKERR, AudioAnalogType::MUX_AUDIO);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_SPEAKERL, AudioAnalogType::MUX_AUDIO);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_HEADSETR, AudioAnalogType::MUX_AUDIO);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_HEADSETL, AudioAnalogType::MUX_AUDIO);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_SPEAKER_HEADSET_R, AudioAnalogType::MUX_AUDIO);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_OUT_SPEAKER_HEADSET_L, AudioAnalogType::MUX_AUDIO);
#if defined(MTK_DUAL_MIC_SUPPORT)  // base on dual or single mic select mic input source.
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_IN_PREAMP_L, AudioAnalogType::MUX_IN_MIC1);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_IN_PREAMP_R, AudioAnalogType::MUX_IN_MIC3);
#else
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_IN_PREAMP_L, AudioAnalogType::MUX_IN_MIC1);
    mAudioAnalogInstance->AnalogSetMux(AudioAnalogType::DEVICE_IN_PREAMP_R, AudioAnalogType::MUX_IN_MIC1);
#endif

    mFd = ::open(kAudioDeviceName, O_RDWR);

    return;
}

AudioFtm::~AudioFtm()
{
    ::close(mFd);
    return;
}

bool AudioFtm::AudFtm_Init()
{
    ALOGD("AudFtm_Init \n");
    return true;
}

unsigned int AudioFtm::WavGen_AudioWrite(void *buffer, unsigned int bytes)
{
    uint32 consume_byte = 0, i;
    consume_byte = ::write(mFd, buffer, bytes);
    return consume_byte;
}

void AudioFtm::WavGen_AudioRead(char *pBuffer, unsigned int bytes)
{
    int copysize, IdxAudioPattern_Next, i, TotalSample;
    char *copybuffer = NULL;
    copybuffer = pBuffer;
    TotalSample = bytes >> 1;

    copysize = SizeAudioPattern - IdxAudioPattern;
    ALOGV("WavGen_AudioRead IdxAudioPattern=%d, SizeAudioPattern=%d, copysize=%d, bytes=%d,", IdxAudioPattern, SizeAudioPattern, copysize, bytes);

    while (bytes)
    {
        memcpy((void *)copybuffer, (void *)g_i2VDL_DATA + IdxAudioPattern, copysize);
        bytes -= copysize;
        copybuffer += copysize;
        if (bytes >= SizeAudioPattern)
        {
            copysize = SizeAudioPattern;
            IdxAudioPattern = 0;
        }
        else
        {
            copysize = bytes;
            IdxAudioPattern_Next = bytes;
        }

        ALOGV("in loop IdxAudioPattern=%d, SizeAudioPattern=%d, copysize=%d, bytes=%d,", IdxAudioPattern, SizeAudioPattern, copysize, bytes);
    }
    IdxAudioPattern = IdxAudioPattern_Next;
}

void AudioFtm::FmTx_thread_digital_out(void)
{

}

void  AudioFtm::FmTx_thread_analog_out(void)
{
}

void AudioFtm::HDMI_thread_I2SOutput(void)
{
    int SizeByte, numread = 0, i;
    SizeByte = 12288;
    if (mAudioBuffer == NULL)
    {
        mAudioBuffer = new char[SizeByte];
    }

    //config register
    mSamplingRate = 44100;
    IdxAudioPattern = 0;
    memset(mAudioBuffer, 0, SizeByte);

    ALOGD("HDMI_thread_I2SOutput: SizeByte=%d, g_i2VDL_DATA addr=0x%x", SizeByte, g_i2VDL_DATA);
    ::ioctl(mFd, AUD_SET_HDMI_CLOCK, 1);

    while (1)
    {
        if (!mAudioSinWave_thread)
        {
            ALOGD("HDMI_thread_I2SOutput, AUD_SET_HDMI_CLOCK");
            ::ioctl(mFd, AUD_SET_HDMI_CLOCK, 0);
            ALOGD("exit HDMI_thread_I2SOutput thread");
            break;
        }
        //Read pattern and write to asm buf
        WavGen_AudioRead(mAudioBuffer, SizeByte);
        WavGen_AudioWrite(mAudioBuffer, SizeByte);
    }

    if (mAudioBuffer)
    {
        delete [] mAudioBuffer;
        mAudioBuffer = NULL;
    }
}

void *AudioFtm::FmTx_thread_create(void *arg)
{
    ALOGD("not supported!!!");
    return NULL;
}

void *AudioFtm::HDMI_thread_create(void *arg)
{
    AudioFtm *p;
    p = (AudioFtm *)arg;

    ALOGD("HDMI_thread_I2SOutput");
    p->HDMI_thread_I2SOutput();

    return NULL;
}

bool AudioFtm::WavGen_SW_SineWave(bool Enable, uint32 Freq, int type)
{
    return WavGen_SWPattern(Enable, Freq, type);
}

bool AudioFtm::WavGen_SWPattern(bool Enable, uint32 Freq, int type)
{
    uint32 Reg_Freq, Reg;
    ALOGD("WavGen_SW_SineWave, Enable=%d,  Freq = %d\n", Enable, Freq);

    if (Enable)
    {
        if (!mAudioSinWave_thread)
        {
            if ((Freq <= FREQ_NONE) || (Freq > FREQ_15K_HZ))
            {
                ALOGE("Invalid SineWave Frequency %d", Freq);
                return false;
            }
            else
            {
                switch (Freq)
                {
                    case FREQ_1K_HZ:
                        SizeAudioPattern = 192;
                        g_i2VDL_DATA = &stone1k_m4dB_48kHz[0];
                        break;
                    case FREQ_2K_HZ:
                        SizeAudioPattern = 96;
                        g_i2VDL_DATA = &stone2k_m4dB_48kHz[0];
                        break;
                    case FREQ_3K_HZ:
                        SizeAudioPattern = 64;
                        g_i2VDL_DATA = &stone3k_m4dB_48kHz[0];
                        break;
                    case FREQ_4K_HZ:
                        SizeAudioPattern = 48;
                        g_i2VDL_DATA = &stone4k_m4dB_48kHz[0];
                        break;
                    case FREQ_5K_HZ:
                        SizeAudioPattern = 192;
                        g_i2VDL_DATA = &stone5k_m4dB_48kHz[0];
                        break;
                    case FREQ_6K_HZ:
                        SizeAudioPattern = 32;
                        g_i2VDL_DATA = &stone6k_m4dB_48kHz[0];
                        break;
                    case FREQ_7K_HZ:
                        SizeAudioPattern = 192;
                        g_i2VDL_DATA = &stone7k_m4dB_48kHz[0];
                        break;
                    case FREQ_8K_HZ:
                        SizeAudioPattern = 24;
                        g_i2VDL_DATA = &stone8k_m4dB_48kHz[0];
                        break;
                    case FREQ_9K_HZ:
                        SizeAudioPattern = 64;
                        g_i2VDL_DATA = &stone9k_m4dB_48kHz[0];
                        break;
                    case FREQ_10K_HZ:
                        SizeAudioPattern = 96;
                        g_i2VDL_DATA = &stone10k_m4dB_48kHz[0];
                        break;
                    case FREQ_11K_HZ:
                        SizeAudioPattern = 192;
                        g_i2VDL_DATA = &stone11k_m4dB_48kHz[0];
                        break;
                    case FREQ_12K_HZ:
                        SizeAudioPattern = 64;
                        g_i2VDL_DATA = &stone12k_m4dB_48kHz[0];
                        break;
                    case FREQ_13K_HZ:
                        SizeAudioPattern = 192;
                        g_i2VDL_DATA = &stone13k_m4dB_48kHz[0];
                        break;
                    case FREQ_14K_HZ:
                        SizeAudioPattern = 96;
                        g_i2VDL_DATA = &stone14k_m4dB_48kHz[0];
                        break;
                    case FREQ_15K_HZ:
                        SizeAudioPattern = 64;
                        g_i2VDL_DATA = &stone15k_m4dB_48kHz[0];
                        break;
                    default:
                        SizeAudioPattern = 192;
                        g_i2VDL_DATA = &stone1k_m4dB_48kHz[0];
                        break;
                }
            }

            if (type == FTM_Audio_FMTx)
            {
                pthread_create(&m_WaveThread, NULL, &AudioFtm::FmTx_thread_create, (void *)this);
            }
            else if (type == FTM_Audio_HDMI)
            {
                pthread_create(&m_WaveThread, NULL, &AudioFtm::HDMI_thread_create, (void *)this);
            }
            else
            {
                ALOGD("WavGen_SWPattern fail");
            }

            mAudioSinWave_thread = true;
        }
        return true;
    }
    else
    {
        //WavGen_SWPattern
        if (mAudioSinWave_thread)
        {
            //leave thread
            ALOGD("WavGen_SWPattern, destroy m_WaveThread");
            mAudioSinWave_thread = false;
            pthread_join(m_WaveThread, NULL);
        }
        return true;
    }
}

// for test , this function will sned sine tone to I2S out
void AudioFtm::Afe_Enable_SineWave(bool bEnable)
{
    ALOGD("Afe_Enable_SineWave, bEnable:%d \n", bEnable);
    if (bEnable)
    {
        mSineWaveStatus = 1;
        FTMI2SDacOutSet(48000);
        mAudioResourceManager->SetFrequency(AudioResourceManagerInterface::DEVICE_OUT_DAC, 48000);
        mAudioDigitalInstance->EnableSideToneHw(AudioDigitalType::O03 , false, true);
        mAudioDigitalInstance->SetI2SDacEnable(true);
        mAudioDigitalInstance->SetMemIfEnable(AudioDigitalType::I2S_OUT_DAC, true);
        mAudioDigitalInstance->SetAfeEnable(true);
    }
    else
    {
        mAudioDigitalInstance->EnableSideToneHw(AudioDigitalType::O03 , false, false);
        mAudioDigitalInstance->SetI2SDacEnable(false);
        mAudioDigitalInstance->SetMemIfEnable(AudioDigitalType::I2S_OUT_DAC, false);
        mAudioDigitalInstance->SetAfeEnable(false);
        mSineWaveStatus = 0;
    }
}

void AudioFtm::FTMI2SDacOutSet(uint32 SampleRate)
{
    AudioDigtalI2S DacI2SOut;
    DacI2SOut.mLR_SWAP = AudioDigtalI2S::NO_SWAP;
    DacI2SOut.mI2S_SLAVE = AudioDigtalI2S::MASTER_MODE;
    DacI2SOut.mINV_LRCK = AudioDigtalI2S::NO_INVERSE;
    DacI2SOut.mI2S_FMT = AudioDigtalI2S::I2S;
    DacI2SOut.mI2S_WLEN = AudioDigtalI2S::WLEN_16BITS;
    DacI2SOut.mI2S_SAMPLERATE = SampleRate;
    mAudioDigitalInstance    ->SetI2SDacOut(&DacI2SOut);
}

void AudioFtm::FTMPMICLoopbackTest(bool bEnable)
{
    ALOGD(" To Do");
}

void AudioFtm::FTMPMICEarpieceLoopbackTest(bool bEnable)
{
    ALOGD(" To Do");
}

void AudioFtm::FTMPMICDualModeLoopbackTest(bool bEnable)
{
    ALOGD(" To Do");
}

// here to enable analog DL path
void AudioFtm::FTM_AnaLpk_on()
{
    ALOGD("FTM_AnaLpk_on \n");
}
// here to disbale analog DL path
void AudioFtm::FTM_AnaLpk_off()
{
    ALOGD("FTM_AnaLpk_off \n");
}

void AudioFtm::Audio_Set_Speaker_Vol(int level)
{
    ALOGD("Audio_Set_Speaker_Vol with level = %d", level);
}

void AudioFtm::Audio_Set_Speaker_On(int Channel)
{
    ALOGD("Audio_Set_Speaker_On Channel = %d\n", Channel);
    mAudioAnalogInstance->AnalogOpen(AudioAnalogType::DEVICE_OUT_SPEAKERR, AudioAnalogType::DEVICE_PLATFORM_MACHINE);
#ifdef USING_EXTAMP_HP
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_HPOUTL, OutputGainMap[FTM_OUTPUTGAIN_3]);
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_HPOUTR, OutputGainMap[FTM_OUTPUTGAIN_3]);
#else
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_SPKL, OutputGainMap[FTM_OUTPUTGAIN_3]);
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_SPKR, OutputGainMap[FTM_OUTPUTGAIN_3]);
#endif
}

void AudioFtm::Audio_Set_Speaker_Off(int Channel)
{
    ALOGD("Audio_Set_Speaker_Off Channel = %d\n", Channel);
    mAudioAnalogInstance->AnalogClose(AudioAnalogType::DEVICE_OUT_SPEAKERR, AudioAnalogType::DEVICE_PLATFORM_MACHINE);
}

void AudioFtm::Audio_Set_HeadPhone_On(int Channel)
{
    ALOGD("Audio_Set_HeadPhone_On Channel = %d\n", Channel);
    mAudioAnalogInstance->AnalogOpen(AudioAnalogType::DEVICE_OUT_HEADSETR, AudioAnalogType::DEVICE_PLATFORM_MACHINE);
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_HPOUTR, OutputGainMap[FTM_OUTPUTGAIN_3]);
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_HPOUTL, OutputGainMap[FTM_OUTPUTGAIN_3]);
}

void AudioFtm::Audio_Set_HeadPhone_Off(int Channel)
{
    ALOGD("Audio_Set_HeadPhone_Off Channel = %d\n", Channel);
    mAudioAnalogInstance->AnalogClose(AudioAnalogType::DEVICE_OUT_HEADSETR, AudioAnalogType::DEVICE_PLATFORM_MACHINE);
}

void AudioFtm::Audio_Set_Earpiece_On()
{
    ALOGD("Audio_Set_Earpiece_On Channel\n");
    mAudioAnalogInstance->AnalogOpen(AudioAnalogType::DEVICE_OUT_EARPIECER, AudioAnalogType::DEVICE_PLATFORM_MACHINE);
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_HSOUTR, OutputGainMap[FTM_OUTPUTGAIN_3]);
    mAudioAnalogInstance->SetAnalogGain(AudioAnalogType::VOLUME_HSOUTL, OutputGainMap[FTM_OUTPUTGAIN_3]);
}

void AudioFtm::Audio_Set_Earpiece_Off()
{
    ALOGD("Audio_Set_Earpiece_Off Channel\n");
    mAudioAnalogInstance->AnalogClose(AudioAnalogType::DEVICE_OUT_EARPIECER, AudioAnalogType::DEVICE_PLATFORM_MACHINE);

}



int AudioFtm::RecieverTest(char receiver_test)
{
    if (receiver_test)
    {
        ALOGD("RecieverTest echoflag=%d", receiver_test);
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_AFE, true);
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_ANA, true);
        Afe_Enable_SineWave(true);
        Audio_Set_Earpiece_On();
    }
    else
    {
        Afe_Enable_SineWave(false);
        Audio_Set_Earpiece_Off();
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_AFE, false);
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_ANA, false);

    }
    return true;
}

int AudioFtm::RequestClock()
{
    mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_AFE, true);
    mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_ANA, true);
    return true;
}

int AudioFtm::ReleaseClock()
{
    mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_AFE, false);
    mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_ANA, false);
    return true;
}


int AudioFtm::LouderSPKTest(char left_channel, char right_channel)
{
    ALOGD("LouderSPKTest left_channel=%d, right_channel=%d", left_channel, right_channel);
    int Speaker_Channel = 0;
    if (left_channel == 0 && right_channel == 0)
    {
        ReleaseClock();
        Afe_Enable_SineWave(false);
        Audio_Set_Speaker_Off(Channel_Stereo);
    }
    else
    {
        //Request Analog clock before access analog hw
        RequestClock();
        Afe_Enable_SineWave(true);
        if (left_channel == 1 && right_channel == 1)
        {
            Audio_Set_Speaker_On(Channel_Stereo);
        }
        else if (right_channel == 1)
        {
            Audio_Set_Speaker_On(Channel_Right);
        }
        else if (left_channel == 1)
        {
            Audio_Set_Speaker_On(Channel_Left);
        }
    }
    return true;
}


int AudioFtm::EarphoneTest(char bEnable)
{
    ALOGD("EarphoneTest bEnable=%d", bEnable);

    //Audio_Set_Speaker_Off(Channel_Stereo);
    if (bEnable)
    {
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_AFE, true);
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_ANA, true);
        Afe_Enable_SineWave(true);
        Audio_Set_HeadPhone_On(Channel_Stereo);
    }
    else
    {
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_AFE, false);
        mAudioResourceManager->EnableAudioClock(AudioResourceManagerInterface::CLOCK_AUD_ANA, false);
        Audio_Set_HeadPhone_Off(Channel_Stereo);
        Afe_Enable_SineWave(false);
    }
    return true;

}

int AudioFtm::EarphoneTestLR(char bLR)
{
    mAudioDigitalInstance->SetSinetoneOutputLR(bLR);
    return true;
}

// this is for analog FM
int AudioFtm::FMLoopbackTest(char bEnable)
{
    ALOGD(" doesn't support analog FM");
    return true;
}

int AudioFtm::Pmic_I2s_out(char echoflag)
{
    ALOGD(" To Do");
    return true;
}


// this is for digital FM
int AudioFtm::Audio_FM_I2S_Play(char bEnable)
{
    AudioFMController *pAudioFMController = AudioFMController::GetInstance();
    const float kMaxFmVolume = 1.0;

    if (bEnable == true)
    {
        // force assigned earphone
        mAudioResourceManager->setDlOutputDevice(AUDIO_DEVICE_OUT_WIRED_HEADPHONE);

        // enable
        pAudioFMController->SetFmVolume(0);
        pAudioFMController->SetFmEnable(true);
        pAudioFMController->SetFmVolume(kMaxFmVolume);
    }
    else
    {
        // disable
        pAudioFMController->SetFmVolume(0);
        pAudioFMController->SetFmEnable(false);
    }

    return true;
}


// this is for digital mATV
int AudioFtm::Audio_MATV_I2S_Play(char bEnable)
{
    AudioMATVController *pAudioMATVController = AudioMATVController::GetInstance();

    if (bEnable == true)
    {
        // force assigned speaker
        mAudioResourceManager->setDlOutputDevice(AUDIO_DEVICE_OUT_SPEAKER);

        // enable
        pAudioMATVController->SetMatvEnable(true, MATV_DIGITAL);
    }
    else
    {
        // disable
        pAudioMATVController->SetMatvEnable(false, MATV_DIGITAL);
    }

    return true;
}

int AudioFtm::Audio_READ_SPK_OC_STA(void)
{
    return mAudioAnalogInstance->GetAnalogSpkOCState();
}

int AudioFtm::LouderSPKOCTest(char left_channel, char right_channel)
{
    LouderSPKTest(left_channel, right_channel);
    usleep(500 * 1000);
    // true => OC ,  false ==> no OC
    return Audio_READ_SPK_OC_STA();
}

/// Loopback
int AudioFtm::PhoneMic_Receiver_Loopback(char echoflag)
{
    if (echoflag == MIC1_ON)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_MAIN_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_RECEIVER);
    }
    else if (echoflag == MIC2_ON)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_REF_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_RECEIVER);
    }
    else
    {
        LoopbackManager::GetInstance()->SetLoopbackOff();
    }
    return true;
}

int AudioFtm::PhoneMic_EarphoneLR_Loopback(char echoflag)
{
    if (echoflag == MIC1_ON)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_MAIN_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_EARPHONE);
    }
    else if (echoflag == MIC2_ON)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_REF_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_EARPHONE);
    }
    else
    {
        LoopbackManager::GetInstance()->SetLoopbackOff();
    }
    return true;
}

int AudioFtm::PhoneMic_SpkLR_Loopback(char echoflag)
{
    if (echoflag == MIC1_ON)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_MAIN_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_SPEAKER);
    }
    else if (echoflag == MIC2_ON)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_REF_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_SPEAKER);
    }
    else
    {
        LoopbackManager::GetInstance()->SetLoopbackOff();
    }
    return true;
}

int AudioFtm::HeadsetMic_EarphoneLR_Loopback(char bEnable, char bHeadsetMic)
{
    if (bEnable)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_HEADSET_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_EARPHONE);
    }
    else
    {
        LoopbackManager::GetInstance()->SetLoopbackOff();
    }
    return true;
}


int AudioFtm::HeadsetMic_SpkLR_Loopback(char echoflag)
{
    if (echoflag)
    {
        LoopbackManager::GetInstance()->SetLoopbackOn(AP_HEADSET_MIC_AFE_LOOPBACK, LOOPBACK_OUTPUT_SPEAKER);
    }
    else
    {
        LoopbackManager::GetInstance()->SetLoopbackOff();
    }
    return true;
}

int AudioFtm::PhoneMic_Receiver_Acoustic_Loopback(int Acoustic_Type, int *Acoustic_Status_Flag, int bHeadset_Output)
{
    ALOGD("PhoneMic_Receiver_Acoustic_Loopback Acoustic_Type=%d, headset_available=%d", Acoustic_Type, bHeadset_Output);
    /*  Acoustic loopback
    *   0: Dual mic (w/o DMNR)acoustic loopback off
    *   1: Dual mic (w/o DMNR)acoustic loopback
    *   2: Dual mic (w/  DMNR)acoustic loopback off
    *   3: Dual mic (w/  DMNR)acoustic loopback
    */

    static LoopbackManager *pLoopbackManager = LoopbackManager::GetInstance();
    loopback_output_device_t loopback_output_device;
    if (bHeadset_Output == true)
    {
        loopback_output_device = LOOPBACK_OUTPUT_EARPHONE;
    }
    else
    {
        loopback_output_device = LOOPBACK_OUTPUT_RECEIVER; // default use receiver here
    }



    bool retval = true;
    static int acoustic_status = 0;
    switch (Acoustic_Type)
    {
        case ACOUSTIC_STATUS:
            *Acoustic_Status_Flag = acoustic_status;
            break;
        case DUAL_MIC_WITHOUT_DMNR_ACS_OFF:
            // close single mic acoustic loopback
            pLoopbackManager->SetLoopbackOff();
            acoustic_status = DUAL_MIC_WITHOUT_DMNR_ACS_OFF;
            break;
        case DUAL_MIC_WITHOUT_DMNR_ACS_ON:
            // open dual mic acoustic loopback (w/o DMNR)
            pLoopbackManager->SetLoopbackOn(MD_DUAL_MIC_ACOUSTIC_LOOPBACK_WITHOUT_DMNR, loopback_output_device);
            acoustic_status = DUAL_MIC_WITHOUT_DMNR_ACS_ON;
            break;
        case DUAL_MIC_WITH_DMNR_ACS_OFF:
            // close dual mic acoustic loopback
            pLoopbackManager->SetLoopbackOff();
            acoustic_status = DUAL_MIC_WITH_DMNR_ACS_OFF;
            break;
        case DUAL_MIC_WITH_DMNR_ACS_ON:
            // open dual mic acoustic loopback (w/ DMNR)
            pLoopbackManager->SetLoopbackOn(MD_DUAL_MIC_ACOUSTIC_LOOPBACK_WITH_DMNR, loopback_output_device);
            acoustic_status = DUAL_MIC_WITH_DMNR_ACS_ON;
            break;
        default:
            break;
    }

    ALOGD("PhoneMic_Receiver_Acoustic_Loopback out -");

    return retval;
}


int AudioFtm::SetVibSpkCalibrationParam(void *cali_param)
{
    return SetAudioCompFltCustParamToNV(AUDIO_COMP_FLT_VIBSPK, (AUDIO_ACF_CUSTOM_PARAM_STRUCT *)cali_param);
}

uint32_t AudioFtm::GetVibSpkCalibrationStatus()
{
    AUDIO_ACF_CUSTOM_PARAM_STRUCT audioParam;
    GetAudioCompFltCustParamFromNV(AUDIO_COMP_FLT_VIBSPK, &audioParam);
    if (audioParam.bes_loudness_WS_Gain_Max != VIBSPK_CALIBRATION_DONE && audioParam.bes_loudness_WS_Gain_Max != VIBSPK_SETDEFAULT_VALUE)
    {
        return 0;
    }
    else
    {
        return audioParam.bes_loudness_WS_Gain_Min;
    }
}

void AudioFtm::SetVibSpkEnable(bool enable, uint32_t freq)
{
    if (enable)
    {
        AudioVIBSPKControl::getInstance()->setParameters(44100, freq, 0, 0);
    }
    AudioVIBSPKControl::getInstance()->setVibSpkEnable(enable);
}

void AudioFtm::SetVibSpkRampControl(uint8_t rampcontrol)
{
    AudioVIBSPKControl::getInstance()->VibSpkRampControl(rampcontrol);
}

bool AudioFtm::ReadAuxadcData(int channel, int *value)
{
    int ret;
    ret = ::ioctl(mFd, AUDDRV_GET_AUXADC_CHANNEL_VALUE, channel);
    if (ret == -EFAULT)
    {
        return false;
    }

    *value = ret;
    return true;
}

int AudioFtm::HDMI_SineGenPlayback(bool bEnable, int dSamplingRate)
{
    ALOGD("HDMI_SineGenPlayback, bEnable:%d\n", bEnable);

    if (bEnable)
    {
        RequestClock();
        AudioDigtalI2S master_2nd_i2s_out_attribute;
        memset((void *)&master_2nd_i2s_out_attribute, 0, sizeof(master_2nd_i2s_out_attribute));
        master_2nd_i2s_out_attribute.mI2S_SAMPLERATE = dSamplingRate;
        master_2nd_i2s_out_attribute.mINV_LRCK = AudioDigtalI2S::NO_INVERSE;
        master_2nd_i2s_out_attribute.mI2S_FMT  = AudioDigtalI2S::I2S;
#if defined(HDMI_2NDI2S_32BIT)
        master_2nd_i2s_out_attribute.mI2S_WLEN = AudioDigtalI2S::WLEN_32BITS;
#else
        master_2nd_i2s_out_attribute.mI2S_WLEN = AudioDigtalI2S::WLEN_16BITS;
#endif
        mAudioDigitalInstance->Set2ndI2SOut(&master_2nd_i2s_out_attribute);
        mAudioDigitalInstance->Set2ndI2SOutEnable(true);
        mAudioDigitalInstance->EnableSideToneHw(AudioDigitalType::O00 , false, true);
        mAudioDigitalInstance->SetAfeEnable(true);
    }
    else
    {
        ReleaseClock();
        mAudioDigitalInstance->EnableSideToneHw(AudioDigitalType::O00, false, false);
        mAudioDigitalInstance->Set2ndI2SOutEnable(false);
        mAudioDigitalInstance->SetAfeEnable(false);
    }

    return true;
}


}
