/********************************************************************************************
 *     LEGAL DISCLAIMER
 *
 *     (Header of MediaTek Software/Firmware Release or Documentation)
 *
 *     BY OPENING OR USING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 *     THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE") RECEIVED
 *     FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON AN "AS-IS" BASIS
 *     ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES, EXPRESS OR IMPLIED,
 *     INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR
 *     A PARTICULAR PURPOSE OR NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY
 *     WHATSOEVER WITH RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 *     INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK
 *     ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
 *     NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S SPECIFICATION
 *     OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
 *
 *     BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE LIABILITY WITH
 *     RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION,
 *     TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE
 *     FEES OR SERVICE CHARGE PAID BY BUYER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 *     THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE WITH THE LAWS
 *     OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF LAWS PRINCIPLES.
 ************************************************************************************************/
#ifndef RES_MGR_DRV_H
#define RES_MGR_DRV_H
//-----------------------------------------------------------------------------
typedef enum
{
    RES_MGR_DRV_SCEN_SW_NONE,
    RES_MGR_DRV_SCEN_SW_CAM_IDLE,
    RES_MGR_DRV_SCEN_SW_CAM_PRV,
    RES_MGR_DRV_SCEN_SW_CAM_CAP,
    RES_MGR_DRV_SCEN_SW_VIDEO_PRV,
    RES_MGR_DRV_SCEN_SW_VIDEO_REC,
    RES_MGR_DRV_SCEN_SW_VIDEO_VSS,
    RES_MGR_DRV_SCEN_SW_ZSD,
    RES_MGR_DRV_SCEN_SW_N3D,
}RES_MGR_DRV_SCEN_SW_ENUM;
//
typedef enum
{
    RES_MGR_DRV_SCEN_HW_NONE,
    RES_MGR_DRV_SCEN_HW_IC,
    RES_MGR_DRV_SCEN_HW_VR,
    RES_MGR_DRV_SCEN_HW_ZSD,
    RES_MGR_DRV_SCEN_HW_IP,
    RES_MGR_DRV_SCEN_HW_N3D,
    RES_MGR_DRV_SCEN_HW_VSS
}RES_MGR_DRV_SCEN_HW_ENUM;
//
typedef enum
{
    RES_MGR_DRV_DEV_CAM,
    RES_MGR_DRV_DEV_ATV,
    RES_MGR_DRV_DEV_VT
}RES_MGR_DRV_DEV_ENUM;
//
typedef struct
{
    RES_MGR_DRV_SCEN_SW_ENUM    ScenSw;
    RES_MGR_DRV_SCEN_HW_ENUM    ScenHw;
    RES_MGR_DRV_DEV_ENUM        Dev;
}RES_MGR_DRV_MODE_STRUCT;
//-----------------------------------------------------------------------------
class ResMgrDrv
{
    protected:
        virtual ~ResMgrDrv() {};
    //
    public:
        static ResMgrDrv* CreateInstance(void);
        virtual MVOID   DestroyInstance(void) = 0;
        virtual MBOOL   Init(void) = 0;
        virtual MBOOL   Uninit(void) = 0;
        virtual MBOOL   GetMode(RES_MGR_DRV_MODE_STRUCT* pMode) = 0;
        virtual MBOOL   SetMode(RES_MGR_DRV_MODE_STRUCT* pMode) = 0;
};
//-----------------------------------------------------------------------------
#endif


