#ifndef __DDP_REG_H__
#define __DDP_REG_H__

#include <platform/mt_reg_base.h>
#include <platform/sync_write.h>

// ---------------------------------------------------------------------------
//  Register Field Access
// ---------------------------------------------------------------------------

#define REG_FLD(width, shift) \
    ((unsigned int)((((width) & 0xFF) << 16) | ((shift) & 0xFF)))

#define REG_FLD_WIDTH(field) \
    ((unsigned int)(((field) >> 16) & 0xFF))

#define REG_FLD_SHIFT(field) \
    ((unsigned int)((field) & 0xFF))

#define REG_FLD_MASK(field) \
    (((unsigned int)(1 << REG_FLD_WIDTH(field)) - 1) << REG_FLD_SHIFT(field))

#define REG_FLD_VAL(field, val) \
    (((val) << REG_FLD_SHIFT(field)) & REG_FLD_MASK(field))

#define REG_FLD_GET(field, reg32) \
    (((reg32) & REG_FLD_MASK(field)) >> REG_FLD_SHIFT(field))

#define REG_FLD_SET(field, reg32, val)                  \
    do {                                                \
        (reg32) = (((reg32) & ~REG_FLD_MASK(field)) |   \
                   REG_FLD_VAL((field), (val)));        \
    } while (0)

#define DISP_REG_GET(reg32) (*(volatile unsigned int*)(reg32))
#define DISP_REG_GET_FIELD(field, reg32) \
    do { \
        ((*(volatile unsigned int*)(reg32) & REG_FLD_MASK(field)) >> REG_FLD_SHIFT(field)) \
    } while(0)

#define DISP_REG_SET(reg32, val) mt65xx_reg_sync_writel(val, reg32)
#define DISP_REG_SET_FIELD(field, reg32, val) \
    do { \
        mt_reg_sync_writel((*(volatile unsigned int*)(reg32) & ~REG_FLD_MASK(field)) | REG_FLD_VAL((field), (val)), reg32); \
    } while (0)

#define DDP_MOD_ISP_MOUT    BIT(0)
#define DDP_MOD_MDP_RDMA    BIT(1)
#define DDP_MOD_MDP_RSZ     BIT(2)
#define DDP_MOD_MDP_SHP     BIT(3)
#define DDP_MOD_MDP_WROT    BIT(4)
#define DDP_MOD_DISP_OVL    BIT(5)
#define DDP_MOD_DISP_WDMA   BIT(6)
#define DDP_MOD_DISP_RDMA   BIT(7)
#define DDP_MOD_DISP_PQ     BIT(8)
#define DDP_MOD_DISP_BLS    BIT(9)
#define DDP_MOD_DISP_PWM    BIT(10)

//-----------------------------------------------------------------
// Config
#define DISP_REG_CONFIG_CAM_MDP_MOUT_EN           (MMSYS_CONFIG_BASE + 0x01C)
#define DISP_REG_CONFIG_MDP_RDMA_MOUT_EN          (MMSYS_CONFIG_BASE + 0x020)
#define DISP_REG_CONFIG_MDP_RSZ0_MOUT_EN          (MMSYS_CONFIG_BASE + 0x024)
#define DISP_REG_CONFIG_MDP_RSZ1_MOUT_EN          (MMSYS_CONFIG_BASE + 0x028)
#define DISP_REG_CONFIG_MDP_SHP_MOUT_EN           (MMSYS_CONFIG_BASE + 0x02C)
#define DISP_REG_CONFIG_DISP_OVL_MOUT_EN          (MMSYS_CONFIG_BASE + 0x030)
#define DISP_REG_CONFIG_MMSYS_MOUT_RST            (MMSYS_CONFIG_BASE + 0x034)
#define DISP_REG_CONFIG_MDP_RSZ0_SEL              (MMSYS_CONFIG_BASE + 0x038)
#define DISP_REG_CONFIG_MDP_RSZ1_SEL              (MMSYS_CONFIG_BASE + 0x03C)
#define DISP_REG_CONFIG_MDP_SHP_SEL               (MMSYS_CONFIG_BASE + 0x040)
#define DISP_REG_CONFIG_MDP_WROT_SEL              (MMSYS_CONFIG_BASE + 0x044)
#define DISP_REG_CONFIG_MDP_WDMA_SEL              (MMSYS_CONFIG_BASE + 0x048)
#define DISP_REG_CONFIG_DISP_BLS_SOUT_SEL         (MMSYS_CONFIG_BASE + 0x04C)
#define DISP_REG_CONFIG_DISP_RDMA_SOUT_SEL        (MMSYS_CONFIG_BASE + 0x050)
#define DISP_REG_CONFIG_DISP_PQ_SEL               (MMSYS_CONFIG_BASE + 0x054)
#define DISP_REG_CONFIG_DISP_DSI_SEL              (MMSYS_CONFIG_BASE + 0x058)
#define DISP_REG_CONFIG_DISP_DPI_SEL              (MMSYS_CONFIG_BASE + 0x05C)
#define DISP_REG_CONFIG_DBI_PAD_DELAY_SEL         (MMSYS_CONFIG_BASE + 0x060)
#define DISP_REG_CONFIG_DBI_DPI_IO_SEL            (MMSYS_CONFIG_BASE + 0x064)
#define DISP_REG_CONFIG_LCD_RESET_CON             (MMSYS_CONFIG_BASE + 0x070)
#define DISP_REG_CONFIG_MMSYS_CG_CON0             (MMSYS_CONFIG_BASE + 0x100)
#define DISP_REG_CONFIG_MMSYS_CG_SET0             (MMSYS_CONFIG_BASE + 0x104)
#define DISP_REG_CONFIG_MMSYS_CG_CLR0             (MMSYS_CONFIG_BASE + 0x108)
#define DISP_REG_CONFIG_MMSYS_CG_CON1             (MMSYS_CONFIG_BASE + 0x110)
#define DISP_REG_CONFIG_MMSYS_CG_SET1             (MMSYS_CONFIG_BASE + 0x114)
#define DISP_REG_CONFIG_MMSYS_CG_CLR1             (MMSYS_CONFIG_BASE + 0x118)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS0         (MMSYS_CONFIG_BASE + 0x120)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_SET0     (MMSYS_CONFIG_BASE + 0x124)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_CLR0     (MMSYS_CONFIG_BASE + 0x128)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS1         (MMSYS_CONFIG_BASE + 0x12C)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_SET1     (MMSYS_CONFIG_BASE + 0x130)
#define DISP_REG_CONFIG_MMSYS_HW_DCM_DIS_CLR1     (MMSYS_CONFIG_BASE + 0x134)
#define DISP_REG_CONFIG_MMSYS_SW_RST_B            (MMSYS_CONFIG_BASE + 0x138)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_EN          (MMSYS_CONFIG_BASE + 0x200)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_RST         (MMSYS_CONFIG_BASE + 0x204)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_CON0        (MMSYS_CONFIG_BASE + 0x208)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_CON1        (MMSYS_CONFIG_BASE + 0x20C)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_RD_ADDR     (MMSYS_CONFIG_BASE + 0x210)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_WR_ADDR     (MMSYS_CONFIG_BASE + 0x214)
#define DISP_REG_CONFIG_DISP_FAKE_ENG_STATE       (MMSYS_CONFIG_BASE + 0x218)
#define DISP_REG_CONFIG_MMSYS_MBIST_MODE          (MMSYS_CONFIG_BASE + 0x800)
#define DISP_REG_CONFIG_MMSYS_MBIST_HOLDB         (MMSYS_CONFIG_BASE + 0x804)
#define DISP_REG_CONFIG_MMSYS_MBIST_CON           (MMSYS_CONFIG_BASE + 0x808)
#define DISP_REG_CONFIG_MMSYS_MBIST_DONE          (MMSYS_CONFIG_BASE + 0x80C)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL0         (MMSYS_CONFIG_BASE + 0x810)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL1         (MMSYS_CONFIG_BASE + 0x814)
#define DISP_REG_CONFIG_MMSYS_MBIST_FAIL2         (MMSYS_CONFIG_BASE + 0x818)
#define DISP_REG_CONFIG_MMSYS_MBIST_BSEL0         (MMSYS_CONFIG_BASE + 0x820)
#define DISP_REG_CONFIG_MMSYS_MBIST_BSEL1         (MMSYS_CONFIG_BASE + 0x824)
#define DISP_REG_CONFIG_MMSYS_MBIST_BSEL2         (MMSYS_CONFIG_BASE + 0x828)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL0         (MMSYS_CONFIG_BASE + 0x830)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL1         (MMSYS_CONFIG_BASE + 0x834)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL2         (MMSYS_CONFIG_BASE + 0x838)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL3         (MMSYS_CONFIG_BASE + 0x83C)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL4         (MMSYS_CONFIG_BASE + 0x840)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL5         (MMSYS_CONFIG_BASE + 0x844)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL6         (MMSYS_CONFIG_BASE + 0x848)
#define DISP_REG_CONFIG_MMSYS_MEM_DELSEL7         (MMSYS_CONFIG_BASE + 0x84C)
#define DISP_REG_CONFIG_MDP_WROT_MBISR_RESET      (MMSYS_CONFIG_BASE + 0x850)
#define DISP_REG_CONFIG_MDP_WROT_MBISR_FAIL       (MMSYS_CONFIG_BASE + 0x854)
#define DISP_REG_CONFIG_MDP_WROT_MBISR_OK         (MMSYS_CONFIG_BASE + 0x858)
#define DISP_REG_CONFIG_MMSYS_DEBUG_OUT_SEL       (MMSYS_CONFIG_BASE + 0x860)
#define DISP_REG_CONFIG_MMSYS_DUMMY               (MMSYS_CONFIG_BASE + 0x864)
#define DISP_REG_CONFIG_MMSYS_DL_VALID_0          (MMSYS_CONFIG_BASE + 0x870)
#define DISP_REG_CONFIG_MMSYS_DL_READY_0          (MMSYS_CONFIG_BASE + 0x874)
#define DISP_REG_CONFIG_MMSYS_DL_VALID_1          (MMSYS_CONFIG_BASE + 0x880)
#define DISP_REG_CONFIG_MMSYS_DL_READY_1          (MMSYS_CONFIG_BASE + 0x884)


//-----------------------------------------------------------------
// Mutex
#define DISP_REG_CONFIG_MUTEX_INTEN               (MM_MUTEX_BASE + 0x000)
#define DISP_REG_CONFIG_MUTEX_INTSTA              (MM_MUTEX_BASE + 0x004)
#define DISP_REG_CONFIG_REG_UPD_TIMEOUT           (MM_MUTEX_BASE + 0x008)
#define DISP_REG_CONFIG_REG_COMMIT                (MM_MUTEX_BASE + 0x00C)
#define DISP_REG_CONFIG_MUTEX0_EN                 (MM_MUTEX_BASE + 0x020)
#define DISP_REG_CONFIG_MUTEX0                    (MM_MUTEX_BASE + 0x024)
#define DISP_REG_CONFIG_MUTEX0_RST                (MM_MUTEX_BASE + 0x028)
#define DISP_REG_CONFIG_MUTEX0_MOD                (MM_MUTEX_BASE + 0x02C)
#define DISP_REG_CONFIG_MUTEX0_SOF                (MM_MUTEX_BASE + 0x030)
#define DISP_REG_CONFIG_MUTEX1_EN                 (MM_MUTEX_BASE + 0x040)
#define DISP_REG_CONFIG_MUTEX1                    (MM_MUTEX_BASE + 0x044)
#define DISP_REG_CONFIG_MUTEX1_RST                (MM_MUTEX_BASE + 0x048)
#define DISP_REG_CONFIG_MUTEX1_MOD                (MM_MUTEX_BASE + 0x04C)
#define DISP_REG_CONFIG_MUTEX1_SOF                (MM_MUTEX_BASE + 0x050)
#define DISP_REG_CONFIG_MUTEX2_EN                 (MM_MUTEX_BASE + 0x060)
#define DISP_REG_CONFIG_MUTEX2                    (MM_MUTEX_BASE + 0x064)
#define DISP_REG_CONFIG_MUTEX2_RST                (MM_MUTEX_BASE + 0x068)
#define DISP_REG_CONFIG_MUTEX2_MOD                (MM_MUTEX_BASE + 0x06C)
#define DISP_REG_CONFIG_MUTEX2_SOF                (MM_MUTEX_BASE + 0x070)
#define DISP_REG_CONFIG_MUTEX3_EN                 (MM_MUTEX_BASE + 0x080)
#define DISP_REG_CONFIG_MUTEX3                    (MM_MUTEX_BASE + 0x084)
#define DISP_REG_CONFIG_MUTEX3_RST                (MM_MUTEX_BASE + 0x088)
#define DISP_REG_CONFIG_MUTEX3_MOD                (MM_MUTEX_BASE + 0x08C)
#define DISP_REG_CONFIG_MUTEX3_SOF                (MM_MUTEX_BASE + 0x090)
#define DISP_REG_CONFIG_MUTEX4_EN                 (MM_MUTEX_BASE + 0x0A0)
#define DISP_REG_CONFIG_MUTEX4                    (MM_MUTEX_BASE + 0x0A4)
#define DISP_REG_CONFIG_MUTEX4_RST                (MM_MUTEX_BASE + 0x0A8)
#define DISP_REG_CONFIG_MUTEX4_MOD                (MM_MUTEX_BASE + 0x0AC)
#define DISP_REG_CONFIG_MUTEX4_SOF                (MM_MUTEX_BASE + 0x0B0)
#define DISP_REG_CONFIG_MUTEX5_EN                 (MM_MUTEX_BASE + 0x0C0)
#define DISP_REG_CONFIG_MUTEX5                    (MM_MUTEX_BASE + 0x0C4)
#define DISP_REG_CONFIG_MUTEX5_RST                (MM_MUTEX_BASE + 0x0C8)
#define DISP_REG_CONFIG_MUTEX5_MOD                (MM_MUTEX_BASE + 0x0CC)
#define DISP_REG_CONFIG_MUTEX5_SOF                (MM_MUTEX_BASE + 0x0D0)
#define DISP_REG_CONFIG_MUTEX6_EN                 (MM_MUTEX_BASE + 0x0E0)
#define DISP_REG_CONFIG_MUTEX6                    (MM_MUTEX_BASE + 0x0E4)
#define DISP_REG_CONFIG_MUTEX6_RST                (MM_MUTEX_BASE + 0x0E8)
#define DISP_REG_CONFIG_MUTEX6_MOD                (MM_MUTEX_BASE + 0x0EC)
#define DISP_REG_CONFIG_MUTEX6_SOF                (MM_MUTEX_BASE + 0x0F0)
#define DISP_REG_CONFIG_MUTEX7_EN                 (MM_MUTEX_BASE + 0x100)
#define DISP_REG_CONFIG_MUTEX7                    (MM_MUTEX_BASE + 0x104)
#define DISP_REG_CONFIG_MUTEX7_RST                (MM_MUTEX_BASE + 0x108)
#define DISP_REG_CONFIG_MUTEX7_MOD                (MM_MUTEX_BASE + 0x10C)
#define DISP_REG_CONFIG_MUTEX7_SOF                (MM_MUTEX_BASE + 0x110)
#define DISP_REG_CONFIG_MUTEX_DEBUG_OUT_SEL       (MM_MUTEX_BASE + 0x200)

#define DISP_REG_CONFIG_MUTEX_EN(X)               (DISP_REG_CONFIG_MUTEX0_EN  + (0x20 * X))
#define DISP_REG_CONFIG_MUTEX(X)                  (DISP_REG_CONFIG_MUTEX0     + (0x20 * X))
#define DISP_REG_CONFIG_MUTEX_RST(X)              (DISP_REG_CONFIG_MUTEX0_RST + (0x20 * X))
#define DISP_REG_CONFIG_MUTEX_MOD(X)              (DISP_REG_CONFIG_MUTEX0_MOD + (0x20 * X))
#define DISP_REG_CONFIG_MUTEX_SOF(X)              (DISP_REG_CONFIG_MUTEX0_SOF + (0x20 * X))


//-----------------------------------------------------------------
// OVL
#define DISP_REG_OVL_STA                          (DISP_OVL_BASE + 0x000)
#define DISP_REG_OVL_INTEN                        (DISP_OVL_BASE + 0x004)
#define DISP_REG_OVL_INTSTA                       (DISP_OVL_BASE + 0x008)
#define DISP_REG_OVL_EN                           (DISP_OVL_BASE + 0x00C)
#define DISP_REG_OVL_TRIG                         (DISP_OVL_BASE + 0x010)
#define DISP_REG_OVL_RST                          (DISP_OVL_BASE + 0x014)
#define DISP_REG_OVL_ROI_SIZE                     (DISP_OVL_BASE + 0x020)
#define DISP_REG_OVL_DATAPATH_CON                 (DISP_OVL_BASE + 0x024)
#define DISP_REG_OVL_ROI_BGCLR                    (DISP_OVL_BASE + 0x028)
#define DISP_REG_OVL_SRC_CON                      (DISP_OVL_BASE + 0x02C)
#define DISP_REG_OVL_L0_CON                       (DISP_OVL_BASE + 0x030)
#define DISP_REG_OVL_L0_SRCKEY                    (DISP_OVL_BASE + 0x034)
#define DISP_REG_OVL_L0_SRC_SIZE                  (DISP_OVL_BASE + 0x038)
#define DISP_REG_OVL_L0_OFFSET                    (DISP_OVL_BASE + 0x03C)
#define DISP_REG_OVL_L0_ADDR                      (DISP_OVL_BASE + 0x040)
#define DISP_REG_OVL_L0_PITCH                     (DISP_OVL_BASE + 0x044)
#define DISP_REG_OVL_L0_TILE                      (DISP_OVL_BASE + 0x048)
#define DISP_REG_OVL_L1_CON                       (DISP_OVL_BASE + 0x050)
#define DISP_REG_OVL_L1_SRCKEY                    (DISP_OVL_BASE + 0x054)
#define DISP_REG_OVL_L1_SRC_SIZE                  (DISP_OVL_BASE + 0x058)
#define DISP_REG_OVL_L1_OFFSET                    (DISP_OVL_BASE + 0x05C)
#define DISP_REG_OVL_L1_ADDR                      (DISP_OVL_BASE + 0x060)
#define DISP_REG_OVL_L1_PITCH                     (DISP_OVL_BASE + 0x064)
#define DISP_REG_OVL_L1_TILE                      (DISP_OVL_BASE + 0x068)
#define DISP_REG_OVL_L2_CON                       (DISP_OVL_BASE + 0x070)
#define DISP_REG_OVL_L2_SRCKEY                    (DISP_OVL_BASE + 0x074)
#define DISP_REG_OVL_L2_SRC_SIZE                  (DISP_OVL_BASE + 0x078)
#define DISP_REG_OVL_L2_OFFSET                    (DISP_OVL_BASE + 0x07C)
#define DISP_REG_OVL_L2_ADDR                      (DISP_OVL_BASE + 0x080)
#define DISP_REG_OVL_L2_PITCH                     (DISP_OVL_BASE + 0x084)
#define DISP_REG_OVL_L2_TILE                      (DISP_OVL_BASE + 0x088)
#define DISP_REG_OVL_L3_CON                       (DISP_OVL_BASE + 0x090)
#define DISP_REG_OVL_L3_SRCKEY                    (DISP_OVL_BASE + 0x094)
#define DISP_REG_OVL_L3_SRC_SIZE                  (DISP_OVL_BASE + 0x098)
#define DISP_REG_OVL_L3_OFFSET                    (DISP_OVL_BASE + 0x09C)
#define DISP_REG_OVL_L3_ADDR                      (DISP_OVL_BASE + 0x0A0)
#define DISP_REG_OVL_L3_PITCH                     (DISP_OVL_BASE + 0x0A4)
#define DISP_REG_OVL_L3_TILE                      (DISP_OVL_BASE + 0x0A8)
#define DISP_REG_OVL_RDMA0_CTRL                   (DISP_OVL_BASE + 0x0C0)
#define DISP_REG_OVL_RDMA0_MEM_GMC_SETTING1       (DISP_OVL_BASE + 0x0C8)
#define DISP_REG_OVL_RDMA0_MEM_SLOW_CON           (DISP_OVL_BASE + 0x0CC)
#define DISP_REG_OVL_RDMA0_FIFO_CTRL              (DISP_OVL_BASE + 0x0D0)
#define DISP_REG_OVL_RDMA1_CTRL                   (DISP_OVL_BASE + 0x0E0)
#define DISP_REG_OVL_RDMA1_MEM_GMC_SETTING1       (DISP_OVL_BASE + 0x0E8)
#define DISP_REG_OVL_RDMA1_MEM_SLOW_CON           (DISP_OVL_BASE + 0x0EC)
#define DISP_REG_OVL_RDMA1_FIFO_CTRL              (DISP_OVL_BASE + 0x0F0)
#define DISP_REG_OVL_RDMA2_CTRL                   (DISP_OVL_BASE + 0x100)
#define DISP_REG_OVL_RDMA2_MEM_GMC_SETTING1       (DISP_OVL_BASE + 0x108)
#define DISP_REG_OVL_RDMA2_MEM_SLOW_CON           (DISP_OVL_BASE + 0x10C)
#define DISP_REG_OVL_RDMA2_FIFO_CTRL              (DISP_OVL_BASE + 0x110)
#define DISP_REG_OVL_RDMA3_CTRL                   (DISP_OVL_BASE + 0x120)
#define DISP_REG_OVL_RDMA3_MEM_GMC_SETTING1       (DISP_OVL_BASE + 0x128)
#define DISP_REG_OVL_RDMA3_MEM_SLOW_CON           (DISP_OVL_BASE + 0x12C)
#define DISP_REG_OVL_RDMA3_FIFO_CTRL              (DISP_OVL_BASE + 0x130)
#define DISP_REG_OVL_L0_Y2R_PARA_R0               (DISP_OVL_BASE + 0x134)
#define DISP_REG_OVL_L0_Y2R_PARA_R1               (DISP_OVL_BASE + 0x138)
#define DISP_REG_OVL_L0_Y2R_PARA_G0               (DISP_OVL_BASE + 0x13C)
#define DISP_REG_OVL_L0_Y2R_PARA_G1               (DISP_OVL_BASE + 0x140)
#define DISP_REG_OVL_L0_Y2R_PARA_B0               (DISP_OVL_BASE + 0x144)
#define DISP_REG_OVL_L0_Y2R_PARA_B1               (DISP_OVL_BASE + 0x148)
#define DISP_REG_OVL_L0_Y2R_PARA_YUV_A_0          (DISP_OVL_BASE + 0x14C)
#define DISP_REG_OVL_L0_Y2R_PARA_YUV_A_1          (DISP_OVL_BASE + 0x150)
#define DISP_REG_OVL_L0_Y2R_PARA_RGB_A_0          (DISP_OVL_BASE + 0x154)
#define DISP_REG_OVL_L0_Y2R_PARA_RGB_A_1          (DISP_OVL_BASE + 0x158)
#define DISP_REG_OVL_L1_Y2R_PARA_R0               (DISP_OVL_BASE + 0x15C)
#define DISP_REG_OVL_L1_Y2R_PARA_R1               (DISP_OVL_BASE + 0x160)
#define DISP_REG_OVL_L1_Y2R_PARA_G0               (DISP_OVL_BASE + 0x164)
#define DISP_REG_OVL_L1_Y2R_PARA_G1               (DISP_OVL_BASE + 0x168)
#define DISP_REG_OVL_L1_Y2R_PARA_B0               (DISP_OVL_BASE + 0x16C)
#define DISP_REG_OVL_L1_Y2R_PARA_B1               (DISP_OVL_BASE + 0x170)
#define DISP_REG_OVL_L1_Y2R_PARA_YUV_A_0          (DISP_OVL_BASE + 0x174)
#define DISP_REG_OVL_L1_Y2R_PARA_YUV_A_1          (DISP_OVL_BASE + 0x178)
#define DISP_REG_OVL_L1_Y2R_PARA_RGB_A_0          (DISP_OVL_BASE + 0x17C)
#define DISP_REG_OVL_L1_Y2R_PARA_RGB_A_1          (DISP_OVL_BASE + 0x180)
#define DISP_REG_OVL_L2_Y2R_PARA_R0               (DISP_OVL_BASE + 0x184)
#define DISP_REG_OVL_L2_Y2R_PARA_R1               (DISP_OVL_BASE + 0x188)
#define DISP_REG_OVL_L2_Y2R_PARA_G0               (DISP_OVL_BASE + 0x18C)
#define DISP_REG_OVL_L2_Y2R_PARA_G1               (DISP_OVL_BASE + 0x190)
#define DISP_REG_OVL_L2_Y2R_PARA_B0               (DISP_OVL_BASE + 0x194)
#define DISP_REG_OVL_L2_Y2R_PARA_B1               (DISP_OVL_BASE + 0x198)
#define DISP_REG_OVL_L2_Y2R_PARA_YUV_A_0          (DISP_OVL_BASE + 0x19C)
#define DISP_REG_OVL_L2_Y2R_PARA_YUV_A_1          (DISP_OVL_BASE + 0x1A0)
#define DISP_REG_OVL_L2_Y2R_PARA_RGB_A_0          (DISP_OVL_BASE + 0x1A4)
#define DISP_REG_OVL_L2_Y2R_PARA_RGB_A_1          (DISP_OVL_BASE + 0x1A8)
#define DISP_REG_OVL_L3_Y2R_PARA_R0               (DISP_OVL_BASE + 0x1AC)
#define DISP_REG_OVL_L3_Y2R_PARA_R1               (DISP_OVL_BASE + 0x1B0)
#define DISP_REG_OVL_L3_Y2R_PARA_G0               (DISP_OVL_BASE + 0x1B4)
#define DISP_REG_OVL_L3_Y2R_PARA_G1               (DISP_OVL_BASE + 0x1B8)
#define DISP_REG_OVL_L3_Y2R_PARA_B0               (DISP_OVL_BASE + 0x1BC)
#define DISP_REG_OVL_L3_Y2R_PARA_B1               (DISP_OVL_BASE + 0x1C0)
#define DISP_REG_OVL_L3_Y2R_PARA_YUV_A_0          (DISP_OVL_BASE + 0x1C4)
#define DISP_REG_OVL_L3_Y2R_PARA_YUV_A_1          (DISP_OVL_BASE + 0x1C8)
#define DISP_REG_OVL_L3_Y2R_PARA_RGB_A_0          (DISP_OVL_BASE + 0x1CC)
#define DISP_REG_OVL_L3_Y2R_PARA_RGB_A_1          (DISP_OVL_BASE + 0x1D0)
#define DISP_REG_OVL_DEBUG_MON_SEL                (DISP_OVL_BASE + 0x1D4)
#define DISP_REG_OVL_RDMA0_MEM_GMC_SETTING2       (DISP_OVL_BASE + 0x1E0)
#define DISP_REG_OVL_RDMA1_MEM_GMC_SETTING2       (DISP_OVL_BASE + 0x1E4)
#define DISP_REG_OVL_RDMA2_MEM_GMC_SETTING2       (DISP_OVL_BASE + 0x1E8)
#define DISP_REG_OVL_RDMA3_MEM_GMC_SETTING2       (DISP_OVL_BASE + 0x1EC)
#define DISP_REG_OVL_DUMMY_REG                    (DISP_OVL_BASE + 0x200)
#define DISP_REG_OVL_FLOW_CTRL_DBG                (DISP_OVL_BASE + 0x240)
#define DISP_REG_OVL_ADDCON_DBG                   (DISP_OVL_BASE + 0x244)
#define DISP_REG_OVL_RDMA0_DBG                    (DISP_OVL_BASE + 0x24C)
#define DISP_REG_OVL_RDMA1_DBG                    (DISP_OVL_BASE + 0x250)
#define DISP_REG_OVL_RDMA2_DBG                    (DISP_OVL_BASE + 0x254)
#define DISP_REG_OVL_RDMA3_DBG                    (DISP_OVL_BASE + 0x258)


//-----------------------------------------------------------------
// RDMA
#define DISP_REG_RDMA_INT_ENABLE                  (DISP_RDMA_BASE + 0x000)
#define DISP_REG_RDMA_INT_STATUS                  (DISP_RDMA_BASE + 0x004)
#define DISP_REG_RDMA_GLOBAL_CON                  (DISP_RDMA_BASE + 0x010)
#define DISP_REG_RDMA_SIZE_CON_0                  (DISP_RDMA_BASE + 0x014)
#define DISP_REG_RDMA_SIZE_CON_1                  (DISP_RDMA_BASE + 0x018)
#define DISP_REG_RDMA_TARGET_LINE                 (DISP_RDMA_BASE + 0x01C)
#define DISP_REG_RDMA_MEM_CON                     (DISP_RDMA_BASE + 0x024)
#define DISP_REG_RDMA_MEM_START_ADDR              (DISP_RDMA_BASE + 0x028)
#define DISP_REG_RDMA_MEM_SRC_PITCH               (DISP_RDMA_BASE + 0x02C)
#define DISP_REG_RDMA_MEM_GMC_SETTING_0           (DISP_RDMA_BASE + 0x030)
#define DISP_REG_RDMA_MEM_SLOW_CON                (DISP_RDMA_BASE + 0x034)
#define DISP_REG_RDMA_MEM_GMC_SETTING_1           (DISP_RDMA_BASE + 0x038)
#define DISP_REG_RDMA_FIFO_CON                    (DISP_RDMA_BASE + 0x040)
#define DISP_REG_RDMA_FIFO_LOG                    (DISP_RDMA_BASE + 0x044)
#define DISP_REG_RDMA_C00                         (DISP_RDMA_BASE + 0x054)
#define DISP_REG_RDMA_C01                         (DISP_RDMA_BASE + 0x058)
#define DISP_REG_RDMA_C02                         (DISP_RDMA_BASE + 0x05C)
#define DISP_REG_RDMA_C10                         (DISP_RDMA_BASE + 0x060)
#define DISP_REG_RDMA_C11                         (DISP_RDMA_BASE + 0x064)
#define DISP_REG_RDMA_C12                         (DISP_RDMA_BASE + 0x068)
#define DISP_REG_RDMA_C20                         (DISP_RDMA_BASE + 0x06C)
#define DISP_REG_RDMA_C21                         (DISP_RDMA_BASE + 0x070)
#define DISP_REG_RDMA_C22                         (DISP_RDMA_BASE + 0x074)
#define DISP_REG_RDMA_PRE_ADD_0                   (DISP_RDMA_BASE + 0x078)
#define DISP_REG_RDMA_PRE_ADD_1                   (DISP_RDMA_BASE + 0x07C)
#define DISP_REG_RDMA_PRE_ADD_2                   (DISP_RDMA_BASE + 0x080)
#define DISP_REG_RDMA_POST_ADD_0                  (DISP_RDMA_BASE + 0x084)
#define DISP_REG_RDMA_POST_ADD_1                  (DISP_RDMA_BASE + 0x088)
#define DISP_REG_RDMA_POST_ADD_2                  (DISP_RDMA_BASE + 0x08C)
#define DISP_REG_RDMA_DUMMY                       (DISP_RDMA_BASE + 0x090)
#define DISP_REG_RDMA_DEBUG_OUT_SEL               (DISP_RDMA_BASE + 0x094)


//-----------------------------------------------------------------
// WDMA
#define DISP_REG_WDMA_INTEN                       (DISP_WDMA_BASE + 0x000)
#define DISP_REG_WDMA_INTSTA                      (DISP_WDMA_BASE + 0x004)
#define DISP_REG_WDMA_EN                          (DISP_WDMA_BASE + 0x008)
#define DISP_REG_WDMA_RST                         (DISP_WDMA_BASE + 0x00C)
#define DISP_REG_WDMA_SMI_CON                     (DISP_WDMA_BASE + 0x010)
#define DISP_REG_WDMA_CFG                         (DISP_WDMA_BASE + 0x014)
#define DISP_REG_WDMA_SRC_SIZE                    (DISP_WDMA_BASE + 0x018)
#define DISP_REG_WDMA_CLIP_SIZE                   (DISP_WDMA_BASE + 0x01C)
#define DISP_REG_WDMA_CLIP_COORD                  (DISP_WDMA_BASE + 0x020)
#define DISP_REG_WDMA_DST_ADDR0                   (DISP_WDMA_BASE + 0x024)
#define DISP_REG_WDMA_DST_W_IN_BYTE               (DISP_WDMA_BASE + 0x028)
#define DISP_REG_WDMA_ALPHA                       (DISP_WDMA_BASE + 0x02C)
#define DISP_REG_WDMA_BUF_CON1                    (DISP_WDMA_BASE + 0x038)
#define DISP_REG_WDMA_BUF_CON2                    (DISP_WDMA_BASE + 0x03C)
#define DISP_REG_WDMA_C00                         (DISP_WDMA_BASE + 0x040)
#define DISP_REG_WDMA_C02                         (DISP_WDMA_BASE + 0x044)
#define DISP_REG_WDMA_C10                         (DISP_WDMA_BASE + 0x048)
#define DISP_REG_WDMA_C12                         (DISP_WDMA_BASE + 0x04C)
#define DISP_REG_WDMA_C20                         (DISP_WDMA_BASE + 0x050)
#define DISP_REG_WDMA_C22                         (DISP_WDMA_BASE + 0x054)
#define DISP_REG_WDMA_PRE_ADD0                    (DISP_WDMA_BASE + 0x058)
#define DISP_REG_WDMA_PRE_ADD2                    (DISP_WDMA_BASE + 0x05C)
#define DISP_REG_WDMA_POST_ADD0                   (DISP_WDMA_BASE + 0x060)
#define DISP_REG_WDMA_POST_ADD2                   (DISP_WDMA_BASE + 0x064)
#define DISP_REG_WDMA_DST_ADDR1                   (DISP_WDMA_BASE + 0x070)
#define DISP_REG_WDMA_DST_ADDR2                   (DISP_WDMA_BASE + 0x074)
#define DISP_REG_WDMA_DST_UV_PITCH                (DISP_WDMA_BASE + 0x078)
#define DISP_REG_WDMA_DST_ADDR_OFFSET0            (DISP_WDMA_BASE + 0x080)
#define DISP_REG_WDMA_DST_ADDR_OFFSET1            (DISP_WDMA_BASE + 0x084)
#define DISP_REG_WDMA_DST_ADDR_OFFSET2            (DISP_WDMA_BASE + 0x088)
#define DISP_REG_WDMA_FLOW_CTRL_DBG               (DISP_WDMA_BASE + 0x0A0)
#define DISP_REG_WDMA_EXEC_DBG                    (DISP_WDMA_BASE + 0x0A4)
#define DISP_REG_WDMA_CT_DBG                      (DISP_WDMA_BASE + 0x0A8)
#define DISP_REG_WDMA_DEBUG                       (DISP_WDMA_BASE + 0x0AC)
#define DISP_REG_WDMA_DUMMY                       (DISP_WDMA_BASE + 0x100)
#define DISP_REG_WDMA_DITHER_0                    (DISP_WDMA_BASE + 0xE00)
#define DISP_REG_WDMA_DITHER_5                    (DISP_WDMA_BASE + 0xE14)
#define DISP_REG_WDMA_DITHER_6                    (DISP_WDMA_BASE + 0xE18)
#define DISP_REG_WDMA_DITHER_7                    (DISP_WDMA_BASE + 0xE1C)
#define DISP_REG_WDMA_DITHER_8                    (DISP_WDMA_BASE + 0xE20)
#define DISP_REG_WDMA_DITHER_9                    (DISP_WDMA_BASE + 0xE24)
#define DISP_REG_WDMA_DITHER_10                   (DISP_WDMA_BASE + 0xE28)
#define DISP_REG_WDMA_DITHER_11                   (DISP_WDMA_BASE + 0xE2C)
#define DISP_REG_WDMA_DITHER_12                   (DISP_WDMA_BASE + 0xE30)
#define DISP_REG_WDMA_DITHER_13                   (DISP_WDMA_BASE + 0xE34)
#define DISP_REG_WDMA_DITHER_14                   (DISP_WDMA_BASE + 0xE38)
#define DISP_REG_WDMA_DITHER_15                   (DISP_WDMA_BASE + 0xE3C)
#define DISP_REG_WDMA_DITHER_16                   (DISP_WDMA_BASE + 0xE40)
#define DISP_REG_WDMA_DITHER_17                   (DISP_WDMA_BASE + 0xE44)


//-----------------------------------------------------------------
// PQ
#define DISP_REG_PQ_CTRL                          (DISP_PQ_BASE + 0x000)
#define DISP_REG_PQ_INTEN                         (DISP_PQ_BASE + 0x004)
#define DISP_REG_PQ_INTSTA                        (DISP_PQ_BASE + 0x008)
#define DISP_REG_PQ_STATUS                        (DISP_PQ_BASE + 0x00C)
#define DISP_REG_PQ_CFG                           (DISP_PQ_BASE + 0x010)
#define DISP_REG_PQ_INPUT_COUNT                   (DISP_PQ_BASE + 0x014)
#define DISP_REG_PQ_CHKSUM                        (DISP_PQ_BASE + 0x018)
#define DISP_REG_PQ_OUTPUT_COUNT                  (DISP_PQ_BASE + 0x01C)
#define DISP_REG_PQ_INPUT_SIZE                    (DISP_PQ_BASE + 0x020)
#define DISP_REG_PQ_OUTPUT_OFFSET                 (DISP_PQ_BASE + 0x024)
#define DISP_REG_PQ_OUTPUT_SIZE                   (DISP_PQ_BASE + 0x028)
#define DISP_REG_PQ_HSYNC                         (DISP_PQ_BASE + 0x02C)
#define DISP_REG_PQ_DEMO_HMASK                    (DISP_PQ_BASE + 0x030)
#define DISP_REG_PQ_DEMO_VMASK                    (DISP_PQ_BASE + 0x034)
#define DISP_REG_PQ_SHP_CON_00                    (DISP_PQ_BASE + 0x040)
#define DISP_REG_PQ_SHP_CON_01                    (DISP_PQ_BASE + 0x044)
#define DISP_REG_PQ_CONT_CP                       (DISP_PQ_BASE + 0x050)
#define DISP_REG_PQ_CONT_SLOPE                    (DISP_PQ_BASE + 0x054)
#define DISP_REG_PQ_CONT_OFFSET                   (DISP_PQ_BASE + 0x058)
#define DISP_REG_PQ_SAT_CON_00                    (DISP_PQ_BASE + 0x060)
#define DISP_REG_PQ_SAT_CON_01                    (DISP_PQ_BASE + 0x064)
#define DISP_REG_PQ_SAT_GAIN                      (DISP_PQ_BASE + 0x068)
#define DISP_REG_PQ_SAT_SLOPE                     (DISP_PQ_BASE + 0x06C)
#define DISP_REG_PQ_HIST_X_CFG                    (DISP_PQ_BASE + 0x070)
#define DISP_REG_PQ_HIST_Y_CFG                    (DISP_PQ_BASE + 0x074)
#define DISP_REG_PQ_LUMA_HIST_00                  (DISP_PQ_BASE + 0x078)
#define DISP_REG_PQ_LUMA_HIST_01                  (DISP_PQ_BASE + 0x07C)
#define DISP_REG_PQ_LUMA_HIST_02                  (DISP_PQ_BASE + 0x080)
#define DISP_REG_PQ_LUMA_HIST_03                  (DISP_PQ_BASE + 0x084)
#define DISP_REG_PQ_LUMA_HIST_04                  (DISP_PQ_BASE + 0x088)
#define DISP_REG_PQ_LUMA_HIST_05                  (DISP_PQ_BASE + 0x08C)
#define DISP_REG_PQ_LUMA_HIST_06                  (DISP_PQ_BASE + 0x090)
#define DISP_REG_PQ_LUMA_HIST_07                  (DISP_PQ_BASE + 0x094)
#define DISP_REG_PQ_LUMA_HIST_08                  (DISP_PQ_BASE + 0x098)
#define DISP_REG_PQ_LUMA_HIST_09                  (DISP_PQ_BASE + 0x09C)
#define DISP_REG_PQ_LUMA_HIST_10                  (DISP_PQ_BASE + 0x0A0)
#define DISP_REG_PQ_LUMA_HIST_11                  (DISP_PQ_BASE + 0x0A4)
#define DISP_REG_PQ_LUMA_HIST_12                  (DISP_PQ_BASE + 0x0A8)
#define DISP_REG_PQ_LUMA_HIST_13                  (DISP_PQ_BASE + 0x0AC)
#define DISP_REG_PQ_LUMA_HIST_14                  (DISP_PQ_BASE + 0x0B0)
#define DISP_REG_PQ_LUMA_HIST_15                  (DISP_PQ_BASE + 0x0B4)
#define DISP_REG_PQ_LUMA_HIST_16                  (DISP_PQ_BASE + 0x0B8)
#define DISP_REG_PQ_LUMA_SUM                      (DISP_PQ_BASE + 0x0C0)
#define DISP_REG_PQ_LUMA_MIN_MAX                  (DISP_PQ_BASE + 0x0C4)
#define DISP_REG_PQ_Y_FTN_1_0                     (DISP_PQ_BASE + 0x0D0)
#define DISP_REG_PQ_Y_FTN_3_2                     (DISP_PQ_BASE + 0x0D4)
#define DISP_REG_PQ_Y_FTN_5_4                     (DISP_PQ_BASE + 0x0D8)
#define DISP_REG_PQ_Y_FTN_7_6                     (DISP_PQ_BASE + 0x0DC)
#define DISP_REG_PQ_Y_FTN_9_8                     (DISP_PQ_BASE + 0x0E0)
#define DISP_REG_PQ_Y_FTN_11_10                   (DISP_PQ_BASE + 0x0E4)
#define DISP_REG_PQ_Y_FTN_13_12                   (DISP_PQ_BASE + 0x0E8)
#define DISP_REG_PQ_Y_FTN_15_14                   (DISP_PQ_BASE + 0x0EC)
#define DISP_REG_PQ_Y_FTN_16                      (DISP_PQ_BASE + 0x0F0)
#define DISP_REG_PQ_C_BOOST_CON                   (DISP_PQ_BASE + 0x100)
#define DISP_REG_PQ_C_HIST_X_CFG                  (DISP_PQ_BASE + 0x110)
#define DISP_REG_PQ_C_HIST_Y_CFG                  (DISP_PQ_BASE + 0x114)
#define DISP_REG_PQ_C_HIST_CON                    (DISP_PQ_BASE + 0x118)
#define DISP_REG_PQ_C_HIST_BIN                    (DISP_PQ_BASE + 0x11C)
#define DISP_REG_PQ_DEMO_MAIN                     (DISP_PQ_BASE + 0x200)
#define DISP_REG_PQ_INK_LUMA                      (DISP_PQ_BASE + 0x208)
#define DISP_REG_PQ_INK_CHROMA                    (DISP_PQ_BASE + 0x20C)
#define DISP_REG_PQ_CAP_POS                       (DISP_PQ_BASE + 0x210)
#define DISP_REG_PQ_CAP_IN_Y                      (DISP_PQ_BASE + 0x218)
#define DISP_REG_PQ_CAP_IN_C                      (DISP_PQ_BASE + 0x21C)
#define DISP_REG_PQ_CAP_OUT_Y                     (DISP_PQ_BASE + 0x220)
#define DISP_REG_PQ_CAP_OUT_C                     (DISP_PQ_BASE + 0x224)


//-----------------------------------------------------------------
// PWM
#define DISP_REG_PWM_EN                           (DISP_PWM_BASE + 0x000)
#define DISP_REG_PWM_RST                          (DISP_PWM_BASE + 0x004)
#define DISP_REG_PWM_CON_0                        (DISP_PWM_BASE + 0x010)
#define DISP_REG_PWM_CON_1                        (DISP_PWM_BASE + 0x014)
#define DISP_REG_PWM_GRADUAL                      (DISP_PWM_BASE + 0x018)
#define DISP_REG_PWM_GRADUAL_RO                   (DISP_PWM_BASE + 0x01C)
#define DISP_REG_PWM_DEBUG                        (DISP_PWM_BASE + 0x020)
#define DISP_REG_PWM_DUMMY                        (DISP_PWM_BASE + 0x030)


//-----------------------------------------------------------------
// BLS
#define DISP_REG_BLS_EN                           (DISP_BLS_BASE + 0x000)
#define DISP_REG_BLS_RST                          (DISP_BLS_BASE + 0x004)
#define DISP_REG_BLS_INTEN                        (DISP_BLS_BASE + 0x008)
#define DISP_REG_BLS_INTSTA                       (DISP_BLS_BASE + 0x00C)
#define DISP_REG_BLS_BLS_SETTING                  (DISP_BLS_BASE + 0x010)
#define DISP_REG_BLS_FANA_SETTING                 (DISP_BLS_BASE + 0x014)
#define DISP_REG_BLS_SRC_SIZE                     (DISP_BLS_BASE + 0x018)
#define DISP_REG_BLS_GAIN_SETTING                 (DISP_BLS_BASE + 0x020)
#define DISP_REG_BLS_MANUAL_GAIN                  (DISP_BLS_BASE + 0x024)
#define DISP_REG_BLS_MANUAL_MAXCLR                (DISP_BLS_BASE + 0x028)
#define DISP_REG_BLS_GAMMA_SETTING                (DISP_BLS_BASE + 0x030)
#define DISP_REG_BLS_LUT_UPDATE                   (DISP_BLS_BASE + 0x038)
#define DISP_REG_BLS_MAXCLR_THD                   (DISP_BLS_BASE + 0x060)
#define DISP_REG_BLS_DISTPT_THD                   (DISP_BLS_BASE + 0x064)
#define DISP_REG_BLS_MAXCLR_LIMIT                 (DISP_BLS_BASE + 0x068)
#define DISP_REG_BLS_DISTPT_LIMIT                 (DISP_BLS_BASE + 0x06C)
#define DISP_REG_BLS_AVE_SETTING                  (DISP_BLS_BASE + 0x070)
#define DISP_REG_BLS_AVE_LIMIT                    (DISP_BLS_BASE + 0x074)
#define DISP_REG_BLS_DISTPT_SETTING               (DISP_BLS_BASE + 0x078)
#define DISP_REG_BLS_HIS_CLEAR                    (DISP_BLS_BASE + 0x07C)
#define DISP_REG_BLS_SC_DIFF_THD                  (DISP_BLS_BASE + 0x080)
#define DISP_REG_BLS_SC_BIN_THD                   (DISP_BLS_BASE + 0x084)
#define DISP_REG_BLS_MAXCLR_GRADUAL               (DISP_BLS_BASE + 0x088)
#define DISP_REG_BLS_DISTPT_GRADUAL               (DISP_BLS_BASE + 0x08C)
#define DISP_REG_BLS_FAST_IIR_XCOEFF              (DISP_BLS_BASE + 0x090)
#define DISP_REG_BLS_FAST_IIR_YCOEFF              (DISP_BLS_BASE + 0x094)
#define DISP_REG_BLS_SLOW_IIR_XCOEFF              (DISP_BLS_BASE + 0x098)
#define DISP_REG_BLS_SLOW_IIR_YCOEFF              (DISP_BLS_BASE + 0x09C)
#define DISP_REG_BLS_PWM_DUTY                     (DISP_BLS_BASE + 0x0A0)
#define DISP_REG_BLS_DEBUG                        (DISP_BLS_BASE + 0x0B0)
#define DISP_REG_BLS_PATTERN                      (DISP_BLS_BASE + 0x0B4)
#define DISP_REG_BLS_CHKSUM                       (DISP_BLS_BASE + 0x0B8)
#define DISP_REG_BLS_SAFE_MEASURE                 (DISP_BLS_BASE + 0x0C0)
#define DISP_REG_BLS_HIS_BIN_                     (DISP_BLS_BASE + 0x100)
#define DISP_REG_BLS_PWM_DUTY_RD                  (DISP_BLS_BASE + 0x200)
#define DISP_REG_BLS_FRAME_AVE_RD                 (DISP_BLS_BASE + 0x204)
#define DISP_REG_BLS_MAXCLR_RD                    (DISP_BLS_BASE + 0x208)
#define DISP_REG_BLS_DISTPT_RD                    (DISP_BLS_BASE + 0x20C)
#define DISP_REG_BLS_GAIN_RD                      (DISP_BLS_BASE + 0x210)
#define DISP_REG_BLS_SC_RD                        (DISP_BLS_BASE + 0x214)
#define DISP_REG_BLS_LUMINANCE_                   (DISP_BLS_BASE + 0x300)
#define DISP_REG_BLS_LUMINANCE_255                (DISP_BLS_BASE + 0x384)
#define DISP_REG_BLS_GAMMA_LUT_                   (DISP_BLS_BASE + 0x400)
#define DISP_REG_BLS_DITHER_0                     (DISP_BLS_BASE + 0xE00)
#define DISP_REG_BLS_DITHER_5                     (DISP_BLS_BASE + 0xE14)
#define DISP_REG_BLS_DITHER_6                     (DISP_BLS_BASE + 0xE18)
#define DISP_REG_BLS_DITHER_7                     (DISP_BLS_BASE + 0xE1C)
#define DISP_REG_BLS_DITHER_8                     (DISP_BLS_BASE + 0xE20)
#define DISP_REG_BLS_DITHER_9                     (DISP_BLS_BASE + 0xE24)
#define DISP_REG_BLS_DITHER_10                    (DISP_BLS_BASE + 0xE28)
#define DISP_REG_BLS_DITHER_11                    (DISP_BLS_BASE + 0xE2C)
#define DISP_REG_BLS_DITHER_12                    (DISP_BLS_BASE + 0xE30)
#define DISP_REG_BLS_DITHER_13                    (DISP_BLS_BASE + 0xE34)
#define DISP_REG_BLS_DITHER_14                    (DISP_BLS_BASE + 0xE38)
#define DISP_REG_BLS_DITHER_15                    (DISP_BLS_BASE + 0xE3C)
#define DISP_REG_BLS_DITHER_16                    (DISP_BLS_BASE + 0xE40)
#define DISP_REG_BLS_DITHER_17                    (DISP_BLS_BASE + 0xE44)
#define DISP_REG_BLS_DUMMY                        (DISP_BLS_BASE + 0xF00)

#define DISP_REG_BLS_HIS_BIN(X)                   (DISP_REG_BLS_HIS_BIN_   + (4 * (X)))
#define DISP_REG_BLS_LUMINANCE(X)                 (DISP_REG_BLS_LUMINANCE_ + (4 * (X)))
#define DISP_REG_BLS_GAMMA_LUT(X)                 (DISP_REG_BLS_GAMMA_LUT_ + (4 * (X)))
#define DISP_REG_BLS_DITHER(X)                    (DISP_REG_BLS_DITHER_0   + (4 * (X)))

#endif

