/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2008
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/

#ifndef __MT_DISP_DRV_H__
#define __MT_DISP_DRV_H__

#include <platform/mt_typedefs.h>
#include <platform/disp_drv.h>
#include "lcm_drv.h"

#ifdef __cplusplus
extern "C" {
#endif

// ---------------------------------------------------------------------------
//  UBoot Display Utility Macros
// ---------------------------------------------------------------------------

#if 0
#define AS_UINT32(x)    (*(unsigned int *)(x))
#define AS_UINT16(x)    (*(unsigned short *)(x))
#else
#define AS_UINT32(x)  INREG32(x)
#define AS_UINT16(x)  INREG16(x)
#endif


#define MT_DISP_DBG 1

#if MT_DISP_DBG

#ifndef ASSERT
#define ASSERT(expr)                                                    \
    do {                                                                \
        if(!(expr)) {                                                   \
    		printf("<ASSERT> %s:line %d %s\n",                          \
    		    __FILE__,__LINE__,(int)(#expr));                        \
    		while (1);                                                  \
        }                                                               \
    } while(0);
#endif

#ifndef NOT_IMPLEMENTED
#define NOT_IMPLEMENTED()                                               \
    do {                                                                \
        printf("<NOT_IMPLEMENTED> %s:line %d\n", __FILE__, __LINE__);   \
        while (1);                                                      \
    } while(0);
#endif

#else   // !MT_DISP_DBG

    #define ASSERT(expr)
    #define NOT_IMPLEMENTED()

#endif  // end of MT_DISP_DBG

// ---------------------------------------------------------------------------

#define NOT_REFERENCED(x) {(x) = (x);}

// ---------------------------------------------------------------------------
typedef enum {
   DISP_VERTICAL_PROG_BAR = 0,
   DISP_HORIZONTAL_PROG_BAR,
} DISP_PROG_BAR_DIRECT;



   

// ---------------------------------------------------------------------------
//  UBoot Display Export Functions
// ---------------------------------------------------------------------------

UINT32 mt_disp_get_vram_size(void);
void   mt_disp_init(void *lcdbase);
void   mt_disp_power(BOOL on);
void   mt_disp_update(UINT32 x, UINT32 y, UINT32 width, UINT32 height);
void   mt_disp_wait_idle(void);
UINT32 mt_disp_get_lcd_time(void);

BOOL DISP_DetectDevice(void);

// -- Utility Functions for Customization --

void*  mt_get_logo_db_addr(void);
void*  mt_get_fb_addr(void);
void*  mt_get_tempfb_addr(void);
UINT32 mt_get_fb_size(void);

void mt_disp_fill_rect(UINT32 left, UINT32 top,
                           UINT32 right, UINT32 bottom,
                           UINT32 color);

void mt_disp_draw_prog_bar(DISP_PROG_BAR_DIRECT direct,
                               UINT32 left, UINT32 top,
                               UINT32 right, UINT32 bottom,
                               UINT32 fgColor, UINT32 bgColor,
                               UINT32 start_div, UINT32 total_div,
                               UINT32 occupied_div);

#ifdef __cplusplus
}
#endif

#endif // __MT_DISP_DRV_H__