#ifndef _DDP_REG_H_
#define _DDP_REG_H_

#include "mt_reg_base.h"

//TDODO: get base reg addr from system header
#define DISPSYS_CONFIG_BASE     DISPSYS_BASE		
#define DISPSYS_OVL_BASE        OVL_BASE				
#define DISPSYS_WDMA0_BASE      WDMA0_BASE			
#define DISPSYS_RDMA0_BASE      RDMA0_BASE			
#define DISPSYS_BLS_BASE        BLS_BASE				
#define DISPSYS_COLOR_BASE      COLOR_BASE			
#define DISPSYS_DBI_BASE        LCD_BASE				
#define DISPSYS_DPI_BASE        DPI_BASE				
#define DISPSYS_DSI_BASE        DSI_BASE				
#define DISPSYS_MUTEX_BASE      DISP_MUTEX_BASE	
#define DISPSYS_CMDQ_BASE       DISP_CMDQ_BASE

 
// ---------------------------------------------------------------------------
//  Register Field Access
// ---------------------------------------------------------------------------

#define REG_FLD(width, shift) \
    ((unsigned int)((((width) & 0xFF) << 16) | ((shift) & 0xFF)))

#define REG_FLD_WIDTH(field) \
    ((unsigned int)(((field) >> 16) & 0xFF))

#define REG_FLD_SHIFT(field) \
    ((unsigned int)((field) & 0xFF))

#define REG_FLD_MASK(field) \
    (((unsigned int)(1 << REG_FLD_WIDTH(field)) - 1) << REG_FLD_SHIFT(field))

#define REG_FLD_VAL(field, val) \
    (((val) << REG_FLD_SHIFT(field)) & REG_FLD_MASK(field))

#define REG_FLD_GET(field, reg32) \
    (((reg32) & REG_FLD_MASK(field)) >> REG_FLD_SHIFT(field))

#define REG_FLD_SET(field, reg32, val)                  \
    do {                                                \
        (reg32) = (((reg32) & ~REG_FLD_MASK(field)) |   \
                   REG_FLD_VAL((field), (val)));        \
    } while (0)
    
#define DISP_REG_GET(reg32) (*(volatile unsigned int*)(reg32))
#define DISP_REG_SET(reg32, val) (*(volatile unsigned int*)(reg32) = val)

#define DISP_REG_GET_FIELD(field, reg32) \
    do{                           \
          ((*(volatile unsigned int*)(reg32) & REG_FLD_MASK(field)) >> REG_FLD_SHIFT(field)) \
      } while(0)

#define DISP_REG_SET_FIELD(field, reg32, val)  \
    do {                                \
           *(volatile unsigned int*)(reg32) = ((*(volatile unsigned int*)(reg32) & ~REG_FLD_MASK(field)) |  REG_FLD_VAL((field), (val)));  \
    } while (0)

//-----------------------------------------------------------------
// CMDQ
#define CMDQ_THREAD_NUM 7
#define DISP_REG_CMDQ_IRQ_FLAG                         (DISPSYS_CMDQ_BASE + 0x10)
#define DISP_REG_CMDQ_LOADED_THR                       (DISPSYS_CMDQ_BASE + 0x20)
#define DISP_REG_CMDQ_THR_SLOT_CYCLES                  (DISPSYS_CMDQ_BASE + 0x30)
#define DISP_REG_CMDQ_BUS_CTRL                         (DISPSYS_CMDQ_BASE + 0x40)
#define DISP_REG_CMDQ_ABORT                            (DISPSYS_CMDQ_BASE + 0x50)
#define DISP_REG_CMDQ_THRx_RESET(idx)                  (DISPSYS_CMDQ_BASE + 0x100 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_EN(idx)                     (DISPSYS_CMDQ_BASE + 0x104 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_SUSPEND(idx)                (DISPSYS_CMDQ_BASE + 0x108 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_STATUS(idx)                 (DISPSYS_CMDQ_BASE + 0x10c + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_IRQ_FLAG(idx)               (DISPSYS_CMDQ_BASE + 0x110 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_IRQ_FLAG_EN(idx)            (DISPSYS_CMDQ_BASE + 0x114 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_SECURITY(idx)               (DISPSYS_CMDQ_BASE + 0x118 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_PC(idx)                     (DISPSYS_CMDQ_BASE + 0x120 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_END_ADDR(idx)               (DISPSYS_CMDQ_BASE + 0x124 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_EXEC_CMDS_CNT(idx)          (DISPSYS_CMDQ_BASE + 0x128 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_WAIT_EVENTS0(idx)           (DISPSYS_CMDQ_BASE + 0x130 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_WAIT_EVENTS1(idx)           (DISPSYS_CMDQ_BASE + 0x134 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_OBSERVED_EVENTS0(idx)       (DISPSYS_CMDQ_BASE + 0x140 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_OBSERVED_EVENTS1(idx)       (DISPSYS_CMDQ_BASE + 0x144 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_OBSERVED_EVENTS0_CLR(idx)   (DISPSYS_CMDQ_BASE + 0x148 + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_OBSERVED_EVENTS1_CLR(idx)   (DISPSYS_CMDQ_BASE + 0x14c + 0x80*idx)   
#define DISP_REG_CMDQ_THRx_INSTN_TIMEOUT_CYCLES(idx)   (DISPSYS_CMDQ_BASE + 0x150 + 0x80*idx) 

//-----------------------------------------------------------------
// Config
#define DISP_REG_CONFIG_RDMA_MOUT_EN    (DISPSYS_CONFIG_BASE + 0x020)
#define DISP_REG_CONFIG_RSZ0_MOUT_EN    (DISPSYS_CONFIG_BASE + 0x024)
#define DISP_REG_CONFIG_RSZ1_MOUT_EN    (DISPSYS_CONFIG_BASE + 0x028)
#define DISP_REG_CONFIG_TDSHP_MOUT_EN    (DISPSYS_CONFIG_BASE + 0x02C)
#define DISP_REG_CONFIG_OVL_MOUT_EN      (DISPSYS_CONFIG_BASE + 0x030)
#define DISP_REG_CONFIG_MOUT_RST         (DISPSYS_CONFIG_BASE + 0x034)
#define DISP_REG_CONFIG_RSZ0_SEL    (DISPSYS_CONFIG_BASE + 0x038)
#define DISP_REG_CONFIG_RSZ1_SEL    (DISPSYS_CONFIG_BASE + 0x03C)
#define DISP_REG_CONFIG_TDSHP_SEL        (DISPSYS_CONFIG_BASE + 0x040)
#define DISP_REG_CONFIG_WROT_SEL        (DISPSYS_CONFIG_BASE + 0x044)
#define DISP_REG_CONFIG_WDMA0_SEL        (DISPSYS_CONFIG_BASE + 0x048)
#define DISP_REG_CONFIG_DISP_OUT_SEL    (DISPSYS_CONFIG_BASE + 0x04C)
#define DISP_REG_CONFIG_RDMA0_OUT_SEL    (DISPSYS_CONFIG_BASE + 0x050)
#define DISP_REG_CONFIG_COLOR_SEL        (DISPSYS_CONFIG_BASE + 0x054)
#define DISP_REG_CONFIG_DSI_SEL         (DISPSYS_CONFIG_BASE + 0x058)
#define DISP_REG_CONFIG_DPI0_SEL         (DISPSYS_CONFIG_BASE + 0x05C)
#define DISP_REG_CONFIG_CG_CON0          (DISPSYS_CONFIG_BASE + 0x100)
#define DISP_REG_CONFIG_CG_SET0          (DISPSYS_CONFIG_BASE + 0x104)
#define DISP_REG_CONFIG_CG_CLR0          (DISPSYS_CONFIG_BASE + 0x108)
#define DISP_REG_CONFIG_CG_CON1          (DISPSYS_CONFIG_BASE + 0x110)
#define DISP_REG_CONFIG_CG_SET1          (DISPSYS_CONFIG_BASE + 0x114)
#define DISP_REG_CONFIG_CG_CLR1          (DISPSYS_CONFIG_BASE + 0x118)
#define DISP_REG_CONFIG_HW_DCM_EN0       (DISPSYS_CONFIG_BASE + 0x120)
#define DISP_REG_CONFIG_HW_DCM_EN_SET0   (DISPSYS_CONFIG_BASE + 0x124)
#define DISP_REG_CONFIG_HW_DCM_EN_CLR0   (DISPSYS_CONFIG_BASE + 0x128)
#define DISP_REG_CONFIG_HW_DCM_EN1       (DISPSYS_CONFIG_BASE + 0x12C)
#define DISP_REG_CONFIG_HW_DCM_EN_SET1   (DISPSYS_CONFIG_BASE + 0x130)
#define DISP_REG_CONFIG_HW_DCM_EN_CLR1   (DISPSYS_CONFIG_BASE + 0x134)
#define DISP_REG_CONFIG_MMSYS_SW_RST_B   (DISPSYS_CONFIG_BASE + 0x138)
#define DISP_REG_CONFIG_MBIST_DONE0      (DISPSYS_CONFIG_BASE + 0x800)
#define DISP_REG_CONFIG_MBIST_FAIL0      (DISPSYS_CONFIG_BASE + 0x804)
#define DISP_REG_CONFIG_MBIST_FAIL1      (DISPSYS_CONFIG_BASE + 0x808)
#define DISP_REG_CONFIG_MBIST_HOLDB0     (DISPSYS_CONFIG_BASE + 0x80C)
#define DISP_REG_CONFIG_MBIST_MODE0      (DISPSYS_CONFIG_BASE + 0x810)
#define DISP_REG_CONFIG_MBIST_BSEL0      (DISPSYS_CONFIG_BASE + 0x814)
#define DISP_REG_CONFIG_MBIST_BSEL1      (DISPSYS_CONFIG_BASE + 0x818)
#define DISP_REG_CONFIG_MBIST_BSEL2      (DISPSYS_CONFIG_BASE + 0x81C)
#define DISP_REG_CONFIG_MBIST_CON        (DISPSYS_CONFIG_BASE + 0x820)
#define DISP_REG_CONFIG_MEM_DELSEL0        (DISPSYS_CONFIG_BASE + 0x824)
#define DISP_REG_CONFIG_MEM_DELSEL1        (DISPSYS_CONFIG_BASE + 0x828)
#define DISP_REG_CONFIG_MEM_DELSEL2        (DISPSYS_CONFIG_BASE + 0x82C)
#define DISP_REG_CONFIG_MEM_DELSEL3        (DISPSYS_CONFIG_BASE + 0x830)
#define DISP_REG_CONFIG_MEM_DELSEL4        (DISPSYS_CONFIG_BASE + 0x834)
#define DISP_REG_CONFIG_MEM_DELSEL5        (DISPSYS_CONFIG_BASE + 0x838)
#define DISP_REG_CONFIG_MEM_DELSEL6        (DISPSYS_CONFIG_BASE + 0x83C)
#define DISP_REG_CONFIG_DEBUG_OUT_SEL    (DISPSYS_CONFIG_BASE + 0x840)
#define DISP_REG_CONFIG_DUMMY            (DISPSYS_CONFIG_BASE + 0x844)
#define DISP_REG_CONFIG_MROT_MBISR_RESET            (DISPSYS_CONFIG_BASE + 0x850)
#define DISP_REG_CONFIG_MROT_MBISR_FAIL            (DISPSYS_CONFIG_BASE + 0x854)
#define DISP_REG_CONFIG_MROT_MBISR_OK            (DISPSYS_CONFIG_BASE + 0x858)
#define DISP_REG_CONFIG_DL_VALID0            (DISPSYS_CONFIG_BASE + 0x860)
#define DISP_REG_CONFIG_DL_VALID1            (DISPSYS_CONFIG_BASE + 0x864)
#define DISP_REG_CONFIG_DL_READY0            (DISPSYS_CONFIG_BASE + 0x868)
#define DISP_REG_CONFIG_DL_READY1            (DISPSYS_CONFIG_BASE + 0x86C)
 
//-----------------------------------------------------------------
// MUTEX
#define DISP_REG_CONFIG_MUTEX_INTEN      (DISPSYS_MUTEX_BASE + 0x0)
#define DISP_REG_CONFIG_MUTEX_INTSTA     (DISPSYS_MUTEX_BASE + 0x4)
#define DISP_REG_CONFIG_REG_UPD_TIMEOUT  (DISPSYS_MUTEX_BASE + 0x8)
#define DISP_REG_CONFIG_REG_COMMIT       (DISPSYS_MUTEX_BASE + 0xC)
#define DISP_REG_CONFIG_MUTEX_EN(n)      (DISPSYS_MUTEX_BASE + 0x20 + (0x20 * n))
#define DISP_REG_CONFIG_MUTEX(n)         (DISPSYS_MUTEX_BASE + 0x24 + (0x20 * n))
#define DISP_REG_CONFIG_MUTEX_RST(n)     (DISPSYS_MUTEX_BASE + 0x28 + (0x20 * n))
#define DISP_REG_CONFIG_MUTEX_MOD(n)     (DISPSYS_MUTEX_BASE + 0x2C + (0x20 * n))
#define DISP_REG_CONFIG_MUTEX_SOF(n)     (DISPSYS_MUTEX_BASE + 0x30 + (0x20 * n))                                        
#define DISP_REG_CONFIG_MUTEX0_EN        (DISPSYS_MUTEX_BASE + 0x20)    
#define DISP_REG_CONFIG_MUTEX0           (DISPSYS_MUTEX_BASE + 0x24)
#define DISP_REG_CONFIG_MUTEX0_RST       (DISPSYS_MUTEX_BASE + 0x28)
#define DISP_REG_CONFIG_MUTEX0_MOD       (DISPSYS_MUTEX_BASE + 0x2C)
#define DISP_REG_CONFIG_MUTEX0_SOF       (DISPSYS_MUTEX_BASE + 0x30)
#define DISP_REG_CONFIG_MUTEX1_EN        (DISPSYS_MUTEX_BASE + 0x40)
#define DISP_REG_CONFIG_MUTEX1           (DISPSYS_MUTEX_BASE + 0x44)
#define DISP_REG_CONFIG_MUTEX1_RST       (DISPSYS_MUTEX_BASE + 0x48)
#define DISP_REG_CONFIG_MUTEX1_MOD       (DISPSYS_MUTEX_BASE + 0x4C)
#define DISP_REG_CONFIG_MUTEX1_SOF       (DISPSYS_MUTEX_BASE + 0x50)
#define DISP_REG_CONFIG_MUTEX2_EN        (DISPSYS_MUTEX_BASE + 0x60)
#define DISP_REG_CONFIG_MUTEX2           (DISPSYS_MUTEX_BASE + 0x64)
#define DISP_REG_CONFIG_MUTEX2_RST       (DISPSYS_MUTEX_BASE + 0x68)
#define DISP_REG_CONFIG_MUTEX2_MOD       (DISPSYS_MUTEX_BASE + 0x6C)
#define DISP_REG_CONFIG_MUTEX2_SOF       (DISPSYS_MUTEX_BASE + 0x70)
#define DISP_REG_CONFIG_MUTEX3_EN        (DISPSYS_MUTEX_BASE + 0x80)
#define DISP_REG_CONFIG_MUTEX3           (DISPSYS_MUTEX_BASE + 0x84)
#define DISP_REG_CONFIG_MUTEX3_RST       (DISPSYS_MUTEX_BASE + 0x88)
#define DISP_REG_CONFIG_MUTEX3_MOD       (DISPSYS_MUTEX_BASE + 0x8C)
#define DISP_REG_CONFIG_MUTEX3_SOF       (DISPSYS_MUTEX_BASE + 0x90)
#define DISP_REG_CONFIG_MUTEX4_EN        (DISPSYS_MUTEX_BASE + 0xA0)
#define DISP_REG_CONFIG_MUTEX4           (DISPSYS_MUTEX_BASE + 0xA4)
#define DISP_REG_CONFIG_MUTEX4_RST       (DISPSYS_MUTEX_BASE + 0xA8)
#define DISP_REG_CONFIG_MUTEX4_MOD       (DISPSYS_MUTEX_BASE + 0xAC)
#define DISP_REG_CONFIG_MUTEX4_SOF       (DISPSYS_MUTEX_BASE + 0xB0)
#define DISP_REG_CONFIG_MUTEX5_EN        (DISPSYS_MUTEX_BASE + 0xC0)
#define DISP_REG_CONFIG_MUTEX5           (DISPSYS_MUTEX_BASE + 0xC4)
#define DISP_REG_CONFIG_MUTEX5_RST       (DISPSYS_MUTEX_BASE + 0xC8)
#define DISP_REG_CONFIG_MUTEX5_MOD       (DISPSYS_MUTEX_BASE + 0xCC)
#define DISP_REG_CONFIG_MUTEX5_SOF       (DISPSYS_MUTEX_BASE + 0xD0)
#define DISP_REG_CONFIG_MUTEX6_EN            (DISPSYS_MUTEX_BASE + 0xE0)
#define DISP_REG_CONFIG_MUTEX6               (DISPSYS_MUTEX_BASE + 0xE4)
#define DISP_REG_CONFIG_MUTEX6_RST                      (DISPSYS_MUTEX_BASE + 0xE8)
#define DISP_REG_CONFIG_MUTEX6_MOD                      (DISPSYS_MUTEX_BASE + 0xEC)
#define DISP_REG_CONFIG_MUTEX6_SOF                      (DISPSYS_MUTEX_BASE + 0xF0)
#define DISP_REG_CONFIG_MUTEX7_EN            (DISPSYS_MUTEX_BASE + 0x100)
#define DISP_REG_CONFIG_MUTEX7               (DISPSYS_MUTEX_BASE + 0x104)
#define DISP_REG_CONFIG_MUTEX7_RST                      (DISPSYS_MUTEX_BASE + 0x108)
#define DISP_REG_CONFIG_MUTEX7_MOD                      (DISPSYS_MUTEX_BASE + 0x10C)
#define DISP_REG_CONFIG_MUTEX7_SOF                      (DISPSYS_MUTEX_BASE + 0x110)
#define DISP_REG_CONFIG_MUTEX_DEBUG_OUT_SEL   (DISPSYS_MUTEX_BASE + 0x200)  

//-----------------------------------------------------------------
// OVL
#define DISP_REG_OVL_STA                         (DISPSYS_OVL_BASE + 0x0000)
#define DISP_REG_OVL_INTEN                       (DISPSYS_OVL_BASE + 0x0004)
#define DISP_REG_OVL_INTSTA                      (DISPSYS_OVL_BASE + 0x0008)
#define DISP_REG_OVL_EN                          (DISPSYS_OVL_BASE + 0x000C)
#define DISP_REG_OVL_TRIG                        (DISPSYS_OVL_BASE + 0x0010)
#define DISP_REG_OVL_RST                         (DISPSYS_OVL_BASE + 0x0014)
#define DISP_REG_OVL_ROI_SIZE                    (DISPSYS_OVL_BASE + 0x0020)
#define DISP_REG_OVL_DATAPATH_CON                (DISPSYS_OVL_BASE + 0x0024)
#define DISP_REG_OVL_ROI_BGCLR                   (DISPSYS_OVL_BASE + 0x0028)
#define DISP_REG_OVL_SRC_CON                     (DISPSYS_OVL_BASE + 0x002C)
#define DISP_REG_OVL_L0_CON                      (DISPSYS_OVL_BASE + 0x0030)
#define DISP_REG_OVL_L0_SRCKEY                   (DISPSYS_OVL_BASE + 0x0034)
#define DISP_REG_OVL_L0_SRC_SIZE                 (DISPSYS_OVL_BASE + 0x0038)
#define DISP_REG_OVL_L0_OFFSET                   (DISPSYS_OVL_BASE + 0x003C)
#define DISP_REG_OVL_L0_ADDR                     (DISPSYS_OVL_BASE + 0x0040)
#define DISP_REG_OVL_L0_PITCH                    (DISPSYS_OVL_BASE + 0x0044)
#define DISP_REG_OVL_L1_CON                      (DISPSYS_OVL_BASE + 0x0050)
#define DISP_REG_OVL_L1_SRCKEY                   (DISPSYS_OVL_BASE + 0x0054)
#define DISP_REG_OVL_L1_SRC_SIZE                 (DISPSYS_OVL_BASE + 0x0058)
#define DISP_REG_OVL_L1_OFFSET                   (DISPSYS_OVL_BASE + 0x005C)
#define DISP_REG_OVL_L1_ADDR                     (DISPSYS_OVL_BASE + 0x0060)
#define DISP_REG_OVL_L1_PITCH                    (DISPSYS_OVL_BASE + 0x0064)
#define DISP_REG_OVL_L2_CON                      (DISPSYS_OVL_BASE + 0x0070)
#define DISP_REG_OVL_L2_SRCKEY                   (DISPSYS_OVL_BASE + 0x0074)
#define DISP_REG_OVL_L2_SRC_SIZE                 (DISPSYS_OVL_BASE + 0x0078)
#define DISP_REG_OVL_L2_OFFSET                   (DISPSYS_OVL_BASE + 0x007C)
#define DISP_REG_OVL_L2_ADDR                     (DISPSYS_OVL_BASE + 0x0080)
#define DISP_REG_OVL_L2_PITCH                    (DISPSYS_OVL_BASE + 0x0084)
#define DISP_REG_OVL_L3_CON                      (DISPSYS_OVL_BASE + 0x0090)
#define DISP_REG_OVL_L3_SRCKEY                   (DISPSYS_OVL_BASE + 0x0094)
#define DISP_REG_OVL_L3_SRC_SIZE                 (DISPSYS_OVL_BASE + 0x0098)
#define DISP_REG_OVL_L3_OFFSET                   (DISPSYS_OVL_BASE + 0x009C)
#define DISP_REG_OVL_L3_ADDR                     (DISPSYS_OVL_BASE + 0x00A0)
#define DISP_REG_OVL_L3_PITCH                    (DISPSYS_OVL_BASE + 0x00A4)
#define DISP_REG_OVL_RDMA0_CTRL                  (DISPSYS_OVL_BASE + 0x00C0)
#define DISP_REG_OVL_RDMA0_MEM_START_TRIG        (DISPSYS_OVL_BASE + 0x00C4)
#define DISP_REG_OVL_RDMA0_MEM_GMC_SETTING       (DISPSYS_OVL_BASE + 0x00C8)
#define DISP_REG_OVL_RDMA0_MEM_SLOW_CON          (DISPSYS_OVL_BASE + 0x00CC)
#define DISP_REG_OVL_RDMA0_FIFO_CTRL             (DISPSYS_OVL_BASE + 0x00D0)
#define DISP_REG_OVL_RDMA1_CTRL                  (DISPSYS_OVL_BASE + 0x00E0)
#define DISP_REG_OVL_RDMA1_MEM_START_TRIG        (DISPSYS_OVL_BASE + 0x00E4)
#define DISP_REG_OVL_RDMA1_MEM_GMC_SETTING       (DISPSYS_OVL_BASE + 0x00E8)
#define DISP_REG_OVL_RDMA1_MEM_SLOW_CON          (DISPSYS_OVL_BASE + 0x00EC)
#define DISP_REG_OVL_RDMA1_FIFO_CTRL             (DISPSYS_OVL_BASE + 0x00F0)
#define DISP_REG_OVL_RDMA2_CTRL                  (DISPSYS_OVL_BASE + 0x0100)
#define DISP_REG_OVL_RDMA2_MEM_START_TRIG        (DISPSYS_OVL_BASE + 0x0104)
#define DISP_REG_OVL_RDMA2_MEM_GMC_SETTING       (DISPSYS_OVL_BASE + 0x0108)
#define DISP_REG_OVL_RDMA2_MEM_SLOW_CON          (DISPSYS_OVL_BASE + 0x010C)
#define DISP_REG_OVL_RDMA2_FIFO_CTRL             (DISPSYS_OVL_BASE + 0x0110)
#define DISP_REG_OVL_RDMA3_CTRL                  (DISPSYS_OVL_BASE + 0x0120)
#define DISP_REG_OVL_RDMA3_MEM_START_TRIG        (DISPSYS_OVL_BASE + 0x0124)
#define DISP_REG_OVL_RDMA3_MEM_GMC_SETTING       (DISPSYS_OVL_BASE + 0x0128)
#define DISP_REG_OVL_RDMA3_MEM_SLOW_CON          (DISPSYS_OVL_BASE + 0x012C)
#define DISP_REG_OVL_RDMA3_FIFO_CTRL             (DISPSYS_OVL_BASE + 0x0130)
#define DISP_REG_OVL_L0_Y2R_PARA_R0              (DISPSYS_OVL_BASE + 0x0134)
#define DISP_REG_OVL_L0_Y2R_PARA_R1              (DISPSYS_OVL_BASE + 0x0138)
#define DISP_REG_OVL_L0_Y2R_PARA_G0              (DISPSYS_OVL_BASE + 0x013C)
#define DISP_REG_OVL_L0_Y2R_PARA_G1              (DISPSYS_OVL_BASE + 0x0140)
#define DISP_REG_OVL_L0_Y2R_PARA_B0              (DISPSYS_OVL_BASE + 0x0144)
#define DISP_REG_OVL_L0_Y2R_PARA_B1              (DISPSYS_OVL_BASE + 0x0148)
#define DISP_REG_OVL_L0_Y2R_PARA_YUV_A_0         (DISPSYS_OVL_BASE + 0x014C)
#define DISP_REG_OVL_L0_Y2R_PARA_YUV_A_1         (DISPSYS_OVL_BASE + 0x0150)
#define DISP_REG_OVL_L0_Y2R_PARA_RGB_A_0         (DISPSYS_OVL_BASE + 0x0154)
#define DISP_REG_OVL_L0_Y2R_PARA_RGB_A_1         (DISPSYS_OVL_BASE + 0x0158)
#define DISP_REG_OVL_L1_Y2R_PARA_R0              (DISPSYS_OVL_BASE + 0x015C)
#define DISP_REG_OVL_L1_Y2R_PARA_R1              (DISPSYS_OVL_BASE + 0x0160)
#define DISP_REG_OVL_L1_Y2R_PARA_G0              (DISPSYS_OVL_BASE + 0x0164)
#define DISP_REG_OVL_L1_Y2R_PARA_G1              (DISPSYS_OVL_BASE + 0x0168)
#define DISP_REG_OVL_L1_Y2R_PARA_B0              (DISPSYS_OVL_BASE + 0x016C)
#define DISP_REG_OVL_L1_Y2R_PARA_B1              (DISPSYS_OVL_BASE + 0x0170)
#define DISP_REG_OVL_L1_Y2R_PARA_YUV_A_0         (DISPSYS_OVL_BASE + 0x0174)
#define DISP_REG_OVL_L1_Y2R_PARA_YUV_A_1         (DISPSYS_OVL_BASE + 0x0178)
#define DISP_REG_OVL_L1_Y2R_PARA_RGB_A_0         (DISPSYS_OVL_BASE + 0x017C)
#define DISP_REG_OVL_L1_Y2R_PARA_RGB_A_1         (DISPSYS_OVL_BASE + 0x0180)
#define DISP_REG_OVL_L2_Y2R_PARA_R0              (DISPSYS_OVL_BASE + 0x0184)
#define DISP_REG_OVL_L2_Y2R_PARA_R1              (DISPSYS_OVL_BASE + 0x0188)
#define DISP_REG_OVL_L2_Y2R_PARA_G0              (DISPSYS_OVL_BASE + 0x018C)
#define DISP_REG_OVL_L2_Y2R_PARA_G1              (DISPSYS_OVL_BASE + 0x0190)
#define DISP_REG_OVL_L2_Y2R_PARA_B0              (DISPSYS_OVL_BASE + 0x0194)
#define DISP_REG_OVL_L2_Y2R_PARA_B1              (DISPSYS_OVL_BASE + 0x0198)
#define DISP_REG_OVL_L2_Y2R_PARA_YUV_A_0         (DISPSYS_OVL_BASE + 0x019C)
#define DISP_REG_OVL_L2_Y2R_PARA_YUV_A_1         (DISPSYS_OVL_BASE + 0x01A0)
#define DISP_REG_OVL_L2_Y2R_PARA_RGB_A_0         (DISPSYS_OVL_BASE + 0x01A4)
#define DISP_REG_OVL_L2_Y2R_PARA_RGB_A_1         (DISPSYS_OVL_BASE + 0x01A8)
#define DISP_REG_OVL_L3_Y2R_PARA_R0              (DISPSYS_OVL_BASE + 0x01AC)
#define DISP_REG_OVL_L3_Y2R_PARA_R1              (DISPSYS_OVL_BASE + 0x01B0)
#define DISP_REG_OVL_L3_Y2R_PARA_G0              (DISPSYS_OVL_BASE + 0x01B4)
#define DISP_REG_OVL_L3_Y2R_PARA_G1              (DISPSYS_OVL_BASE + 0x01B8)
#define DISP_REG_OVL_L3_Y2R_PARA_B0              (DISPSYS_OVL_BASE + 0x01BC)
#define DISP_REG_OVL_L3_Y2R_PARA_B1              (DISPSYS_OVL_BASE + 0x01C0)
#define DISP_REG_OVL_L3_Y2R_PARA_YUV_A_0         (DISPSYS_OVL_BASE + 0x01C4)
#define DISP_REG_OVL_L3_Y2R_PARA_YUV_A_1         (DISPSYS_OVL_BASE + 0x01C8)
#define DISP_REG_OVL_L3_Y2R_PARA_RGB_A_0         (DISPSYS_OVL_BASE + 0x01CC)
#define DISP_REG_OVL_L3_Y2R_PARA_RGB_A_1         (DISPSYS_OVL_BASE + 0x01D0)
#define DISP_REG_OVL_DEBUG_MON_SEL               (DISPSYS_OVL_BASE + 0x01D4)
#define DISP_REG_OVL_RDMA0_MEM_GMC_SETTING2      (DISPSYS_OVL_BASE + 0x01E0)
#define DISP_REG_OVL_RDMA1_MEM_GMC_SETTING2      (DISPSYS_OVL_BASE + 0x01E4)
#define DISP_REG_OVL_RDMA2_MEM_GMC_SETTING2      (DISPSYS_OVL_BASE + 0x01E8)
#define DISP_REG_OVL_RDMA3_MEM_GMC_SETTING2      (DISPSYS_OVL_BASE + 0x01EC)
#define DISP_REG_OVL_DUMMY                       (DISPSYS_OVL_BASE + 0x0200)
#define DISP_REG_OVL_FLOW_CTRL_DBG               (DISPSYS_OVL_BASE + 0x0240)
#define DISP_REG_OVL_ADDCON_DBG                  (DISPSYS_OVL_BASE + 0x0244)
#define DISP_REG_OVL_OUTMUX_DBG                  (DISPSYS_OVL_BASE + 0x0248)
#define DISP_REG_OVL_RDMA0_DBG                   (DISPSYS_OVL_BASE + 0x024C)
#define DISP_REG_OVL_RDMA1_DBG                   (DISPSYS_OVL_BASE + 0x0250)
#define DISP_REG_OVL_RDMA2_DBG                   (DISPSYS_OVL_BASE + 0x0254)
#define DISP_REG_OVL_RDMA3_DBG                   (DISPSYS_OVL_BASE + 0x0258)


//-----------------------------------------------------------------
// RDMA
#define DISP_REG_RDMA_INT_ENABLE          (DISPSYS_RDMA0_BASE + 0x0000)
#define DISP_REG_RDMA_INT_STATUS          (DISPSYS_RDMA0_BASE + 0x0004)
#define DISP_REG_RDMA_GLOBAL_CON          (DISPSYS_RDMA0_BASE + 0x0010)
#define DISP_REG_RDMA_SIZE_CON_0          (DISPSYS_RDMA0_BASE + 0x0014)
#define DISP_REG_RDMA_SIZE_CON_1          (DISPSYS_RDMA0_BASE + 0x0018)
#define DISP_REG_RDMA_TARGET_LINE         (DISPSYS_RDMA0_BASE + 0x001C)
#define DISP_REG_RDMA_MEM_CON             (DISPSYS_RDMA0_BASE + 0x0024)
#define DISP_REG_RDMA_MEM_START_ADDR      (DISPSYS_RDMA0_BASE + 0x0028)
#define DISP_REG_RDMA_MEM_SRC_PITCH       (DISPSYS_RDMA0_BASE + 0x002C)
#define DISP_REG_RDMA_MEM_GMC_SETTING_0   (DISPSYS_RDMA0_BASE + 0x0030)
#define DISP_REG_RDMA_MEM_SLOW_CON        (DISPSYS_RDMA0_BASE + 0x0034)
#define DISP_REG_RDMA_MEM_GMC_SETTING_1   (DISPSYS_RDMA0_BASE + 0x0038)
#define DISP_REG_RDMA_FIFO_CON            (DISPSYS_RDMA0_BASE + 0x0040)
#define DISP_REG_RDMA_CF_00               (DISPSYS_RDMA0_BASE + 0x0054)
#define DISP_REG_RDMA_CF_01               (DISPSYS_RDMA0_BASE + 0x0058)
#define DISP_REG_RDMA_CF_02               (DISPSYS_RDMA0_BASE + 0x005C)
#define DISP_REG_RDMA_CF_10               (DISPSYS_RDMA0_BASE + 0x0060)
#define DISP_REG_RDMA_CF_11               (DISPSYS_RDMA0_BASE + 0x0064)
#define DISP_REG_RDMA_CF_12               (DISPSYS_RDMA0_BASE + 0x0068)
#define DISP_REG_RDMA_CF_20               (DISPSYS_RDMA0_BASE + 0x006C)
#define DISP_REG_RDMA_CF_21               (DISPSYS_RDMA0_BASE + 0x0070)
#define DISP_REG_RDMA_CF_22               (DISPSYS_RDMA0_BASE + 0x0074)
#define DISP_REG_RDMA_CF_PRE_ADD0         (DISPSYS_RDMA0_BASE + 0x0078)
#define DISP_REG_RDMA_CF_PRE_ADD1         (DISPSYS_RDMA0_BASE + 0x007C)
#define DISP_REG_RDMA_CF_PRE_ADD2         (DISPSYS_RDMA0_BASE + 0x0080)
#define DISP_REG_RDMA_CF_POST_ADD0        (DISPSYS_RDMA0_BASE + 0x0084)
#define DISP_REG_RDMA_CF_POST_ADD1        (DISPSYS_RDMA0_BASE + 0x0088)
#define DISP_REG_RDMA_CF_POST_ADD2        (DISPSYS_RDMA0_BASE + 0x008C)
#define DISP_REG_RDMA_DUMMY               (DISPSYS_RDMA0_BASE + 0x0090)
#define DISP_REG_RDMA_DEBUG_OUT_SEL       (DISPSYS_RDMA0_BASE + 0x0094)

 //-----------------------------------------------------------------
// WDMA
#define DISP_REG_WDMA_INTEN                   (DISPSYS_WDMA0_BASE + 0x0000)
#define DISP_REG_WDMA_INTSTA                  (DISPSYS_WDMA0_BASE + 0x0004)
#define DISP_REG_WDMA_EN                      (DISPSYS_WDMA0_BASE + 0x0008)
#define DISP_REG_WDMA_RST                     (DISPSYS_WDMA0_BASE + 0x000C)
#define DISP_REG_WDMA_SMI_CON                 (DISPSYS_WDMA0_BASE + 0x0010)
#define DISP_REG_WDMA_CFG                     (DISPSYS_WDMA0_BASE + 0x0014)
#define DISP_REG_WDMA_SRC_SIZE                (DISPSYS_WDMA0_BASE + 0x0018)
#define DISP_REG_WDMA_CLIP_SIZE               (DISPSYS_WDMA0_BASE + 0x001C)
#define DISP_REG_WDMA_CLIP_COORD              (DISPSYS_WDMA0_BASE + 0x0020)
#define DISP_REG_WDMA_DST_ADDR                (DISPSYS_WDMA0_BASE + 0x0024)
#define DISP_REG_WDMA_DST_W_IN_BYTE           (DISPSYS_WDMA0_BASE + 0x0028)
#define DISP_REG_WDMA_ALPHA                   (DISPSYS_WDMA0_BASE + 0x002C)
#define DISP_REG_WDMA_BUF_ADDR                (DISPSYS_WDMA0_BASE + 0x0030)
#define DISP_REG_WDMA_STA                     (DISPSYS_WDMA0_BASE + 0x0034)
#define DISP_REG_WDMA_BUF_CON1                (DISPSYS_WDMA0_BASE + 0x0038)
#define DISP_REG_WDMA_BUF_CON2                (DISPSYS_WDMA0_BASE + 0x003C)
#define DISP_REG_WDMA_C00                     (DISPSYS_WDMA0_BASE + 0x0040)
#define DISP_REG_WDMA_C02                     (DISPSYS_WDMA0_BASE + 0x0044)
#define DISP_REG_WDMA_C10                     (DISPSYS_WDMA0_BASE + 0x0048)
#define DISP_REG_WDMA_C12                     (DISPSYS_WDMA0_BASE + 0x004C)
#define DISP_REG_WDMA_C20                     (DISPSYS_WDMA0_BASE + 0x0050)
#define DISP_REG_WDMA_C22                     (DISPSYS_WDMA0_BASE + 0x0054)
#define DISP_REG_WDMA_PRE_ADD0                (DISPSYS_WDMA0_BASE + 0x0058)
#define DISP_REG_WDMA_PRE_ADD2                (DISPSYS_WDMA0_BASE + 0x005C)
#define DISP_REG_WDMA_POST_ADD0               (DISPSYS_WDMA0_BASE + 0x0060)
#define DISP_REG_WDMA_POST_ADD2               (DISPSYS_WDMA0_BASE + 0x0064)
#define DISP_REG_WDMA_DST_U_ADDR              (DISPSYS_WDMA0_BASE + 0x0070)
#define DISP_REG_WDMA_DST_V_ADDR              (DISPSYS_WDMA0_BASE + 0x0074)
#define DISP_REG_WDMA_DST_UV_PITCH            (DISPSYS_WDMA0_BASE + 0x0078)
#define DISP_REG_WDMA_DITHER_CON              (DISPSYS_WDMA0_BASE + 0x0090)
#define DISP_REG_WDMA_FLOW_CTRL_DBG           (DISPSYS_WDMA0_BASE + 0x00A0)
#define DISP_REG_WDMA_EXEC_DBG                (DISPSYS_WDMA0_BASE + 0x00A4)
#define DISP_REG_WDMA_CLIP_DBG                (DISPSYS_WDMA0_BASE + 0x00A8)

//-----------------------------------------------------------------
// CMDQ
#define DISP_INT_MUTEX_BIT_MASK     0x00000002

//-----------------------------------------------------------------
// COLOR
#define DISP_REG_COLOR_CFG_MAIN                     (DISPSYS_COLOR_BASE + 0x0400)
#define DISP_REG_COLOR_PXL_CNT_MAIN                    (DISPSYS_COLOR_BASE + 0x0404)
#define DISP_REG_COLOR_LINE_CNT_MAIN                  (DISPSYS_COLOR_BASE + 0x0408)
#define DISP_REG_COLOR_WIN_X_MAIN                 (DISPSYS_COLOR_BASE + 0x040C)
#define DISP_REG_COLOR_WIN_Y_MAIN                 (DISPSYS_COLOR_BASE + 0x0410)
#define DISP_REG_COLOR_TIMING_DETECTION_0                  (DISPSYS_COLOR_BASE + 0x0418)
#define DISP_REG_COLOR_TIMING_DETECTION_1                 (DISPSYS_COLOR_BASE + 0x041C)
#define DISP_REG_COLOR_DBG_CFG_MAIN                 (DISPSYS_COLOR_BASE + 0x0420)
#define DISP_REG_COLOR_C_BOOST_MAIN                  (DISPSYS_COLOR_BASE + 0x0428)
#define DISP_REG_COLOR_C_BOOST_MAIN_2                 (DISPSYS_COLOR_BASE + 0x042C)
#define DISP_REG_COLOR_LUMA_ADJ                 (DISPSYS_COLOR_BASE + 0x0430)
#define DISP_REG_COLOR_G_PIC_ADJ_MAIN_1                    (DISPSYS_COLOR_BASE + 0x0434)
#define DISP_REG_COLOR_G_PIC_ADJ_MAIN_2                  (DISPSYS_COLOR_BASE + 0x0438)
#define DISP_REG_COLOR_Y_FTN_1_0_MAIN                 (DISPSYS_COLOR_BASE + 0x0440)
#define DISP_REG_COLOR_Y_FTN_3_2_MAIN                    (DISPSYS_COLOR_BASE + 0x0444)
#define DISP_REG_COLOR_Y_FTN_5_4_MAIN                  (DISPSYS_COLOR_BASE + 0x0448)
#define DISP_REG_COLOR_Y_FTN_7_6_MAIN                 (DISPSYS_COLOR_BASE + 0x044C)
#define DISP_REG_COLOR_Y_FTN_9_8_MAIN                 (DISPSYS_COLOR_BASE + 0x0450)
#define DISP_REG_COLOR_Y_FTN_11_10_MAIN                    (DISPSYS_COLOR_BASE + 0x0454)
#define DISP_REG_COLOR_Y_FTN_13_12_MAIN                  (DISPSYS_COLOR_BASE + 0x0458)
#define DISP_REG_COLOR_Y_FTN_15_14_MAIN                 (DISPSYS_COLOR_BASE + 0x045C)
#define DISP_REG_COLOR_Y_FTN_17_16_MAIN                 (DISPSYS_COLOR_BASE + 0x0460)
#define DISP_REG_COLOR_POS_MAIN                    (DISPSYS_COLOR_BASE + 0x0484)
#define DISP_REG_COLOR_INK_DATA_MAIN                  (DISPSYS_COLOR_BASE + 0x0488)
#define DISP_REG_COLOR_INK_DATA_MAIN_CR                 (DISPSYS_COLOR_BASE + 0x048C)
#define DISP_REG_COLOR_CAP_IN_DATA_MAIN                 (DISPSYS_COLOR_BASE + 0x0490)
#define DISP_REG_COLOR_CAP_IN_DATA_MAIN_CR                    (DISPSYS_COLOR_BASE + 0x0494)
#define DISP_REG_COLOR_CAP_OUT_DATA_MAIN                  (DISPSYS_COLOR_BASE + 0x0498)
#define DISP_REG_COLOR_CAP_OUT_DATA_MAIN_CR                 (DISPSYS_COLOR_BASE + 0x049C)
#define DISP_REG_COLOR_LUMA_HIST_00                 (DISPSYS_COLOR_BASE + 0x0520)
#define DISP_REG_COLOR_LUMA_HIST_01                    (DISPSYS_COLOR_BASE + 0x0524)
#define DISP_REG_COLOR_LUMA_HIST_02                  (DISPSYS_COLOR_BASE + 0x0528)
#define DISP_REG_COLOR_LUMA_HIST_03                 (DISPSYS_COLOR_BASE + 0x052C)
#define DISP_REG_COLOR_LUMA_HIST_04                 (DISPSYS_COLOR_BASE + 0x0530)
#define DISP_REG_COLOR_LUMA_HIST_05                    (DISPSYS_COLOR_BASE + 0x0534)
#define DISP_REG_COLOR_LUMA_HIST_06                  (DISPSYS_COLOR_BASE + 0x0538)
#define DISP_REG_COLOR_LUMA_HIST_07                 (DISPSYS_COLOR_BASE + 0x053C)
#define DISP_REG_COLOR_LUMA_HIST_08                 (DISPSYS_COLOR_BASE + 0x0540)
#define DISP_REG_COLOR_LUMA_HIST_09                    (DISPSYS_COLOR_BASE + 0x0544)
#define DISP_REG_COLOR_LUMA_HIST_10                  (DISPSYS_COLOR_BASE + 0x0548)
#define DISP_REG_COLOR_LUMA_HIST_11                 (DISPSYS_COLOR_BASE + 0x054C)
#define DISP_REG_COLOR_LUMA_HIST_12                 (DISPSYS_COLOR_BASE + 0x0550)
#define DISP_REG_COLOR_LUMA_HIST_13                    (DISPSYS_COLOR_BASE + 0x0554)
#define DISP_REG_COLOR_LUMA_HIST_14                  (DISPSYS_COLOR_BASE + 0x0558)
#define DISP_REG_COLOR_LUMA_HIST_15                 (DISPSYS_COLOR_BASE + 0x055C)
#define DISP_REG_COLOR_LUMA_HIST_16                 (DISPSYS_COLOR_BASE + 0x0560)
#define DISP_REG_COLOR_LUMA_SUM                    (DISPSYS_COLOR_BASE + 0x05A4)
#define DISP_REG_COLOR_LUMA_MIN_MAX                  (DISPSYS_COLOR_BASE + 0x05A8)
#define DISP_REG_COLOR_LOCAL_HUE_CD_0                 (DISPSYS_COLOR_BASE + 0x0620)
#define DISP_REG_COLOR_LOCAL_HUE_CD_1                    (DISPSYS_COLOR_BASE + 0x0624)
#define DISP_REG_COLOR_LOCAL_HUE_CD_2                  (DISPSYS_COLOR_BASE + 0x0628)
#define DISP_REG_COLOR_LOCAL_HUE_CD_3                 (DISPSYS_COLOR_BASE + 0x062C)
#define DISP_REG_COLOR_LOCAL_HUE_CD_4                 (DISPSYS_COLOR_BASE + 0x0630)
#define DISP_REG_COLOR_TWO_D_WINDOW_1                 (DISPSYS_COLOR_BASE + 0x0740)
#define DISP_REG_COLOR_TWO_D_W1_RESULT                 (DISPSYS_COLOR_BASE + 0x074C)
#define DISP_REG_COLOR_SAT_HIST_X_CFG_MAIN                 (DISPSYS_COLOR_BASE + 0x0768)
#define DISP_REG_COLOR_SAT_HIST_Y_CFG_MAIN                 (DISPSYS_COLOR_BASE + 0x076C)
#define DISP_REG_COLOR_CRC(n)               (DISPSYS_COLOR_BASE + 0x07E0 + (4 * n))
#define DISP_REG_COLOR_PARTIAL_SAT_GAIN1(n)               (DISPSYS_COLOR_BASE + 0x07FC + (4 * n))
#define DISP_REG_COLOR_PARTIAL_SAT_GAIN2(n)               (DISPSYS_COLOR_BASE + 0x0810 + (4 * n))
#define DISP_REG_COLOR_PARTIAL_SAT_GAIN3(n)               (DISPSYS_COLOR_BASE + 0x0824 + (4 * n))
#define DISP_REG_COLOR_PARTIAL_SAT_POINT1(n)               (DISPSYS_COLOR_BASE + 0x0838 + (4 * n))
#define DISP_REG_COLOR_PARTIAL_SAT_POINT2(n)               (DISPSYS_COLOR_BASE + 0x084C + (4 * n))
#define DISP_REG_COLOR_START                 (DISPSYS_COLOR_BASE + 0x0F00)
#define DISP_REG_COLOR_INTEN                 (DISPSYS_COLOR_BASE + 0x0F04)
#define DISP_REG_COLOR_INTSTA                 (DISPSYS_COLOR_BASE + 0x0F08)
#define DISP_REG_COLOR_OUT_SEL                 (DISPSYS_COLOR_BASE + 0x0F0C)
#define DISP_REG_COLOR_FRAME_DONE_DEL                 (DISPSYS_COLOR_BASE + 0x0F10)
#define DISP_REG_COLOR_CRC_EN                 (DISPSYS_COLOR_BASE + 0x0F14)
#define DISP_REG_COLOR_SW_SCRATCH                 (DISPSYS_COLOR_BASE + 0x0F18)
#define DISP_REG_COLOR_RDY_SEL                 (DISPSYS_COLOR_BASE + 0x0F20)
#define DISP_REG_COLOR_RDY_SEL_EN                 (DISPSYS_COLOR_BASE + 0x0F24)
#define DISP_REG_COLOR_CK_ON                 (DISPSYS_COLOR_BASE + 0x0F28)
#define DISP_REG_COLOR_INTERNAL_IP_WIDTH                 (DISPSYS_COLOR_BASE + 0x0F50)
#define DISP_REG_COLOR_INTERNAL_IP_HEIGHT                 (DISPSYS_COLOR_BASE + 0x0F54)
#define DISP_REG_COLOR_CM1_EN                 (DISPSYS_COLOR_BASE + 0x0F60)
#define DISP_REG_COLOR_CM2_EN                 (DISPSYS_COLOR_BASE + 0x0FA0)
#define DISP_REG_COLOR_R0_CRC                 (DISPSYS_COLOR_BASE + 0x0FF0)

//-----------------------------------------------------------------
// BLS
#define DISP_REG_BLS_EN                     (DISPSYS_BLS_BASE + 0x0000)
#define DISP_REG_BLS_RST                    (DISPSYS_BLS_BASE + 0x0004)
#define DISP_REG_BLS_INTEN                  (DISPSYS_BLS_BASE + 0x0008)
#define DISP_REG_BLS_INTSTA                 (DISPSYS_BLS_BASE + 0x000C)
#define DISP_REG_BLS_SETTING                 (DISPSYS_BLS_BASE + 0x0010)
#define DISP_REG_BLS_FANA_SETTING                 (DISPSYS_BLS_BASE + 0x0014)
#define DISP_REG_BLS_SRC_SIZE               (DISPSYS_BLS_BASE + 0x0018)
#define DISP_REG_BLS_GAIN_SETTING               (DISPSYS_BLS_BASE + 0x0020)
#define DISP_REG_BLS_MANUAL_GAIN               (DISPSYS_BLS_BASE + 0x0024)
#define DISP_REG_BLS_MANUAL_MAXCLR               (DISPSYS_BLS_BASE + 0x0028)
#define DISP_REG_BLS_GAMMA_SETTING               (DISPSYS_BLS_BASE + 0x0030)
#define DISP_REG_BLS_GAMMA_BOUND               (DISPSYS_BLS_BASE + 0x0034)
#define DISP_REG_BLS_LUT_UPDATE               (DISPSYS_BLS_BASE + 0x0038)
#define DISP_REG_BLS_MAXCLR_THD               (DISPSYS_BLS_BASE + 0x0060)
#define DISP_REG_BLS_DISTPT_THD               (DISPSYS_BLS_BASE + 0x0064)
#define DISP_REG_BLS_MAXCLR_LIMIT               (DISPSYS_BLS_BASE + 0x0068)
#define DISP_REG_BLS_DISTPT_LIMIT               (DISPSYS_BLS_BASE + 0x006C)
#define DISP_REG_BLS_AVE_SETTING               (DISPSYS_BLS_BASE + 0x0070)
#define DISP_REG_BLS_AVE_LIMIT               (DISPSYS_BLS_BASE + 0x0074)
#define DISP_REG_BLS_DISTPT_SETTING               (DISPSYS_BLS_BASE + 0x0078)
#define DISP_REG_BLS_HIS_CLEAR               (DISPSYS_BLS_BASE + 0x007C)
#define DISP_REG_BLS_SC_DIFF_THD               (DISPSYS_BLS_BASE + 0x0080)
#define DISP_REG_BLS_SC_BIN_THD               (DISPSYS_BLS_BASE + 0x0084)
#define DISP_REG_BLS_MAXCLR_GRADUAL               (DISPSYS_BLS_BASE + 0x0088)
#define DISP_REG_BLS_DISTPT_GRADUAL               (DISPSYS_BLS_BASE + 0x008C)
#define DISP_REG_BLS_FAST_IIR_XCOEFF               (DISPSYS_BLS_BASE + 0x0090)
#define DISP_REG_BLS_FAST_IIR_YCOEFF               (DISPSYS_BLS_BASE + 0x0094)
#define DISP_REG_BLS_SLOW_IIR_XCOEFF               (DISPSYS_BLS_BASE + 0x0098)
#define DISP_REG_BLS_SLOW_IIR_YCOEFF               (DISPSYS_BLS_BASE + 0x009C)
#define DISP_REG_BLS_PWM_DUTY               (DISPSYS_BLS_BASE + 0x00A0)
#define DISP_REG_BLS_PWM_GRADUAL               (DISPSYS_BLS_BASE + 0x00A4)
#define DISP_REG_BLS_PWM_CON               (DISPSYS_BLS_BASE + 0x00A8)
#define DISP_REG_BLS_PWM_MANUAL               (DISPSYS_BLS_BASE + 0x00AC)
#define DISP_REG_BLS_DEBUG               (DISPSYS_BLS_BASE + 0x00B0)
#define DISP_REG_BLS_PATTERN               (DISPSYS_BLS_BASE + 0x00B4)
#define DISP_REG_BLS_CHKSUM               (DISPSYS_BLS_BASE + 0x00B8)
#define DISP_REG_BLS_HIS_BIN(n)               (DISPSYS_BLS_BASE + 0x0100 + (4 * n))
#define DISP_REG_BLS_PWM_DUTY_RD               (DISPSYS_BLS_BASE + 0x0200)
#define DISP_REG_BLS_FRAME_AVE_RD               (DISPSYS_BLS_BASE + 0x0204)
#define DISP_REG_BLS_MAXCLR_RD               (DISPSYS_BLS_BASE + 0x0208)
#define DISP_REG_BLS_DISTPT_RD               (DISPSYS_BLS_BASE + 0x020C)
#define DISP_REG_BLS_GAIN_RD               (DISPSYS_BLS_BASE + 0x0210)
#define DISP_REG_BLS_SC_RD               (DISPSYS_BLS_BASE + 0x0214)
#define DISP_REG_BLS_LUMINANCE(n)               (DISPSYS_BLS_BASE + 0x0300 + (4 * n))
#define DISP_REG_BLS_LUMINANCE_255               (DISPSYS_BLS_BASE + 0x0384)
#define DISP_REG_BLS_GAMMA_LUT(n)               (DISPSYS_BLS_BASE + 0x0400 + (4 * n))
#define DISP_REG_BLS_DITHER_0               (DISPSYS_BLS_BASE + 0x0E00)
#define DISP_REG_BLS_DITHER_5               (DISPSYS_BLS_BASE + 0x0E14)
#define DISP_REG_BLS_DITHER_6               (DISPSYS_BLS_BASE + 0x0E18)
#define DISP_REG_BLS_DITHER_7               (DISPSYS_BLS_BASE + 0x0E1C)
#define DISP_REG_BLS_DITHER_8               (DISPSYS_BLS_BASE + 0x0E20)
#define DISP_REG_BLS_DITHER_9               (DISPSYS_BLS_BASE + 0x0E24)
#define DISP_REG_BLS_DITHER_10               (DISPSYS_BLS_BASE + 0x0E28)
#define DISP_REG_BLS_DITHER_11               (DISPSYS_BLS_BASE + 0x0E2C)
#define DISP_REG_BLS_DITHER_12               (DISPSYS_BLS_BASE + 0x0E30)
#define DISP_REG_BLS_DITHER_13               (DISPSYS_BLS_BASE + 0x0E34)
#define DISP_REG_BLS_DITHER_14               (DISPSYS_BLS_BASE + 0x0E38)
#define DISP_REG_BLS_DITHER_15               (DISPSYS_BLS_BASE + 0x0E3C)
#define DISP_REG_BLS_DITHER_16               (DISPSYS_BLS_BASE + 0x0E40)
#define DISP_REG_BLS_DITHER_17               (DISPSYS_BLS_BASE + 0x0E44)
#define DISP_REG_BLS_DUMMY               (DISPSYS_BLS_BASE + 0x0F00)

//-----------------------------------------------------------------
// DPI
#define DISP_REG_DPI_EN                     (DISPSYS_DPI_BASE + 0x0000)
#define DISP_REG_DPI_RST                    (DISPSYS_DPI_BASE + 0x0004)
#define DISP_REG_DPI_INTEN                  (DISPSYS_DPI_BASE + 0x0008)
#define DISP_REG_DPI_INTSTA                 (DISPSYS_DPI_BASE + 0x000C)
#define DISP_REG_DPI_CON               (DISPSYS_DPI_BASE + 0x0010)
#define DISP_REG_DPI_OUTPUT_SETTING               (DISPSYS_DPI_BASE + 0x0014)
#define DISP_REG_DPI_SIZE          (DISPSYS_DPI_BASE + 0x0018)
#define DISP_REG_DPI_TGEN_HWIDTH                (DISPSYS_DPI_BASE + 0x0020)
#define DISP_REG_DPI_TGEN_HPROCH             (DISPSYS_DPI_BASE + 0x0024)
#define DISP_REG_DPI_TGEN_VWIDTH             (DISPSYS_DPI_BASE + 0x0028)
#define DISP_REG_DPI_TGEN_VPROCH             (DISPSYS_DPI_BASE + 0x002C)
#define DISP_REG_DPI_BG_HCNTL             (DISPSYS_DPI_BASE + 0x0030)
#define DISP_REG_DPI_BG_VCNTL             (DISPSYS_DPI_BASE + 0x0034)
#define DISP_REG_DPI_BG_COLOR             (DISPSYS_DPI_BASE + 0x0038)
#define DISP_REG_DPI_FIFO_CTL               (DISPSYS_DPI_BASE + 0x003C)
#define DISP_REG_DPI_STATUS             (DISPSYS_DPI_BASE + 0x0040)
#define DISP_REG_DPI_TMODE                 (DISPSYS_DPI_BASE + 0x0044)
#define DISP_REG_DPI_CHKSUM           (DISPSYS_DPI_BASE + 0x0048)
#define DISP_REG_DPI_PATTERN           (DISPSYS_DPI_BASE + 0x004C)

#endif

