#ifndef CASHBOXBUILDCONFIG_H
#define CASHBOXBUILDCONFIG_H

#include <QDir>
#include <QStandardPaths>
#include <QLocale>

#if defined DEBUG_HOST
#   define CASHBOX_DATA_PATH QDir::fromNativeSeparators(QStringLiteral("%1/SK1/").arg(QStandardPaths::writableLocation(QStandardPaths::GenericDataLocation)))
#elif defined RELEASE_UNIT
#   define CASHBOX_DATA_PATH "/opt/sk1/var/"
#endif

#define CASHBOX_BUILD_DT QLocale("en").toDateTime(QString("%1 %2").arg(__DATE__, __TIME__).simplified(), "MMM d yyyy hh:mm:ss")
#define CASHBOX_APP_VERSION QStringLiteral("0.0.3")
#define CASHBOX_APP_VERSION_CODE 3


#ifdef CASHBOX_SERVICE
#   define APPNAME "unitcore"
#   define ORGANISATION_NAME "Armax"
#   define ORGANISATION_DOMAIN "armax.ru"
#endif

#define DEFAULT_SERIAL_LENGTH       12


#define DEFAULT_AMOUNT_MULT                 100u
#define DEFAULT_QUANTITY_MULT               1000u
#define DEFAULT_AMOUNT_DEC                 2u
#define DEFAULT_QUANTITY_DEC               3u


#define UMKASERVER_HOST_URL "umka365.ru"
#define UMKASERVER_PORT	443
#define UMKASERVER_SCHEME "HTTPS"

#define CASHBOX_MODEL                   2011
#define CASHBOX_MODEL_NAME              "СК-1"
#define CASHBOX_SRV_MODEL               77
#define CASHBOX_VERSION                {QLatin1Char('0'),QLatin1Char('1'),QLatin1Char('2')}


#define DEBUG_BUILD_VERSION         0

#define ALWAYS_SEND_ADDRESS_AND_PLACE_IN_RECEIPT

//BUILTING MENU
#define ENABLE_SELF_APK_UPDATE_MENU                 1

//FULL CLEARING
#define FULL_CLEAR_AUTH_DEALER_ID  3


#endif //CASHBOXBUILDCONFIG_H
