#include "cashboxserviceapi.h"
#include "cashboxbuildconfig.h"


#include <QElapsedTimer>
#include <QCoreApplication>
#include <QEventLoop>
#include <QTimer>


CashboxServiceApi::CashboxServiceApi(QObject *parent) noexcept
    : QObject(parent)
    , queue_(new ProcessingQueue)
{

}

CashboxServiceApi::~CashboxServiceApi()
{
    delete queue_;
}

bool CashboxServiceApi::isReady() const
{
    return true;
}

CoreApiResult CashboxServiceApi::loadCashierNames()
{
    CoreTransaction t;
    t.setOperation(CoreTransaction::Operation::GET_CASHIER_NAMES);
    t.genUid();
    return exec(t);
}

CoreApiResult CashboxServiceApi::exec(CoreTransaction transaction)
{
    if(transaction.uid().trimmed().isEmpty()) transaction.genUid();
    QEventLoop loop;
    auto resultWaiter = [&loop] () ->void {
        QTimer::singleShot(5, &loop, SLOT(quit()));
    };
    bool savedToQueue =  queue_->enqueue(transaction, resultWaiter);
    //    lmWarning() << savedToQueue;
    CoreApiResult res;
    if(savedToQueue)
    {
        loop.exec();
        res = queue_->takeResult(transaction.uid());
    }
    else
    {
        res = CoreApiResult(CoreApiConst::ErrorCode::InvalidTransactionType, tr("Дублирование ид транзакции"));
    }
//    blockSignals(true);
    return res;
}

CoreApiResult CashboxServiceApi::writeSerial(CoreTransaction trans)
{
    CoreApiResult res = exec(trans);
    if(res.isOk())
    {
        CashboxStatus st(res.data());
        initGlobalStatus(st);
        return res;
    }
    return res;
}

CoreApiResult CashboxServiceApi::loadCashboxStatus(bool toExternal)
{
    CoreTransaction trans;
    trans.setOperation(CoreTransaction::Operation::CASHBOX_STATUS);
    trans.setFormatToExternal(toExternal);
    trans.genUid();
    CoreApiResult res = exec(trans);

    CashboxStatus st(res.data());
    initGlobalStatus(st);
//    lmWarning() << logvariant(res.toMap());
    return res;
}

ModelData CashboxServiceApi::loadModelData(bool toExternal)
{
    CoreTransaction trans;
    trans.setOperation(CoreTransaction::Operation::GET_CASHBOX_MODELDATA);
    trans.setFormatToExternal(toExternal);
    trans.genUid();
    CoreApiResult res = exec(trans);

    CashboxStatus st(res.data());
//    lmWarning() << logvariant(res.toMap());
    return ModelData(res.data());
}

CoreApiResult CashboxServiceApi::loadReceiptData()
{
    CoreTransaction trans;
    trans.setOperation(CoreTransaction::Operation::GET_DATA_FOR_RECEIPT);
    trans.genUid();
    CoreApiResult res = exec(trans);
    initCatalogsData(res.data());
//    lmWarning() << logvariant(res.toMap());
    return res;
}




