#ifndef CASHBOXSERVICEAPI_H
#define CASHBOXSERVICEAPI_H

#include "coreapiconst.h"
#include "coretransaction.h"
#include "coreapiresult.h"
#include "cashboxstatus.h"
#include "processingqueue.h"

#include <QObject>
#include <QPointer>
#include <QMutex>


class CashboxServiceApi : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(CashboxServiceApi)
    friend class CashboxServiceConnection;
public:
    explicit CashboxServiceApi(QObject *parent = nullptr)noexcept;
    ~CashboxServiceApi() override;

    bool isReady() const;

    CoreApiResult loadCashierNames();
    CoreApiResult exec(CoreTransaction transaction);
    CoreApiResult writeSerial(CoreTransaction trans);

    CoreApiResult loadCashboxStatus(bool toExternal = false);
    ModelData loadModelData(bool toExternal = false);
    CoreApiResult loadReceiptData();

signals:
    void error(QString error);
protected:
    ProcessingQueue *queue_;


    virtual void initGlobalStatus(const CashboxStatus &status) = 0;
    virtual void initCatalogsData(const QVariantMap &data) = 0;
};

#endif // CASHBOXSERVICEAPI_H
