#include "cashboxserviceroot.h"
#include "appdirectories.h"
#include "cashboxbuildconfig.h"
#include "abstractworkerthread.h"
#include "frworkingthread.h"
#include "ofdworker.h"
#include "oismworker.h"
#include "httpcashboxserviceapi.h"
#include "apiconfigstore.h"
#include "internalobjectsorage.h"
#include "httpworkersfactory.h"


#include <QLocale>
#include <QTranslator>
#include <QTextCodec>
#include <QTimer>
#include <QStorageInfo>
#include <QCoreApplication>

CashboxServiceRoot* CashboxServiceRoot::_instance = nullptr;

int CashboxServiceRoot::start(int &argc, char *argv[])
{
    // std::system("echo 0 > /sys/class/leds/green/brightness");
    std::system("echo 0 > /sys/class/leds/red/brightness");
    CashboxServiceRoot root(argc, argv);
    int res = root.init() ? root.exec() : -1;
    root.stop();
    return res;
}

void CashboxServiceRoot::startHttp()
{
    stopHttp();
    ApiConfigStore st;
    ApiConfig cfg = st.apiConfig();
    if(!server_ && cfg.useHttpApi())
    {
        server_ = new QHttpServer(this);
        HttpWorkersFactory::initHttpServer(server_);
        auto port = server_->listen(QHostAddress::Any, cfg.httpPort());
        Q_UNUSED(port)
    }
}

void CashboxServiceRoot::stopHttp()
{
    if(server_)
    {
        server_->deleteLater();
        server_ = nullptr;
    }
}

void CashboxServiceRoot::startUdp()
{
    stopUdp();
    ApiConfigStore st;
    ApiConfig cfg = st.apiConfig();
    if(cfg.useUdp())
    {
        broadCastSocket_ = new QUdpSocket(this);
        connect(broadCastSocket_, SIGNAL(readyRead()), this, SLOT(processPendingDatagramm()));
        bool bindResult = broadCastSocket_->bind(cfg.udpPort(), QUdpSocket::ShareAddress);
        Q_UNUSED(bindResult)
    }
}

void CashboxServiceRoot::stopUdp()
{
    if(broadCastSocket_)
    {
        delete broadCastSocket_;
        broadCastSocket_ = nullptr;
    }
}


CashboxServiceRoot::CashboxServiceRoot(int &argc, char *argv[])
    : QObject(nullptr)
    , argc_(&argc)
    , argv_(argv)
    , server_(nullptr)
    , broadCastSocket_(nullptr)
    , coreWorker_(nullptr)
    , ofdWorker_(nullptr)
    , oismWorker_(nullptr)
{
    if (!_instance) _instance = this;
    Q_ASSERT(argc > 0 && argv);
}

CashboxServiceRoot::~CashboxServiceRoot()
{
    if(_instance == this) _instance = nullptr;
}



bool CashboxServiceRoot::createApplication()
{
    QCoreApplication *app = new QCoreApplication(*argc_, argv_);
    app->setApplicationName(APPNAME);
    app->setOrganizationName(ORGANISATION_NAME);
    app->setOrganizationDomain(ORGANISATION_DOMAIN);
    QTextCodec::setCodecForLocale(QTextCodec::codecForName("UTF-8"));
    return true;
}

bool CashboxServiceRoot::init()
{
    if(!createApplication()) return false;
    QTextCodec::setCodecForLocale(QTextCodec::codecForName("UTF-8"));
    return true;
}

int CashboxServiceRoot::exec()
{
    QTimer::singleShot(100, this, SLOT(startAfterExec()));
    int res =  qApp->exec();
    return res;
}

void CashboxServiceRoot::stop()
{
//    qrConfigMgr_->stopWatcher();
    stopHttp();
    stopUdp();
    stopThread(coreWorker_);
    stopThread(ofdWorker_);
    stopThread(oismWorker_);
}

void CashboxServiceRoot::stopThread(QPointer<QThread> &t)
{
    if(t)
    {
        t->quit();
    }
    QElapsedTimer tout;
    tout.start();
    while((t && !t->isFinished()) )
    {
        QCoreApplication::processEvents();
        if(tout.elapsed() > 30000 && t) t->terminate();
    }
}

void CashboxServiceRoot::startAfterExec()
{

    if(!coreWorker_)
    {
        FrWorkingThread *w = new FrWorkingThread();
        connect(w, &FrWorkingThread::sendToOfd, this, &CashboxServiceRoot::sendToOfd, Qt::QueuedConnection);
        AbstractWorkerThread * wt = new AbstractWorkerThread(w, this);
        connect(wt, &QThread::finished, wt, &QThread::deleteLater);
        coreWorker_ = wt;
        wt->start();
    }
    if(!ofdWorker_)
    {
        OfdWorker *w = new OfdWorker();
        connect(this, &CashboxServiceRoot::sendToOfd, w, &OfdWorker::send, Qt::QueuedConnection);
        AbstractWorkerThread * wt = new AbstractWorkerThread(w, this);
        connect(wt, &QThread::finished, wt, &QThread::deleteLater);
        ofdWorker_ = wt;
        wt->start();

    }
    if(!oismWorker_)
    {
        OismWorker *w = new OismWorker();
        connect(this, &CashboxServiceRoot::sendToOfd, w, &OismWorker::send, Qt::QueuedConnection);
        AbstractWorkerThread * wt = new AbstractWorkerThread(w, this);
        connect(wt, &QThread::finished, wt, &QThread::deleteLater);
        oismWorker_ = wt;
        wt->start();

    }
    startHttp();
    startUdp();
//https://medium.com/@vishtech36/installing-apps-programmatically-in-android-10-7e39cfe22b86
}

void CashboxServiceRoot::processPendingDatagramm()
{
    // while (broadCastSocket_ && broadCastSocket_->hasPendingDatagrams())
    {
        QByteArray datagram;
        datagram.resize(broadCastSocket_->pendingDatagramSize());
        QHostAddress peer;
        quint16 peerPort = 0;
        broadCastSocket_->readDatagram(datagram.data(), datagram.size(), &peer, &peerPort);
        QString text = QString::fromUtf8(datagram);

        if(text.trimmed().toLower().startsWith("searchcashbox012"))
        {
            QStringList sl = text.split("##");
            if(sl.size() > 1)
            {
                sendBroadCastAnswer(sl[1].trimmed());
            }
            else
            {
                sendBroadCastAnswer(broadCastSocket_->peerAddress().toString());
            }
        }
    }
}

void CashboxServiceRoot::sendBroadCastAnswer(const QString &addr)
{
    if(broadCastSocket_)
    {
        if(!IOSG::getModelData().isValid())
        {
            return;
        }
        QVariantMap content;
        QVariantMap obj;
        ApiConfigStore st;
        ApiConfig cfg = st.apiConfig();
        obj = IOSG::getModelData().toExternalMap();
        obj.insert("http", cfg.httpPort());
        content.insert("cashbox012autoconf", obj);
        broadCastSocket_->writeDatagram(QJsonDocument::fromVariant(content).toJson(QJsonDocument::Compact),
                                        addr.isEmpty()? QHostAddress(QHostAddress::Broadcast) : QHostAddress(addr),
                                        cfg.broadcastPort());
    }
}
