#ifndef CASHBOXSERVICEROOT_H
#define CASHBOXSERVICEROOT_H

#include <QObject>
#include <QPointer>

#include <QtHttpServer>
#include <QUdpSocket>

class CashboxServiceRoot : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(CashboxServiceRoot)
public:
    static int start(int &argc, char *argv[]);
    static CashboxServiceRoot* instance() {return _instance;}
signals:
    void sendToOfd();
public slots:
    void startHttp();
    void stopHttp();
    void startUdp();
    void stopUdp();
private:
    static CashboxServiceRoot* _instance;
    int * argc_;
    char ** argv_;
    QHttpServer *server_;
    QUdpSocket *broadCastSocket_;

    QPointer<QThread> coreWorker_;
    QPointer<QThread> ofdWorker_;
    QPointer<QThread> oismWorker_;
//    MerchantConfigManager *qrConfigMgr_;

    CashboxServiceRoot(int &argc, char *argv[]);
    virtual ~CashboxServiceRoot() override;

    bool createApplication();

    bool init();
    int exec();
    void stop();
    void stopThread(QPointer<QThread> &t);
private slots:
    void startAfterExec();
    void processPendingDatagramm();
    void sendBroadCastAnswer(const QString &addr);
};

#define serviceRoot CashboxServiceRoot::instance()

#endif // CASHBOXSERVICEROOT_H
