#include "apiconfig.h"

const QString ApiConfig::SECTION = "API_CONFIG";
const QString ApiConfig::OPTIONS = "options";
const QString ApiConfig::HTTP_PORT = "httpPort";
const QString ApiConfig::UDP_PORT = "udpPort";


ApiConfig::ApiConfig() noexcept
    : options_(UseHttpApi | UseUdp)
    , httpPort_(8088)
    , udpPort_(18093)
    , broadcastPort_(18095)
{

}

ApiConfig::ApiConfig(const ApiConfig &other) noexcept
    : options_(other.options_)
    , httpPort_(other.httpPort_)
    , udpPort_(other.udpPort_)
    , broadcastPort_(other.broadcastPort_)
{

}

ApiConfig::ApiConfig(ApiConfig &&other) noexcept
    : options_(other.options_)
    , httpPort_(other.httpPort_)
    , udpPort_(other.udpPort_)
    , broadcastPort_(other.broadcastPort_)
{

}

ApiConfig::ApiConfig(const QVariantMap &map) noexcept
    : options_(UseHttpApi | UseUdp)
    , httpPort_(8088)
    , udpPort_(18093)
    , broadcastPort_(18095)
{
    parseMap(map);
}

ApiConfig::~ApiConfig()
{

}

bool ApiConfig::useHttpApi() const
{
    return options_.testFlag(UseHttpApi) && httpPort_ > 0;
}

bool ApiConfig::useUdp() const
{
    return options_.testFlag(UseUdp) && udpPort_ > 0;
}

const ApiConfig::Options &ApiConfig::options() const
{
    return options_;
}

void ApiConfig::setOptions(const Options &newOptions)
{
    options_ = newOptions;
}

quint16 ApiConfig::httpPort() const
{
    return httpPort_;
}

void ApiConfig::setHttpPort(quint16 newHttpPort)
{
    httpPort_ = newHttpPort;
}

quint16 ApiConfig::udpPort() const
{
    return udpPort_;
}

void ApiConfig::setUdpPort(quint16 newUdpPort)
{
    udpPort_ = newUdpPort;
}

quint16 ApiConfig::broadcastPort() const
{
    return broadcastPort_;
}

void ApiConfig::setBroadcastPort(quint16 newBroadcastPort)
{
    broadcastPort_ = newBroadcastPort;
}
QStringList ApiConfig::fields() const
{
    return (QStringList() << OPTIONS << HTTP_PORT);
}

QVariantMap ApiConfig::toMap() const
{
    return QVariantMap {
                       {OPTIONS, static_cast<qint32>(options_)},
        {HTTP_PORT, httpPort_}
    };
}

void ApiConfig::parseMap(const QVariantMap &map)
{
    udpPort_ = 18093;
    broadcastPort_ = 18095;
    options_ = Options(map[OPTIONS].toInt());
    httpPort_ = static_cast<quint16>(map[HTTP_PORT].toInt());
}


QString ApiConfig::section() const
{
    return SECTION;
}

QMap<QString, QString> ApiConfig::toStringMap() const
{
    return QMap<QString, QString> {
        {OPTIONS, QString::number(static_cast<qint32>(options_))},
        {HTTP_PORT, QString::number(httpPort_)}
    };
}

void ApiConfig::parseStringMap(const QMap<QString, QString> &map)
{
    udpPort_ = 18093;
    broadcastPort_ = 18095;
    options_ = Options(map[OPTIONS].toInt());
    httpPort_ = static_cast<quint16>(map[HTTP_PORT].toInt());
}
