#ifndef APICONFIG_H
#define APICONFIG_H

#include "iserviceconfigdata.h"
#include <QVariantMap>
#include <QFlags>
#include <QStringList>

class ApiConfig : public IServiceConfigData
{
    static const QString SECTION;
    static const QString OPTIONS;
    static const QString HTTP_PORT;
    static const QString UDP_PORT;
public:

    enum Option
    {
        UseHttpApi                      = 0x00000001,
        UseUdp                          = 0x00000002,
    };
    Q_DECLARE_FLAGS(Options, Option)

    ApiConfig() noexcept;
    ApiConfig(const ApiConfig &other) noexcept;
    ApiConfig(ApiConfig &&other)noexcept;
    explicit ApiConfig(const QVariantMap &map) noexcept;
    ~ApiConfig();

    bool useHttpApi() const;
    bool useUdp() const;


    const Options &options() const;
    void setOptions(const Options &newOptions);

    quint16 httpPort() const;
    void setHttpPort(quint16 newHttpPort);

    quint16 udpPort() const;
    void setUdpPort(quint16 newUdpPort);

    quint16 broadcastPort() const;
    void setBroadcastPort(quint16 newBroadcastPort);

    QStringList fields()const override;
    QVariantMap toMap() const override;
    void parseMap(const QVariantMap &map) override;



private:
    Options options_;
    quint16 httpPort_;
    quint16 udpPort_;
    quint16 broadcastPort_;

    QString section() const override;
    QMap<QString, QString> toStringMap() const override;
    void parseStringMap(const QMap<QString, QString> &map) override;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(ApiConfig::Options)

#endif // APICONFIG_H
