#include "basecoreconfigdata.h"

#include "coreapiconst.h"

BaseCoreConfigData::~BaseCoreConfigData()
{

}

CoreTransaction BaseCoreConfigData::createTransactionForSave(const QString &login, const QString &password) const
{
    CoreTransaction res;
    res.setCashierLogin(login);
    res.setCashierPassword(password);
    res.setOperation(CoreTransaction::Operation::SAVE_CORE_SETTINGS);
    res.setParams(QVariantMap {
        {"section", section()},
        {"value", toMap()}

    });
    res.genUid();
    return res;
}

CoreTransaction BaseCoreConfigData::createTransactionForLoad(const QString &login, const QString &password) const
{
    CoreTransaction res;
    res.setCashierLogin(login);
    res.setCashierPassword(password);
    res.setOperation(CoreTransaction::Operation::LOAD_CORE_SETTINGS);
    res.setParams(QVariantMap {
        {"section", section()}
    });
    res.genUid();
    return res;
}

CoreApiResult BaseCoreConfigData::toSuccessResult() const
{
    return CoreApiResult(
                CoreApiConst::ErrorCode::Ok,
                QString(),
                QVariantMap {
                    {"section", section()},
                    {"value", toMap()}
                    }
                );
}

void BaseCoreConfigData::parseTransactionParams(const QVariantMap &params)
{
    if(params["section"] == "SECTION")
    {
        parseMap(params["value"].toMap());
    }
}

BaseCoreConfigData::BaseCoreConfigData()
    : IServiceConfigData()
{

}
