#ifndef BASECORECONFIGDATA_H
#define BASECORECONFIGDATA_H

#include "iserviceconfigdata.h"

#include "coretransaction.h"
#include "coreapiresult.h"

class BaseCoreConfigData :public IServiceConfigData
{
public:
    ~BaseCoreConfigData() override;
    virtual CoreTransaction createTransactionForSave(const QString &login, const QString &password) const;
    virtual CoreTransaction createTransactionForLoad(const QString &login, const QString &password) const;
    virtual CoreApiResult toSuccessResult() const;
    virtual void parseTransactionParams(const QVariantMap &params);
protected:
    BaseCoreConfigData();
};

#endif // BASECORECONFIGDATA_H
