#include "baseiniconfigstore.h"



BaseIniConfigStore::BaseIniConfigStore(const QString &fileName, QObject *parent)
    : QObject(parent)
    , storage_(new QSettings(fileName, QSettings::IniFormat, this))
{

}


BaseIniConfigStore::~BaseIniConfigStore()
{

}

void BaseIniConfigStore::load(IServiceConfigData *data) const
{
    if(data && storage_)
    {
        QStringList fields = data->fields();
        QVariantMap map = data->toMap();
        storage_->beginGroup(data->section());
        for(const QString &f :fields)
        {
            map[f] =  storage_->value(f, map[f]);
        }
        storage_->endGroup();
        data->parseMap(map);
    }
}

void BaseIniConfigStore::save(const IServiceConfigData *data)
{
    if(data && storage_)
    {
        QStringList fields = data->fields();
        QVariantMap map = data->toMap();
        storage_->beginGroup(data->section());
        for(const QString &f :fields)
        {
            storage_->setValue(f, map[f]);
        }
        storage_->endGroup();
    }
}

BaseIniConfigStore::BaseIniConfigStore(QSettings *storage, QObject *parent)
    : QObject(parent)
    , storage_(storage)
{

}

