#ifndef BASEINICONFIGSTORE_H
#define BASEINICONFIGSTORE_H

#include "iserviceconfigdata.h"

#include <QObject>
#include <QSettings>

class BaseIniConfigStore : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(BaseIniConfigStore)
public:
    explicit BaseIniConfigStore(const QString &fileName, QObject *parent = nullptr);
    ~BaseIniConfigStore() override;

    void load(IServiceConfigData *data) const;
    void save(const IServiceConfigData *data);

protected:
    QSettings *storage_;

    explicit BaseIniConfigStore(QSettings *storage, QObject *parent = nullptr);
};

#endif // BASEINICONFIGSTORE_H
