#include "cashiersstore.h"

#include "appdirectories.h"

CashiersStore::CashiersStore(QObject *parent)
    : QObject{parent}
    , store_(new QSettings(APATH.configDir() + "/cashiers.conf", QSettings::IniFormat, this))
{

}

CashiersStore::~CashiersStore()
{

}

Cashier CashiersStore::getCashier(qint32 id) const
{
    if(id < Cashier::SUPER_USER_ID || id > Cashier::MAX_CASHIERS_ID) return Cashier();
    if(id == Cashier::SUPER_USER_ID) return getSuCashier();
    store_->beginGroup(QStringLiteral("C%1").arg(id));
    Cashier c;
    c.setId(id);
    c.setInn(store_->value("inn", QString()).toString());
    c.setLogin(store_->value("login", QString()).toString());
    c.setName(store_->value("name", QString()).toString());
    c.setPassword(store_->value("password", QString()).toString());
    c.setPermissions(Cashier::Permissions(store_->value("permissions", 0u).toUInt()));
    c.setServerId(store_->value("serverId", -1).toLongLong());
    store_->endGroup();
    return c;
}

bool CashiersStore::saveCashier(Cashier &c)
{
    if(c.id() > Cashier::MAX_CASHIERS_ID) return false;
    else if(c.id() == Cashier::SUPER_USER_ID) return saveSuCashier(c);
    if(c.id() < Cashier::SUPER_USER_ID)
    {
        for(int i = Cashier::SUPER_USER_ID +1; i <= Cashier::MAX_CASHIERS_ID; ++i)
        {
            Cashier tmp = getCashier(i);
            if(!tmp.isValid() && tmp.login().isEmpty() && tmp.serverId() <= 0)
            {
                c.setId(i);
                break;
            }
        }
        if(c.id() < Cashier::SUPER_USER_ID) return false;
    }

    store_->beginGroup(QStringLiteral("C%1").arg(c.id()));
    store_->setValue("inn", c.inn());
    store_->setValue("login", c.login());
    store_->setValue("name", c.name());
    store_->setValue("permissions", static_cast<quint32>(c.permissions()));
    store_->setValue("password", c.password());
    store_->setValue("serverId", c.serverId());
    store_->endGroup();


    return true;
}

bool CashiersStore::removeCashier(qint32 id)
{
    if(id <= Cashier::SUPER_USER_ID || id > Cashier::MAX_CASHIERS_ID) return false;
    else
    {
        store_->beginGroup(QStringLiteral("C%1").arg(id));
        store_->setValue("inn", QString());
        store_->setValue("login", QString());
        store_->setValue("name", QString());
        store_->setValue("permissions", 0u);
        store_->setValue("password", QString());
        store_->setValue("serverId", -1);
        store_->endGroup();
    }
    return true;
}

QVariantList CashiersStore::getCashierNames() const
{
    QVariantList res;
    for(int i = Cashier::SUPER_USER_ID; i <= Cashier::MAX_CASHIERS_ID; ++i)
    {
        Cashier c = getCashier(i);
        if(c.isValid()) res << QVariantMap{{"login", c.login()}, {"name", c.name()}};
    }
    return res;
}

Cashier CashiersStore::getSuCashier() const
{
    store_->beginGroup("C1");
    Cashier c;
    c.setId(Cashier::SUPER_USER_ID);
    c.setInn(store_->value("inn", QString()).toString());
    c.setLogin("su");
    c.setName(store_->value("name", QString("СИС.АДМИН")).toString());
    c.setPassword(store_->value("password", "99").toString());
    c.setPermissions(Cashier::SU_PERMS);
    c.setServerId(store_->value("serverId", -1).toLongLong());
    store_->endGroup();
    return c;
}

bool CashiersStore::saveSuCashier(const Cashier &c)
{
    store_->beginGroup("C1");
    store_->setValue("inn", c.inn());
    // c.setLogin("su");
    store_->setValue("name", c.name());
    store_->setValue("password", c.password());
    store_->setValue("serverId", c.serverId());
    store_->endGroup();
    return true;
}
