#ifndef CASHIERSSTORE_H
#define CASHIERSSTORE_H

#include "cashier.h"

#include <QObject>
#include <QSettings>

class CashiersStore : public QObject
{
    Q_OBJECT
    Q_DISABLE_COPY(CashiersStore)
public:
    explicit CashiersStore(QObject *parent = nullptr);
    ~CashiersStore() override;

    Cashier getCashier(qint32 id) const;
    bool saveCashier(Cashier &c);
    bool removeCashier(qint32 id);
    QVariantList getCashierNames() const;


signals:
private:
    QSettings *store_;

    Cashier getSuCashier() const;
    bool saveSuCashier(const Cashier &c);



};

#endif // CASHIERSSTORE_H
