#include "coreconfigstore.h"
#include "appdirectories.h"


const QSet<QString> CoreConfigStore::SUPPORTED_SECTIONS = {
    ReceiptConfigData::SECTION
};

CoreConfigStore::CoreConfigStore(QObject *parent)
    : BaseIniConfigStore(APATH.configDir() + "/core.conf", parent)
    , receiptConfig_()
{
}

CoreConfigStore::~CoreConfigStore()
{

}

ReceiptConfigData CoreConfigStore::receiptConfig() const
{
    if(receiptConfig_.has_value()) return receiptConfig_.value();
    ReceiptConfigData res;
    load(&res);
    receiptConfig_ = res;
    return res;
}

void CoreConfigStore::setReceiptConfig(const ReceiptConfigData &rec)
{
    save(&rec);
    receiptConfig_ = rec;
}

OfdSettings CoreConfigStore::ofdConfig() const
{
    OfdSettings res;
    load(&res);
    return res;
}

void CoreConfigStore::setOfdConfig(const OfdSettings &rec)
{
     save(&rec);
}

CoreApiResult CoreConfigStore::processTransaction(const CoreTransaction &trans)
{
    switch (trans.operation()) {
    case CoreTransaction::Operation::LOAD_CORE_SETTINGS:
    {
        QString section = trans.params().value("section").toString();
        BaseCoreConfigData *res = createObject(section);
        if(!res) return CoreApiResult(CoreApiConst::ErrorCode::InvalidSettingsSection,
                                      tr("Указан некорректный раздел настроек: %1").arg(section));
        load(res);
        CoreApiResult ans = res->toSuccessResult();
        delete res;
        return ans;
    }break;
    case CoreTransaction::Operation::SAVE_CORE_SETTINGS:
    {
        BaseCoreConfigData *res = createObject(ReceiptConfigData::SECTION);
        if(!res) return CoreApiResult(CoreApiConst::ErrorCode::InvalidSettingsSection,
                                      tr("Указан некорректный раздел настроек: %1").arg(ReceiptConfigData::SECTION));
        res->parseTransactionParams(trans.params());
        save(res);
        load(res);
        CoreApiResult ans = res->toSuccessResult();
        delete res;
        resetObject(ReceiptConfigData::SECTION);
        return ans;
    }break;
    case CoreTransaction::Operation::LOAD_OFD_SETTINGS:
    {
        BaseCoreConfigData *res = createObject(OfdSettings::SECTION);
        if(!res) return CoreApiResult(CoreApiConst::ErrorCode::InvalidSettingsSection,
                                 tr("Указан некорректный раздел настроек: %1").arg(OfdSettings::SECTION));
        load(res);
        CoreApiResult ans = res->toSuccessResult();
        delete res;
        return ans;
    }break;
    case CoreTransaction::Operation::SAVE_OFD_SETTINGS:
    {
        BaseCoreConfigData *res = createObject(OfdSettings::SECTION);
        if(!res) return CoreApiResult(CoreApiConst::ErrorCode::InvalidSettingsSection,
                                 tr("Указан некорректный раздел настроек: %1").arg(OfdSettings::SECTION));
        res->parseTransactionParams(trans.params());
        save(res);
        load(res);
        CoreApiResult ans = res->toSuccessResult();
        delete res;
        resetObject(OfdSettings::SECTION);
        return ans;
    }break;
    default:
        return CoreApiResult(CoreApiConst::ErrorCode::InvalidTransactionType);
        break;
    }
}

BaseCoreConfigData *CoreConfigStore::createObject(const QString &name)
{
    BaseCoreConfigData *res = nullptr;
    if(name == ReceiptConfigData::SECTION)
    {
        res = new ReceiptConfigData;
    }
    if(name == OfdSettings::SECTION)
    {
        res = new OfdSettings();
    }
    return res;
}

void CoreConfigStore::resetObject(const QString &name)
{
    if(name == ReceiptConfigData::SECTION)
    {
        receiptConfig_.reset();
    }
}
