#ifndef CORECONFIGSTORE_H
#define CORECONFIGSTORE_H

#include "baseiniconfigstore.h"
#include "receiptconfigdata.h"
#include "ofdsettings.h"

#include <optional>
#include <QSet>

class CoreConfigStore : public BaseIniConfigStore
{
    Q_OBJECT
    Q_DISABLE_COPY(CoreConfigStore)
    static const QSet<QString> SUPPORTED_SECTIONS;
public:
    explicit CoreConfigStore(QObject *parent = nullptr);
    ~CoreConfigStore() override;

    ReceiptConfigData receiptConfig() const;
    void setReceiptConfig(const ReceiptConfigData &rec);

    OfdSettings ofdConfig() const;
    void setOfdConfig(const OfdSettings &rec);


    CoreApiResult processTransaction(const CoreTransaction &trans);

private:
    mutable std::optional<ReceiptConfigData> receiptConfig_;

    BaseCoreConfigData *createObject(const QString &name);
    void resetObject(const QString &name);
};

#endif // CORECONFIGSTORE_H
