#ifndef ISERVICECONFIGDATA_H
#define ISERVICECONFIGDATA_H

#include <QMap>
#include <QString>
#include <QVariantMap>


class IServiceConfigData
{
public:
    virtual ~IServiceConfigData();

    virtual QString section() const = 0;
    virtual QStringList fields() const = 0;
    virtual QMap<QString, QString> toStringMap() const = 0;
    virtual void parseStringMap(const QMap<QString, QString> &map) = 0;
    virtual QVariantMap toMap() const = 0;
    virtual void parseMap(const QVariantMap &map) = 0;



protected:
    IServiceConfigData();
};

#endif // ISERVICECONFIGDATA_H
