#include "receiptconfigdata.h"

#include "formatutils.h"


const QString ReceiptConfigData::SECTION = "RECEIPT";
const QString ReceiptConfigData::MAX_RECEIPT_AMOUNT = "maxAmount";
const QString ReceiptConfigData::OPTIONS = "options";


ReceiptConfigData::ReceiptConfigData() noexcept
    : BaseCoreConfigData()
{

}

ReceiptConfigData::ReceiptConfigData(const ReceiptConfigData &other) noexcept
    : BaseCoreConfigData(other)
    , maxReceiptAmount_(other.maxReceiptAmount_)
    , options_(other.options_)
{

}

ReceiptConfigData::ReceiptConfigData(ReceiptConfigData &&other) noexcept
    : BaseCoreConfigData(other)
    , maxReceiptAmount_(other.maxReceiptAmount_)
    , options_(other.options_)
{

}

ReceiptConfigData::~ReceiptConfigData()
{

}

QString ReceiptConfigData::section() const
{
    return SECTION;
}

QStringList ReceiptConfigData::fields() const
{
    return QStringList{MAX_RECEIPT_AMOUNT, OPTIONS};
}

QMap<QString, QString> ReceiptConfigData::toStringMap() const
{
    return QMap<QString, QString> {
        {MAX_RECEIPT_AMOUNT, maxReceiptAmount_.toString()},
        {OPTIONS, QString::number(static_cast<quint32>(options_))}
    };
}

void ReceiptConfigData::parseStringMap(const QMap<QString, QString> &map)
{
    maxReceiptAmount_ = FixNumber(DEFAULT_AMOUNT_MULT);
    if(map.contains(MAX_RECEIPT_AMOUNT)) maxReceiptAmount_.setString(map[MAX_RECEIPT_AMOUNT]);
    if(map.contains(OPTIONS)) options_ = Options(map[OPTIONS].toUInt());
}

QVariantMap ReceiptConfigData::toMap() const
{
    return QVariantMap {
        {MAX_RECEIPT_AMOUNT, maxReceiptAmount_.value()},
        {OPTIONS, QString::number(static_cast<quint32>(options_))}
    };
}

void ReceiptConfigData::parseMap(const QVariantMap &map)
{
    maxReceiptAmount_ = FixNumber(DEFAULT_AMOUNT_MULT);
    if(map.contains(MAX_RECEIPT_AMOUNT)) maxReceiptAmount_.setValue(map[MAX_RECEIPT_AMOUNT].toLongLong());
    if(map.contains(OPTIONS)) options_ = Options(map[OPTIONS].toString().toUInt());
}

FixNumber ReceiptConfigData::maxReceiptAmount() const
{
    return maxReceiptAmount_;
}

void ReceiptConfigData::setMaxReceiptAmount(const FixNumber &newMaxReceiptAmount)
{
    maxReceiptAmount_ = newMaxReceiptAmount;
}

ReceiptConfigData::Options ReceiptConfigData::options() const
{
    return options_;
}

void ReceiptConfigData::setOptions(const Options &newOptions)
{
    options_ = newOptions;
}


ReceiptConfigData &ReceiptConfigData::operator =(const ReceiptConfigData &other) noexcept
{
    maxReceiptAmount_ = other.maxReceiptAmount_;
    options_ = other.options_;
    return *this;
}

ReceiptConfigData &ReceiptConfigData::operator =(ReceiptConfigData &&other) noexcept
{
    std::swap(maxReceiptAmount_, other.maxReceiptAmount_);
    options_ = other.options_;
    return *this;
}


bool ReceiptConfigData::operator ==(const ReceiptConfigData &other) const noexcept
{
    return maxReceiptAmount_ == other.maxReceiptAmount_ &&
           options_ == other.options_;
}

bool ReceiptConfigData::operator !=(const ReceiptConfigData &other) const noexcept
{
    return !(*this == other);
}
