#ifndef RECEIPTCONFIGDATA_H
#define RECEIPTCONFIGDATA_H

#include "basecoreconfigdata.h"
#include "fixnumber.h"
#include "cashboxbuildconfig.h"

#include <QFlags>

class ReceiptConfigData : public BaseCoreConfigData
{
    friend class CoreConfigStore;
    static const QString SECTION;
    static const QString MAX_RECEIPT_AMOUNT;
    static const QString OPTIONS;
public:
    enum Option
    {
        NoOptions               = 0x00000000
    };
    Q_DECLARE_FLAGS(Options, Option)
    ReceiptConfigData() noexcept;
    ReceiptConfigData(const ReceiptConfigData &other) noexcept;
    ReceiptConfigData(ReceiptConfigData &&other) noexcept;
    ~ReceiptConfigData() override;

    QString section() const override;
    QStringList fields() const  override;
    QMap<QString, QString> toStringMap() const  override;
    void parseStringMap(const QMap<QString, QString> &map)  override;
    QVariantMap toMap() const  override;
    void parseMap(const QVariantMap &map)  override;

    FixNumber maxReceiptAmount() const;
    void setMaxReceiptAmount(const FixNumber &newMaxReceiptAmount);

    Options options() const;
    void setOptions(const Options &newOptions);


    ReceiptConfigData &operator =(const ReceiptConfigData &other) noexcept;
    ReceiptConfigData &operator =(ReceiptConfigData &&other) noexcept;
    bool operator ==(const ReceiptConfigData &other) const noexcept;
    bool operator !=(const ReceiptConfigData &other) const noexcept;


private:
    FixNumber maxReceiptAmount_ {DEFAULT_AMOUNT_MULT};
    Options options_ {};
};

Q_DECLARE_OPERATORS_FOR_FLAGS(ReceiptConfigData::Options)

#endif // RECEIPTCONFIGDATA_H
