#include "cryptedsettingsstorage.h"

#include "qextdes.h"
#include "dircreator.h"
#include "devicehelper.h"

#include <QIODevice>
#include <QCryptographicHash>

#include <QBuffer>
#include <QFile>
#include <QJsonParseError>
#include <QJsonDocument>

const QSettings::Format CryptedSettingsStorage::CRYPTED_FORMAT =
        QSettings::registerFormat("crypto", readCryptoFile, writeCryptoFile);

CryptedSettingsStorage::CryptedSettingsStorage(const QString &organization,
            const QString &application, QObject *parent) :
    QSettings(CRYPTED_FORMAT, QSettings::UserScope, organization, application, parent)
{
}

CryptedSettingsStorage::CryptedSettingsStorage(Scope scope, const QString &organization,
            const QString &application, QObject *parent) :
    QSettings(CRYPTED_FORMAT, scope, organization, application, parent)
{
}

CryptedSettingsStorage::CryptedSettingsStorage(const QString &fileName, QObject *parent) :
    QSettings(fileName, CRYPTED_FORMAT, parent)
{
}




bool CryptedSettingsStorage::readCryptoFile(QIODevice &device, QSettings::SettingsMap &map)
{
    map.clear();
    QByteArray ba = device.readAll();
    QByteArray key = DeviceHelper().getHardwareHash().toUtf8();
//	lmWarning() << logbinary(key) << logbinary(iv);
    ba = decrypt(ba, key);
    if(!ba.isEmpty()) ba = qUncompress(ba);
    QJsonParseError jerr;
    QJsonDocument jdoc = QJsonDocument::fromJson(ba, &jerr);
    if(jerr.error != QJsonParseError::NoError) return false;
    map = jdoc.toVariant().toMap();
    return true;
}

bool CryptedSettingsStorage::writeCryptoFile(QIODevice &device, const QSettings::SettingsMap &map)
{
    QJsonDocument jdoc = QJsonDocument::fromVariant(map);
    QByteArray key = DeviceHelper().getHardwareHash().toUtf8();
    QByteArray data = encrypt(qCompress(jdoc.toJson()), key);
    device.write(data);
    return true;
}

QByteArray CryptedSettingsStorage::encrypt(const QByteArray &data, const QByteArray &key)
{
    QExtDes des(key);
    QByteArray buf = data;
    if(buf.size() % 8)
    {
        buf.append(QByteArray(8 - buf.size() % 8, '\x00'));
    }
    QByteArray res;
    for(int i = 0; i < buf.size(); i+=8)
    {
        QByteArray ba;
        des.processMessage(buf.mid(i), ba, QExtDes::Mode::Encrypt);
        res.append(ba.mid(0, 8));
    }
    return res;
}

QByteArray CryptedSettingsStorage::decrypt(const QByteArray &data, const QByteArray &key)
{
    QExtDes des(key);
    QByteArray buf = data;
    if(buf.size() % 8)
    {
        buf.append(QByteArray(8 - buf.size() % 8, '\x00'));
    }
    QByteArray res;
    for(int i = 0; i < buf.size(); i+=8)
    {
        QByteArray ba;
        des.processMessage(buf.mid(i), ba, QExtDes::Mode::Decrypt);
        res.append(ba.mid(0, 8));
    }
    while (res.endsWith('\x00'))
    {
        res = res.mid(0, res.size() - 1);
    }
    return res;
}

