#ifndef CRYPTEDSETTINGSSTORAGE_H
#define CRYPTEDSETTINGSSTORAGE_H

#include <QSettings>


class CryptedSettingsStorage : public QSettings
{
    Q_OBJECT
    Q_DISABLE_COPY(CryptedSettingsStorage)
    static const QSettings::Format CRYPTED_FORMAT;
public:
    CryptedSettingsStorage(const QString &organization,
                const QString &application = QString(), QObject *parent = 0);

    CryptedSettingsStorage(Scope scope, const QString &organization,
                const QString &application = QString(), QObject *parent = 0);

    CryptedSettingsStorage(const QString &fileName, QObject *parent = 0);

private:
    static bool readCryptoFile(QIODevice &device, QSettings::SettingsMap &map);
    static bool writeCryptoFile(QIODevice &device, const QSettings::SettingsMap &map);

    static QByteArray encrypt(const QByteArray &data, const QByteArray&key);
    static QByteArray decrypt(const QByteArray &data, const QByteArray&key);

};

#endif // CRYPTEDSETTINGSSTORAGE_H
