#ifndef CASHBOXSTATUS_H
#define CASHBOXSTATUS_H

#include "modeldata.h"
#include "regdata.h"
#include "devicestatus.h"
#include "fsfullstatus.h"

class CashboxStatus
{
public:
    CashboxStatus()noexcept;
    CashboxStatus(const CashboxStatus &other)noexcept;
    CashboxStatus(CashboxStatus &&other)noexcept;
    explicit CashboxStatus(const QVariantMap &map)noexcept;
    ~CashboxStatus();

    bool isFiscalized() const;
    bool needFiscalization() const;
    bool cycleIsOpen() const;
    bool cycleIsOver() const;

    ModelData modelData() const;
    void setModelData(const ModelData &modelData);

    RegData regData() const;
    void setRegData(const RegData &regData);


    DeviceStatus dev() const;
    void setDev(const DeviceStatus &dev);

    FsFullStatus fs() const;
    void setFs(const FsFullStatus &newFs);


    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);

    QString toHtml() const;

    CashboxStatus &operator =(const CashboxStatus &other)noexcept;
    CashboxStatus &operator =(CashboxStatus &&other)noexcept;
    bool operator ==(const CashboxStatus &other)const;
    bool operator !=(const CashboxStatus &other)const;





private:
    ModelData modelData_;
    RegData regData_;
    DeviceStatus dev_;
    FsFullStatus fs_;

};

Q_DECLARE_METATYPE(CashboxStatus)

#endif // CASHBOXSTATUS_H
