#include "coreapiconst.h"

#include <QObject>

QString CoreApiConst::defaultErrorMsg(CoreApiConst::ErrorCode code)
{
    switch (code) {
    case ErrorCode::Ok                                      :
        return QString();
    case ErrorCode::UnsupportedApiCommand                   :
        return QObject::tr("Команда не поддерживается");
    case ErrorCode::InvalidTransactionCashier               :
        return QObject::tr("Некорректные данные кассира");
    case ErrorCode::InvalidTransactionType                  :
        return QObject::tr("Некорректный тип транзакции");
    case ErrorCode::EmptyTransactionUid                     :
        return QObject::tr("Пустой идентификатор транзакции");
    case ErrorCode::AccessDenied                            :
        return QObject::tr("Доступ запрещен");
    case ErrorCode::ServiceDoesNotStarted                   :
        return QObject::tr("Сервис ядра не доступен");
    case ErrorCode::SerialWriteError                        :
        return QObject::tr("Ошибка записи заводского номера");
    case ErrorCode::SerialExists                            :
        return QObject::tr("Заводской номер уже записан");
    case ErrorCode::NoCashboxSerial                         :
        return QObject::tr("Нет заводского номера");
    case ErrorCode::NoFiscalModule                          :
        return QObject::tr("Не установлен фискальный модуль");
    case ErrorCode::FiscalizationError                      :
        return QObject::tr("Ошибка фискализации ККТ");
    case ErrorCode::DatabaseLoadingError                    :
        return QObject::tr("Ошибка чтения из БД");
    case ErrorCode::DatabaseSavingError                     :
        return QObject::tr("Ошибка записи в БД");
    case ErrorCode::NotFiscalized                           :
        return QObject::tr("ККТ не фискализирована");
    case ErrorCode::CycleIsOpened                           :
        return QObject::tr("Смена уже открыта");
    case ErrorCode::CycleIsClosed                           :
        return QObject::tr("Смена закрыта");
    case ErrorCode::CycleIsOff                              :
        return QObject::tr("Смена превысила 24 часа");
    case ErrorCode::ReceiptEncodingError                    :
        return QObject::tr("Ошибка кодирования чека");
    case ErrorCode::CardSumTooLarge                         :
        return QObject::tr("Сумма оплаты картой превышает сумму по чеку");
    case ErrorCode::PaymentsNotEnough                       :
        return QObject::tr("Не достаточно средств для оплаты чека");
    case ErrorCode::PrinterBaseError                        :
        return QObject::tr("Ошибка принтера");
    case ErrorCode::PrinterPrintFail                        :
        return QObject::tr("Ошибка принтера");
    case ErrorCode::PrinterAddPrnStrFail                    :
        return QObject::tr("Ошибка печати текста");
    case ErrorCode::PrinterAddImgFail                       :
        return QObject::tr("Ошибка печати изображения");
    case ErrorCode::PrinterBusy                             :
        return QObject::tr("Принтер занят");
    case ErrorCode::PrinterPaperLack                        :
        return QObject::tr("Нет бумаги");
    case ErrorCode::PrinterWrongPackage                     :
        return QObject::tr("Ошибка принтера");
    case ErrorCode::PrinterFault                            :
        return QObject::tr("Ошибка принтера");
    case ErrorCode::PrintreTooHot                           :
        return QObject::tr("Перегрев головки принтера");
    case ErrorCode::PrinterUnFinished                       :
        return QObject::tr("Ошибка API принтера");
    case ErrorCode::PrinterNoFontLib                        :
        return QObject::tr("Нет шрифтов для принтера");
    case ErrorCode::PrinterOutOfMemory                      :
        return QObject::tr("Ошибка контроллера принтера");
    case ErrorCode::PrinterOtherError                       :
        return QObject::tr("Ошибка принтера");
    case ErrorCode::LavbelsServerError                      :
        return QObject::tr("Нет связи с сервером проверки КМ");
    case ErrorCode::InvalidSumFormat               :
        return QObject::tr("Некорректный формат суммы");
    case ErrorCode::InvalidFd                      :
        return QObject::tr("Некорректный ФД");
    case ErrorCode::InvalidParams                  :
        return QObject::tr("Некорректное значение реквиита");
    case ErrorCode::AlienFs                        :
        return QObject::tr("Вставлен ФН, зарегистрированный в составе другой ККТ");
    case ErrorCode::InvalidSerialNumber            :
        return QObject::tr("Некореектный заводской номер ККТ");
    case ErrorCode::InvalidParamValue              :
        return QObject::tr("Некорректное значение реквизита");
    case ErrorCode::InvalidUserInn                 :
        return QObject::tr("Некорректное значение ИНН пользователя");
    case ErrorCode::InvalidRegNumber               :
        return QObject::tr("Некорректное значение РНМ");
    case ErrorCode::EmptyFsStatus                  :
        return QObject::tr("Пустой статус ФН");
    case ErrorCode::FsExchangeError                :
        return QObject::tr("Ошибка обмена с ФН");
    case ErrorCode::HasNotSended                   :
        return QObject::tr("В ФН есть неотправленные документы");
    case ErrorCode::NoAnyParameter                 :
        return QObject::tr("Не хватает реквизитов");
    case ErrorCode::NoItemPrice                    :
        return QObject::tr("Не указана цена единицы предмета расчета");
    case ErrorCode::InvalidItemPrice               :
        return QObject::tr("Некорректное значение цены единицы предметы расчета");
    case ErrorCode::InvalidItemCost                :
        return QObject::tr("Некорректное значение цены предмета расчета");
    case ErrorCode::InvalidItemQuantity            :
        return QObject::tr("Некорректное значение количества предмета расчета");
    case ErrorCode::InvalidItemName                :
        return QObject::tr("Пустое поле наименования товара");
    case ErrorCode::InvalidItemAgentData           :
        return QObject::tr("Некорректное значение данных агента");
    case ErrorCode::InvalidProviderInn             :
        return QObject::tr("Некорректное значение ИНН поставщика");
    case ErrorCode::NoProviderData                 :
        return QObject::tr("Не указаны данные поставщика");
    case ErrorCode::InvalidProductUnit             :
        return QObject::tr("Некорректное значение единицы измерения предмета расчета");
    case ErrorCode::InvalidVatRate                 :
        return QObject::tr("Некорректное значение ставки НДС");
    case ErrorCode::KeysServerError                :
        return QObject::tr("Ошибка сервера обновления ключей");
    case ErrorCode::NoAnyReceiptOperations         :
        return QObject::tr("В чеке нет предметов расчета");
    case ErrorCode::ReceiptNotPayed                :
        return QObject::tr("Чек не оплачен");
    case ErrorCode::ReceiptOverPayed               :
        return QObject::tr("Переплата по чеку");
    case ErrorCode::InvalidTaxSystem               :
        return QObject::tr("Указана некорректная налоговая система");
    case ErrorCode::InvalidReceiptAmount           :
        return QObject::tr("Некорректная сумма по чеку");
    case ErrorCode::NotContainsCorrrectionReason   :
        return QObject::tr("Не указана причина коррекции");
    case ErrorCode::TooLongLabel                   :
        return QObject::tr("Слишком длинный код маркировки");
    case ErrorCode::LabelsNotSupported             :
        return QObject::tr("Работа с кодами маркировки не поддерживается");
    case ErrorCode::NoAnyLabel                     :
        return QObject::tr("Не указан код маркировки");
    case ErrorCode::NoExpectedParam                :
        return QObject::tr("Неожиданный реквизит");
    case ErrorCode::LabelCheckFsError              :
        return QObject::tr("Ошибка проверки кода маркироваки в ФН");
    case ErrorCode::LabelCheckOismError            :
        return QObject::tr("Ошибка проверки кода маркировки на сервере ОИСМ");
    case ErrorCode::OfflineModeOnly                :
        return QObject::tr("Только для автономного режима");
    case ErrorCode::OfflineFileCreationError       :
        return QObject::tr("Ошибка создания файла экспорта уведомлений в автономном режиме");
    case ErrorCode::UnsupportedFsFFDVersion        :
        return QObject::tr("Текущая версия ФФД ФН не поддерживается");
    case ErrorCode::UnsupportedFFDVersion          :
        return QObject::tr("Текущая версия ФФД не поддерживается");
    case ErrorCode::FsFfdVersionReadError          :
        return QObject::tr("Ошибка чтения версии ФФД");
    case ErrorCode::InternalStorageError           :
        return QObject::tr("Ошибка внутреннего хранилища");
    case ErrorCode::ExternalIdDublicated           :
        return QObject::tr("Документ с таким externalId уже существует");
    case ErrorCode::HasNotPrinted                  :
        return QObject::tr("В ККТ есть недопечатанный документ");
    case ErrorCode::NoRequestedStoredData          :
        return QObject::tr("Нет запрашиваемых данных");
    case ErrorCode::KeysStatusLoadingError         :
        return QObject::tr("Ошибка загрузки статуса обновления ключей");
    case ErrorCode::InvalidItemData         :
        return QObject::tr("Ошибка разбора предмета расчета");
    case ErrorCode::InvalidSettingsSection         :
        return QObject::tr("Запрошенный раздел настроек не поддерживается");
    case ErrorCode::ReceiptAmountToLarge         :
        return QObject::tr("Сумма по чеку превышает разрешенную");
    case ErrorCode::OldCashboxInstalled         :
        return QObject::tr("На аппарате установлены две версии ККТ (для ФФД 1.05 и ФФД 1.2). Должна быть установлена только одна из версий!");
    case ErrorCode::DbAccessError         :
        return QObject::tr("Ошибка доступа к БД!");
    case ErrorCode::NoCashMoney         :
        return QObject::tr("Не хватает наличных в кассе!");

    case ErrorCode::UnknownFsCmd                    : return QObject::tr("Неизвестная команда ФН (01h)");
    case ErrorCode::IncorrectFsState                : return QObject::tr("Другое состояние ФН (02h)");
    case ErrorCode::FsError                         : return QObject::tr("Отказ ФН (03h)");
    case ErrorCode::CcError                         : return QObject::tr("Отказ КС (04h)");
    case ErrorCode::FsOverLifetime                  : return QObject::tr("Параметры команды не соответствуют сроку жизни ФН (05h)");
    case ErrorCode::FsOverflow                      : return QObject::tr("Переполнение ФН (06h)");
    case ErrorCode::IncorrectDt                     : return QObject::tr("Некорректная дата и/или время (07h)");
    case ErrorCode::NoDataRequested                 : return QObject::tr("Нет запрошенных данных (08h)");
    case ErrorCode::InvalidCmdParams                : return QObject::tr("Некорректное значение параметров команды (09h)");
    case ErrorCode::InvlidCmd                       : return QObject::tr("Некорректная команда (0Ah)");
    case ErrorCode::DeniedParams                    : return QObject::tr("Неразрешенные реквизиты (0Bh)");
    case ErrorCode::DubleData                       : return QObject::tr("Дублирование данных (0Ch)");
    case ErrorCode::NotEnophData                    : return QObject::tr("Отсутствуют данные, необходимые для корректного учета в ФН (0Dh)");
    case ErrorCode::TooManyOperations               : return QObject::tr("Количество позиций в документе, превысило допустимый предел (0Eh)");
    case ErrorCode::InvalidTLVSize                  : return QObject::tr("Превышение размеров TLV данных (10h)");
    case ErrorCode::OfdTransportMissing             : return QObject::tr("Нет транспортного соединения (11h)");
    case ErrorCode::CcOverLifetime                  : return QObject::tr("Исчерпан ресурс ФН (12h)");
    case ErrorCode::ExhaustedStorageResource        : return QObject::tr("Ограничение ресурса ФН(14h)");
    case ErrorCode::DocumentTransferTimeout         : return QObject::tr("Таймаут передачи документа (15h)");
    case ErrorCode::CycleOver24h                    : return QObject::tr("Превышена продолжительность смены (16h)");
    case ErrorCode::TimePeriodError                 : return QObject::tr("Некорректные данные о промежутке времени между фискальными документами (17h)");
    case ErrorCode::InvalidParameter                : return QObject::tr("Некорректный реквизитпереданный ККТ в ФН (18h)");
    case ErrorCode::ParameterBannedByReg            : return QObject::tr("Реквизит не соответствует установкам при регистрации (19h)");
    case ErrorCode::OfdMsgError                     : return QObject::tr("Код обработки ответа в ФН: некорректный ответ (20h)");
    case ErrorCode::KeysServerFailure               : return QObject::tr("Отрицательный ответ сервиса обновления ключей проверки КМ(23h)");
    case ErrorCode::KeysServerUnknownError          : return QObject::tr("Неизвестный ответ сервиса обновления ключей проверки кодов проверки (24h)");
    case ErrorCode::RetryKeysUpdate                 : return QObject::tr("Требуется повтор процедуры обновления ключей проверки КМ (30h)");
    case ErrorCode::LabledProductsNotSupported      : return QObject::tr("Запрещена работа с маркированным товарами (32h)");
    case ErrorCode::BxRequestsSequenceError         : return QObject::tr("Неверная последовательность команд при работе с маркированными товарами (33h)");
    case ErrorCode::LabledProductsTemporarryBlocked : return QObject::tr("Работа с маркированными товарами временно заблокирована (34h)");
    case ErrorCode::LabelsCheckTableOverflow        : return QObject::tr("Переполнена таблица проверки кодов маркировки (35h)");
    case ErrorCode::KeyCheckPeriod90Off             : return QObject::tr("Превышен период 90 дней современи последнего обновления ключей проверки (36h)");
    case ErrorCode::TlvStructureParametersNotEnoph  : return QObject::tr("В блоке TLV отсутствуют необходимые реквизиты (3Ch)");
    case ErrorCode::Parameter2007HasNotCheckedLabel : return QObject::tr("В реквизите 2007 содержится КМ, который ранее не проверялся в ФН (3Eh)");
    case ErrorCode::FsRepParsingError               : return QObject::tr("Ошибка разбора ответа от ФН");
    case ErrorCode::FsIsOffline                     : return QObject::tr("Нет связи с ФН");
    case ErrorCode::UnknownFsError                  : return QObject::tr("Неопределенная ошибка ФН");

    case ErrorCode::UnknownError                            :
        return QObject::tr("Странноватая ошибка");
    case ErrorCode::ServiceAccessError                      :
        return QObject::tr("Ошибка доступ к сервису");
    case ErrorCode::NotReady                                :
        return QObject::tr("ККТ не готова");
    default: return QString(QObject::tr("Ошибка №%1")
                            .arg(static_cast<qint32>(code), 4, 16, QLatin1Char('0')));
    }
}

    CoreApiConst::    CoreApiConst()
{

}



