#ifndef COREAPICONST_H
#define COREAPICONST_H

#include <QString>


class CoreApiConst
{
public:
    static const qint32 MIN_PASSWORD_LENGTH = 1;
    enum class RemoteCommand
    {
        INVALID                                 = 0x00000000,
        FIRST_CALL_TRANSACTION                  = 0x00000001,
        GET_CASHIER_NAMES                       = 0x00002001,
        LOGIN                                   = 0x00002002,
        CASHBOX_STATUS                          = 0x00002003,
        WRITE_SERIAL                            = 0x00002004,
        GET_DATA_FOR_RECEIPT                    = 0x00002005,
        SAVE_CASHIER                            = 0x00002006,
        OPEN_CYCLE                              = 0x00002007,
        CLOSE_CYCLE                             = 0x00002008,
        DOWNLOAD_CASHIERS                       = 0x00002009,

        // PREPRINT_FISCALIZATION                  = 0x0000200A,
        FISCALIZATION                           = 0x0000200B,
        FS_CLEAN                                = 0x0000200C,

        FS_COUNTERS                             = 0x0000200D,
        CALC_REPORT                             = 0x0000200E,
        OFD_2_FS_CMD                            = 0x0000200F,

        FIND_FS_DOC                             = 0x00002010,
        FIND_OFD_TICKET                         = 0x00002011,
        GET_TLV_DOC                             = 0x00002012,
        GET_REG_ARCHIVE_DOC                     = 0x00002013,
        GET_REG_TLV_DOC                         = 0x00002014,

        FS_CLOSE                                = 0x00002015,

        RECEIPT                                 = 0x00002016,
        CORRECTION                              = 0x00002017,

        CHECK_LABEL                             = 0x00002018,

        LOAD_OFD_SETTINGS                       = 0x00002019,
        SAVE_OFD_SETTINGS                       = 0x0000201A,

        GET_OFFLINE_NOTIFICATIONS               = 0x0000201B,

        REMOVE_CASHIER                          = 0x0000201C,
        SELF_TEST                               = 0x0000201D,

        // PRINT_NOT_PRINTED                       = 0x0000201E,

        GET_CASHBOX_MODELDATA                   = 0x0000201F,
        // PRINT_TEXT                              = 0x00002020,

        // X_REPORT                                = 0x00002021,
        // FS_REPORT                               = 0x00002022,

        FULL_CLEAR                              = 0x00002023,
        // PRINT_DOC_COPY                          = 0x00002024,

        LOAD_CORE_SETTINGS                      = 0x00002025,
        SAVE_CORE_SETTINGS                      = 0x00002026,

        CLEAN_LABELS                            = 0x00002027,

        // INTRODUCTION                            = 0x00002028,
        // PAYOUT                                  = 0x00002029,
        SET_DATE_TIME                           = 0x0000202A,
        MAX_VALID_OPERATION                     = 0x0000202A,

        LAST_CALL_TRANSACTION                   = 0x00ffffff,
        PING_TRANSACTION                        = 0x5f504e47
    };
    enum class ErrorCode
    {
        Ok                                      = 0x00000000,
        UnsupportedApiCommand                   = 0x00000001,
        InvalidSumFormat                        = 0x00000002,
//        NoAnyWorker                             = 0x00000003,
        InvalidTransactionCashier               = 0x00000004,
        InvalidTransactionType                  = 0x00000005,
        InvalidFd                               = 0x00000006,
        EmptyTransactionUid                     = 0x00000007,
        InvalidParams                           = 0x00000008,
        AlienFs                                 = 0x00000009,
        InvalidSerialNumber                     = 0x0000000A,
        InvalidParamValue                       = 0x0000000B,
        InvalidUserInn                          = 0x0000000C,
        InvalidRegNumber                        = 0x0000000D,
        AccessDenied                            = 0x0000000E,
        ServiceDoesNotStarted                   = 0x0000000F,
        SerialWriteError                        = 0x00000010,
        SerialExists                            = 0x00000011,
        NoCashboxSerial                         = 0x00000012,
        NoFiscalModule                          = 0x00000013,
        FiscalizationError                      = 0x00000014,
        DatabaseLoadingError                    = 0x00000015,
        DatabaseSavingError                     = 0x00000016,
        NotFiscalized                           = 0x00000017,
        CycleIsOpened                           = 0x00000018,
        CycleIsClosed                           = 0x00000019,
        CycleIsOff                              = 0x0000001A,
        ReceiptEncodingError                    = 0x0000001B,
        CardSumTooLarge                         = 0x0000001C,
        PaymentsNotEnough                       = 0x0000001D,
        EmptyFsStatus                           = 0x0000001E,
        FsExchangeError                         = 0x0000001F,
        HasNotSended                            = 0x00000020,
        NoAnyParameter                          = 0x00000021,
        NoItemPrice                             = 0x00000022,
        InvalidItemPrice                        = 0x00000023,
        InvalidItemCost                         = 0x00000024,
        InvalidItemQuantity                     = 0x00000025,
        InvalidItemName                         = 0x00000026,
        InvalidItemAgentData                    = 0x00000027,
        InvalidProviderInn                      = 0x00000028,
        NoProviderData                          = 0x00000029,
        InvalidProductUnit                      = 0x0000002A,
        InvalidVatRate                          = 0x0000002B,
        KeysServerError                         = 0x0000002C,
        NoAnyReceiptOperations                  = 0x0000002D,
        ReceiptNotPayed                         = 0x0000002E,
        ReceiptOverPayed                        = 0x0000002F,
        InvalidTaxSystem                        = 0x00000030,
        InvalidReceiptAmount                    = 0x00000031,
        NotContainsCorrrectionReason            = 0x00000032,
        TooLongLabel                            = 0x00000033,
        LabelsNotSupported                      = 0x00000034,
        NoAnyLabel                              = 0x00000035,
        NoExpectedParam                         = 0x00000036,
        LavbelsServerError                      = 0x00000037,
        LabelCheckFsError                       = 0x00000038,
        LabelCheckOismError                     = 0x00000039,
        OfflineModeOnly                         = 0x0000003A,
        OfflineFileCreationError                = 0x0000003B,
        UnsupportedFsFFDVersion                 = 0x0000003C,
        UnsupportedFFDVersion                   = 0x0000003D,
        FsFfdVersionReadError                   = 0x0000003E,
        InternalStorageError                    = 0x0000003F,
        ExternalIdDublicated                    = 0x00000040,
        HasNotPrinted                           = 0x00000041,
        NoRequestedStoredData                   = 0x00000042,
        KeysStatusLoadingError                  = 0x00000043,
        CashboxDebugBuildOnly                   = 0x00000044,
        InvalidItemData                         = 0x00000045,
        InvalidSettingsSection                  = 0x00000046,
        ReceiptAmountToLarge                    = 0x00000047,
        OldCashboxInstalled                     = 0x00000048,
        ExternalIdAndTaskDublicated             = 0x00000049,
        DbAccessError                           = 0x0000004A,
        NoCashMoney                             = 0x0000004B,
        InvalidCashboxDt                        = 0x0000004C,
        InvalidDt                               = 0x0000004D,
        DtSettingError                          = 0x0000004E,

        PrinterBaseError                        = 0x000003E8,
        PrinterPrintFail                        = 0x000003E9,
        PrinterAddPrnStrFail                    = 0x000003EA,
        PrinterAddImgFail                       = 0x000003EB,
        PrinterBusy                             = 0x000003EC,
        PrinterPaperLack                        = 0x000003ED,
        PrinterWrongPackage                     = 0x000003EE,
        PrinterFault                            = 0x000003EF,
        PrintreTooHot                           = 0x000003F0,
        PrinterUnFinished                       = 0x000003F1,
        PrinterNoFontLib                        = 0x000003F2,
        PrinterOutOfMemory                      = 0x000003F3,
        PrinterOtherError                       = 0x000003CF,

        UnknownFsCmd                            = 0x00000501u,
        IncorrectFsState                        = 0x00000502u,
        FsError                                 = 0x00000503u,
        CcError                                 = 0x00000504u,
        FsOverLifetime                          = 0x00000505u,
        FsOverflow                              = 0x00000506u,
        IncorrectDt                             = 0x00000507u,
        NoDataRequested                         = 0x00000508u,
        InvalidCmdParams                        = 0x00000509u,
        InvlidCmd                               = 0x0000050Au,
        DeniedParams                            = 0x0000050Bu,
        DubleData                               = 0x0000050Cu,
        NotEnophData                            = 0x0000050Du,
        TooManyOperations                       = 0x0000050Eu,
        InvalidTLVSize                          = 0x00000510u,
        OfdTransportMissing                     = 0x00000511u,
        CcOverLifetime                          = 0x00000512u,
        ExhaustedStorageResource                = 0x00000514u,
        DocumentTransferTimeout                 = 0x00000515u,
        CycleOver24h                            = 0x00000516u,
        TimePeriodError                         = 0x00000517u,
        InvalidParameter                        = 0x00000518u,
        ParameterBannedByReg                    = 0x00000519u,
        OfdMsgError                             = 0x00000520u,
        KeysServerFailure                       = 0x00000523u,
        KeysServerUnknownError                  = 0x00000524u,
        RetryKeysUpdate                         = 0x00000530u,
        LabledProductsNotSupported              = 0x00000532u,
        BxRequestsSequenceError                 = 0x00000533u,
        LabledProductsTemporarryBlocked         = 0x00000534u,
        LabelsCheckTableOverflow                = 0x00000535u,
        KeyCheckPeriod90Off                     = 0x00000536u,
        TlvStructureParametersNotEnoph          = 0x0000053Cu,
        Parameter2007HasNotCheckedLabel         = 0x0000053Eu,
        FsRepParsingError                       = 0x000005FDu,
        FsIsOffline                             = 0x000005FEu,
        UnknownFsError                          = 0x000005FFu,

        BaseHttpResult                          = 0x02000000u,

        UnknownError                            = 0x10000000u,
        ServiceAccessError                      = 0x10000001u,
        NotReady                                = 0x20000001u


    };

    static QString defaultErrorMsg(ErrorCode code);

private:
    CoreApiConst();
};
#ifdef Q_DECL_CONST_FUNCTION
Q_DECL_CONST_FUNCTION inline quint32 qHash(const CoreApiConst::RemoteCommand &key, uint seed = 0) Q_DECL_NOTHROW {return static_cast<quint32>(key) ^ seed; }
#else
inline quint32 qHash(const CoreApiConst::RemoteCommand &key, uint seed = 0) Q_DECL_NOTHROW {return static_cast<quint32>(key) }
#endif
#endif // COREAPICONST_H
