#ifndef QRAPIRESULT_H
#define QRAPIRESULT_H

#include "coretransaction.h"
#include "coreapiconst.h"

#include <QVariantMap>

class CoreApiResult
{
public:
    CoreApiResult() noexcept;
    explicit CoreApiResult(const CoreApiConst::ErrorCode &code) noexcept;
    CoreApiResult(const CoreApiConst::ErrorCode &code, const QString &msg)noexcept;
    CoreApiResult(const CoreApiConst::ErrorCode &code, const QString &msg, const QVariantMap &data) noexcept;
    explicit CoreApiResult(const QVariantMap &data)noexcept;
    CoreApiResult(const CoreApiResult &other)noexcept;
    CoreApiResult(CoreApiResult &&other) noexcept;
    ~CoreApiResult();

    bool isOk() const;

    CoreApiConst::ErrorCode code() const;
    CoreApiResult &setCode(CoreApiConst::ErrorCode code);

    QString descr() const;
    CoreApiResult &setDescr(const QString &msg);

    QVariantMap data() const;
    CoreApiResult &setData(const QVariantMap &data);

    QString uid() const;
    CoreApiResult &setUid(const QString &uid);

    QVariantMap toMap() const;

    CoreApiResult &operator =(const CoreApiResult &other)noexcept;
    CoreApiResult &operator =(CoreApiResult &&other) noexcept;
    bool operator ==(const CoreApiResult &other) const noexcept;
    bool operator != (const CoreApiResult &other)const noexcept;
private:
    CoreApiConst::ErrorCode code_;
    QString uid_;
    QString descr_;
    QVariantMap data_;
};

Q_DECLARE_METATYPE(CoreApiResult)

#endif // QRAPIRESULT_H
