#ifndef QRTRANSACTION_H
#define QRTRANSACTION_H

#include "fixnumber.h"

#include "coreapiconst.h"

#include <QString>
#include <QVariantMap>
#include <QMetaType>
#include <QMetaObject>
#include <QDateTime>


class CoreTransaction
{
public:
    typedef CoreApiConst::RemoteCommand  Operation;

    CoreTransaction() noexcept;
    CoreTransaction(const CoreTransaction &other)noexcept;
    CoreTransaction(CoreTransaction &&other)noexcept;
    CoreTransaction(CoreApiConst::RemoteCommand cmd, const QVariantMap &data)noexcept;
    ~CoreTransaction();

    bool isValid(CoreApiConst::ErrorCode &error, QString *message = nullptr, bool checkUid = false) const;

    Operation operation() const;
    void setOperation(const Operation &operation);

    QString uid() const;
    void setUid(const QString &uid);
    QString genUid();

    QString externalId() const;
    void setExternalId(const QString &externalId);

    const QString &clientId() const;
    void setClientId(const QString &newClientId);

    QVariantMap params() const;
    void setParams(const QVariantMap &params);

    QString cashierLogin() const;
    void setCashierLogin(const QString &login);

    QString cashierPassword() const;
    void setCashierPassword(const QString &cashierPassword);

    bool formatToExternal() const;
    void setFormatToExternal(bool newFormatToExternal);

    QDateTime clientDateTime() const;
    void setClientDateTime(const QDateTime &newClientDateTime);

    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);

    CoreTransaction &operator =(const CoreTransaction &other)noexcept;
    CoreTransaction &operator =(CoreTransaction &&other)noexcept;
    bool operator ==(const CoreTransaction &other)const noexcept;
    bool operator !=(const CoreTransaction &other)const noexcept;





private:
    Operation operation_;
    QString uid_;
    QString externalId_;
    QString clientId_;
    QVariantMap params_;
    QString cashierLogin_;
    QString cashierPassword_;
    bool formatToExternal_;
    QDateTime clientDateTime_;

};

Q_DECLARE_METATYPE(CoreTransaction)


#endif // QRTRANSACTION_H
