#ifndef DEVICESTATUS_H
#define DEVICESTATUS_H

#include "fixnumber.h"
#include "coreapiconst.h"

#include <QString>
#include <QVariantMap>

class DeviceStatus
{
public:
    DeviceStatus()noexcept;
    DeviceStatus(const DeviceStatus &other)noexcept;
    DeviceStatus(DeviceStatus &&other)noexcept;
    explicit DeviceStatus (const QVariantMap &map)noexcept;
    ~DeviceStatus();

    bool isValid() const;

    QString dsn() const;
    void setDsn(const QString &dsn);

    QString hwHash() const;
    void setHwHash(const QString &hwHash);

    quint32 versionCode() const;
    void setVersionCode(const quint32 &versionCode);

    QString versionText() const;
    void setVersionText(const QString &versionText);

    QStringList ipAddresses() const;
    QString ipAddress() const;
    void setIpAddress(const QString &ipAddress);

    QString interfaces() const;
    void setInterfaces(const QString &newInterfaces);

    QVariantMap storage() const;
    void setStorage(const QVariantMap &newStorage);

    QVariantMap mem() const;
    void setMem(const QVariantMap &newMem);

    const FixNumber &accumLevel() const;
    void setAccumLevel(const FixNumber &newAccumLevel);


    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);

    QStringList toHtml() const;

    DeviceStatus &operator =(const DeviceStatus &other)noexcept;
    DeviceStatus &operator =(DeviceStatus &&other)noexcept;
    bool operator ==(const DeviceStatus &other)const noexcept;
    bool operator !=(const DeviceStatus &other)const noexcept;







private:
    QString dsn_;
    QString hwHash_;
    quint32 versionCode_;
    QString versionText_;
    QString ipAddress_;
    QString interfaces_;
    QVariantMap mem_;
    QVariantMap storage_;
    FixNumber accumLevel_;
};

#endif // DEVICESTATUS_H
