#include "incomingreg.h"
#include "formatutils.h"

IncomingReg::IncomingReg() noexcept
    : flags_()
    , address_()
    , ofdInn_()
    , ownerInn_()
    , cashier_()
    , boxId_()
    , regNumber_()
    , ofdName_()
    , ownerName_()
    , ftsSite_()
    , taxes_()
    , email_()
    , place_()
    , cashierInn_()
    , additionalParam_()
    , additionalParamData_()
    , extFlags_()
    , reasons_()
{

}

IncomingReg::IncomingReg(const QVariantMap &map) noexcept
    : flags_()
    , address_()
    , ofdInn_()
    , ownerInn_()
    , cashier_()
    , boxId_()
    , regNumber_()
    , ofdName_()
    , ownerName_()
    , ftsSite_()
    , taxes_()
    , email_()
    , place_()
    , cashierInn_()
    , additionalParam_()
    , additionalParamData_()
    , extFlags_()
    , reasons_()
{
    IncomingReg::parseMap(map);
}

IncomingReg::IncomingReg(const IncomingReg &other) noexcept
    : flags_(other.flags_)
    , address_(other.address_)
    , ofdInn_(other.ofdInn_)
    , ownerInn_(other.ownerInn_)
    , cashier_(other.cashier_)
    , boxId_(other.boxId_)
    , regNumber_(other.regNumber_)
    , ofdName_(other.ofdName_)
    , ownerName_(other.ownerName_)
    , ftsSite_(other.ftsSite_)
    , taxes_(other.taxes_)
    , email_(other.email_)
    , place_(other.place_)
    , cashierInn_(other.cashierInn_)
    , additionalParam_(other.additionalParam_)
    , additionalParamData_(other.additionalParamData_)
    , extFlags_(other.extFlags_)
    , reasons_(other.reasons_)
{

}

IncomingReg::IncomingReg(IncomingReg &&other) noexcept
    : flags_(other.flags_)
    , address_()
    , ofdInn_()
    , ownerInn_()
    , cashier_()
    , boxId_()
    , regNumber_()
    , ofdName_()
    , ownerName_()
    , ftsSite_()
    , taxes_(other.taxes_)
    , email_()
    , place_()
    , cashierInn_()
    , additionalParam_()
    , additionalParamData_()
    , extFlags_(other.extFlags_)
    , reasons_(other.reasons_)
{
    address_.swap(other.address_);
    ofdInn_.swap(other.ofdInn_);
    ownerInn_.swap(other.ownerInn_);
    cashier_.swap(other.cashier_);
    boxId_.swap(other.boxId_);
    regNumber_.swap(other.regNumber_);
    ofdName_.swap(other.ofdName_);
    ownerName_.swap(other.ownerName_);
    ftsSite_.swap(other.ftsSite_);
    email_.swap(other.email_);
    place_.swap(other.place_);
    cashierInn_.swap(other.cashierInn_);
    additionalParam_.swap(other.additionalParam_);
    additionalParamData_.swap(other.additionalParamData_);
}

IncomingReg::~IncomingReg()
{

}

bool IncomingReg::forFiscalize() const
{
    return reasons_.toUInt() == 0u;
}

bool IncomingReg::forChangeFs() const
{
    return reasons_.changeFs();
}

bool IncomingReg::forRefiscalize() const
{
    return !forFiscalize() && !reasons_.changeFs();
}

bool IncomingReg::getAutoMode() const
{
    return flags_.testFlag(fdf::RegFlag::AutoMode);
}

void IncomingReg::setAutoMode(bool set)
{
    flags_.setFlag(fdf::RegFlag::AutoMode, set);
}

bool IncomingReg::getOfflineMode() const
{
    return flags_.testFlag(fdf::RegFlag::OfflineMode);
}

void IncomingReg::setOfflineMode(bool set)
{
    flags_.setFlag(fdf::RegFlag::OfflineMode, set);
}

bool IncomingReg::getEncriptionMode() const
{
    return flags_.testFlag(fdf::RegFlag::EncriptionMode);
}

void IncomingReg::setEncriptionMode(bool set)
{
    flags_.setFlag(fdf::RegFlag::EncriptionMode, set);
}

const fdf::RegFlags &IncomingReg::flags() const
{
    return flags_;
}

void IncomingReg::setFlags(const fdf::RegFlags &newFlags)
{
    flags_ = newFlags;
}

const QString &IncomingReg::address() const
{
    return address_;
}

void IncomingReg::setAddress(const QString &newAddress)
{
    address_ = STR4FS_(newAddress);
}

const QString &IncomingReg::ofdInn() const
{
    return ofdInn_;
}

void IncomingReg::setOfdInn(const QString &newOfdInn)
{
    ofdInn_ = newOfdInn;
}

const QString &IncomingReg::ownerInn() const
{
    return ownerInn_;
}

void IncomingReg::setOwnerInn(const QString &newUserInn)
{
    ownerInn_ = newUserInn;
}

const QString &IncomingReg::cashier() const
{
    return cashier_;
}

void IncomingReg::setCashier(const QString &newCashier)
{
    cashier_ = STR4FS_(newCashier);
}

const QString &IncomingReg::boxId() const
{
    return boxId_;
}

void IncomingReg::setBoxId(const QString &newBoxId)
{
    boxId_ = STR4FS_(newBoxId);
}

const QString &IncomingReg::regNumber() const
{
    return regNumber_;
}

void IncomingReg::setRegNumber(const QString &newRegNumber)
{
    regNumber_ = newRegNumber;
}

const QString &IncomingReg::ofdName() const
{
    return ofdName_;
}

void IncomingReg::setOfdName(const QString &newOfdName)
{
    ofdName_ = STR4FS_(newOfdName);
}

const QString &IncomingReg::ownerName() const
{
    return ownerName_;
}

void IncomingReg::setOwnerName(const QString &newUserName)
{
    ownerName_ = newUserName;
}

const QString &IncomingReg::ftsSite() const
{
    return ftsSite_;
}

void IncomingReg::setFtsSite(const QString &newFtsSite)
{
    ftsSite_ = STR4FS_(newFtsSite);
}

const fdf::Taxes &IncomingReg::taxes() const
{
    return taxes_;
}

void IncomingReg::setTaxes(const fdf::Taxes &newTaxes)
{
    taxes_ = newTaxes;
}

void IncomingReg::setTax(const fdf::Tax &tax, bool allow)
{
    taxes_.setFlag(tax, allow);
}

const QString &IncomingReg::email() const
{
    return email_;
}

void IncomingReg::setEmail(const QString &newEmail)
{
    email_ = STR4FS_(newEmail);
}

const QString &IncomingReg::place() const
{
    return place_;
}

void IncomingReg::setPlace(const QString &newPlace)
{
    place_ = STR4FS_(newPlace);
}

const QString &IncomingReg::cashierInn() const
{
    return cashierInn_;
}

void IncomingReg::setCashierInn(const QString &newCashierInn)
{
    cashierInn_ = newCashierInn;
}

const QString &IncomingReg::additionalParam() const
{
    return additionalParam_;
}

void IncomingReg::setAdditionalParam(const QString &newAdditionalParam)
{
    additionalParam_ = newAdditionalParam;
}

const QByteArray &IncomingReg::additionalParamData() const
{
    return additionalParamData_;
}

void IncomingReg::setAdditionalParamData(const QByteArray &newAdditionalParamData)
{
    additionalParamData_ = newAdditionalParamData;
}

const RegistrationFlags1290 &IncomingReg::extFlags() const
{
    return extFlags_;
}

void IncomingReg::setExtFlags(const RegistrationFlags1290 &newExtFlags)
{
    extFlags_ = newExtFlags;
}

void IncomingReg::setExtFlags(const fdf::RegFlags1290 &newExtFlags)
{
    extFlags_ = RegistrationFlags1290(newExtFlags);
}

void IncomingReg::setExtFlag(fdf::RegFlag1290 f, bool set)
{
    extFlags_.setFlag(f, set);
}

const RegReasons &IncomingReg::reasons() const
{
    return reasons_;
}

void IncomingReg::setReasons(const RegReasons &newReasons)
{
    reasons_ = newReasons;
}

void IncomingReg::setReasons(const fdf::Reasons &newReasons)
{
    reasons_ = RegReasons(newReasons);
}

void IncomingReg::setReason(fdf::Reason r, bool set)
{
    reasons_.setReason(r, set);
}


QVariantMap IncomingReg::toMap() const
{
    QVariantMap res = {
        {"flags", static_cast<qint32>(flags_)},
        {"address", address_},
        {"ofdInn", ofdInn_},
        {"ownerInn", ownerInn_},
        {"cashier", cashier_},
        {"boxId", boxId_},
        {"regNumber", regNumber_},
        {"ofdName", ofdName_},
        {"ownerName", ownerName_},
        {"ftsSite", ftsSite_},
        {"taxes", static_cast<qint32>(taxes_)},
        {"email", email_},
        {"place", place_},
        {"cashierInn", cashierInn_},
        {"additionalParam", additionalParam_},
        {"additionalParamData", QString::fromLatin1(additionalParamData_.toHex())},
    };
    res = UNIT_MAPS(res, extFlags_.toMap());
    res = UNIT_MAPS(res, reasons_.toMap());
    return res;
}

QVariantMap IncomingReg::toExternalMap() const
{
    QVariantMap res = {
        {"address", address_.isEmpty() ? QVariant() : QVariant(address_)},
        {"ofdInn", ofdInn_.isEmpty() ? QVariant() : QVariant(ofdInn_)},
        {"ownerInn", ownerInn_},
        {"cashier", cashier_.isEmpty() ? QVariant() : QVariant(cashier_)},
        {"boxId", boxId_.isEmpty() ? QVariant() : QVariant(boxId_)},
        {"regNumber", regNumber_},
        {"ofdName", ofdName_.isEmpty() ? QVariant() : QVariant(ofdName_)},
        {"ownerName", ownerName_.isEmpty() ? QVariant() : QVariant(ownerName_)},
        {"ftsSite", ftsSite_.isEmpty() ? QVariant() : QVariant(ftsSite_)},
        {"taxes", static_cast<qint32>(taxes_)},
        {"email", email_.isEmpty() ? QVariant() : QVariant(email_)},
        {"place", place_.isEmpty() ? QVariant() : QVariant(place_)},
        {"cashierInn", cashierInn_.isEmpty() ? QVariant() : QVariant(cashierInn_)},
        {"additionalParam", additionalParam_.isEmpty() ? QVariant() : QVariant(additionalParam_)},
        {"additionalParamData", additionalParamData_.isEmpty() ? QVariant():
         QVariant(QString::fromLatin1(additionalParamData_.toHex()))},
    };
    res.insert("autoMode", getAutoMode());
    res.insert("offlineMode", getOfflineMode());
    res.insert("useEncription", getEncriptionMode());
    res = UNIT_MAPS(res, extFlags_.toExternalMap());
    if(static_cast<quint32>(reasons_.flags())) res.insert("reasons", reasons_.toExternalMap());
    return res;
}

void IncomingReg::parseMap(const QVariantMap &map)
{
    clean();
    if(map.contains("flags"))
    {
        flags_ = fdf::RegFlags(map["flags"].toInt());
    }
    else
    {
        setAutoMode(map.contains("autoMode") && map["autoMode"].toBool());
        setOfflineMode(map.contains("offlineMode") && map["offlineMode"].toBool());
        setEncriptionMode(map.contains("useEncription") && map["useEncription"].toBool());
    }
    address_ = STR4FS_(map["address"].toString().trimmed());
    ofdInn_ = map["ofdInn"].toString().trimmed();
    ownerInn_ = map["ownerInn"].toString().trimmed();
    cashier_ = STR4FS_(map["cashier"].toString().trimmed());
    boxId_ = STR4FS_(map["boxId"].toString().trimmed());
    regNumber_ = map["regNumber"].toString().trimmed();
    ofdName_ = STR4FS_(map["ofdName"].toString().trimmed());
    ownerName_ = STR4FS_(map["ownerName"].toString().trimmed());
    ftsSite_ = STR4FS_(map["ftsSite"].toString().trimmed());
    taxes_ = fdf::Taxes(map["taxes"].toInt());
    if(!fdf::taxesIsValid(taxes_)) fdf::validateTaxes(taxes_);
    email_ = STR4FS_(map["email"].toString().trimmed());
    place_ = STR4FS_(map["place"].toString().trimmed());
    cashierInn_ = map["cashierInn"].toString().trimmed();
    additionalParam_ = STR4FS_(map["additionalParam"].toString().trimmed());
    additionalParamData_ = QByteArray::fromHex(map["additionalParamData"].toString().trimmed().toLatin1());
    extFlags_ = RegistrationFlags1290(map);
    reasons_ = RegReasons(map);
}

void IncomingReg::clean()
{
    flags_ = fdf::RegFlags();
    address_.clear();
    ofdInn_.clear();
    ownerInn_.clear();
    cashier_.clear();
    boxId_.clear();
    regNumber_.clear();
    ofdName_.clear();
    ownerName_.clear();
    ftsSite_.clear();
    taxes_ = fdf::Taxes();
    email_.clear();
    place_.clear();
    cashierInn_.clear();
    additionalParam_.clear();
    additionalParamData_.clear();
    extFlags_  = RegistrationFlags1290();
    reasons_ = RegReasons();
}

IncomingReg &IncomingReg::operator =(const IncomingReg &other) noexcept
{
    flags_ = other.flags_;
    address_ = other.address_;
    ofdInn_ = other.ofdInn_;
    ownerInn_ = other.ownerInn_;
    cashier_ = other.cashier_;
    boxId_ = other.boxId_;
    regNumber_ = other.regNumber_;
    ofdName_ = other.ofdName_;
    ownerName_ = other.ownerName_;
    ftsSite_ = other.ftsSite_;
    taxes_ = other.taxes_;
    email_ = other.email_;
    place_ = other.place_;
    cashierInn_ = other.cashierInn_;
    additionalParam_ = other.additionalParam_;
    additionalParamData_ = other.additionalParamData_;
    extFlags_ = other.extFlags_;
    reasons_ = other.reasons_;
    return *this;
}

IncomingReg &IncomingReg::operator =(IncomingReg &&other) noexcept
{
    flags_ = other.flags_;
    address_.swap(other.address_);
    ofdInn_.swap(other.ofdInn_);
    ownerInn_.swap(other.ownerInn_);
    cashier_.swap(other.cashier_);
    boxId_.swap(other.boxId_);
    regNumber_.swap(other.regNumber_);
    ofdName_.swap(other.ofdName_);
    ownerName_.swap(other.ownerName_);
    ftsSite_.swap(other.ftsSite_);
    taxes_ = other.taxes_;
    email_.swap(other.email_);
    place_.swap(other.place_);
    cashierInn_.swap(other.cashierInn_);
    additionalParam_.swap(other.additionalParam_);
    additionalParamData_.swap(other.additionalParamData_);
    extFlags_ = other.extFlags_;
    reasons_ = other.reasons_;
    return *this;
}

bool IncomingReg::operator ==(const IncomingReg &other) const noexcept
{
    return flags_ == other.flags_ &&
            address_ == other.address_ &&
            ofdInn_ == other.ofdInn_ &&
            ownerInn_ == other.ownerInn_ &&
            cashier_ == other.cashier_ &&
            boxId_ == other.boxId_ &&
            regNumber_ == other.regNumber_ &&
            ofdName_ == other.ofdName_ &&
            ownerName_ == other.ownerName_ &&
            ftsSite_ == other.ftsSite_ &&
            taxes_ == other.taxes_ &&
            email_ == other.email_ &&
            place_ == other.place_ &&
            cashierInn_ == other.cashierInn_ &&
            additionalParam_ == other.additionalParam_ &&
            additionalParamData_ == other.additionalParamData_ &&
            extFlags_ == other.extFlags_ &&
            reasons_ == other.reasons_;
}

bool IncomingReg::operator !=(const IncomingReg &other) const noexcept
{
    return !(*this == other);
}
