#ifndef INCOMINGREG_H
#define INCOMINGREG_H

#include "inn.h"
#include "regnumber.h"
#include "fdfconstants.h"
#include "regreasons.h"
#include "registrationflags1290.h"
#include "coreapiconst.h"

#include <QVariant>
#include <QVariantMap>
#include <QFlags>

class IncomingReg
{
public:
    IncomingReg() noexcept;
    explicit IncomingReg(const QVariantMap &map) noexcept;
    IncomingReg(const IncomingReg &other)noexcept;
    IncomingReg(IncomingReg &&other)noexcept;
    virtual ~IncomingReg();

    bool forFiscalize() const;
    bool forChangeFs() const;
    bool forRefiscalize() const;

    bool getAutoMode()const;
    void setAutoMode(bool set);
    bool getOfflineMode()const;
    void setOfflineMode(bool set);
    bool getEncriptionMode()const;
    void setEncriptionMode(bool set);

    const fdf::RegFlags &flags() const;
    void setFlags(const fdf::RegFlags &newFlags);

    const QString &address() const;
    void setAddress(const QString &newAddress);

    const QString &ofdInn() const;
    void setOfdInn(const QString &newOfdInn);

    const QString &ownerInn() const;
    void setOwnerInn(const QString &newUserInn);

    const QString &cashier() const;
    void setCashier(const QString &newCashier);

    const QString &boxId() const;
    void setBoxId(const QString &newBoxId);

    const QString &regNumber() const;
    void setRegNumber(const QString &newRegNumber);

    const QString &ofdName() const;
    void setOfdName(const QString &newOfdName);

    const QString &ownerName() const;
    void setOwnerName(const QString &newUserName);

    const QString &ftsSite() const;
    void setFtsSite(const QString &newFtsSite);

    const fdf::Taxes &taxes() const;
    void setTaxes(const fdf::Taxes &newTaxes);
    void setTax(const fdf::Tax &tax, bool allow);

    const QString &email() const;
    void setEmail(const QString &newEmail);

    const QString &place() const;
    void setPlace(const QString &newPlace);

    const QString &cashierInn() const;
    void setCashierInn(const QString &newCashierInn);

    const QString &additionalParam() const;
    void setAdditionalParam(const QString &newAdditionalParam);

    const QByteArray &additionalParamData() const;
    void setAdditionalParamData(const QByteArray &newAdditionalParamData);

    const RegistrationFlags1290 &extFlags() const;
    void setExtFlags(const RegistrationFlags1290 &newExtFlags);
    void setExtFlags(const fdf::RegFlags1290 &newExtFlags);
    void setExtFlag(fdf::RegFlag1290 f, bool set);

    const RegReasons &reasons() const;
    void setReasons(const RegReasons &newReasons);
    void setReasons(const fdf::Reasons &newReasons);
    void setReason(fdf::Reason r, bool set);

    virtual QVariantMap toMap() const;
    virtual QVariantMap toExternalMap() const;
    virtual void parseMap(const QVariantMap &map);
    virtual void clean();

    IncomingReg &operator =(const IncomingReg &other)noexcept;
    IncomingReg &operator =(IncomingReg &&other)noexcept;
    bool operator ==(const IncomingReg &other)const noexcept;
    bool operator !=(const IncomingReg &other)const noexcept;

protected:
    fdf::RegFlags flags_;
    QString address_;
    QString ofdInn_;
    QString ownerInn_;
    QString cashier_;
    QString boxId_;
    QString regNumber_;
    QString ofdName_;
    QString ownerName_;
    QString ftsSite_;
    fdf::Taxes taxes_;
    QString email_;
    QString place_;
    QString cashierInn_;
    QString additionalParam_;
    QByteArray additionalParamData_;
    RegistrationFlags1290 extFlags_;
    RegReasons reasons_;

};

#endif // INCOMINGREG_H
