#ifndef INN_H
#define INN_H

#include <QString>
#include <optional>

class Inn
{
public:
    enum class Type: quint8
    {
        Null                = 0x00,
        Person              = 0x01,
        Organization        = 0x02,
        Invalid             = 0xFF,
    };
    Inn() noexcept;
    explicit Inn(const QString &val) noexcept;
    Inn(const Inn &other)noexcept;
    Inn(Inn &&other)noexcept;
    ~Inn();

    bool isNull() const;
    Type type() const;
    bool isValid(bool canBeNull = false) const;

    const QString &value() const;
    void setValue(const QString &newValue);

    QByteArray data() const;

    //Создает только непустое значение
    static std::optional<Inn> create(const QString &val);

    Inn &operator =(const Inn &other)noexcept;
    Inn &operator =(Inn &&other)noexcept;
    bool operator ==(const Inn &other)const noexcept;
    bool operator !=(const Inn &other)const noexcept;

private:
    QString value_;

    bool check() const;
};

#endif // INN_H
