#ifndef LABELCHECKDATA_H
#define LABELCHECKDATA_H

#include "labelcode.h"

class LabelCheckData
{
public:

    enum LabelCheckFlag
    {
        SkipFsResult                    = 0x01,
        SkipFsWrong                     = 0x02,
        SkipNetworkError                = 0x04,
        SkipIfRequestError              = 0x08,
        SkipIsStatusError               = 0x10,
        SkipB5                          = 0x20
    };

    Q_DECLARE_FLAGS(LabelCheckFlags, LabelCheckFlag)

    LabelCheckData() noexcept;
    LabelCheckData(const LabelCheckData &other) noexcept;
    LabelCheckData(LabelCheckData &&other) noexcept;
    explicit LabelCheckData(const QVariantMap &map) noexcept;
    ~LabelCheckData();

    bool isValid(CoreApiConst::ErrorCode &err, QString &msg) const;
    bool isValid() const;

    QString rawLabel() const;
    void setRawLabel(const QString &newRawLabel);

    LabelCode labelCode() const;
    void setLabelCode(const std::optional<LabelCode> &newLabelCode);

    fdf::LabelProductStatus excpectedStatus() const;
    void setExcpectedStatus(fdf::LabelProductStatus newExcpectedStatus);

    quint8 mode() const;
    void setMode(quint8 newMode);

    std::optional<FixNumber> quantity() const;
    void setQuantity(std::optional<FixNumber> newQuantity);

    std::optional<fdf::ItemUnit> unit() const;
    void setUnit(std::optional<fdf::ItemUnit> newUnit);

    std::optional<QuantityFraction> fraction() const;
    void setFraction(std::optional<QuantityFraction> newFraction);

    const LabelCheckFlags &checkFlags() const;
    void setCheckFlags(const LabelCheckFlags &newCheckFlags);

    QVariantMap toMap() const;
    void parseMap(const QVariantMap &map);
    void clean();

    Tlv::Stlv forB5() const;

    QList<LabelCheckData> withAlternativeStatuses() const;

    LabelCheckData &operator =(const LabelCheckData &other) noexcept;
    LabelCheckData &operator =(LabelCheckData &&other) noexcept;
    bool operator ==(const LabelCheckData &other) const noexcept;
    bool operator !=(const LabelCheckData &other) const noexcept;



private:
    std::optional<LabelCode> labelCode_;
    fdf::LabelProductStatus excpectedStatus_;
    quint8 mode_;
    std::optional<FixNumber> quantity_;
    std::optional<fdf::ItemUnit> unit_;
    std::optional<QuantityFraction> fraction_;
    LabelCheckFlags checkFlags_;

    LabelCheckData withAlternativeStatus(fdf::LabelProductStatus s) const;
};

Q_DECLARE_OPERATORS_FOR_FLAGS(LabelCheckData::LabelCheckFlags)


#endif // LABELCHECKDATA_H
