#ifndef LABELCHECKRESULT_H
#define LABELCHECKRESULT_H


#include "labelcheckdata.h"


class LabelCheckResult
{
public:
    enum class Status2109 :quint8
    {
        Correct                         = 1,
        Incorrect                       = 2,
        ProductIncorrect                = 3, //Оборот товара приостановлен
    };
    enum class ReqCode2105 :quint8
    {
        Correct                         = 0,
        IncorrectRequest                = 1,
        IncorrectCode                   = 2
    };

    enum class ReqResultFlag: quint8
    {
        Reserved0                       = 0x01,
        Success                         = 0x02,
        Reserved2                       = 0x04,
        ProductStatusSuccess            = 0x08
    };
    Q_DECLARE_FLAGS(ReqResult, ReqResultFlag)


    LabelCheckResult()noexcept;
    LabelCheckResult(const LabelCheckResult &other) noexcept;
    LabelCheckResult(LabelCheckResult &&other) noexcept;
    explicit LabelCheckResult(const LabelCheckData &in) noexcept;
    explicit LabelCheckResult(const QVariantMap &map) noexcept;
    ~LabelCheckResult();

    QString rawLabel() const;
    void setRawLabel(const QString &newRawLabel);


    LabelCode labelCode() const;
    void setLabelCode(const std::optional<LabelCode> &newLabelCode);
    QString calc2115() const;

    fdf::LabelProductStatus actualStatus() const;
    void setActualStatus(fdf::LabelProductStatus newExcpectedStatus);

    quint8 mode() const;
    void setMode(quint8 newMode);

    std::optional<FixNumber> quantity() const;
    void setQuantity(std::optional<FixNumber> newQuantity);

    std::optional<fdf::ItemUnit> unit() const;
    void setUnit(std::optional<fdf::ItemUnit> newUnit);

    std::optional<QuantityFraction> fraction() const;
    void setFraction(std::optional<QuantityFraction> newFraction);

    fdf::LabelCodeType lct2100() const;
    void setLct2100(std::optional<fdf::LabelCodeType> newLct2100);
    void setLct2100(fdf::LabelCodeType lct);

    QString productId() const;
    void setProductId(std::optional<QString> newProductId);
    void setProductId(const QString &newProductId);

    const fdf::CheckLabelFlags &clFlags() const;
    void setClFlags(const fdf::CheckLabelFlags &newClFlags);

    const QDateTime &reqDt() const;
    void setReqDt(const QDateTime &newReqDt);

    Status2109 st2109() const;
    void setSt2109(Status2109 newSt2109);

    ReqCode2105 reqCode2105() const;
    void setReqCode2105(ReqCode2105 newReqCode2105);

    const ReqResult &reqResult() const;
    void setReqResult(const ReqResult &newReqResult);

    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);
    void clean();

    void parseB6(const fdf::CheckLabelFlags &flags, const Tlv::Stlv &list);


    LabelCheckResult &operator =(const LabelCheckResult &other) noexcept;
    LabelCheckResult &operator =(LabelCheckResult &&other) noexcept;
    bool operator ==(const LabelCheckResult &other) const noexcept;
    bool operator !=(const LabelCheckResult &other) const noexcept;

private:
    std::optional<LabelCode> labelCode_;
    fdf::LabelProductStatus actualStatus_;
    quint8 mode_;
    std::optional<FixNumber> quantity_;
    std::optional<fdf::ItemUnit> unit_;
    std::optional<QuantityFraction> fraction_;
    std::optional<fdf::LabelCodeType> lct2100_;
    std::optional<QString> productId_;//2101
    fdf::CheckLabelFlags clFlags_;
    QDateTime reqDt_;
    Status2109 st2109_;
    ReqCode2105 reqCode2105_;
    ReqResult reqResult_;

};

Q_DECLARE_INCOMPATIBLE_FLAGS(LabelCheckResult::ReqResult)

Q_DECL_CONSTEXPR inline QFlags<LabelCheckResult::ReqResultFlag> operator~(LabelCheckResult::ReqResultFlag f) Q_DECL_NOTHROW
{ return QFlags<LabelCheckResult::ReqResultFlag>(~static_cast<qint8>(f)) ;}

#endif // LABELCHECKRESULT_H
