#ifndef MODELDATA_H
#define MODELDATA_H

#include <QString>
#include <QVariantMap>
#include <array>

class ModelData
{
public:
    static const qint32 SERIAL_LENGTH;
    ModelData()noexcept;
    ModelData(const ModelData &other)noexcept;
    ModelData(ModelData &&other)noexcept;
    explicit ModelData(const QVariantMap &map)noexcept;
    ~ModelData();

    bool isValid() const;
    bool checkSign(const QString &hwHash) const;
    bool signData(const QString &hwHash);

    quint16 model() const;
    void setModel(const quint16 &model);

    qint32 srvModel() const;
    void setSrvModel(const qint32 &srvModel);

    QString modelName() const;
    void setModelName(const QString &modelName);

    QString serial() const;
    void setSerial(const QString &serial);

    QString sign() const;
    void setSign(const QString &sign);

    QString version() const;
    void setVersion(const QString &ver);

    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);

    QString toHtml(bool withHead = false) const;

    ModelData &operator =(const ModelData &other)noexcept;
    ModelData &operator =(ModelData &&other) noexcept;
    bool operator ==(const ModelData &other) const noexcept;
    bool operator !=(const ModelData &other) const noexcept;



private:
    quint16 model_;
    qint32 srvModel_;
    QString modelName_;
    QString serial_;
    std::array<QChar, 3> version_;
    QString sign_;
};

#endif // MODELDATA_H
