#ifndef OFDSETTINGS_H
#define OFDSETTINGS_H

#include "basecoreconfigdata.h"

#include <QString>
#include <QVariantMap>


//Добавить отдельные настройки для ОИСМ и для обновлния ключей прямо сюда, наверное

class OfdSettings: public BaseCoreConfigData
{
    friend class CoreConfigStore;
    static const QString SECTION;
    static const QString INN;
    static const QString ADDRESS;
    static const QString PORT;
    static const QString QUERYI_NTERVAL;
    static const QString TIMER_S;
    static const QString URL;
    static const QString NAME;
    static const QString SHORT_NAME;
    static const QString LABELS_ADDRESS;
    static const QString LABELS_PORT;
    static const QString KEYS_ADDRESS;
    static const QString KEYS_PORT;
    static const QString TEST_TIMEOUT;
    static const QString KEYS_TIMEOUT;
public:
    static const QMap<QString, OfdSettings> SUPPORTED_OFD;
    static const QMap<QString, OfdSettings> SUPPORTED_DEBUG_OFD;
    static const quint32 OFD_SETTINGS_VERSION = 1;
    OfdSettings(const QString& inn,
                const QString& address,
                quint16 port,
                const QString &url,
                const QString &name,
                const QString &shortName) noexcept;
    OfdSettings(const QString& inn,
                const QString& address,
                quint16 port,
                const QString &url,
                const QString &name,
                const QString &shortName,
                const QString &labelsAddress,
                quint16 labelsPort,
                const QString &keysAddress,
                quint16 keysPort) noexcept;
    OfdSettings()noexcept;
    OfdSettings(const OfdSettings &other)noexcept;
    OfdSettings(OfdSettings &&other)noexcept;
    explicit OfdSettings(const QVariantMap &other)noexcept;
    ~OfdSettings() override;

    bool isValid() const;

    QString address() const;
    void setAddress(const QString &address);

    quint16 port() const;
    void setPort(const quint16 &port);

    quint32 queryInterval() const;
    void setQueryInterval(const quint32 &queryInterval);

    quint32 timerS() const;
    void setTimerS(quint32 newTimerS);


    QString url() const;
    void setUrl(const QString &url);

    QString name() const;
    void setName(const QString &name);


    QString inn() const;
    void setInn(const QString &inn);

    QString shortName() const;
    void setShortName(const QString &shortName);


    const QString &labelsAddress() const;
    void setLabelsAddress(const QString &newLabelsAddress);

    quint16 labelsPort() const;
    void setLabelsPort(quint16 newLabelsPort);

    const QString &keysAddress() const;
    void setKeysAddress(const QString &newKeysAddress);

    quint16 keysPort() const;
    void setKeysPort(quint16 newKeysPort);

    qint32 testTimeout() const;
    void setTestTimeout(qint32 newTestTimeout);

    qint32 keysTimeout() const;
    void setKeysTimeout(qint32 newKeysTimeout);

    QVariantMap toMap() const override;
    void parseMap(const QVariantMap &map) override;


    QString section() const override;
    QStringList fields() const  override;
    QMap<QString, QString> toStringMap() const  override;
    void parseStringMap(const QMap<QString, QString> &map)  override;
    CoreApiResult toSuccessResult() const override;
    void parseTransactionParams(const QVariantMap &params) override;

    OfdSettings &operator=(const OfdSettings &other)noexcept;
    OfdSettings &operator=(OfdSettings &&other)noexcept;
    bool operator==(const OfdSettings &other) const;
    bool operator!=(const OfdSettings &other) const;
private:
    QString inn_;
    QString address_;
    quint16 port_;
    quint32 queryInterval_;
    quint32 timerS_;
    QString url_;
    QString name_;
    QString shortName_;
    QString labelsAddress_;
    quint16 labelsPort_;
    QString keysAddress_;
    quint16 keysPort_;
    qint32 testTimeout_;
    qint32 keysTimeout_;
};
Q_DECLARE_METATYPE(OfdSettings)


#endif // OFDSETTINGS_H
