#ifndef RECEIPT_H
#define RECEIPT_H

#include "basedoc.h"
#include "receiptoperation.h"
#include "regdata.h"

class Receipt : public BaseWorkIncoming
{
    friend class BaseReceiptDoc;
public:
    using Option = ReceiptOption;
    using Options = ReceiptOptions;

    Receipt() noexcept;
    Receipt(const Receipt &other) noexcept;
    Receipt(Receipt &&other) noexcept;
    explicit Receipt(const QVariantMap &map) noexcept;
    ~Receipt();

    bool isValid(const RegData &rd) const;
    bool isValid(const RegData &rd, CoreApiConst::ErrorCode &err, QString &msg) const;
    bool isRefund() const;
    bool isCredit() const;
    bool mayBeLabled() const;
    bool containsLabels() const;

    const Options &options() const;
    void setOptions(const Options &newOptions);

    bool hasOption(Option o) const;
    void setOption(Option o, bool set);

    bool isCorrection() const;
    void setCorrection(bool set);

    bool isFosa() const;
    void setFosa(bool set);

    bool internatCashbox() const;
    void setInternetCashbox(bool set);

    bool supportLabledTrandes() const;
    void setSupportLabledTrandes(bool set);

    bool supportExciseTrandes() const;
    void setSupportExciseTrandes(bool set);

    fdf::DocType needDocType() const;

    fdf::PaymentType paymentAttr() const;
    void setPaymentAttr(fdf::PaymentType newPaymentAttr);

    fdf::Tax tax() const;
    void setTax(fdf::Tax newTax);

    FixNumber amount() const;
    FixNumber calculatedAmount() const;
    void setAmount(std::optional<FixNumber> newAmount);

    FixNumber change() const;

    std::optional<FixNumber> cash() const;
    void setCash(std::optional<FixNumber> newCash);
    void setCash(const FixNumber cash);

    std::optional<FixNumber> card() const;
    void setCard(std::optional<FixNumber> newCard);
    void setCard(const FixNumber &card);

    std::optional<FixNumber> prepay() const;
    void setPrepay(std::optional<FixNumber> newPrepay);
    void setPrepay(const FixNumber &prepay);

    std::optional<FixNumber> postpay() const;
    void setPostpay(std::optional<FixNumber> newPostpay);
    void setPostpay(const FixNumber &postpay);

    std::optional<FixNumber> barter() const;
    void setBarter(std::optional<FixNumber> newBarter);
    void setBarter(const FixNumber &barter);

    std::optional<FixNumber> vat20() const;
    void setVat20(std::optional<FixNumber> newVat20);

    std::optional<FixNumber> vat10() const;
    void setVat10(std::optional<FixNumber> newVat10);

    std::optional<FixNumber> vat0() const;
    void setVat0(std::optional<FixNumber> newVat0);

    std::optional<FixNumber> vatNone() const;
    void setVatNone(std::optional<FixNumber> newVatNone);

    std::optional<FixNumber> vat20_120() const;
    void setVat20_120(std::optional<FixNumber> newVat20_120);

    std::optional<FixNumber> vat10_110() const;
    void setVat10_110(std::optional<FixNumber> newVat10_110);

    std::optional<FixNumber> vat5() const;
    void setVat5(std::optional<FixNumber> newVat5);

    std::optional<FixNumber> vat7() const;
    void setVat7(std::optional<FixNumber> newVat7);

    std::optional<FixNumber> vat5_105() const;
    void setVat5_105(std::optional<FixNumber> newVat5_105);

    std::optional<FixNumber> vat7_107() const;
    void setVat7_107(std::optional<FixNumber> newVat7_107);


    std::optional<ReceiptAdditionalUserParam> userParam() const;
    void setUserParam(std::optional<ReceiptAdditionalUserParam> newUserParam);

    std::optional<BuyerInfo> buyerInfo() const;
    void setBuyerInfo(std::optional<BuyerInfo> newBuyerInfo);

    const QList<IndustryProperty> &industryProperties() const;
    void setIndustryProperties(const QList<IndustryProperty> &newIndustryProperties);

    std::optional<ReceiptOperationalParam> operationalParam() const;
    void setOperationalParam(std::optional<ReceiptOperationalParam> newOperationalParam);

    std::optional<CorrectionReason> correctionReason() const;
    void setCorrectionReason(std::optional<CorrectionReason> newCorrectionReason);

    const QString &buyerPhone() const;
    void setBuyerPhone(const QString &newBuyerPhone);

    const QString &boxId() const;
    void setBoxId(const QString &newBoxId);

    const PSimpleReceiptOperations &operations() const;
    void setOperations(const PSimpleReceiptOperations &newOperations);

    SimpleReceiptOperations simpleOperations() const;

    ReceiptOperations labledOperattions(bool includeOisn, bool includeSimple) const;

    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);

    Tlv::Stlv toTlv(const RegData &rd) const;
    Tlv::Stlv toTlvB7_3(const RegData &rd, quint32 fd) const;
    void clean() override;

    Receipt &operator = (const Receipt &other) noexcept;
    Receipt &operator = (Receipt &&other) noexcept;
    bool operator == (const Receipt &other) const noexcept;
    bool operator != (const Receipt &other) const noexcept;

    const PSimpleReceiptOperation & operator[](int i) const;
    qint32 count() const;
    qint32 addOperation(const ReceiptOperation &op); //Возвращает номер позиции
    qint32 setOperation(const ReceiptOperation &op, qint32 idx);//Возвращает номер позиции или -1, если выход за границы
    qint32 addOperation(const SimpleReceiptOperation &op); //Возвращает номер позиции
    qint32 setOperation(const SimpleReceiptOperation &op, qint32 idx);//Возвращает номер позиции или -1, если выход за границы
    qint32 removeOpearation(qint32 idx); //Возвращает count

    void calcAmounts();

    void addQuantity(qint32 index);
    void subQuantity(qint32 index);




    quint8 t2107() const;
    void setT2107(quint8 newT2107);

    bool internetPayment() const;
    void setInternetPayment(bool newInternetPayment);

    std::optional<CardPaymentsInfo> cardPayments() const;
    void setCardPayments(std::optional<CardPaymentsInfo> newCardPayments);

private:
    Options options_;
    fdf::PaymentType paymentAttr_;
    fdf::Tax tax_;
    std::optional<FixNumber> amount_;
    std::optional<FixNumber> cash_;
    std::optional<FixNumber> card_;
    std::optional<FixNumber> prepay_;
    std::optional<FixNumber> postpay_;
    std::optional<FixNumber> barter_;
    std::optional<FixNumber> vat20_;
    std::optional<FixNumber> vat10_;
    std::optional<FixNumber> vat0_;
    std::optional<FixNumber> vatNone_;
    std::optional<FixNumber> vat20_120_;
    std::optional<FixNumber> vat10_110_;
    std::optional<FixNumber> vat5_;
    std::optional<FixNumber> vat7_;
    std::optional<FixNumber> vat5_105_;
    std::optional<FixNumber> vat7_107_;
    std::optional<FixNumber> calculatedvat20_;
    std::optional<FixNumber> calculatedvat10_;
    std::optional<FixNumber> calculatedvat0_;
    std::optional<FixNumber> calculatedvatNone_;
    std::optional<FixNumber> calculatedvat20_120_;
    std::optional<FixNumber> calculatedvat10_110_;
    std::optional<FixNumber> calculatedvat5_;
    std::optional<FixNumber> calculatedvat7_;
    std::optional<FixNumber> calculatedvat5_105_;
    std::optional<FixNumber> calculatedvat7_107_;
    std::optional<ReceiptAdditionalUserParam> userParam_;
    std::optional<BuyerInfo> buyerInfo_;
    QList<IndustryProperty> industryProperties_;
    std::optional<ReceiptOperationalParam> operationalParam_;
    std::optional<CorrectionReason> correctionReason_;   
    QString buyerPhone_;
    QString boxId_;
    PSimpleReceiptOperations operations_;
    mutable std::optional<bool> containsLabels_;
    quint8 t2107_;
    bool internetPayment_;
    std::optional<CardPaymentsInfo> cardPayments_;

    bool checkAmount(CoreApiConst::ErrorCode &err, QString &msg) const;
    bool checkIndustryCode(CoreApiConst::ErrorCode &err, QString &msg) const;
};


//TODO: если internetPayment_ проверять, что место расчетов и телефон покупателя заданы обязательно

#endif // RECEIPT_H
