#ifndef RECEIPTOPERATION_H
#define RECEIPTOPERATION_H

#include "simplereceiptoperation.h"
#include "receiptdataclasses.h"
#include "labelcheckresult.h"
#include <optional>

class ReceiptOperation :public SimpleReceiptOperation
{

public:
    ReceiptOperation() noexcept;
    ReceiptOperation(const ReceiptOperation &other) noexcept;
    ReceiptOperation(ReceiptOperation &&other) noexcept;
    explicit ReceiptOperation(const QVariantMap &map) noexcept;
    ~ReceiptOperation() override;

    bool isValid() const override;
    bool isValid(CoreApiConst::ErrorCode &err, QString &msg) const override;

    bool isSimpleLabled() const;
    bool isLabled() const;

    bool hasPrice() const override;
    FixNumber price() const override;

    FixNumber priceForPack() const;
    void setPriceForPack(std::optional<FixNumber> newPriceForPack);
    void setPriceForPack(const FixNumber &newPriceForPack);

    std::optional<FixNumber> priceForUnit() const;
    void setPriceForUnit(std::optional<FixNumber> newPriceForUnit);

    std::optional<LabelCheckResult> labelCheckResult() const;
    void setLabelCheckResult(std::optional<LabelCheckResult> newLabelCheckResult);

    std::optional<QuantityFraction> fraction() const;
    void setFraction(std::optional<QuantityFraction> newFraction);

    fdf::CheckLabelFlags checkLabelFlags() const;
    void setCheckLabelFlags(const fdf::CheckLabelFlags &newCheckLabelFlags);

    fdf::ItemUnit unit() const override;

    const QString &controlCode() const;
    void setControlCode(const QString &newControlCode);

    bool skipB() const;
    void setSkipB(bool newSkipB);

    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;
    void parseMap(const QVariantMap &map, CoreApiConst::ErrorCode *err = nullptr) override;

    Tlv to1059() const override;
    Tlv to2007() const;

    void clean() override;

    ReceiptOperation &operator =(const ReceiptOperation &other) noexcept;
    ReceiptOperation &operator =(ReceiptOperation &&other) noexcept;
    bool operator ==(const ReceiptOperation &other) const noexcept;
    bool operator !=(const ReceiptOperation &other) const noexcept;




private:
    std::optional<FixNumber> priceForPack_;//Цена пачки, fесли маркированный товар с дробью
    std::optional<FixNumber> priceForUnit_;//Цена 1/знаменатель товара, если товар с дробью
    std::optional<LabelCheckResult> labelCheckResult_;

    std::optional<QuantityFraction> fraction_;
    fdf::CheckLabelFlags checkLabelFlags_;

    /*20) Реквизит "контрольный код КМ" (тег 2115) должен принимать значение младших четырех
    цифр от десятичного значения контрольной суммы CRC-32, рассчитанной на базе значения реквизита
    "код маркировки" (тег 2000). Вычисление значения CRC-32 выполняются в соответствии с
    параметрами, указанными в таблице 35.*/
    QString controlCode_;
    bool skipB_; //Это чтобы пропускать проверку марки для не КМК и GS1.M. пока не пригодился


    bool checkFraction(CoreApiConst::ErrorCode &err, QString &msg) const;
    bool checkLabled(CoreApiConst::ErrorCode &err, QString &msg) const;

    bool checkPriceAndCost(CoreApiConst::ErrorCode &err, QString &msg) const override;

    void parseChildTlv(const Tlv &tlv) override;
};

typedef QList<ReceiptOperation> ReceiptOperations;

#endif // RECEIPTOPERATION_H
