#ifndef CoreRegData_H
#define CoreRegData_H

#include "fdfconstants.h"
#include "modeldata.h"
#include "fsfullstatus.h"
#include "incomingreg.h"

#include <QDateTime>


class CoreRegData: public IncomingReg
{
public:
    CoreRegData() noexcept;
    CoreRegData(const CoreRegData &other)noexcept;
    explicit CoreRegData(const IncomingReg &other)noexcept;
    CoreRegData(CoreRegData &&other) noexcept;
    explicit CoreRegData(const QVariantMap &map)noexcept;
    ~CoreRegData() override;

    virtual bool isValid() const;


    const QString &serial() const;
    void setSerial(const QString &newSerial);

    fs::FFD fsFfd() const;
    void setFsFfd(fs::FFD newFsFfd);

    fs::FFD ffd() const;
    void setFfd(fs::FFD newFfd);

    fs::FFD cashboxFfd() const;
    void setCashboxFfd(fs::FFD newCashboxFfd);

    const QString &cashboxVersion() const;
    void setCashboxVersion(const QString &newCashboxVersion);

    quint16 keysResource() const;
    void setKeysResource(quint16 newKeysResource);

    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;

    void parseMap(const QVariantMap &map)override;
    void clean()override;
    virtual QString toHtml() const;

    CoreRegData &operator =(const CoreRegData &other) noexcept;
    CoreRegData &operator =(CoreRegData &&other) noexcept;
    bool operator ==(const CoreRegData &other) const noexcept;
    bool operator !=(const CoreRegData &other) const noexcept;

protected:
    QString serial_;
    fs::FFD fsFfd_;
    fs::FFD ffd_;
    fs::FFD cashboxFfd_;
    QString cashboxVersion_;
    quint16 keysResource_;
};

//--------------------------------------------------------------------------------------------------
class RegData : public CoreRegData
{
public:
    RegData() noexcept;
    RegData(const RegData &other)noexcept;
    explicit RegData(const CoreRegData &other)noexcept;
    RegData(RegData &&other) noexcept;
    explicit RegData(const QVariantMap &map)noexcept;
    ~RegData() override;

    bool isValid() const override;

    const QDateTime &dt() const;
    void setDt(const QDateTime &newDt);

    quint32 docNumber() const;
    void setDocNumber(quint32 newDocNumber);

    const QString &fsNumber() const;
    void setFsNumber(const QString &newFsNumber);

    quint32 fiscalCode() const;
    void setFiscalCode(quint32 newFiscalCode);

    QVariantMap toMap() const override;
    QVariantMap toExternalMap() const override;

    void parseMap(const QVariantMap &map)override;
    void clean()override;
    QString toHtml() const override;


    RegData &operator =(const RegData &other) noexcept;
    RegData &operator =(RegData &&other) noexcept;
    bool operator ==(const RegData &other) const noexcept;
    bool operator !=(const RegData &other) const noexcept;

private:
    QDateTime dt_;
    quint32 docNumber_;
    QString fsNumber_;
    quint32 fiscalCode_;
};

//--------------------------------------------------------------------------------------------------

#endif // CoreRegData_H
