#include "registrationflags1290.h"

RegistrationFlags1290::RegistrationFlags1290() noexcept
    : flags_()
{

}

RegistrationFlags1290::RegistrationFlags1290(const fdf::RegFlags1290 &flags) noexcept
    : flags_(flags)
{

}

RegistrationFlags1290::RegistrationFlags1290(const QVariantMap &map) noexcept
    : flags_()
{
    parseMap(map);
}

RegistrationFlags1290::RegistrationFlags1290(const RegistrationFlags1290 &other) noexcept
    : flags_(other.flags_)
{

}

RegistrationFlags1290::RegistrationFlags1290(RegistrationFlags1290 &&other) noexcept
    : flags_(other.flags_)
{

}

RegistrationFlags1290::~RegistrationFlags1290()
{

}

const fdf::RegFlags1290 &RegistrationFlags1290::flags() const
{
    return flags_;
}

void RegistrationFlags1290::setFlags(const fdf::RegFlags1290 &newFlags)
{
    flags_ = newFlags;
}

void RegistrationFlags1290::setFlag(const fdf::RegFlag1290 &f, bool set)
{
    flags_.setFlag(f, set);
}

void RegistrationFlags1290::setFlags(const fs::RegFlags &flags, const fs::ExtRegFlags &extFlags)
{
    flags_ = fdf::RegFlags1290();
    flags_.setFlag(fdf::RegFlag1290::ServicesOnly, flags.testFlag(fs::RegFlag::Services));
    flags_.setFlag(fdf::RegFlag1290::FosaCashbox, flags.testFlag(fs::RegFlag::Fosa));
    flags_.setFlag(fdf::RegFlag1290::InternetOnly, flags.testFlag(fs::RegFlag::ForInternet));

    flags_.setFlag(fdf::RegFlag1290::ExcisableProducts, extFlags.testFlag(fs::ExtRegFlag::ExcisableProducts));
    flags_.setFlag(fdf::RegFlag1290::GamesCashbox   , extFlags.testFlag(fs::ExtRegFlag::GamesCashbox));
    flags_.setFlag(fdf::RegFlag1290::LotteryCashbox , extFlags.testFlag(fs::ExtRegFlag::LotteryCashbox ));
    flags_.setFlag(fdf::RegFlag1290::ExternalPrinter, extFlags.testFlag(fs::ExtRegFlag::ExternalPrinter));
    flags_.setFlag(fdf::RegFlag1290::LabledProducts , extFlags.testFlag(fs::ExtRegFlag::LabledProducts ));
    flags_.setFlag(fdf::RegFlag1290::Pawnshop       , extFlags.testFlag(fs::ExtRegFlag::Pawnshop       ));
    flags_.setFlag(fdf::RegFlag1290::Insurance      , extFlags.testFlag(fs::ExtRegFlag::Insurance      ));
}

bool RegistrationFlags1290::getExternalPrinter() const
{
    return flags_.testFlag(fdf::RegFlag1290::ExternalPrinter);
}

void RegistrationFlags1290::setExternalPrinter(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::ExternalPrinter, set);

}

bool RegistrationFlags1290::getFosaCashbox() const
{
    return flags_.testFlag(fdf::RegFlag1290::FosaCashbox);
}

void RegistrationFlags1290::setFosaCashbox(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::FosaCashbox, set);

}

bool RegistrationFlags1290::getInternetOnly() const
{
    return flags_.testFlag(fdf::RegFlag1290::InternetOnly);
}

void RegistrationFlags1290::setInternetOnly(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::InternetOnly, set);

}

bool RegistrationFlags1290::getExcisableProducts() const
{
    return flags_.testFlag(fdf::RegFlag1290::ExcisableProducts);
}

void RegistrationFlags1290::setExcisableProducts(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::ExcisableProducts, set);

}

bool RegistrationFlags1290::getLabledProducts() const
{
    return flags_.testFlag(fdf::RegFlag1290::LabledProducts);
}

void RegistrationFlags1290::setLabledProducts(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::LabledProducts, set);
}

bool RegistrationFlags1290::getServicesOnly() const
{
    return flags_.testFlag(fdf::RegFlag1290::ServicesOnly);
}

void RegistrationFlags1290::setServicesOnly(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::ServicesOnly, set);

}

bool RegistrationFlags1290::getGamesCashbox() const
{
    return flags_.testFlag(fdf::RegFlag1290::GamesCashbox);

}

void RegistrationFlags1290::setGamesCashbox(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::GamesCashbox, set);

}

bool RegistrationFlags1290::getLotteryCashbox() const
{
    return flags_.testFlag(fdf::RegFlag1290::LotteryCashbox);

}

void RegistrationFlags1290::setLotteryCashbox(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::LotteryCashbox, set);

}

bool RegistrationFlags1290::getPawnshop() const
{
    return flags_.testFlag(fdf::RegFlag1290::Pawnshop);

}

void RegistrationFlags1290::setPawnshop(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::Pawnshop, set);
}

bool RegistrationFlags1290::getInsurance() const
{
    return flags_.testFlag(fdf::RegFlag1290::Insurance);

}

void RegistrationFlags1290::setInsurance(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::Insurance, set);
}

bool RegistrationFlags1290::getAutoCashboxForLabled() const
{
    return flags_.testFlag(fdf::RegFlag1290::AutoCashboxForLabled);
}

void RegistrationFlags1290::setAutoCashboxForLabled(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::AutoCashboxForLabled, set);
}

bool RegistrationFlags1290::getRestaurant() const
{
    return flags_.testFlag(fdf::RegFlag1290::Restaurant);
}

void RegistrationFlags1290::setRestaurant(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::Restaurant, set);
}

bool RegistrationFlags1290::getWholesale() const
{
    return flags_.testFlag(fdf::RegFlag1290::Wholesale);
}

void RegistrationFlags1290::setWholesale(bool set)
{
    flags_.setFlag(fdf::RegFlag1290::Wholesale, set);
}

QVariantMap RegistrationFlags1290::toMap() const
{
    return {
        {"extFlags", static_cast<qint32>(flags_)}
    };
}

QVariantMap RegistrationFlags1290::toExternalMap() const
{
    return {
        { "externalPrinter"             , getExternalPrinter  ()},
        { "fosaCashbox"                 , getFosaCashbox      ()},
        { "internetOnly"                , getInternetOnly     ()},
        { "excisableProducts"           , getExcisableProducts()},
        { "labledProducts"              , getLabledProducts   ()},
        { "servicesOnly"                , getServicesOnly     ()},
        { "gamesCashbox"                , getGamesCashbox     ()},
        { "lotteryCashbox"              , getLotteryCashbox   ()},
        { "pawnshop"                    , getPawnshop         ()},
        { "insurance"                   , getInsurance        ()}
    };
}

void RegistrationFlags1290::parseMap(const QVariantMap &map)
{
    if(map.contains("extFlags"))
    {
        flags_ = fdf::RegFlags1290(static_cast<qint32>(map["extFlags"].toInt()));
    }
    else
    {
        flags_ = fdf::RegFlags1290();
        setExternalPrinter(map.contains("externalPrinter") && map["externalPrinter"].toBool());
        setFosaCashbox(map.contains("fosaCashbox") && map["fosaCashbox"].toBool());
        setInternetOnly(map.contains("internetOnly") && map["internetOnly"].toBool());
        setExcisableProducts(map.contains("excisableProducts") && map["excisableProducts"].toBool());
        setLabledProducts(map.contains("labledProducts") && map["labledProducts"].toBool());
        setServicesOnly(map.contains("servicesOnly") && map["servicesOnly"].toBool());
        setGamesCashbox(map.contains("gamesCashbox") && map["gamesCashbox"].toBool());
        setLotteryCashbox(map.contains("lotteryCashbox") && map["lotteryCashbox"].toBool());
        setPawnshop(map.contains("pawnshop") && map["pawnshop"].toBool());
        setInsurance(map.contains("insurance") && map["insurance"].toBool());
    }
}

quint32 RegistrationFlags1290::toUInt() const
{
    return static_cast<quint32>(flags_);
}

RegistrationFlags1290 &RegistrationFlags1290::operator =(const RegistrationFlags1290 &other) noexcept
{
    flags_ = other.flags_;
    return *this;
}
RegistrationFlags1290 &RegistrationFlags1290::operator =(RegistrationFlags1290 &&other) noexcept
{
    flags_ = other.flags_;
    return *this;
}

bool RegistrationFlags1290::operator ==(const RegistrationFlags1290 &other) const noexcept
{
    return flags_ == other.flags_;
}

bool RegistrationFlags1290::operator !=(const RegistrationFlags1290 &other) const noexcept
{
    return flags_ != other.flags_;
}
