#ifndef REGISTRATIONFLAGS1290_H
#define REGISTRATIONFLAGS1290_H

#include "fdfconstants.h"
#include "fsfullstatus.h"

#include <QVariantMap>

class RegistrationFlags1290
{
public:
    RegistrationFlags1290()noexcept;
    explicit RegistrationFlags1290(const fdf::RegFlags1290 &flags)noexcept;
    explicit RegistrationFlags1290(const QVariantMap &map) noexcept;
    RegistrationFlags1290(const RegistrationFlags1290 &other) noexcept;
    RegistrationFlags1290(RegistrationFlags1290 &&other)noexcept;
    ~RegistrationFlags1290();
    const fdf::RegFlags1290 &flags() const;
    void setFlags(const fdf::RegFlags1290 &newFlags);
    void setFlag(const fdf::RegFlag1290 &f, bool set);

    void setFlags(const fs::RegFlags &flags, const fs::ExtRegFlags &extFlags);

    bool getExternalPrinter() const;
    void setExternalPrinter(bool set);
    bool getFosaCashbox() const;
    void setFosaCashbox(bool set);
    bool getInternetOnly() const;
    void setInternetOnly(bool set);
    bool getExcisableProducts() const;
    void setExcisableProducts(bool set);
    bool getLabledProducts() const;
    void setLabledProducts(bool set);
    bool getServicesOnly() const;
    void setServicesOnly(bool set);
    bool getGamesCashbox() const;
    void setGamesCashbox(bool set);
    bool getLotteryCashbox() const;
    void setLotteryCashbox(bool set);
    bool getPawnshop() const;
    void setPawnshop(bool set);
    bool getInsurance() const;
    void setInsurance(bool set);
    bool getAutoCashboxForLabled() const;
    void setAutoCashboxForLabled(bool set);
    bool getRestaurant() const;
    void setRestaurant(bool set);
    bool getWholesale() const;
    void setWholesale(bool set);


    QVariantMap toMap() const;
    QVariantMap toExternalMap() const;
    void parseMap(const QVariantMap &map);
    quint32 toUInt() const;

    RegistrationFlags1290 &operator =(const RegistrationFlags1290 &other)noexcept;
    RegistrationFlags1290 &operator =(RegistrationFlags1290 &&other)noexcept;
    bool operator ==(const RegistrationFlags1290 &other)const noexcept;
    bool operator !=(const RegistrationFlags1290 &other)const noexcept;

private:
    fdf::RegFlags1290 flags_;
};

#endif // REGISTRATIONFLAGS1290_H
