#ifndef REGNUMBER_H
#define REGNUMBER_H

#include "inn.h"

class RegNumber
{
public:
    RegNumber() noexcept;
    RegNumber(const QString &val, const QString &serial, const QString &inn) noexcept;
    RegNumber(const QString &serial, const QString &inn, qint64 number) noexcept;
    RegNumber(const QString &serial, const QString &inn) noexcept;
    RegNumber(const RegNumber &other)noexcept;
    RegNumber(RegNumber &&other)noexcept;

    bool isValid() const;

    const QString &value() const;
    void setValue(const QString &newValue);

    const Inn &inn() const;
    void setInn(const Inn &newInn);

    const QString &serial() const;
    void setSerial(const QString &newSerial);

    QByteArray data() const;

    RegNumber &operator =(const RegNumber &other)noexcept;
    RegNumber &operator =(RegNumber &&other)noexcept;
    bool operator ==(const RegNumber &other)const noexcept;
    bool operator !=(const RegNumber &other)const noexcept;


private:
    QString value_;
    Inn inn_;
    QString serial_;

    QString normalize(const QString &val) const;
    bool check(const QString &val, const QString &serial, const Inn &inn) const;
    QString create(const QString &serial, const QString &inn, qint64 number = -1) const;
};

#endif // REGNUMBER_H
